unit JDVisible;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  LPalette =
  record
    Couleur : TColor;
    Visible : boolean;
  end;

  TFChoixVisible = class(TForm)
    BtnOk: TButton;
    BtnCancel: TButton;
    procedure FormPaint(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    function Execute : boolean;
    procedure BtnOkClick(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
  private
    { Dclarations prives }
    MargeX  : integer;
    DecaleX : integer;
    Terminaison : boolean;
    NbLarg  : integer;     { nombre de choix par ligne}
    NbCouleurs  : integer; { nombre total couleurs }
    NbChoix     : integer; { nombre total de choix }
    OldPalette : array[0..255] of LPalette; { sauvegarde palette origine }
    OldCouche  : array[0..255] of boolean; { sauvegarde couches origines }
    OldElts    : array[1..3] of boolean;   { sauvegarde lments gomtrie }
    procedure DrawSquare(Num: integer);
    function PosToCell(X,Y : integer):integer;
  public
    { Dclarations publiques }
    ListePalette : array[0..255] of LPalette;
    ListeCouche  : array[0..255] of boolean;
    ListeElts    : array[1..3] of boolean;
    NbCouches    : integer; { Nombre de couches }
    procedure GenerePalette(NbCoul,NbNuances,NbCouc : integer);
    procedure InitVisible;
    function CouleurVisible(Num : integer):boolean;
    function CoucheVisible(Num : integer):boolean;
    function PointVisible:boolean;
    function LigneVisible:boolean;
    function CercleVisible:boolean;
  end;

var
  FChoixVisible: TFChoixVisible;

implementation

{$R *.DFM}

uses
  ExtCtrls, Math;
const
  LargCell = 34; { hauteur des cellules }
  HautCell = 25; { largeur des cellules }

procedure TFChoixVisible.GenerePalette(NbCoul,NbNuances,NbCouc : integer);
var
  Interval,Num : integer;
  Reste,V,V2,V3 : integer;
  NbLigCouche : integer;
begin
  if NbCoul > 16 then NbCoul := 16;
  if NbNuances > 16 then NbNuances := 16;
  if NbCoul < 1 then NbCoul := 1;
  if NbNuances < 1 then NbNuances := 1;
  if NbCouc > 256 then NbCouc := 256;

  NbLarg := NbCoul;
  NbCouches := NbCouc;
  NbCouleurs := NbCoul * NbNuances;

  Width  := NbLarg * (LargCell + 4) + 44;
  MargeX := 20;
  if Width < 222 then
  begin
    Width := 222;
    MargeX := (Width - (NbLarg * (LargCell + 4) + 2)) div 2;
    BtnOk.Left := 20;
    BtnCancel.Left := 120;
  end
  else
  begin
    DecaleX := (Width - 162) div 3;
    BtnOk.Left := DecaleX;
    BtnCancel.Left := 2 * DecaleX + 80;
  end;
  NbLigCouche := NbCouches div NbCoul;
  Height := (NbNuances+NbLigCouche+2 ) * (HautCell + 6)+ 70;
  Left := (Screen.Width - Width) div 2;
  Top  := (Screen.Height - Height) div 2;
  BtnOk.Top := Height - 70;
  BtnCancel.Top := Height - 70;

  Interval := 256 div NbNuances;
  ListePalette[0].Couleur := TColor(RGB(0,0,0));
  for Num := 1 to (NbCouleurs-1) do
  begin
    V := ((Num div NbCoul) + 1) * Interval;
    V2 := V div 2;
    V3 := 3 * V div 4;
    if V > 255 then V := 255;
    Reste  := (Num mod NbCoul) + 1;
    case Reste of
      1  : ListePalette[Num].Couleur := TColor(RGB(V,V,V)); {Blanc}
      2  : ListePalette[Num].Couleur := TColor(RGB(V,0,0)); {Rouge}
      3  : ListePalette[Num].Couleur := TColor(RGB(0,V,0)); {Vert}
      4  : ListePalette[Num].Couleur := TColor(RGB(0,0,V)); {Bleu}
      5  : ListePalette[Num].Couleur := TColor(RGB(V,V,0)); {Jaune}
      6  : ListePalette[Num].Couleur := TColor(RGB(V,0,V)); {Magenta}
      7  : ListePalette[Num].Couleur := TColor(RGB(0,V,V)); {Cyan}
      8  : ListePalette[Num].Couleur := TColor(RGB(V,V2,0)); {Orange}
      9  : ListePalette[Num].Couleur := TColor(RGB(V2,0,0)); {Marron}
      10 : ListePalette[Num].Couleur := TColor(RGB(V,0,V2)); {Rose}
      11 : ListePalette[Num].Couleur := TColor(RGB(V3,0,V2)); {Bordeau}
      12 : ListePalette[Num].Couleur := TColor(RGB(V2,0,V2)); {Violet}
      13 : ListePalette[Num].Couleur := TColor(RGB(0,0,V2)); {Bleu marine}
      14 : ListePalette[Num].Couleur := TColor(RGB(0,V2,V2)); {Turquoise}
      15 : ListePalette[Num].Couleur := TColor(RGB(0,V2,0)); {Vert bouteille}
      16 : ListePalette[Num].Couleur := TColor(RGB(V2,V2,0)); {Vert olive}
    end;
  end;
end;

procedure TFChoixVisible.InitVisible;
var
  N : integer;
begin
  for N := 0 to NbCouleurs-1 do ListePalette[N].Visible := true;
  for N := 0 to NbCouches-1 do ListeCouche[N] := true;
  for N := 1 to 3 do ListeElts[N]:= true;
end;

procedure TFChoixVisible.DrawSquare(Num: integer);
var
  WinTop, WinLeft : integer;
  RectCell : TRect;
  EstVisible : boolean;
begin
  if (Num >= 0) and (Num < NbChoix) then
  begin
    WinTop := 20 + (Num div NbLarg) * (HautCell + 6);
    WinLeft := MargeX + (Num mod NbLarg) * (LargCell + 4);
    RectCell := Bounds(WinLeft,WinTop,LargCell,HautCell);

    Canvas.Pen.Color := clBtnFace;
    Canvas.Brush.Color := clBtnFace;
    if Num < NbCouleurs then EstVisible := ListePalette[Num].Visible
    else
    if (Num >= NbCouleurs) and (Num < (NbCouleurs+NbCouches)) then
      EstVisible := ListeCouche[Num-NbCouleurs]
    else EstVisible := ListeElts[Num-NbCouleurs-NbCouches+1];
    if EstVisible then Frame3D(Canvas, RectCell, clBtnShadow, clBtnHighlight, 3)
                  else Frame3D(Canvas, RectCell, clBtnHighlight, clBtnShadow, 3);
    if Num < (NbCouleurs-1) then
    begin
      Canvas.Brush.Color := ListePalette[Num].Couleur;
      Canvas.Pen.Color := ListePalette[Num].Couleur;
    end
    else
    begin
      Canvas.Pen.Color := clBtnFace;
      Canvas.Brush.Color := clBtnFace;
    end;
    with RectCell do Canvas.Rectangle(Left,Top,Right,Bottom);

    if (Num >= NbCouleurs) and (Num < (NbCouleurs+NbCouches)) then
      Canvas.TextOut(WinLeft+8,WinTop+5,IntToStr(Num-NbCouleurs));
    if Num = (NbCouleurs+NbCouches) then
       Canvas.TextOut(WinLeft+12,WinTop+5,'P');
    if Num = (NbCouleurs+NbCouches+1) then
       Canvas.TextOut(WinLeft+12,WinTop+5,'L');
    if Num = (NbCouleurs+NbCouches+2) then
       Canvas.TextOut(WinLeft+12,WinTop+5,'C');
  end;
end;

function TFChoixVisible.PosToCell(X,Y : integer): integer;
var
  Col,Lig : integer;
begin
  X := X - MargeX;
  Y := Y - 20;
  if X > (Width - 1) then X := Width - 1;
  if X < 0 then X := 0;
  if Y > (Height - 1) then Y := Height - 1;
  if Y < 0 then Y := 0;
  Col := (X div (LargCell + 4));
  Lig := (Y div (HautCell + 6));
  Result := Lig * NbLarg + Col;
end;

procedure TFChoixVisible.FormPaint(Sender: TObject);
var
  Numero: integer;
begin
  NbChoix := NbCouleurs + NbCouches + 3;
  BtnOk.Visible := false;
  BtnCancel.Visible := false;
  for Numero := 0 to NbChoix do DrawSquare(Numero);
  Update;
  BtnOk.Visible := true;
  BtnCancel.Visible := true;
end;

procedure TFChoixVisible.FormMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  Num : integer;
begin
  Num := PosTocell(X,Y);
  if Button = mbLeft then
  begin
    if Num < NbCouleurs then
      ListePalette[Num].Visible := not ListePalette[Num].Visible;
    if ((Num >= NbCouleurs)  and (Num < (NbCouleurs+NbCouches))) then
      ListeCouche[Num-NbCouleurs] := not ListeCouche[Num-NbCouleurs];
    if Num >= (NbCouleurs+NbCouches) then
       ListeElts[Num-(NbCouleurs+NbCouches)+1] :=
          not ListeElts[Num-(NbCouleurs+NbCouches)+1];
    DrawSquare(Num);
  end;
end;

function TFChoixVisible.Execute:boolean;
var
  N : integer;
begin
  Terminaison := false;
  for N := 0 to NbCouleurs-1 do OldPalette[N] := ListePalette[N];
  for N := 0 to NbCouches-1 do OldCouche[N] := ListeCouche[N];
  for N := 1 to 3 do OldElts[N] := ListeElts[N];
  ShowModal;
  Result := Terminaison;
end;

procedure TFChoixVisible.BtnOkClick(Sender: TObject);
begin
  Terminaison := True;
  close;
end;

procedure TFChoixVisible.BtnCancelClick(Sender: TObject);
var
  N : integer;
begin
  Terminaison := false;
  for N := 0 to NbCouleurs do ListePalette[N] := OldPalette[N];
  for N := 0 to NbCouches do ListeCouche[N] := OldCouche[N];
  for N := 1 to 3 do ListeElts[N] := OldElts[N];
  close;
end;

function TFChoixVisible.CouleurVisible(Num : integer):boolean;
begin
  Result := ListePalette[Num].Visible;
end;

function TFChoixVisible.CoucheVisible(Num : integer):boolean;
begin
  Result := ListeCouche[Num];
end;

function TFChoixVisible.PointVisible:boolean;
begin
  Result := ListeElts[1];
end;

function TFChoixVisible.LigneVisible:boolean;
begin
  Result := ListeElts[2];
end;

function TFChoixVisible.CercleVisible:boolean;
begin
  Result := ListeElts[3];
end;


end.
