unit JDSaisie;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TSaisie = (tsReel,tsReelP,tsAngle);
  TFSaisie = class(TForm)
    Texte: TLabel;
    EditSaisie: TEdit;
    procedure FormShow(Sender: TObject);
    procedure EditSaisieKeyPress(Sender: TObject; var Key: Char);
  private
    { Dclarations prives }
    procedure ControleSaisie(var Key:char);
  public
    { Dclarations publiques }
    Style: TSaisie;
    Terminaison : char;
    Valable     : boolean;
  end;

var
  FSaisie: TFSaisie;

implementation

{$R *.DFM}

uses Main;

procedure TFSaisie.FormShow(Sender: TObject);
begin
  Left := FPrincipale.Left + FPrincipale.Width - Width - 4;
  Top := FPrincipale.Top + FPrincipale.Height - Height - 4;
end;

procedure TFSaisie.ControleSaisie(var Key : char);
var
  Nb,NbChar : integer;
  Texte     : string;
  Valeur    : extended;
begin
  Terminaison := Key;
  if Terminaison = #13 then
  begin
    Key := #0;
    Valable := true;
    Texte := EditSaisie.Text;
    Nb := 1;
    NbChar := length(Texte);
    if NbChar = 0 then Valable := false;
    while (Nb < NbChar) and Valable do
    begin
      if Style = tsReelP then
      begin
        if not (Texte[Nb] in ['0'..'9','.','+','E'])
           then Valable := false;
      end
      else
        if not (Texte[Nb] in ['0'..'9','.','+','-','E'])
           then Valable := false;
      inc(Nb);
    end;
    if Valable and (Style = tsAngle) then
    begin
      Valeur := StrToFloat(Texte);
      if (Valeur < -360) or (Valeur > 360) then Valable := false;
    end;
    if not Valable then
    begin
      case Style of
        tsReel  : MessageDlg('Valeur incorrecte',mtWarning,[mbOk], 0);
        tsReelP : MessageDlg('Valeur positive incorrecte',mtWarning,[mbOk], 0);
        tsAngle : MessageDlg('Valeur angulaire incorrecte (+ - 360)',mtWarning,[mbOk], 0);
      end;
      Terminaison := #0;
    end;
  end;
  if Terminaison in [#13,#27] then close;
end;

procedure TFSaisie.EditSaisieKeyPress(Sender: TObject; var Key: Char);
begin
  ControleSaisie(Key);
end;

end.
