unit JDGraph;

interface

uses
  Windows, Graphics, JDData;
type
  TObjet =
    record
      NbPoint  : integer;
      NumPoint : integer;
      NbLigne  : integer;
      NumLigne : array [1..2] of integer;
      NbCercle : integer;
      NumCercle: array [1..2] of integer;
    end;

  TCfgCnv =
    record
      OffsetX   : extended;
      OffsetY   : extended;
      Echelle   : extended;
      MaxPixelX : integer;
      MaxPixelY : integer;
    end;

var
  Imprimante : TCfgCnv;
  Affichage  : TCfgCnv;
  Apercu     : TCfgCnv;

procedure CalculEchelle;
function XToXPixel(ValX : extended;CfgCnv: TCfgCnv) : integer;
function YToYPixel(ValY : extended;CfgCnv: TCfgCnv) : integer;
function XPixelToX(ValX : integer;CfgCnv: TCfgCnv) : extended;
function YPixelToY(ValY : integer;CfgCnv: TCfgCnv) : extended;

function DetectDG(Xs: integer;Xp: extended):char;
function DetectHB(Ys: integer;Yp: extended):char;
function DetectPos(Xs,Ys: integer;Xp,Yp: extended):char;

procedure InitGraph;
procedure EffaceEcran;
procedure RedessineEcran;
procedure DessinePoint(LePoint : DefPoint;Cnv: TCanvas;CfgCnv: TCfgCnv);
procedure DessineLigne(LaLigne : DefLigne;Cnv: TCanvas;CfgCnv: TCfgCnv);
procedure DessineCercle(LeCercle : DefCercle;Cnv: TCanvas;CfgCnv: TCfgCnv);
procedure DessineTout(Cnv: TCanvas;CfgCnv: TCfgCnv);
procedure EffacePoint(LePoint : DefPoint;Cnv: TCanvas;CfgCnv: TCfgCnv);
procedure EffaceLigne(LaLigne : DefLigne;Cnv: TCanvas;CfgCnv: TCfgCnv);
procedure EffaceCercle(LeCercle : DefCercle;Cnv: TCanvas;CfgCnv: TCfgCnv);

procedure DecaleZoom;
procedure AjouteZoom(X1,X2,Y1,Y2 : extended);
procedure ZoomOrigine;
procedure ZoomMoins;
procedure ZoomPlus;
procedure ZoomCadre(P1, P2: TPoint);
procedure ZoomPrecedent;
procedure ZoomSuivant;
procedure CadrageAuto;
procedure ZoomEchelle(P1 : TPoint;Echelle : extended);

function DetectPoint(X,Y : integer;Var Num : integer): boolean;
function DetectLignes(X,Y : integer;Var Num1,Num2 : integer): integer;
function DetectCercles(X,Y : integer;Var Num1,Num2 : integer): integer;
function DetectObjets(X,Y : integer;Var LObjet : TObjet): boolean;

procedure InitImpCentre(MilieuX,MilieuY,Ech : extended);
procedure InitImpCadre(XMin,YMin,XMax,YMax : extended);
procedure ImprimeTout;

implementation

uses
  Main, Math, Classes, Forms, Controls, Printers, JDCalcul, JDEdit, JDColor,
  JDVisible,SysUtils;

type
  UnZoom = record
             MinX : extended;
             MaxX : extended;
             MinY : extended;
             MaxY : extended;
           end;

var
  MaxiX, MaxiY, MiniX, MiniY : extended; {maxi et mini du graph en mm}
  ListeZoom : array[1..20]of UnZoom; {Liste des Zoom}
  ZoomCourant, DernierZoom : integer;

// Utilitaires graphiques

procedure GetTailleEcran;
begin
  with Affichage do
  begin
    MaxPixelX := FPrincipale.ZoneGraphique.Width;
    MaxPixelY := FPrincipale.ZoneGraphique.Height;
  end;
end;

procedure CalculEchelle;
var
  EchX, EchY : extended;
  MilieuX, MilieuY : extended;
begin
  GetTailleEcran;
  with Affichage do
  begin
    if MaxiX = MiniX then EchX := 0
      else EchX := MaxPixelX/(MaxiX - MiniX);
    if MaxiY = MiniY then EchY := 0
      else EchY := MaxPixelY/(MaxiY - MiniY);
    if (EchX=0) and (EchY=0) then Echelle := 1
    else
    begin
      if (EchX=0) or (EchY=0) then
      begin
        if EchX = 0 then Echelle := EchY;
        if EchY = 0 then Echelle := EchX;
      end
      else
      if EchX < EchY then Echelle := EchX
                     else Echelle := EchY;
    end;
    { Calcul le milieu d'cran en mm pour obtenir l'offset }
    MilieuX := (MaxiX + MiniX)/2;
    MilieuY := (MaxiY + MiniY)/2;
    OffsetX := -((MaxPixelX / (2*Echelle)) - MilieuX);
    OffsetY := -((MaxPixelY / (2*Echelle)) - MilieuY);
  end;
end;

function XToXPixel(ValX : extended;CfgCnv : TCfgCnv) : integer;
begin
  with CfgCnv do
  Result := Arrondi((ValX - OffsetX)*Echelle);
end;

function YToYPixel(ValY : extended;CfgCnv : TCfgCnv) : integer;
begin
  with CfgCnv do
  Result := MaxPixelY - Arrondi((ValY - OffsetY)*Echelle);
end;

function XPixelToX(ValX : integer;CfgCnv : TCfgCnv) : extended;
begin
  with CfgCnv do
  result := (ValX/Echelle)+OffsetX;
end;

function YPixelToY(ValY : integer;CfgCnv : TCfgCnv) : extended;
begin
  with CfgCnv do
  result := ((MaxPixelY-ValY)/Echelle)+OffsetY;
end;

function DetectDG(Xs: integer;Xp: extended):char;
{Xs position souris; Xp coordonnees du point de reference}
var
  X: extended;
begin
  Result := ' ';
  X := XPixelToX(Xs,Affichage);
  if X > Xp then Result := 'D'
  else
  if X < Xp then Result := 'G';
end;

function DetectHB(Ys: integer;Yp: extended):char;
{Ys position souris; Yp coordonnees du point de reference}
var
  Y: extended;
begin
  Result := ' ';
  Y := YPixelToY(Ys,Affichage);
  if Y > Yp then Result := 'H'
  else
  if Y < Yp then Result := 'B';
end;

function DetectPos(Xs,Ys: integer;Xp,Yp: extended):char;
{Xs,Ys position souris; Xp,Yp coordonnees du point de reference}
var
  X,Y : extended;
  EcartX, EcartY : extended;
begin
  X := XPixelToX(Xs,Affichage);
  Y := YPixelToY(Ys,Affichage);
  EcartX := abs(Xp-X);
  EcartY := abs(Yp-Y);
  if EcartX > EcartY then Result := DetectDG(Xs,Xp)
                     else Result := DetectHB(Ys,Yp);
end;

// Procedure d'initialisation du graphique

procedure InitGraph;
begin
  MiniX := -80.;
  MaxiX := 80.;
  MiniY := -80.;
  MaxiY := 80.;
  CalculEchelle;
  ZoomCourant := 0;
  AjouteZoom(MiniX,MaxiX,MiniY,MaxiY);
end;

// Procedures d'affichage ecran

procedure EffaceEcran;
var
  Bitmap: TBitmap;
begin
  GetTailleEcran;
  with Affichage do
  begin
    FPrincipale.Dessin.Width := MaxPixelX;
    FPrincipale.Dessin.Height := MaxPixelY;
    FPrincipale.Dessin.Update;
    Bitmap := TBitmap.Create;
    Bitmap.Width := MaxPixelX;
    Bitmap.Height := MaxPixelY;
    Fprincipale.Dessin.Picture.Graphic := Bitmap;
    FPrincipale.Dessin.Canvas.Draw(0,0,Bitmap);
    Bitmap.Free;
  end;
end;

procedure RedessineEcran;

begin
  EffaceEcran;
  DessineTout(FPrincipale.Dessin.Canvas,Affichage);
end;

// Procedures d'affichage gomtrie

procedure DessinePoint(LePoint: DefPoint;Cnv: TCanvas;CfgCnv: TCfgCnv);
var
  XPixel, YPixel : integer;
  Delta : integer;
begin
  if not FChoixVisible.PointVisible then exit;
  if not FChoixVisible.CouleurVisible(LePoint.Cl) then exit;
  if not FChoixVisible.CoucheVisible(LePoint.Cc) then exit;
  with CfgCnv do
  begin
    XPixel := XtoXPixel(LePoint.X,CfgCnv);
    YPixel := YToYPixel(LePoint.Y,CfgCnv);
  end;
  if Cnv = Printer.Canvas then Delta := 10
                          else delta := 3;
  with Cnv do
  begin
    Pen.Mode := pmCopy;
    Pen.Color := EntreePalette[LePoint.Cl];
    MoveTo(XPixel - (Delta-1),YPixel - (Delta-1));
    LineTo(XPixel + Delta,YPixel + Delta);
    MoveTo(XPixel + (Delta-1),YPixel - (Delta-1));
    LineTo(XPixel - Delta,YPixel + Delta);
  end;
end;

procedure DessineLigne(LaLigne : DefLigne;Cnv: TCanvas;CfgCnv: TCfgCnv);
var
  PointsTrouve : integer;
  XPixel, YPixel : integer;
  X, Y : integer;
  Alpha, Beta : extended;
  P : array [1..2] of TPoint;

  procedure MemoPoint;
  begin
    if PointsTrouve = 2 then exit;
    inc(PointsTrouve);
    P[PointsTrouve] := Point(X,Y);
  end;

begin
  if not FChoixVisible.LigneVisible then exit;
  if not FChoixVisible.CouleurVisible(LaLigne.Cl) then exit;
  if not FChoixVisible.CoucheVisible(LaLigne.Cc) then exit;

  PointsTrouve := 0;

  with CfgCnv do
  begin
    XPixel := XToXPixel(LaLigne.Xpd,CfgCnv);
    YPixel := YToYPixel(LaLigne.Ypd,CfgCnv);

    Alpha := LaLigne.Aod;
    if Alpha >= Pi then Alpha := Alpha - Pi;

    if (Alpha = 0) and (YPixel >0) and (YPixel < MaxPixelY) then
    begin
      Y := YPixel;
      X := 0;
      MemoPoint;
      X := MaxPixelX;
      MemoPoint;
    end
    else
    if (Alpha = DegToRad(90)) and (XPixel >0) and (XPixel < MaxPixelX) then
    begin
      X := XPixel;
      Y := 0;
      MemoPoint;
      Y := MaxPixelY;
      MemoPoint;
    end
    else
    if not ((Alpha=0) or (Alpha=DegToRad(90))) then
    begin
      if ((Alpha>DegToRad(45)) and (Alpha<DegToRad(135))) then
      begin
        Beta := Alpha - DegToRad(90);
        Y := 0;
        X := XPixel - Arrondi(YPixel*Tan(Beta));
        if (X >=0) and (X <= MaxPixelX)then MemoPoint;

        Y := MaxPixelY;
        X := XPixel + Arrondi((MaxPixelY - YPixel)*Tan(Beta));
        if (X >=0) and (X <= MaxPixelX)then MemoPoint;
      end
      else
      begin
        Y := 0;
        X := XPixel + Arrondi(YPixel/Tan(Alpha));
        if (X >=0) and (X <= MaxPixelX)then MemoPoint;

        Y := MaxPixelY;
        X := XPixel - Arrondi((MaxPixelY - YPixel)/Tan(Alpha));
        if (X >=0) and (X <= MaxPixelX)then MemoPoint;
      end;

      X := 0;
      Y := YPixel + Arrondi(XPixel*Tan(Alpha));
      if (Y >=0) and (Y <= MaxPixelY)then MemoPoint;

      X := MaxPixelX;
      Y := YPixel - Arrondi((MaxPixelX - XPixel)*Tan(Alpha));
      if (Y >=0) and (Y <= MaxPixelX)then MemoPoint;
    end;
  end;

  if PointsTrouve = 2 then
  with Cnv do
  begin
    Pen.Mode := pmCopy;
    Pen.Color := EntreePalette[LaLigne.Cl];
    MoveTo(P[1].X,P[1].Y);
    LineTo(P[2].X,P[2].Y);
  end;
end;

procedure DessineCercle(LeCercle : DefCercle;Cnv: TCanvas;CfgCnv: TCfgCnv);
var
  XPixel, YPixel : integer;
  RayonPixel : integer;
  X1, Y1, X2, Y2 : integer;
begin
  if not FChoixVisible.CercleVisible then exit;
  if not FChoixVisible.CouleurVisible(LeCercle.Cl) then exit;
  if not FChoixVisible.CoucheVisible(LeCercle.Cc) then exit;

  with CfgCnv do
  begin
    XPixel := XToXPixel(LeCercle.Xc,CfgCnv);
    YPixel := YToYPixel(LeCercle.Yc,CfgCnv);
    RayonPixel := Arrondi(LeCercle.Rc*Echelle);
  end;

  with Cnv do
  begin
    Pen.Mode := pmCopy;
    Pen.Color := EntreePalette[LeCercle.Cl];
    Brush.Style := bsClear;
    X1 := XPixel-RayonPixel;
    Y1 := YPixel-RayonPixel;
    X2 := XPixel+RayonPixel;
    Y2 := YPixel+RayonPixel;
    Ellipse(X1,Y1,X2,Y2);
  end;
end;

procedure DessineTout(Cnv: TCanvas;CfgCnv: TCfgCnv);
var
  LePoint: DefPoint;
  LaLigne: DefLigne;
  LeCercle: DefCercle;
begin
  VerrouilleTables(false);

  if LitPremierPoint(LePoint) then
  begin
    DessinePoint(LePoint,Cnv,CfgCnv);
    while LitPointSuivant(LePoint) do DessinePoint(LePoint,Cnv,CfgCnv);
  end;

  if LitPremiereLigne(LaLigne) then
  begin
    DessineLigne(LaLigne,Cnv,CfgCnv);
    while LitLigneSuivante(LaLigne) do DessineLigne(LaLigne,Cnv,CfgCnv);
  end;

  if LitPremierCercle(LeCercle) then
  begin
    DessineCercle(LeCercle,Cnv,CfgCnv);
    while LitCercleSuivant(LeCercle) do DessineCercle(LeCercle,Cnv,CfgCnv);
  end;

  VerrouilleTables(true);
end;

procedure EffacePoint(LePoint : DefPoint;Cnv: TCanvas;CfgCnv: TCfgCnv);
var
  XPixel, YPixel : integer;
begin
  with CfgCnv do
  begin
    XPixel := XToXPixel(LePoint.X,CfgCnv);
    YPixel := YToYPixel(LePoint.Y,CfgCnv);
  end;
  with Cnv do
  begin
    Pen.Mode := pmNotXor;
    Pen.Color := EntreePalette[LePoint.Cl];
    MoveTo(XPixel - 2,YPixel - 2);
    LineTo(XPixel + 3,YPixel + 3);
    MoveTo(XPixel + 2,YPixel - 2);
    LineTo(XPixel - 3,YPixel + 3);
  end;
end;

procedure EffaceLigne(LaLigne : DefLigne;Cnv: TCanvas;CfgCnv: TCfgCnv);

var
  PointsTrouve : integer;
  XPixel, YPixel : integer;
  X, Y : integer;
  P : array [1..2] of TPoint;

  procedure MemoPoint;
  begin
    if PointsTrouve = 2 then exit;
    inc(PointsTrouve);
    P[PointsTrouve] := Point(X,Y);
  end;

begin
  PointsTrouve := 0;
  with CfgCnv do
  begin
    XPixel := XToXPixel(LaLigne.Xpd,CfgCnv);
    YPixel := YToYPixel(LaLigne.Ypd,CfgCnv);

    if ((LaLigne.Aod=0) or (LaLigne.Aod=DegToRad(180)))
      and (YPixel >0) and (YPixel < MaxPixelY) then
    begin
      Y := YPixel;
      X := 0;
      MemoPoint;
      X := MaxPixelX;
      MemoPoint;
    end
    else
    if ((LaLigne.Aod=DegToRad(90)) or (LaLigne.Aod=DegToRad(270)))
      and (XPixel >0) and (XPixel < MaxPixelX) then
    begin
      X := XPixel;
      Y := 0;
      MemoPoint;
      Y := MaxPixelY;
      MemoPoint;
    end
    else
    begin
      Y := 0;
      X := XPixel + Arrondi(YPixel/Tan(LaLigne.Aod));
      if (X >=0) and (X <= MaxPixelX)then MemoPoint;

      Y := MaxPixelY;
      X := XPixel - Arrondi((MaxPixelY - YPixel)/Tan(LaLigne.Aod));
      if (X >=0) and (X <= MaxPixelX)then MemoPoint;

      X := 0;
      Y := YPixel + Arrondi(XPixel*Tan(LaLigne.Aod));
      if (Y >=0) and (Y <= MaxPixelY)then MemoPoint;

      X := MaxPixelX;
      Y := YPixel - Arrondi((MaxPixelX - XPixel)*Tan(LaLigne.Aod));
      if (Y >=0) and (Y <= MaxPixelX)then MemoPoint;
    end;
  end;

  if PointsTrouve = 2 then
  with Cnv do
  begin
    Pen.Mode := pmNotXor;
    Pen.Color := EntreePalette[LaLigne.Cl];
    MoveTo(P[1].X,P[1].Y);
    LineTo(P[2].X,P[2].Y);
  end;
end;

procedure EffaceCercle(LeCercle : DefCercle;Cnv: TCanvas;CfgCnv: TCfgCnv);
var
  XPixel, YPixel : integer;
  RayonPixel : integer;
  X1, Y1, X2, Y2 : integer;
begin
  with CfgCnv do
  begin
    XPixel := XToXPixel(LeCercle.Xc,CfgCnv);
    YPixel := YToYPixel(LeCercle.Yc,CfgCnv);
    RayonPixel := Arrondi(LeCercle.Rc*Echelle)+2;
  end;

  with Cnv do
  begin
    Pen.Mode := pmNotXor;
    Pen.Color := EntreePalette[LeCercle.Cl];
    Brush.Style := bsClear;
    X1 := XPixel-RayonPixel;
    Y1 := YPixel-RayonPixel;
    X2 := XPixel+RayonPixel;
    Y2 := YPixel+RayonPixel;
    Ellipse(X1,Y1,X2,Y2);
  end;
end;

// Procedures de zoom

procedure DecaleZoom;
var
  N : integer;
begin
  for N := 1 to 9 do ListeZoom[N] := ListeZoom[N+1];
  dec(ZoomCourant);
end;

procedure AjouteZoom(X1,X2,Y1,Y2 : extended);
begin
  if ZoomCourant = 20 then DecaleZoom;
  inc(ZoomCourant);
  with ListeZoom[ZoomCourant] do
  begin
    MinX := X1;
    MaxX := X2;
    MinY := Y1;
    MaxY := Y2;
  end;
  DernierZoom := ZoomCourant;
  if ZoomCourant > 1 then
  begin
    FPrincipale.BtnZoomPrecedent1.Enabled := true;
    FPrincipale.BtnZoomPrecedent2.Enabled := true;
    FPrincipale.BtnZoomPrecedent3.Enabled := true;
    FPrincipale.BtnZoomPrecedent4.Enabled := true;
  end
  else
  begin
    FPrincipale.BtnZoomPrecedent1.Enabled := false;
    FPrincipale.BtnZoomPrecedent2.Enabled := false;
    FPrincipale.BtnZoomPrecedent3.Enabled := false;
    FPrincipale.BtnZoomPrecedent4.Enabled := false;
  end;
end;

procedure ZoomOrigine;
begin
  FPrincipale.BtnZoomPrecedent1.Enabled := false;
  FPrincipale.BtnZoomPrecedent2.Enabled := false;
  FPrincipale.BtnZoomPrecedent3.Enabled := false;
  FPrincipale.BtnZoomPrecedent4.Enabled := false;

  FPrincipale.BtnZoomSuivant1.Enabled := false;
  FPrincipale.BtnZoomSuivant2.Enabled := false;
  FPrincipale.BtnZoomSuivant3.Enabled := false;
  FPrincipale.BtnZoomSuivant4.Enabled := false;

  InitGraph;
  RedessineEcran;
end;

procedure ZoomMoins;
var
  Larg, Haut : extended;
  MilieuX, MilieuY : extended;
begin
  Larg := (MaxiX - MiniX);
  Haut := (MaxiY - MiniY);
  MilieuX := (MaxiX + MiniX)/2;
  MilieuY := (MaxiY + MiniY)/2;
  MiniX := MilieuX - Larg;
  MaxiX := MilieuX + Larg;
  MiniY := MilieuY - Haut;
  MaxiY := MilieuY + Haut;
  CalculEchelle;
  RedessineEcran;
end;

procedure ZoomPlus;
var
  Larg, Haut : extended;
  MilieuX, MilieuY : extended;
begin
  Larg := (MaxiX - MiniX)/4;
  Haut := (MaxiY - MiniY)/4;
  MilieuX := (MaxiX + MiniX)/2;
  MilieuY := (MaxiY + MiniY)/2;
  MiniX := MilieuX - Larg;
  MaxiX := MilieuX + Larg;
  MiniY := MilieuY - Haut;
  MaxiY := MilieuY + Haut;
  CalculEchelle;
  RedessineEcran;
end;

procedure ZoomCadre(P1, P2: TPoint);
var
  P0 : TPoint;
begin
  if P1.X > P2.X then
  begin
    P0.X := P1.X;
    P1.X := P2.X;
    P2.X := P0.X;
  end;
  if P1.Y > P2.Y then
  begin
    P0.Y := P1.Y;
    P1.Y := P2.Y;
    P2.Y := P0.Y;
  end;
  MiniX := XPixelToX(P1.X,Affichage);
  MaxiX := XPixelToX(P2.X,Affichage);
  MiniY := YPixelToY(P2.Y,Affichage);
  MaxiY := YPixelToY(P1.Y,Affichage);
  AjouteZoom(MiniX,MaxiX,MiniY,MaxiY);
  CalculEchelle;
  RedessineEcran;
end;

procedure ZoomPrecedent;
begin
  dec(ZoomCourant);

  if ZoomCourant = 1 then
  begin
    FPrincipale.BtnZoomPrecedent1.Enabled := false;
    FPrincipale.BtnZoomPrecedent2.Enabled := false;
    FPrincipale.BtnZoomPrecedent3.Enabled := false;
    FPrincipale.BtnZoomPrecedent4.Enabled := false;
  end;

  FPrincipale.BtnZoomSuivant1.Enabled := true;
  FPrincipale.BtnZoomSuivant2.Enabled := true;
  FPrincipale.BtnZoomSuivant3.Enabled := true;
  FPrincipale.BtnZoomSuivant4.Enabled := true;

  with ListeZoom[ZoomCourant] do
  begin
    MiniX := MinX;
    MaxiX := MaxX;
    MiniY := MinY;
    MaxiY := MaxY;
  end;
  CalculEchelle;
  RedessineEcran;
end;

procedure ZoomSuivant;
begin
  inc(ZoomCourant);

  if ZoomCourant = DernierZoom then
  begin
    FPrincipale.BtnZoomSuivant1.Enabled := false;
    FPrincipale.BtnZoomSuivant2.Enabled := false;
    FPrincipale.BtnZoomSuivant3.Enabled := false;
    FPrincipale.BtnZoomSuivant4.Enabled := false;
  end;

  FPrincipale.BtnZoomPrecedent1.Enabled := true;
  FPrincipale.BtnZoomPrecedent2.Enabled := true;
  FPrincipale.BtnZoomPrecedent3.Enabled := true;
  FPrincipale.BtnZoomPrecedent4.Enabled := true;

  with ListeZoom[ZoomCourant] do
  begin
    MiniX := MinX;
    MaxiX := MaxX;
    MiniY := MinY;
    MaxiY := MaxY;
  end;
  CalculEchelle;
  RedessineEcran;
end;

procedure RechercheMiniMaxi(var MinX,MaxX,MinY,MaxY : extended);
var
  LePoint : DefPoint;
  LaLigne : DefLigne;
  LeCercle: DefCercle;
  Marge   : integer;

  procedure RecherchePoint;
  begin
    with LePoint do
    begin
      if X < MinX then MinX := X;
      if X > MaxX then MaxX := X;
      if Y < MinY then MinY := Y;
      if Y > MaxY then MaxY := Y;
    end;
  end;

  procedure RechercheLigne;
  begin
    with LaLigne do
    begin
      if Xpd < MinX then MinX := Xpd;
      if Xpd > MaxX then MaxX := Xpd;
      if Ypd < MinY then MinY := Ypd;
      if Ypd > MaxY then MaxY := Ypd;
    end;
  end;

  procedure RechercheCercle;
  begin
    with LeCercle do
    begin
      if Xc-Rc < MinX then MinX := Xc-Rc;
      if Xc+Rc > MaxX then MaxX := Xc+Rc;
      if Yc-Rc < MinY then MinY := Yc-Rc;
      if Yc+Rc > MaxY then MaxY := Yc+Rc;
    end;
  end;

begin
  VerrouilleTables(false);

  if LitPremierPoint(LePoint) then
  begin
    RecherchePoint;
    while LitPointSuivant(LePoint) do RecherchePoint;
  end;

  if LitPremiereLigne(LaLigne) then
  begin
    RechercheLigne;
    while LitLigneSuivante(LaLigne) do RechercheLigne;
  end;

  if LitPremierCercle(LeCercle) then
  begin
    RechercheCercle;
    while LitCercleSuivant(LeCercle) do RechercheCercle;
  end;

  VerrouilleTables(true);

  Marge := Arrondi(10/Affichage.Echelle);
  MinX := MinX - Marge;
  MaxX := MaxX + Marge;
  MinY := MinY - Marge;
  MaxY := MaxY + Marge;
end;

procedure CadrageAuto;
begin
  MiniX := 0;
  MaxiX := 0;
  MiniY := 0;
  MaxiY := 0;
  RechercheMiniMaxi(MiniX,MaxiX,MiniY,MaxiY);
  if not (((MiniX=0)and(MaxiX=0))or ((MiniY=0)and(MaxiY=0)))then
  begin
    CalculEchelle;
    RedessineEcran;
    ZoomCourant := 0;
    AjouteZoom(MiniX,MaxiX,MiniY,MaxiY);
  end;
end;

procedure ZoomEchelle(P1 : TPoint;Echelle : extended);
var
  XCentre, YCentre : extended;
  Larg, Haut : extended;
begin
  XCentre := XPixelToX(P1.X,Affichage);
  YCentre := YPixelToY(P1.Y,Affichage);
  Larg := (MaxiX - MiniX)/(2*Affichage.Echelle);
  Haut := (MaxiY - MiniY)/(2*Affichage.Echelle);
  MiniX := XCentre - Larg;
  MaxiX := XCentre + Larg;
  MiniY := YCentre - Haut;
  MaxiY := YCentre + Haut;
  AjouteZoom(MiniX,MaxiX,MiniY,MaxiY);
  CalculEchelle;
  RedessineEcran;
end;

// Procedures de dtection

function DetectPoint(X,Y : integer;Var Num : integer): boolean;
var
  P1,P2: DefPoint;
  Tolerance,Erreur: extended;

  procedure CalculErreur;
  begin
    if not FChoixVisible.CouleurVisible(P2.Cl) then exit;
    if not FChoixVisible.CoucheVisible(P2.Cc) then exit;

    Erreur := Distance2Points(P1,P2);
    if Erreur < Tolerance then
    begin
      Tolerance := Erreur;
      Num := P2.Num;
      Result := true;
    end;
  end;

begin
  result := false;
  if not FChoixVisible.PointVisible then exit;
  Num := 0;
  P1.X := XPixelToX(X,Affichage);
  P1.Y := YpixelToY(Y,Affichage);
  Tolerance := 9/Affichage.Echelle;
  if LitPremierPoint(P2) then
  begin
    CalculErreur;
    while LitPointSuivant(P2) do CalculErreur;
  end;
end;

function DetectLignes(X,Y : integer;Var Num1,Num2 : integer): integer;
var
  P1,P2: DefPoint;
  L1: DefLigne;
  Tolerance: extended;
  Erreur,Erreur1,Erreur2: extended;
  Nombre : integer;

  procedure CalculErreur;
  begin
    if not FChoixVisible.CouleurVisible(L1.Cl) then exit;
    if not FChoixVisible.CoucheVisible(L1.Cc) then exit;

    P2 := PointLignePoint(P1,L1);
    Erreur := Distance2Points(P1,P2);
    if Erreur < Tolerance then
    begin
      case Nombre of
        0 : begin
              Erreur1 := Erreur;
              Num1 := L1.Num;
              inc(Nombre);
            end;
        1 : begin
              if Erreur < Erreur1 then
              begin
                Erreur2 := Erreur1;
                Num2 := Num1;
                Erreur1 := Erreur;
                Num1 := L1.Num;
                inc(Nombre);
              end
              else
              begin
                Erreur2 := Erreur;
                Num2 := L1.Num;
                inc(Nombre);
              end;
            end;
        2 : begin
              if Erreur < Erreur1 then
              begin
                Erreur2 := Erreur1;
                Num2 := Num1;
                Erreur1 := Erreur;
                Num1 := L1.Num;
              end
              else
              if Erreur < Erreur2 then
              begin
                Erreur2 := Erreur;
                Num2 := L1.Num;
              end;
            end;
      end;
    end;
  end;

begin
  Result := 0;
  if not FChoixVisible.LigneVisible then exit;

  Nombre := 0;
  Num1 := 0;
  Num2 := 0;
  P1.X := XPixelToX(X,Affichage);
  P1.Y := YpixelToY(Y,Affichage);
  Tolerance := 9/Affichage.Echelle;
  if LitPremiereLigne(L1) then
  begin
    CalculErreur;
    while LitLigneSuivante(L1) do CalculErreur;
  end;
  Result := Nombre;
end;

function DetectCercles(X,Y : integer;Var Num1,Num2 : integer): integer;
var
  P1,P2: DefPoint;
  C1: DefCercle;
  Tolerance: extended;
  Erreur,Erreur1,Erreur2: extended;
  Nombre : integer;

  procedure CalculErreur;
  begin
    if not FChoixVisible.CouleurVisible(C1.Cl) then exit;
    if not FChoixVisible.CoucheVisible(C1.Cc) then exit;

    P2.X := C1.Xc;
    P2.Y := C1.Yc;
    Erreur := Distance2Points(P1,P2) - C1.Rc;
    if (Erreur > -Tolerance) and (Erreur < Tolerance) then
    begin
      case Nombre of
        0 : begin
              Erreur1 := Erreur;
              Num1 := C1.Num;
              inc(Nombre);
            end;
        1 : begin
              if Erreur < Erreur1 then
              begin
                Erreur2 := Erreur1;
                Num2 := Num1;
                Erreur1 := Erreur;
                Num1 := C1.Num;
                inc(Nombre);
              end
              else
              begin
                Erreur2 := Erreur;
                Num2 := C1.Num;
                inc(Nombre);
              end;
            end;
        2 : begin
              if Erreur < Erreur1 then
              begin
                Erreur2 := Erreur1;
                Num2 := Num1;
                Erreur1 := Erreur;
                Num1 := C1.Num;
              end
              else
              if Erreur < Erreur2 then
              begin
                Erreur2 := Erreur;
                Num2 := C1.Num;
              end;
            end;
      end;
    end;
  end;

begin
  Result := 0;
  if not FChoixVisible.CercleVisible then exit;

  Nombre := 0;
  Num1 := 0;
  Num2 := 0;
  P1.X := XPixelToX(X,Affichage);
  P1.Y := YpixelToY(Y,Affichage);
  Tolerance := 9/Affichage.Echelle;
  if LitPremierCercle(C1) then
  begin
    CalculErreur;
    while LitCercleSuivant(C1) do CalculErreur;
  end;
  Result := Nombre;
end;

function DetectObjets(X,Y : integer;Var LObjet : TObjet): boolean;
begin
  Result := false;
  with LObjet do
  begin
    NbPoint := 0;
    NbLigne := 0;
    NbCercle := 0;
    if DetectPoint(X,Y,NumPoint) then NbPoint:= 1
                                 else NbPoint := 0;
    NbLigne := DetectLignes(X,Y,NumLigne[1],NumLigne[2]);
    Nbcercle:= DetectCercles(X,Y,NumCercle[1],NumCercle[2]);
    if (NbPoint>0) or (NbLigne>0) or (NbCercle>0) then Result := true;
  end;
end;

// Utilitaires pour l'imprimante

procedure InitImpCentre(MilieuX,MilieuY,Ech : extended);
var
  EchX, EchY : extended;
  MaxMmX, MaxMmY : extended;
begin
  with Imprimante do
  begin
    MaxPixelX := Printer.PageWidth;
    MaxPixelY := Printer.PageHeight;
    MaxMmX := GetDeviceCaps(Printer.Handle,HORZSIZE);
    MaxMmY := GetDeviceCaps(Printer.Handle,VERTSIZE);
    EchX := MaxPixelX/MaxMmX;
    EchY := MaxPixelY/MaxMmY;
    if EchX < EchY then Echelle := EchX * Ech
                   else Echelle := EchY * Ech;
    { Calcul le milieu de l'impression en mm pour obtenir l'offset }
    OffsetX := -((MaxPixelX / (2*Echelle)) - MilieuX);
    OffsetY := -((MaxPixelY / (2*Echelle)) - MilieuY);
  end;
end;

procedure InitImpCadre(XMin,YMin,XMax,YMax : extended);
var
  Larg, Haut : extended;
  EchX, EchY : extended;
  MilieuX,MilieuY : extended;
begin
  with Imprimante do
  begin
    MaxPixelX := Printer.PageWidth;
    MaxPixelY := Printer.PageHeight;
    Larg := XMax - XMin;
    Haut := YMax - YMin;
    EchX := MaxPixelX/Larg;
    EchY := MaxPixelY/Haut;
    if EchX < EchY then Echelle := EchX
                   else Echelle := EchY;
    { Calcul le milieu de l'impression en mm pour obtenir l'offset }
    MilieuX := (XMin + XMax)/2;
    MilieuY := (YMin + YMax)/2;
    OffsetX := -((MaxPixelX / (2*Echelle)) - MilieuX);
    OffsetY := -((MaxPixelY / (2*Echelle)) - MilieuY);
  end;
end;

procedure ImprimeTout;
begin
    Screen.Cursor := crHourGlass;
    Printer.Title := 'Impression :' + FPrincipale.Caption;
    Printer.BeginDoc;
    DessineTout(Printer.Canvas,Imprimante);
    Printer.EndDoc;
    Screen.Cursor := crDefault;
end;

end.
