unit JDFCanon;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

type
  TFFCanon = class(TForm)
    BitBtnOk: TBitBtn;
    TitreNum: TLabel;
    TitreX: TLabel;
    TitreY: TLabel;
    TitreRayon: TLabel;
    TitreXDebut: TLabel;
    TitreYDebut: TLabel;
    TitreAngleDebut: TLabel;
    TitreXFin: TLabel;
    TitreYFin: TLabel;
    TitreAngleFin: TLabel;
    TitreCouleur: TLabel;
    TitreCouche: TLabel;
    ValeurNum: TLabel;
    ValeurX: TLabel;
    ValeurY: TLabel;
    ValeurRayon: TLabel;
    ValeurXDebut: TLabel;
    ValeurYDebut: TLabel;
    ValeurAngleDebut: TLabel;
    ValeurXFin: TLabel;
    ValeurYFin: TLabel;
    ValeurAngleFin: TLabel;
    ValeurCouleur: TLabel;
    ValeurCouche: TLabel;
    CadreClCc: TBevel;
    CadreXY: TBevel;
    CadreXdYd: TBevel;
    CadreXfYf: TBevel;
    CadreAdAf: TBevel;
    Bevel1: TBevel;
    procedure BitBtnOkClick(Sender: TObject);
  private
    { Dclarations prives }
    Numero : integer;
    procedure InitPoint;
    procedure InitLigne;
    procedure InitCercle;
  public
    { Dclarations publiques }
    procedure Execute(LeType: char; Num : integer );
  end;

var
  FFCanon: TFFCanon;

implementation

{$R *.DFM}
uses Math, JDData;

procedure TFFCanon.InitPoint;
var
 P : DefPoint;
begin
  FFCanon.Height := 250;
  BitBtnOk.Top := FFCanon.Height - 70;
  CadreXY.Height := 57;
  TitreNum.Caption := 'Point numro : ';
  TitreX.Caption   := 'Coordonne X : ';
  TitreY.Caption   := 'Coordonne Y : ';
  ValeurNum.Caption := IntToStr(Numero);
  P := LitPoint(Numero);
  ValeurCouleur.Caption := IntToStr(P.Cl);
  ValeurCouche.Caption := IntToStr(P.Cc);
  ValeurX.Caption := FloatToStr(P.X);
  ValeurY.Caption := FloatToStr(P.Y);

  CadreClCc.Visible := true;
  CadreXY.Visible := true;
  CadreXdYd.Visible := false;
  CadreXfYf.Visible := false;
  CadreAdAf.Visible := false;

  TitreNum.Visible := true;
  TitreX.Visible := true;
  TitreY.Visible := true;
  TitreRayon.Visible := false;
  TitreXDebut.Visible := false;
  TitreYDebut.Visible := false;
  TitreAngleDebut.Visible := false;
  TitreXFin.Visible := false;
  TitreYFin.Visible := false;
  TitreAngleFin.Visible := false;

  ValeurNum.Visible := true;
  ValeurX.Visible := true;
  ValeurY.Visible := true;
  ValeurRayon.Visible := false;
  ValeurXDebut.Visible := false;
  ValeurYDebut.Visible := false;
  ValeurAngleDebut.Visible := false;
  ValeurXFin.Visible := false;
  ValeurYFin.Visible := false;
  ValeurAngleFin.Visible := false;
end;

procedure TFFCanon.InitLigne;
var
 L : DefLigne;
begin
  FFCanon.Height := 400;
  BitBtnOk.Top := FFCanon.Height - 70;
  CadreXY.Height := 81;
  TitreNum.Caption   := 'Ligne numro : ';
  TitreX.Caption     := ' X : ';
  TitreY.Caption     := ' Y : ';
  TitreRayon.Caption := 'Angle : ';

  ValeurNum.Caption := IntToStr(Numero);
  L := LitLigne(Numero);
  ValeurCouleur.Caption := IntToStr(L.Cl);
  ValeurCouche.Caption := IntToStr(L.Cc);
  ValeurX.Caption := FloatToStr(L.Xpd);
  ValeurY.Caption := FloatToStr(L.Ypd);
  ValeurRayon.Caption := FloatToStr(RadToDeg(L.Aod));
  ValeurXDebut.Caption := FloatToStr(L.Xdd);
  ValeurYDebut.Caption := FloatToStr(L.Ydd);
  ValeurXFin.Caption := FloatToStr(L.Xfd);
  ValeurYFin.Caption := FloatToStr(L.Xfd);

  CadreClCc.Visible := true;
  CadreXY.Visible := true;
  CadreXdYd.Visible := true;
  CadreXfYf.Visible := true;
  CadreAdAf.Visible := false;

  TitreNum.Visible := true;
  TitreX.Visible := true;
  TitreY.Visible := true;
  TitreRayon.Visible := true;
  TitreXDebut.Visible := true;
  TitreYDebut.Visible := true;
  TitreAngleDebut.Visible := false;
  TitreXFin.Visible := true;
  TitreYFin.Visible := true;
  TitreAngleFin.Visible := false;

  ValeurNum.Visible := true;
  ValeurX.Visible := true;
  ValeurY.Visible := true;
  ValeurRayon.Visible := true;
  ValeurXDebut.Visible := true;
  ValeurYDebut.Visible := true;
  ValeurAngleDebut.Visible := false;
  ValeurXFin.Visible := true;
  ValeurYFin.Visible := true;
  ValeurAngleFin.Visible := false;

  FFCanon.Position := poScreenCenter;
  Update;
end;

procedure TFFCanon.InitCercle;
var
 C : DefCercle;
begin
  FFCanon.Height := 458;
  BitBtnOk.Top := FFCanon.Height - 70;
  CadreXY.Height := 81;
  TitreNum.Caption := 'Cercle numro : ';
  TitreX.Caption   := 'X du centre : ';
  TitreY.Caption   := 'Y du centre : ';
  TitreRayon.Caption := 'Rayon : ';
  ValeurNum.Caption := IntToStr(Numero);
  C := LitCercle(Numero);
  ValeurCouleur.Caption := IntToStr(C.Cl);
  ValeurCouche.Caption := IntToStr(C.Cc);
  ValeurX.Caption := FloatToStr(C.Xc);
  ValeurY.Caption := FloatToStr(C.Yc);
  ValeurRayon.Caption := FloatToStr(C.Rc);
  ValeurXDebut.Caption := FloatToStr(C.Xdc);
  ValeurYDebut.Caption := FloatToStr(C.Ydc);
  ValeurAngleDebut.Caption := FloatToStr(RadToDeg(C.Adc));
  ValeurXFin.Caption := FloatToStr(C.Xfc);
  ValeurYFin.Caption := FloatToStr(C.Yfc);
  ValeurAngleFin.Caption := FloatToStr(RadToDeg(C.Afc));

  CadreClCc.Visible := true;
  CadreXY.Visible := true;
  CadreXdYd.Visible := true;
  CadreXfYf.Visible := true;
  CadreAdAf.Visible := true;

  TitreNum.Visible := true;
  TitreX.Visible := true;
  TitreY.Visible := true;
  TitreRayon.Visible := true;
  TitreXDebut.Visible := true;
  TitreYDebut.Visible := true;
  TitreAngleDebut.Visible := true;
  TitreXFin.Visible := true;
  TitreYFin.Visible := true;
  TitreAngleFin.Visible := true;

  ValeurNum.Visible := true;
  ValeurX.Visible := true;
  ValeurY.Visible := true;
  ValeurRayon.Visible := true;
  ValeurXDebut.Visible := true;
  ValeurYDebut.Visible := true;
  ValeurAngleDebut.Visible := true;
  ValeurXFin.Visible := true;
  ValeurYFin.Visible := true;
  ValeurAngleFin.Visible := true;

  FFCanon.Position := poScreenCenter;
  Update;
end;

procedure TFFCanon.Execute(LeType: char; Num : integer );
begin
  Numero := Num;
  case LeType of
    'P' : InitPoint;
    'L' : InitLigne;
    'C' : InitCercle;
  end;
  ShowModal;
end;

procedure TFFCanon.BitBtnOkClick(Sender: TObject);
begin
  close;
end;

end.
