unit JDEdit;

interface

uses
  Windows, Messages, SysUtils, Forms, Controls;

procedure AjouteLigne(UneLigne : string);
procedure SupprimeLigne(LeTexte : string);
procedure AjouteEntete;
procedure AjouteOrigines;
function EnteteExiste : boolean;
procedure AjouteDerniereModif;
function ExecuteLigne(Ligne : string):boolean;
procedure ExecuteTout;
procedure AjouteErreur(NumLig,Erreur : longint; Ref : string);
procedure VaLigneErreur(NumLigErreur : longint);

implementation

uses
  Main, JDData, JDCalcul, JDGraph;

var
  UneErreur : boolean; { Permet de savoir si une erreur  t dtecte }

  P : array [1..10] of word;
  L : array [1..10] of word;
  C : array [1..10] of word;
  V : array [1..10] of word;
  F : array [1..10] of word;
  N : array [1..10] of extended;
  D : array [1..10] of char;

  Commentaire : boolean;
  Forme : boolean;

procedure AjouteLigne(UneLigne : string);
begin
  FPrincipale.Editeur.Lines.Add(UneLigne);
end;

procedure SupprimeLigne(LeTexte : string);
var
  NumLigne : integer;
begin
  NumLigne := FPrincipale.Editeur.Lines.IndexOf(LeTexte);
  FPrincipale.Editeur.Lines.Delete(NumLigne);
end;

procedure AjouteEntete;
var
  Ligne : string;
begin
  with FPrincipale.Editeur do
  begin
    Ligne := 'Programme JADE Version ' + Version + ' ' + DateTimeToStr(Now);
    Lines.Insert(0,Ligne);
    Ligne := 'Derniere modif. : ' + DateTimeToStr(Now);
    Lines.Insert(1,Ligne);
    Lines.Insert(2,'');
  end;
  SendMessage(FPrincipale.Editeur.Handle, EM_EMPTYUNDOBUFFER, 0, 0);
end;

procedure AjouteOrigines;
begin
  with FPrincipale.Editeur do
  begin
    AjouteLigne('P0:=0,0,0,0');
    AjouteLigne('L0:=P0,A0,0,0');
    AjouteLigne('L1:=P0,A90,0,0');
  end;
  SendMessage(FPrincipale.Editeur.Handle, EM_EMPTYUNDOBUFFER, 0, 0);
end;

function EnteteExiste : boolean;
var
  Ligne : string;
begin
  Ligne := 'Programme JADE Version ' + Version + ' ';
  Result:= pos(Ligne,FPrincipale.Editeur.Lines[0]) <> 0;
end;

procedure AjouteDerniereModif;
var
  Ligne : string;
begin
  if not FPrincipale.Editeur.Modified then exit;
  Ligne := 'Derniere modif. : ' + DateTimeToStr(Now);
  FPrincipale.Editeur.Lines.Delete(1);
  Fprincipale.Editeur.Lines.Insert(1,Ligne);
  SendMessage(FPrincipale.Editeur.Handle, EM_EMPTYUNDOBUFFER, 0, 0);
end;

// Utilitaires

function Compresse(UneLigne : string):string;
var
  N      : cardinal;
begin
  Result := '';
  for N := 1 to length(UneLigne) do
  begin
    case UneLigne[N] of
      ' ' : ;
    else
      Result := Result + UneLigne[N];
    end;
  end;
end;

procedure DefiniPoint(Num: word;LePoint: DefPoint;NumCl,NumCc: extended);
begin
  if not PasdeSol then
  begin
    LePoint.Cl := Arrondi(NumCl);
    LePoint.Cc := Arrondi(NumCc);
    StockePoint(Num, LePoint);
    DessinePoint(LePoint,FPrincipale.Dessin.Canvas,Affichage);
  end;
end;

procedure DefiniLigne(Num : word;LaLigne : DefLigne;NumCl,NumCc: extended);
begin
  if not PasDeSol then
  begin
    LaLigne.Cl := Arrondi(NumCl);
    LaLigne.Cc := Arrondi(NumCc);
    LaLigne.Num := Num;
    StockeLigne(Num, LaLigne);
    DessineLigne(LaLigne,FPrincipale.Dessin.Canvas,Affichage);
  end;
end;

procedure DefiniCercle(Num : word;LeCercle : DefCercle;NumCl,NumCc: extended);
begin
  if not PasDeSol then
  begin
    LeCercle.Cl := Arrondi(NumCl);
    LeCercle.Cc := Arrondi(NumCc);
    StockeCercle(Num, LeCercle);
    DessineCercle(LeCercle,FPrincipale.Dessin.Canvas,Affichage);
  end;
end;

procedure DefiniForme(Num: word);
begin
  if not PasdeSol then
  begin
    StockeForme(Num);
  end;
end;

// Decodage des definitions

function DecodeGeom(Numero : cardinal;UneLigne : string):string;
var
  NumPoint    : byte;
  NumLigne    : byte;
  NumCercle   : byte;
  NumVariable : byte;
  NumForme    : byte;
  NumNombre   : byte;
  NumDiscri   : byte;
  Mot         : string;
  Num         : word;

  procedure LitNumero;
  begin
    delete(UneLigne,1,1);
    Num := 0;
    Mot := '';
    while (length(UneLigne)>0) and (UneLigne[1] in ['0'..'9']) do
    begin
      Mot := Mot + UneLigne[1];
      delete(UneLigne,1,1);
    end;
    if Mot <> '' then Num := StrToInt(Mot)
                 else AjouteErreur(Numero,0,'');
(*    if ((Num < 0) or (Num > 65535)) then AjouteErreur(Numero,9,'');*)
  end;

  function LitNombre : extended;
  begin
    Result := -1;
    Mot := '';
    while (length(UneLigne)>0) and
          (UneLigne[1] in ['-','+','.','e','E','0'..'9']) do
    begin
      Mot := Mot + UneLigne[1];
      delete(UneLigne,1,1);
    end;
    if Mot <> '' then
    begin
      try
       Result := StrToFloat(Mot);
      except
       AjouteErreur(Numero,0,'');
      end;
    end
    else AjouteErreur(Numero,0,'');
  end;

begin
  UneErreur := false;
  Result := '';
  NumPoint    := 0;
  NumLigne    := 0;
  NumCercle   := 0;
  NumVariable := 0;
  NumForme    := 0;
  NumNombre   := 0;
  NumDiscri   := 0;
  case UneLigne[1] of
    'P' : begin
            Result := Result + 'P';
            inc(NumPoint);
            LitNumero;
            if not UneErreur then
               if not PointExiste(Num) then P[NumPoint] := Num
                  else AjouteErreur(Numero,40,IntToStr(Num));
          end;
    'L' : begin
            Result := Result + 'L';
            inc(NumLigne);
            LitNumero;
            if not UneErreur then
               if not LigneExiste(Num) then L[NumLigne] := Num
                  else AjouteErreur(Numero,41,IntToStr(Num));
          end;
    'C' : begin
            Result := Result + 'C';
            inc(NumCercle);
            LitNumero;
            if not UneErreur then
               if not CercleExiste(Num) then C[NumCercle] := Num
                  else AjouteErreur(Numero,42,IntToStr(Num));
          end;
    'V' : begin
            Result := Result + 'V';
            inc(NumVariable);
            LitNumero;
            if not UneErreur then V[NumVariable] := Num;
          end;
    'F' : begin
            if Forme then AjouteErreur(Numero,50,'')
            else
            begin
              Result := Result + 'F';
              inc(NumForme);
              LitNumero;
              Forme := true;
              if not UneErreur then
                 if not FormeExiste(Num) then F[NumForme] := Num
                    else AjouteErreur(Numero,44,IntToStr(Num));
            end;
          end;
    else AjouteErreur(Numero,3,'');
  end;

  if length(UneLigne) < 2 then
  begin
    AjouteErreur(Numero,1,'');
    exit;
  end;
  Mot := copy(UneLigne,1,2);
  delete(UneLigne,1,2);
  if not (UneErreur or (Mot = ':=')) then AjouteErreur(Numero,1,'');

  while (length(UneLigne) > 0) and (not UneErreur) do
  begin
    case UneLigne[1] of
      'P' : begin
              Result := Result + 'P';
              inc(NumPoint);
              LitNumero;
              if not UneErreur then
              begin
                P[NumPoint] := Num;
                if not PointExiste(Num) then
                  AjouteErreur(Numero,10,IntToStr(Num));
              end;
            end;
      'L' : begin
              Result := Result + 'L';
              inc(NumLigne);
              LitNumero;
              if not UneErreur then
              begin
                L[NumLigne] := Num;
                if not LigneExiste(Num) then
                  AjouteErreur(Numero,11,IntToStr(Num));
              end;
            end;
      'C' : begin
              Result := Result + 'C';
              inc(NumCercle);
              LitNumero;
              if not UneErreur then
              begin
                C[NumCercle] := Num;
                if not CercleExiste(Num) then
                  AjouteErreur(Numero,12,IntToStr(Num));
              end;
            end;
      'V' : begin
              Result := Result + 'N';
              LitNumero;
              if not VariableExiste(Num) then
                  AjouteErreur(Numero,13,IntToStr(Num));
              if not UneErreur then
              begin
                inc(NumNombre);
                N[NumNombre] := LitVariable(Num);
              end;
            end;

      'A' : begin
              Result := Result + 'A';
              delete(UneLigne,1,1);
              inc(NumNombre);
              N[NumNombre] := LitNombre;
            end;

      'H' : begin
              Result := Result + 'D';
              delete(UneLigne,1,1);
              inc(NumDiscri);
              D[NumDiscri] := 'H';
            end;
      'B' : begin
              Result := Result + 'D';
              delete(UneLigne,1,1);
              inc(NumDiscri);
              D[NumDiscri] := 'B';
            end;
      'D' : begin
              Result := Result + 'D';
              delete(UneLigne,1,1);
              inc(NumDiscri);
              D[NumDiscri] := 'D';
            end;
      'G' : begin
              Result := Result + 'D';
              delete(UneLigne,1,1);
              inc(NumDiscri);
              D[NumDiscri] := 'G';
            end;

      'M' : begin
              Result := Result + 'D';
              delete(UneLigne,1,1);
              inc(NumDiscri);
              D[NumDiscri] := 'M';
            end;
      'I' : begin
              Result := Result + 'D';
              delete(UneLigne,1,1);
              inc(NumDiscri);
              D[NumDiscri] := 'I';
            end;
      'E' : begin
              Result := Result + 'D';
              delete(UneLigne,1,1);
              inc(NumDiscri);
              D[NumDiscri] := 'E';
            end;
      'O' : begin
              Result := Result + 'D';
              delete(UneLigne,1,1);
              inc(NumDiscri);
              D[NumDiscri] := 'O';
            end;
      'X' : begin
              Result := Result + 'D';
              delete(UneLigne,1,1);
              inc(NumDiscri);
              D[NumDiscri] := 'X';
            end;
      'Y' : begin
              Result := Result + 'D';
              delete(UneLigne,1,1);
              inc(NumDiscri);
              D[NumDiscri] := 'Y';
            end;

      else
      begin
        result := Result + 'N';
        inc(NumNombre);
        N[NumNombre] := LitNombre;
      end;
    end;
    if (length(UneLigne) > 0) and (not UneErreur) then
      if UneLigne[1] = ',' then delete(UneLigne,1,1)
                           else AjouteErreur(Numero,2,'');
  end;
end;

// Calcul de la definition

procedure Calcul(Numero: cardinal;Fct: string);
begin
// Points
  if Fct = 'PNNNN' then
    DefiniPoint(P[1],PNN(N[1],N[2]),N[3],N[4])
  else
  if Fct = 'PNANN' then
    DefiniPoint(P[1],PNA(N[1],N[2]),N[3],N[4])
  else
  if Fct = 'PPNNNN' then
    DefiniPoint(P[1],PPNN(LitPoint(P[2]),N[1],N[2]),N[3],N[4])
  else
  if Fct = 'PPNANN' then
    DefiniPoint(P[1],PPNA(LitPoint(P[2]),N[1],N[2]),N[3],N[4])
  else
  if Fct = 'PCNN' then
    DefiniPoint(P[1],PC(LitCercle(C[1])),N[1],N[2])
  else
  if Fct = 'PPPANN' then
    DefiniPoint(P[1],PPPA(LitPoint(P[2]),LitPoint(P[3]),N[1]),N[2],N[3])
  else
  if Fct = 'PPPNN' then
    DefiniPoint(P[1],PPP(LitPoint(P[2]),LitPoint(P[3])),N[1],N[2])
  else
  if Fct = 'PPLNN' then
    DefiniPoint(P[1],PPL(LitPoint(P[2]),LitLigne(L[1])),N[1],N[2])
  else
  if Fct = 'PLLNN' then
    DefiniPoint(P[1],PLL(LitLigne(L[1]),LitLigne(L[2])),N[1],N[2])
  else
  if (Fct = 'PLCDNN') and (D[1] in ['H','B','D','G']) then
    DefiniPoint(P[1],PLCD(LitLigne(L[1]),LitCercle(C[1]),D[1]),N[1],N[2])
  else
  if (Fct = 'PCCDNN') and (D[1] in ['H','B','D','G']) then
    DefiniPoint(P[1],PCCD(LitCercle(C[1]),LitCercle(C[2]),D[1]),N[1],N[2])
  else
  if (Fct = 'PPPDNN') and (D[1]='M') then
    DefiniPoint(P[1],PPPD(LitPoint(P[2]),LitPoint(P[3])),N[1],N[2])
  else
// Lignes
  if Fct = 'LNNANN' then
    DefiniLigne(L[1],LNNA(N[1],N[2],N[3]),N[4],N[5])
  else
  if Fct = 'LPANN' then
    DefiniLigne(L[1],LPA(LitPoint(P[1]),N[1]),N[2],N[3])
  else
  if Fct = 'LPPNN' then
    DefiniLigne(L[1],LPP(LitPoint(P[1]),LitPoint(P[2])),N[1],N[2])
  else
  if Fct = 'LPLNN' then
    DefiniLigne(L[1],LPL(LitPoint(P[1]),LitLigne(L[2])),N[1],N[2])
  else
  if (Fct = 'LPLDNN') and (D[1]='O') then
    DefiniLigne(L[1],LPLD(LitPoint(P[1]),LitLigne(L[2])),N[1],N[2])
  else
  if (Fct = 'LPCDNN') and (D[1]in['H','B','D','G']) then
    DefiniLigne(L[1],LPCD(LitPoint(P[1]),LitCercle(C[1]),D[1]),N[1],N[2])
  else
  if (Fct = 'LNDNN') and (D[1]in['X','Y']) then
    DefiniLigne(L[1],LND(N[1],D[1]),N[2],N[3])
  else
  if (Fct = 'LLNDNN') and (D[1]in['H','B','D','G']) then
    DefiniLigne(L[1],LLND(LitLigne(L[2]),N[1],D[1]),N[2],N[3])
  else
  if (Fct = 'LLCDNN') and (D[1]in['H','B','D','G']) then
    DefiniLigne(L[1],LLCD(LitLigne(L[2]),LitCercle(C[1]),D[1]),N[1],N[2])
  else
  if (Fct = 'LLCDDNN') and (D[1] = 'O') and (D[2]in['H','B','D','G']) then
    DefiniLigne(L[1],LLCDD(LitLigne(L[2]),LitCercle(C[1]),D[2]),N[1],N[2])
  else
  if (Fct = 'LCCDDNN') and (D[1]in['H','B','D','G']) and
    (D[2]in['H','B','D','G'])then
    DefiniLigne(L[1],LCCDD(LitCercle(C[1]),LitCercle(C[2]),D[1],D[2]),N[1],N[2])
  else
  if (Fct = 'LCADNN') and (D[1]in['H','B','D','G']) then
    DefiniLigne(L[1],LCAD(LitCercle(C[1]),N[1],D[1]),N[2],N[3])
  else
  if (Fct = 'LLPNN') then
    DefiniLigne(L[1],LLP(LitLigne(L[2]),LitPoint(P[1])),N[1],N[2])
  else
  if (Fct = 'LLLNN') then
    DefiniLigne(L[1],LLL(LitLigne(L[2]),LitLigne(L[3])),N[1],N[2])
  else
  if (Fct = 'LLPANN') then
    DefiniLigne(L[1],LLPA(LitLigne(L[2]),LitPoint(P[1]),N[1]),N[2],N[3])
  else
  if (Fct = 'LLLDNN') and (D[1] = 'M') then
    DefiniLigne(L[1],LLLD(LitLigne(L[2]),LitLigne(L[3])),N[1],N[2])
  else
// Cercles
  if Fct = 'CNNNNN' then
    DefiniCercle(C[1],CNNN(N[1],N[2],N[3]),N[4],N[5])
  else
  if Fct = 'CPNNN' then
    DefiniCercle(C[1],CPN(LitPoint(P[1]),N[1]),N[2],N[3])
  else
  if Fct = 'CPPNN' then
    DefiniCercle(C[1],CPP(LitPoint(P[1]),LitPoint(P[2])),N[1],N[2])
  else
  if Fct = 'CPLNN' then
    DefiniCercle(C[1],CPL(LitPoint(P[1]),LitLigne(L[1])),N[1],N[2])
  else
  if (Fct = 'CPCDNN') and (D[1] in ['I','G']) then
    DefiniCercle(C[1],CPCD(LitPoint(P[1]),LitCercle(C[2]),D[1]),N[1],N[2])
  else
  if Fct = 'CCNNNN' then
    DefiniCercle(C[1],CCNN(LitCercle(C[2]),N[1],N[2]),N[3],N[4])
  else
  if Fct = 'CCNANN' then
    DefiniCercle(C[1],CCNA(LitCercle(C[2]),N[1],N[2]),N[3],N[4])
  else
  if (Fct = 'CPPNDNN') and (D[1] in ['H','B','D','G']) then
    DefiniCercle(C[1],CPPND(LitPoint(P[1]),LitPoint(P[2]),N[1],D[1]),N[2],N[3])
  else
  if (Fct = 'CPLNDNN') and (D[1] in ['H','B','D','G']) then
    DefiniCercle(C[1],CPLND(LitPoint(P[1]),LitLigne(L[1]),N[1],D[1]),N[2],N[3])
  else
  if (Fct = 'CPCNDDNN') and (D[1]in['I','E']) and (D[2]in['H','B','D','G']) then
    DefiniCercle(C[1],CPCNDD(LitPoint(P[1]),LitCercle(C[2]),N[1],D[1],D[2]),N[2],N[3])
  else
  if (Fct = 'CLLNDDNN') and (D[1]in['H','B','D','G']) and
   (D[2]in['H','B','D','G']) then
   DefiniCercle(C[1],CLLNDD(LitLigne(L[1]),LitLigne(L[2]),N[1],D[1],D[2]),N[2],N[3])
  else
  if (Fct = 'CLCNDDDNN') and (D[1]in['H','B','D','G']) and (D[2]in['I','E'])
    and (D[3]in['H','B','D','G']) then
    DefiniCercle(C[1],CLCNDDD(LitLigne(L[1]),
      LitCercle(C[2]),N[1],D[1],D[2],D[3]),N[2],N[3])
  else
  if (Fct = 'CCCNDDDNN') and (D[1]in['I','E']) and (D[2]in['I','E'])
    and (D[3]in['H','B','D','G']) then DefiniCercle(C[1],CCCNDDD(LitCercle(C[2]),
    LitCercle(C[3]),N[1],D[1],D[2],D[3]),N[2],N[3])
  else
  if Fct = 'CCNNN' then
    DefiniCercle(C[1],CCN(LitCercle(C[2]),N[1]),N[2],N[3])
  else
  if (Fct = 'CCNDNN') and (D[1]in['I','G']) then
    DefiniCercle(C[1],CCND(LitCercle(C[2]),N[1],D[1]),N[2],N[3])
  else
  if Fct = 'CPPPNN' then
    DefiniCercle(C[1],CPPP(LitPoint(P[1]),LitPoint(P[2]),LitPoint(P[3])),N[1],N[2])
  else

  if Fct = 'CCPANN' then
    DefiniCercle(C[1],CCPA(LitCercle(C[2]),LitPoint(P[1]),N[1]),N[2],N[3])
  else
  if Fct = 'CCPNN' then
    DefiniCercle(C[1],CCP(LitCercle(C[2]),LitPoint(P[1])),N[1],N[2])
  else
  if Fct = 'CCLNN' then
    DefiniCercle(C[1],CCL(LitCercle(C[2]),LitLigne(L[1])),N[1],N[2])
  else
// Variables
  if Fct = 'VN' then StockeVariable(V[1],N[1])
  else
// Formes
  if Fct = 'F' then {StockeVariable(V[1],N[1])}
  else AjouteErreur(Numero,100,'');
  if PasDeSol then AjouteErreur(Numero,99,'');
end;


// Dcodage forme

procedure DecodeForme(Numero: cardinal;UneLigne: string);
var
{  NumPoint    : byte;
  NumLigne    : byte;
  NumCercle   : byte;
  NumNombre   : byte;
  NumDiscri   : byte;}
  Mot         : string;
  Num         : word;

  procedure LitNumero;
  begin
    delete(UneLigne,1,1);
    Num := 0;
    Mot := '';
    while (length(UneLigne)>0) and (UneLigne[1] in ['0'..'9']) do
    begin
      Mot := Mot + UneLigne[1];
      delete(UneLigne,1,1);
    end;
    if Mot <> '' then Num := StrToInt(Mot)
                 else AjouteErreur(Numero,0,'');
(*    if ((Num < 0) or (Num > 65535)) then AjouteErreur(Numero,9,'');*)
  end;

begin
  UneErreur := false;
{  NumPoint    := 0;
  NumLigne    := 0;
  NumCercle   := 0;
  NumNombre   := 0;
  NumDiscri   := 0;}
  case UneLigne[1] of
    'F' : begin
            if UneLigne = 'FIN' then Forme := false;
          end;
{    else AjouteErreur(Numero,3,'');}
  end;
end;

// Execution

function IdentifieLigne(var Ligne:string):integer;
var
  ValTmp : integer;
begin
  { 1 : dbut de commentaire }
  { 2 : commentaire en cours }
  { 3 : fin de commentaire }
  { 4 : commentaire }
  { 5 : gomtrie}
  { 6 : forme }
  Result := 0;
  if Commentaire then
  begin
    if (pos('}',Ligne)>0) then
    begin
      Commentaire := false;
      Result := 3;
    end
    else Result := 2;
  end
  else
  begin
    ValTmp := pos('{',Ligne);
    if (ValTmp > 1) and (pos('}',Ligne)=length(Ligne)) then
    begin
      Ligne := copy(Ligne,1,ValTmp-1); {supprime le commentaire dans la ligne}
      ValTmp := 0;
    end;
    if ValTmp > 0 then
    begin
      Result := 1;
      if pos('}',Ligne) > ValTmp then Result := 4
                                 else Commentaire := true
    end
    else
      if pos('//',Ligne) > 0 then Result := 4
      else
        if pos(':=',Ligne) > 0 then Result := 5
        else if Forme then Result := 6;
  end;
end;

procedure TraiteLigne(Num: cardinal;Ligne: string);
var
  Fonction : string;
begin
  case IdentifieLigne(Ligne) of
    0 : AjouteErreur(Num,0,'');
    1 : {dbut commentaire};
    2 : {commentaire en cours};
    3 : {fin commentaire};
    4 : {commentaire};
    5 : begin
          Fonction := DecodeGeom(Num,Ligne);
          if not UneErreur then Calcul(Num,Fonction);
        end;
    6 : DecodeForme(Num,Ligne);
  end;
end;

function ExecuteLigne(Ligne : string):boolean;
begin
  VerrouilleTables(false);
  Ligne := Compresse(Ligne);
  Ligne := AnsiUpperCase(Ligne);
  if Ligne <> '' then TraiteLigne(0,Ligne);
  VerrouilleTables(true);
  Result := not(UneErreur);
end;

procedure ExecuteTout;
var
  NbLignes : cardinal;
  LigneNum : cardinal;
  Ligne    : string;
begin
  Screen.Cursor := crHourGlass;
  FPrincipale.ListeMessages.Visible := false;
  FPrincipale.ListeMessages.Clear;
  NbLignes := FPrincipale.Editeur.Lines.Count;
  VideTables;
  VerrouilleTables(false);
  Commentaire := false;
  Forme := false;
  EffaceEcran;
  if NbLignes <= 3 then exit;
  // la numerotation des lignes de l'editeur commence  0 donc on enleve 1
  dec(NbLignes);
  for LigneNum := 3 to NbLignes do
  begin
    Ligne := FPrincipale.Editeur.Lines[LigneNum];
    Ligne := Compresse(Ligne);
    Ligne := AnsiUpperCase(Ligne);
    if Ligne <> '' then TraiteLigne(LigneNum,Ligne);
  end;
  VerrouilleTables(true);
  if FPrincipale.ListeMessages.Items.Count > 0 then
  begin
    FPrincipale.ListeMessages.Visible := true;
    FPrincipale.ListeMessages.ItemIndex := 0;
    VaLigneErreur(0);
  end;
  Screen.Cursor := crDefault;
end;

procedure AjouteErreur(NumLig,Erreur : longint; Ref : string);
var
  Texte : string;
begin
  Texte := '(' + IntToStr(NumLig + 1) + ')';
  case Erreur of
      0 : Texte := Texte + ' Erreur de syntaxe';
      1 : Texte := Texte + ' Erreur de syntaxe : manque '':='' ';
      2 : Texte := Texte + ' Erreur de syntaxe : manque '','' ';
      3 : Texte := Texte + ' Erreur de syntaxe : caractre de dfinition inconnu';

      9 : Texte := Texte + ' Indice hors des limites permises';
     10 : Texte := Texte + ' Point P' + Ref + ' non dfini';
     11 : Texte := Texte + ' Ligne L' + Ref + ' non dfinie';
     12 : Texte := Texte + ' Cercle C' + Ref + ' non dfini';
     13 : Texte := Texte + ' Variable V' + Ref + ' non dfinie';

     40 : Texte := Texte + ' Point P' + Ref + ' dj dfini';
     41 : Texte := Texte + ' Ligne L' + Ref + ' dj dfinie';
     42 : Texte := Texte + ' Cercle C' + Ref + ' dj dfini';
     43 : Texte := Texte + ' Variable V' + Ref + ' dj dfinie';
     44 : Texte := Texte + ' Forme F' + Ref + ' dj dfinie';

     50 : Texte := Texte + ' Il y a dj une forme en cours de dfinition';

     98 : Texte := Texte + ' Test ' + Ref;
     99 : Texte := Texte + ' Pas de solution possible';
    100 : Texte := Texte + ' Dfinition gomtrique non dfinie';
  else
    Texte := Texte + ' Erreur inconnue';
  end;
  FPrincipale.ListeMessages.Items.Add(Texte);
  UneErreur := true;
end;

procedure VaLigneErreur(NumLigErreur : longint);
var
  Chaine, SousChaine : string;
begin
  Chaine := FPrincipale.ListeMessages.Items[NumLigErreur];
  delete(Chaine,1,1);
  SousChaine := '';
  while Chaine[1] <> ')' do
  begin
    SousChaine := SousChaine + Chaine[1];
    delete(Chaine,1,1);
  end;
  with FPrincipale.Editeur do
  begin
    SelStart := Perform(EM_LINEINDEX, StrToInt(SousChaine)-1, 0);
    Perform(EM_SCROLLCARET, 0, 0);
    SetFocus;
  end;
end;
end.

