unit JDData;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables;

type
  TModuleDonnee = class(TDataModule)
    SourcePoint: TDataSource;
    SourceLigne: TDataSource;
    Point: TTable;
    Ligne: TTable;
    Cercle: TTable;
    SourceCercle: TDataSource;
    SourceVariable: TDataSource;
    Variable: TTable;
    SourceForme: TDataSource;
    Forme: TTable;

    procedure CreeTables;
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

  DefPoint =
    record
      Num : integer;
      X   : extended;
      Y   : extended;
      Cl  : integer;
      Cc  : integer;
    end;

  DefLigne =
    record
      Num : integer;
      Xpd : extended;
      Ypd : extended;
      Aod : extended;
      Xdd : extended;
      Ydd : extended;
      Xfd : extended;
      Yfd : extended;
      Cl  : integer;
      Cc  : integer;
    end;

  DefCercle =
    record
      Num : integer;
      Xc  : extended;
      Yc  : extended;
      Rc  : extended;
      Xdc : extended;
      Ydc : extended;
      Adc : extended;
      Xfc : extended;
      Yfc : extended;
      Afc : extended;
      Cl  : integer;
      Cc  : integer;
    end;

  EquaLigne =
    record
      A   : extended;
      B   : extended;
      C   : extended;
    end;

var
  ModuleDonnee: TModuleDonnee;
  TableOk     : boolean;
  PasDeSol    : boolean;

procedure VideTables;
procedure VerrouilleTables(Lecture : boolean);

function PointExiste(Index : word) : boolean;
function LigneExiste(Index : word) : boolean;
function CercleExiste(Index : word) : boolean;
function VariableExiste(Index : word) : boolean;
function FormeExiste(Index : word) : boolean;

procedure StockePoint(Num : word;LePoint : DefPoint);
procedure StockeLigne(Num : word;LaLigne : DefLigne);
procedure StockeCercle(Num : word;LeCercle : DefCercle);
procedure StockeVariable(Num : word;LaVariable : extended);
procedure StockeForme(Num : word);

function LitPoint(Num : word) : DefPoint;
function LitLigne(Num : word) : DefLigne;
function LitCercle(Num : word) : DefCercle;
function LitVariable(Num : word) : extended;

function LitPremierPoint(Var LePoint: DefPoint): boolean;
function LitPremiereLigne(Var LaLigne: DefLigne): boolean;
function LitPremierCercle(Var LeCercle: DefCercle) : boolean;

function LitPointSuivant(Var LePoint: DefPoint): boolean;
function LitLigneSuivante(Var LaLigne: DefLigne): boolean;
function LitCercleSuivant(Var LeCercle: DefCercle) : boolean;

function PremierPointLibre : integer;
function PremiereLigneLibre : integer;
function PremierCercleLibre : integer;

implementation

{$R *.DFM}

uses
  Main;

function CorrigeCote(Valeur : extended):extended;
begin
  Result := Valeur;
  if (Valeur > -1.0E-14) and (Valeur < 1.0E-14) then Result := 0;
end;

procedure TModuleDonnee.CreeTables;
begin
{Cration table Point}
  with Point do
  begin
    Active := false;
    DataBaseName := Chemin;
    TableType := ttParadox;
    TableName := 'Points.DB';
    if not FileExists(DatabaseName+TableName)then
    begin
      with FieldDefs do
      begin
        Clear;
        Add('Numero',ftWord,0,true);
        Add('X',ftFloat,0,true); {X du point }
        Add('Y',ftFloat,0,true); {Y du point }
        Add('Couleur',ftInteger,0,true);
        Add('Couche',ftWord,0,true);
      end;
      with IndexDefs do
      begin
        Clear;
        Add('Numero','Numero',[ixPrimary, ixUnique]);
      end;
      CreateTable;
    end
    else EmptyTable;
  end;
{Cration table Ligne}
  with Ligne do
  begin
    Active := false;
    DataBaseName := Chemin;
    TableType := ttParadox;
    TableName := 'Lignes.DB';
    if not FileExists(DatabaseName+TableName)then
    begin
      with FieldDefs do
      begin
        Clear;
        Add('Numero',ftWord,0,true);
        Add('Xpd',ftFloat,0,true); {X d'un point de la ligne}
        Add('Ypd',ftFloat,0,true); {Y d'un point de la ligne}
        Add('Aod',ftFloat,0,true); {angle par rapport  l'horizontale}
        Add('Xdd',ftFloat,0,false); {X du point de dbut de la ligne}
        Add('Ydd',ftFloat,0,false); {Y du point de dbut de la ligne}
        Add('Xfd',ftFloat,0,false); {X du point de fin de la ligne}
        Add('Yfd',ftFloat,0,false); {X du point de fin de la ligne}
        Add('Couleur',ftInteger,0,true);
        Add('Couche',ftWord,0,true);
      end;
      with IndexDefs do
      begin
        Clear;
        Add('Numero','Numero',[ixPrimary, ixUnique]);
      end;
      CreateTable;
    end
    else EmptyTable;
  end;
{ Cration table Cercle}
  with Cercle do
  begin
    Active := false;
    DataBaseName := Chemin;
    TableType := ttParadox;
    TableName := 'Cercles.DB';
    if not FileExists(DatabaseName+TableName)then
    begin
      with FieldDefs do
      begin
        Clear;
        Add('Numero',ftWord,0,true);
        Add('Xc',ftFloat,0,true); {X du centre du cercle}
        Add('Yc',ftFloat,0,true); {Y du centre du cercle}
        Add('Rc',ftFloat,0,true); {rayon du cercle}
        Add('Xdc',ftFloat,0,false); {X du point de dbut du cercle}
        Add('Ydc',ftFloat,0,false); {Y du point de dbut du cercle}
        Add('Adc',ftFloat,0,false); {Angle de dbut du cercle}
        Add('Xfc',ftFloat,0,false); {X du point de fin du cercle}
        Add('Yfc',ftFloat,0,false); {X du point de fin du cercle}
        Add('Afc',ftFloat,0,false); {Angle de fin du cercle}
        Add('Couleur',ftInteger,0,true);
        Add('Couche',ftWord,0,true);
      end;
      with IndexDefs do
      begin
        Clear;
        Add('Numero','Numero',[ixPrimary, ixUnique]);
      end;
      CreateTable;
    end
    else EmptyTable;
  end;
{ Cration table Variable}
  with Variable do
  begin
    Active := false;
    DataBaseName := Chemin;
    TableType := ttParadox;
    TableName := 'Variables.DB';
    if not FileExists(DatabaseName+TableName)then
    begin
      with FieldDefs do
      begin
        Clear;
        Add('Numero',ftWord,0,true);
        Add('Valeur',ftFloat,0,true); {valeur de la variable }
      end;
      with IndexDefs do
      begin
        Clear;
        Add('Numero','Numero',[ixPrimary, ixUnique]);
      end;
      CreateTable;
    end
    else EmptyTable;
  end;
{ Cration table Forme}
  with Forme do
  begin
    Active := false;
    DataBaseName := Chemin;
    TableType := ttParadox;
    TableName := 'Formes.DB';
    if not FileExists(DatabaseName+TableName)then
    begin
      with FieldDefs do
      begin
        Clear;
        Add('Numero',ftWord,0,true);
      end;
      with IndexDefs do
      begin
        Clear;
        Add('Numero','Numero',[ixPrimary, ixUnique]);
      end;
      CreateTable;
    end
    else EmptyTable;
  end;

  Point.Active := true;
  Ligne.Active := true;
  Cercle.Active := true;
  Variable.Active := true;
  Forme.Active := true;
  TableOk := true;
end;

procedure VideTables;
begin
  with ModuleDonnee do
  begin
    Point.Active := false;
    Ligne.Active := false;
    Cercle.Active := false;
    Variable.Active := false;
    Forme.Active := false;

    Point.EmptyTable;
    Ligne.EmptyTable;
    Cercle.EmptyTable;
    Variable.EmptyTable;
    Forme.EmptyTable;

    Point.Active := true;
    Ligne.Active := true;
    Cercle.Active := true;
    Variable.Active := true;
    Forme.Active := true;

  end;
end;

procedure VerrouilleTables(Lecture : boolean);
begin
  with ModuleDonnee do
  begin
    Point.Active := false;
    Ligne.Active := false;
    Cercle.Active := false;
    Variable.Active := false;
    Forme.Active := false;

    Point.ReadOnly := Lecture;
    Ligne.ReadOnly := Lecture;
    Cercle.ReadOnly := Lecture;
    Variable.ReadOnly := Lecture;
    Forme.ReadOnly := Lecture;

    Point.Active := true;
    Ligne.Active := true;
    Cercle.Active := true;
    Variable.Active := true;
    Forme.Active := true;

  end;
end;

function PointExiste(Index : word) : boolean;
begin
  with ModuleDonnee.Point do Result := Locate('Numero',Index,[]);
end;

function LigneExiste(Index : word) : boolean;
begin
  with ModuleDonnee.Ligne do Result := Locate('Numero',Index,[]);
end;

function CercleExiste(Index : word) : boolean;
begin
  with ModuleDonnee.Cercle do Result := Locate('Numero',Index,[]);
end;

function VariableExiste(Index : word) : boolean;
begin
  with ModuleDonnee.Variable do Result := Locate('Numero',Index,[]);
end;

function FormeExiste(Index : word) : boolean;
begin
  with ModuleDonnee.Forme do Result := Locate('Numero',Index,[]);
end;

// Stockage rsultat

procedure StockePoint(Num : word;LePoint : DefPoint);
begin
  with ModuleDonnee do
  begin
    Point.Insert;
    Point.FieldValues['Numero'] := Num;
    Point.FieldValues['X'] := CorrigeCote(LePoint.X);
    Point.FieldValues['Y'] := CorrigeCote(LePoint.Y);
    Point.FieldValues['Couleur'] := LePoint.Cl;
    Point.FieldValues['Couche'] := LePoint.Cc;
    Point.Post;
  end;
end;

procedure StockeLigne(Num : word;LaLigne : DefLigne);
begin
  with ModuleDonnee do
  begin
    Ligne.Insert;
    Ligne.FieldValues['Numero'] := Num;
    Ligne.FieldValues['Xpd'] := CorrigeCote(LaLigne.Xpd);
    Ligne.FieldValues['Ypd'] := CorrigeCote(LaLigne.Ypd);
    Ligne.FieldValues['Aod'] := LaLigne.Aod;
    Ligne.FieldValues['Xdd'] := CorrigeCote(LaLigne.Xdd);
    Ligne.FieldValues['Ydd'] := CorrigeCote(LaLigne.Ydd);
    Ligne.FieldValues['Xfd'] := CorrigeCote(LaLigne.Xfd);
    Ligne.FieldValues['Yfd'] := CorrigeCote(LaLigne.Yfd);
    Ligne.FieldValues['Couleur'] := LaLigne.Cl;
    Ligne.FieldValues['Couche'] := LaLigne.Cc;
    Ligne.Post;
  end;
end;

procedure StockeCercle(Num : word;LeCercle : DefCercle);
begin
  with ModuleDonnee do
  begin
    Cercle.Insert;
    Cercle.FieldValues['Numero'] := Num;
    Cercle.FieldValues['Xc']  := CorrigeCote(LeCercle.Xc);
    Cercle.FieldValues['Yc']  := CorrigeCote(LeCercle.Yc);
    Cercle.FieldValues['Rc']  := LeCercle.Rc;
    Cercle.FieldValues['Xdc'] := CorrigeCote(LeCercle.Xdc);
    Cercle.FieldValues['Ydc'] := CorrigeCote(LeCercle.Ydc);
    Cercle.FieldValues['Adc'] := LeCercle.Adc;
    Cercle.FieldValues['Xfc'] := CorrigeCote(LeCercle.Xfc);
    Cercle.FieldValues['Yfc'] := CorrigeCote(LeCercle.Yfc);
    Cercle.FieldValues['Afc'] := LeCercle.Afc;
    Cercle.FieldValues['Couleur'] := LeCercle.Cl;
    Cercle.FieldValues['Couche'] := LeCercle.Cc;
    Cercle.Post;
  end;
end;

procedure StockeVariable(Num : word;LaVariable : extended);
begin
  with ModuleDonnee do
    if Variable.Locate('Numero',Num,[])then
    begin
      Variable.Edit;
      Variable.FieldValues['Valeur'] := LaVariable;
      Variable.Post;
    end
    else
    begin
      Variable.Insert;
      Variable.FieldValues['Numero'] := Num;
      Variable.FieldValues['Valeur'] := LaVariable;
      Variable.Post;
    end;
end;

procedure StockeForme(Num : word);
begin
  with ModuleDonnee do
  begin
    Forme.Insert;
    Forme.FieldValues['Numero'] := Num;
    Forme.Post;
  end;
end;

// Lecture valeur

function LitPoint(Num : word) : DefPoint;
begin
  with ModuleDonnee do
    if Point.Locate('Numero',Num,[])then
    begin
      Result.Num := Point.FieldValues['Numero'];
      Result.X   := Point.FieldValues['X'];
      Result.Y   := Point.FieldValues['Y'];
      Result.Cl  := Point.FieldValues['Couleur'];
      Result.Cc  := Point.FieldValues['Couche'];
    end;
end;

function LitLigne(Num : word) : DefLigne;
begin
  with ModuleDonnee do
    if Ligne.Locate('Numero',Num,[])then
    begin
      Result.Num := Ligne.FieldValues['Numero'];
      Result.Xpd := Ligne.FieldValues['Xpd'];
      Result.Ypd := Ligne.FieldValues['Ypd'];
      Result.Aod := Ligne.FieldValues['Aod'];
      Result.Xdd := Ligne.FieldValues['Xdd'];
      Result.Ydd := Ligne.FieldValues['Ydd'];
      Result.Xfd := Ligne.FieldValues['Xfd'];
      Result.Yfd := Ligne.FieldValues['Yfd'];
      Result.Cl  := Ligne.FieldValues['Couleur'];
      Result.Cc  := Ligne.FieldValues['Couche'];
    end;
end;

function LitCercle(Num : word) : DefCercle;
begin
  with ModuleDonnee do
    if Cercle.Locate('Numero',Num,[])then
    begin
      Result.Num := Cercle.FieldValues['Numero'];
      Result.Xc  := Cercle.FieldValues['Xc'];
      Result.Yc  := Cercle.FieldValues['Yc'];
      Result.Rc  := Cercle.FieldValues['Rc'];
      Result.Xdc := Cercle.FieldValues['Xdc'];
      Result.Ydc := Cercle.FieldValues['Ydc'];
      Result.Adc := Cercle.FieldValues['Adc'];
      Result.Xfc := Cercle.FieldValues['Xfc'];
      Result.Yfc := Cercle.FieldValues['Yfc'];
      Result.Afc := Cercle.FieldValues['Afc'];
      Result.Cl  := Cercle.FieldValues['Couleur'];
      Result.Cc  := Cercle.FieldValues['Couche'];
    end;
end;

function LitVariable(Num : word) : extended;
begin
  Result := 0;
  with ModuleDonnee do
    if Variable.Locate('Numero',Num,[])then
      Result := Variable.FieldValues['Valeur'];
end;

function LitPremierPoint(Var LePoint: DefPoint): boolean;
begin
  result := true;
  with ModuleDonnee do
    if Point.FindFirst then
    begin
      LePoint.Num := Point.FieldValues['Numero'];
      LePoint.X   := Point.FieldValues['X'];
      LePoint.Y   := Point.FieldValues['Y'];
      LePoint.Cl  := Point.FieldValues['Couleur'];
      LePoint.Cc  := Point.FieldValues['Couche'];
    end
    else result := false;
end;

function LitPremiereLigne(Var LaLigne: DefLigne): boolean;
begin
  result := true;
  with ModuleDonnee do
    if Ligne.FindFirst then
    begin
      LaLigne.Num := Ligne.FieldValues['Numero'];
      LaLigne.Xpd := Ligne.FieldValues['Xpd'];
      LaLigne.Ypd := Ligne.FieldValues['Ypd'];
      LaLigne.Aod := Ligne.FieldValues['Aod'];
      LaLigne.Xdd := Ligne.FieldValues['Xdd'];
      LaLigne.Ydd := Ligne.FieldValues['Ydd'];
      LaLigne.Xfd := Ligne.FieldValues['Xfd'];
      LaLigne.Yfd := Ligne.FieldValues['Yfd'];
      LaLigne.Cl  := Ligne.FieldValues['Couleur'];
      LaLigne.Cc  := Ligne.FieldValues['Couche'];
    end
    else Result := false;
end;

function LitPremierCercle(Var LeCercle: DefCercle) : boolean;
begin
  result := true;
  with ModuleDonnee do
    if Cercle.FindFirst then
    begin
      LeCercle.Num := Cercle.FieldValues['Numero'];
      LeCercle.Xc  := Cercle.FieldValues['Xc'];
      LeCercle.Yc  := Cercle.FieldValues['Yc'];
      LeCercle.Rc  := Cercle.FieldValues['Rc'];
      LeCercle.Xdc := Cercle.FieldValues['Xdc'];
      LeCercle.Ydc := Cercle.FieldValues['Ydc'];
      LeCercle.Adc := Cercle.FieldValues['Adc'];
      LeCercle.Xfc := Cercle.FieldValues['Xfc'];
      LeCercle.Yfc := Cercle.FieldValues['Yfc'];
      LeCercle.Afc := Cercle.FieldValues['Afc'];
      LeCercle.Cl  := Cercle.FieldValues['Couleur'];
      LeCercle.Cc  := Cercle.FieldValues['Couche'];
    end
    else Result := false;
end;

function LitPointSuivant(Var LePoint: DefPoint): boolean;
begin
  result := true;
  with ModuleDonnee do
    if Point.FindNext then
    begin
      LePoint.Num := Point.FieldValues['Numero'];
      LePoint.X   := Point.FieldValues['X'];
      LePoint.Y   := Point.FieldValues['Y'];
      LePoint.Cl  := Point.FieldValues['Couleur'];
      LePoint.Cc  := Point.FieldValues['Couche'];
    end
    else result := false;
end;

function LitLigneSuivante(Var LaLigne: DefLigne): boolean;
begin
  result := true;
  with ModuleDonnee do
    if Ligne.FindNext then
    begin
      LaLigne.Num := Ligne.FieldValues['Numero'];
      LaLigne.Xpd := Ligne.FieldValues['Xpd'];
      LaLigne.Ypd := Ligne.FieldValues['Ypd'];
      LaLigne.Aod := Ligne.FieldValues['Aod'];
      LaLigne.Xdd := Ligne.FieldValues['Xdd'];
      LaLigne.Ydd := Ligne.FieldValues['Ydd'];
      LaLigne.Xfd := Ligne.FieldValues['Xfd'];
      LaLigne.Yfd := Ligne.FieldValues['Yfd'];
      LaLigne.Cl  := Ligne.FieldValues['Couleur'];
      LaLigne.Cc  := Ligne.FieldValues['Couche'];
    end
    else Result := false;
end;

function LitCercleSuivant(Var LeCercle: DefCercle) : boolean;
begin
  result := true;
  with ModuleDonnee do
    if Cercle.FindNext then
    begin
      LeCercle.Num := Cercle.FieldValues['Numero'];
      LeCercle.Xc  := Cercle.FieldValues['Xc'];
      LeCercle.Yc  := Cercle.FieldValues['Yc'];
      LeCercle.Rc  := Cercle.FieldValues['Rc'];
      LeCercle.Xdc := Cercle.FieldValues['Xdc'];
      LeCercle.Ydc := Cercle.FieldValues['Ydc'];
      LeCercle.Adc := Cercle.FieldValues['Adc'];
      LeCercle.Xfc := Cercle.FieldValues['Xfc'];
      LeCercle.Yfc := Cercle.FieldValues['Yfc'];
      LeCercle.Afc := Cercle.FieldValues['Afc'];
      LeCercle.Cl  := Cercle.FieldValues['Couleur'];
      LeCercle.Cc  := Cercle.FieldValues['Couche'];
    end
    else Result := false;
end;

function PremierPointLibre : integer;
var
  Num : integer;
begin
  Num := 0;
  with ModuleDonnee do
    while Point.Locate('Numero',Num,[])do inc(Num);
  result := Num;
end;

function PremiereLigneLibre : integer;
var
  Num : integer;
begin
  Num := 0;
  with ModuleDonnee do
    while Ligne.Locate('Numero',Num,[])do inc(Num);
  result := Num;
end;

function PremierCercleLibre : integer;
var
  Num : integer;
begin
  Num := 0;
  with ModuleDonnee do
    while Cercle.Locate('Numero',Num,[])do inc(Num);
  result := Num;
end;


begin
  TableOk := false;
end.
