unit JDColor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Spin;

type
  TFChoixCouleur = class(TForm)
    TitreCouleur: TLabel;
    BtnOk: TButton;
    BtnCancel: TButton;
    TitreCouche: TLabel;
    SpinEditCouche: TSpinEdit;
    procedure FormPaint(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    function Execute : boolean;
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure BtnOkClick(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
  private
    { Dclarations prives }
    MargeX  : integer;
    DecaleX : integer;
    Terminaison : boolean;
    procedure DrawSquare(Num: integer;Selectionne: boolean);
    procedure DrawChoix;
    function PosToCell(X,Y : integer):integer;
  public
    { Dclarations publiques }
    NbCouleurs   : integer; { Nombre de couleurs de base }
    NbNuances    : integer; { Nombre de nuances des couleurs }
    Selected     : integer; { Numero de la couleur selectionnee }
    Color        : TColor; { Couleur selectionnee }
    Layer        : integer;
  end;

var
  FChoixCouleur: TFChoixCouleur;
  EntreePalette: array[0..255] of TColor;
  
implementation

{$R *.DFM}

uses
  ExtCtrls, Math;
const
  LargCell = 25; { hauteur des cellules }
  HautCell = 15; { largeur des cellules }
var
  NbEntree : integer;

procedure TFChoixCouleur.DrawSquare(Num: integer;Selectionne: boolean);
var
  WinTop, WinLeft : integer;
  RectCell : TRect;
begin
  if (Num >= 0) and (Num < NbEntree) then
  begin
    WinTop := 20 + (Num div NbCouleurs) * (HautCell + 6);
    WinLeft := MargeX + (Num mod NbCouleurs) * (LargCell + 2);
    RectCell := Bounds(WinLeft,WinTop,LargCell,HautCell);
    Canvas.Pen.Color := clBtnFace;
    with RectCell do Canvas.Rectangle(Left,Top,Right,Bottom);
    InflateRect(RectCell,-1,1);
    Frame3D(Canvas, RectCell, clBtnShadow, ClBtnHighlight, 2);
    Canvas.Brush.Color := EntreePalette[Num];
    Canvas.Pen.Color := EntreePalette[Num];
    if Selectionne then
    begin
      with RectCell do Canvas.Rectangle(Left,Top,Right,Bottom);
      InflateRect(RectCell,-1,-1);
      DrawFocusRect(Canvas.Handle, RectCell);
      Color := EntreePalette[Num];
      DrawChoix;
    end
    else with RectCell do Canvas.Rectangle(Left,Top,Right,Bottom);
  end;
end;

procedure TFChoixCouleur.DrawChoix;
var
  WinTop, WinLeft : integer;
  RectCell : TRect;
begin
    WinTop := Height - 128;
    WinLeft := 165;
    RectCell := Bounds(WinLeft,WinTop,2*LargCell,HautCell);
    Canvas.Pen.Color := clBtnFace;
    with RectCell do Canvas.Rectangle(Left,Top,Right,Bottom);
    InflateRect(RectCell,-1,1);
    Frame3D(Canvas, RectCell, clBtnShadow, ClBtnHighlight, 2);
    Canvas.Brush.Color := Color;
    Canvas.Pen.Color := Color;
    with RectCell do Canvas.Rectangle(Left,Top,Right,Bottom);
end;

function TFChoixCouleur.PosToCell(X,Y : integer): integer;
var
  Col,Lig : integer;
begin
  X := X - MargeX;
  Y := Y - 20;
  if X > (Width - 1) then X := Width - 1;
  if X < 0 then X := 0;
  if Y > (Height - 1) then Y := Height - 1;
  if Y < 0 then Y := 0;
  Col := (X div (LargCell + 2));
  Lig := (Y div (HautCell + 6));
  Result := Lig * NbCouleurs + Col;
end;

procedure TFChoixCouleur.FormShow(Sender: TObject);
var
  Num       : integer;
  Interval  : integer;
  V,V2,V3   : integer; { valeur, valeur div 2}
  Reste     : integer;
begin
  if NbCouleurs > 16 then NbCouleurs := 16;
  if NbNuances > 16 then NbNuances := 16;
  if NbCouleurs < 1 then NbCouleurs := 1;
  if NbNuances < 1 then NbNuances := 1;

  Width  := NbCouleurs * (LargCell + 2) + 44;
  MargeX := 20;
  if Width < 242 then
  begin
    Width := 242;
    MargeX := (Width - (NbCouleurs * (LargCell + 2) + 2)) div 2;
    BtnOk.Left := 20;
    BtnCancel.Left := 140;
  end
  else
  begin
    DecaleX := (Width - 162) div 3;
    BtnOk.Left := DecaleX;
    BtnCancel.Left := 2 * DecaleX + 80;
  end;
  Height := (NbNuances + 1) * (HautCell + 6) + 140;

  Left := (Screen.Width - Width) div 2;
  Top  := (Screen.Height - Height) div 2;

  BtnOk.Top := Height - 70;
  BtnCancel.Top := Height - 70;
  TitreCouleur.Top := Height -128;
  TitreCouche.Top := Height - 103;
  SpinEditCouche.Top := Height - 105;

  NbEntree := NbCouleurs * NbNuances;
  if Selected > NbEntree then Selected := NbEntree;
  if Selected < 0 then Selected := 0;

  Interval := 256 div NbNuances;
  EntreePalette[0] := TColor(RGB(0,0,0));
  for Num := 1 to (NbEntree-1) do
  begin
    V := ((Num div NbCouleurs) + 1) * Interval;
    V2 := V div 2;
    V3 := 3 * V div 4;
    if V > 255 then V := 255;
    Reste  := (Num mod NbCouleurs) + 1;
    case Reste of
      1  : EntreePalette[Num] := TColor(RGB(V,V,V)); {Blanc}
      2  : EntreePalette[Num] := TColor(RGB(V,0,0)); {Rouge}
      3  : EntreePalette[Num] := TColor(RGB(0,V,0)); {Vert}
      4  : EntreePalette[Num] := TColor(RGB(0,0,V)); {Bleu}
      5  : EntreePalette[Num] := TColor(RGB(V,V,0)); {Jaune}
      6  : EntreePalette[Num] := TColor(RGB(V,0,V)); {Magenta}
      7  : EntreePalette[Num] := TColor(RGB(0,V,V)); {Cyan}
      8  : EntreePalette[Num] := TColor(RGB(V,V2,0)); {Orange}
      9  : EntreePalette[Num] := TColor(RGB(V2,0,0)); {Marron}
      10 : EntreePalette[Num] := TColor(RGB(V,0,V2)); {Rose}
      11 : EntreePalette[Num] := TColor(RGB(V3,0,V2)); {Bordeau}
      12 : EntreePalette[Num] := TColor(RGB(V2,0,V2)); {Violet}
      13 : EntreePalette[Num] := TColor(RGB(0,0,V2)); {Bleu marine}
      14 : EntreePalette[Num] := TColor(RGB(0,V2,V2)); {Turquoise}
      15 : EntreePalette[Num] := TColor(RGB(0,V2,0)); {Vert bouteille}
      16 : EntreePalette[Num] := TColor(RGB(V2,V2,0)); {Vert olive}
    end;
  end;
end;

procedure TFChoixCouleur.FormPaint(Sender: TObject);
var
  Numero: integer;
begin
  BtnOk.Visible := false;
  BtnCancel.Visible := false;
  for Numero := 0 to (NbEntree - 1) do DrawSquare(Numero,false);
  DrawSquare(Selected,true);
  BtnOk.Visible := true;
  BtnCancel.Visible := true;
end;

procedure TFChoixCouleur.FormMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  Num : integer;
begin
  Num := PosTocell(X,Y);
  if Button = mbLeft then
  begin
    DrawSquare(Selected,false);
    Selected := Num;
    DrawSquare(Selected,true);
  end;
end;

function TFChoixCouleur.Execute:boolean;
begin
  Terminaison := false;
  ShowModal;
  Result := Terminaison;
end;

procedure TFChoixCouleur.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  Nouveau : integer;
begin
  Nouveau := Selected;
  case Key of
    VK_RIGHT : inc(Nouveau);
    VK_LEFT  : dec(Nouveau);
    VK_UP    : begin
                 Nouveau := Nouveau - NbCouleurs;
                 if Nouveau < 0 then Nouveau := NbEntree - Nouveau;
               end;
    VK_DOWN  : begin
                 Nouveau := Nouveau + NbCouleurs;
                 if Nouveau > NbEntree then Nouveau := Nouveau - NbEntree;
               end;
  end;
  if Nouveau > NbEntree then Nouveau := 0;
  if Nouveau < 0 then Nouveau := NbEntree;
  if Nouveau <> Selected then
  begin
    DrawSquare(Selected,false);
    Selected := Nouveau;
    DrawSquare(Selected,true);
    Key := 0;
  end;
end;

procedure TFChoixCouleur.BtnOkClick(Sender: TObject);
begin
  Terminaison := True;
  Layer := SpinEditCouche.Value;
  close;
end;

procedure TFChoixCouleur.BtnCancelClick(Sender: TObject);
begin
  Terminaison := false;
  close;
end;

end.
