unit JDCalcul;

interface

uses
  JDData;

// Utilitaires
function MiseEnFormeAngle(A : extended): extended;
function Distance2Points(P1,P2 : DefPoint): extended;
function PointLignePoint(P1: DefPoint; L1:DefLigne):DefPoint;
function EquationDroite(L1: DefLigne): EquaLigne;
function AngleSegment(P1,P2: DefPoint): extended;
function Arrondi(Valeur: extended): longint;

// Points
function PNN(N1,N2:extended): DefPoint;
function PNA(N1,N2:extended): DefPoint;
function PPNN(P1:DefPoint;N1,N2:extended): DefPoint;
function PPNA(P1:Defpoint;N1,N2:extended): DefPoint;
function PC(C1:DefCercle): DefPoint;
function PPPA(P1,P2:DefPoint;N1:extended): DefPoint;
function PPP(P1,P2:DefPoint): DefPoint;
function PPL(P1:Defpoint;L1:DefLigne): DefPoint;
function PLL(L1,L2:DefLigne): DefPoint;
function PLCD(L1:DefLigne;C1:DefCercle;D1:char): DefPoint;
function PCCD(C1,C2:DefCercle;D1:char): DefPoint;
function PPPD(P1,P2:DefPoint): DefPoint;
// Lignes
function LNNA(N1,N2,N3:extended): DefLigne;
function LPA(P1:DefPoint;N1:extended): DefLigne;
function LPP(P1,P2:DefPoint): DefLigne;
function LPL(P1:Defpoint;L1:DefLigne): DefLigne;
function LPLD(P1:Defpoint;L1:DefLigne): DefLigne;
function LPCD(P1:DefPoint;C1:DefCercle;D1:char): DefLigne;
function LND(N1:extended;D1:char): DefLigne;
function LLND(L1:DefLigne;N1:extended;D1:char): DefLigne;
function LLCD(L1:DefLigne;C1:DefCercle;D1:char): DefLigne;
function LLCDD(L1:DefLigne;C1:DefCercle;D1:char): DefLigne;
function LCCDD(C1,C2:DefCercle;D1,D2:char): DefLigne;
function LCAD(C1:DefCercle;N1:extended;D1:char): DefLigne;
function LLP(L1:DefLigne;P1:DefPoint): DefLigne;
function LLL(L1,L2:DefLigne): DefLigne;
function LLPA(L1:DefLigne;P1:DefPoint;N1:extended): DefLigne;
function LLLD(L1,L2:DefLigne): DefLigne;
//Cercles
function CNNN(N1,N2,N3:extended): DefCercle;
function CPN(P1:Defpoint;N1:extended): DefCercle;
function CPP(P1,P2:DefPoint): DefCercle;
function CPL(P1:DefPoint;L1:DefLigne): DefCercle;
function CPCD(P1:DefPoint;C1:DefCercle;D1:char): DefCercle;
function CCNN(C1:DefCercle;N1,N2:extended): DefCercle;
function CCNA(C1:DefCercle;N1,N2:extended): DefCercle;
function CPPND(P1,P2:DefPoint;N1:extended;D1:char): DefCercle;
function CPLND(P1:DefPoint;L1:DefLigne;N1:extended;D1:char): DefCercle;
function CPCNDD(P1:DefPoint;C1:DefCercle;N1:extended;D1,D2:char): DefCercle;
function CLLNDD(L1,L2:DefLigne;N1:extended;D1,D2:char):DefCercle;
function CLCNDDD(L1:DefLigne;C1:DefCercle;N1:extended;D1,D2,D3:char): DefCercle;
function CCCNDDD(C1,C2:DefCercle;N1:extended;D1,D2,D3:char): DefCercle;
function CCN(C1:DefCercle;N1:extended): DefCercle;
function CCND(C1:DefCercle;N1:extended;D1:char): DefCercle;
function CPPP(P1,P2,P3:DefPoint): DefCercle;

function CCPA(C1:DefCercle;P1:DefPoint;N1:extended): DefCercle;
function CCP(C1:DefCercle;P1:DefPoint): DefCercle;
function CCL(C1:DefCercle;L1:DefLigne): DefCercle;

implementation

uses
  SysUtils, Math;

// Utilitaires

function MiseEnFormeAngle(A : extended): extended;
begin
  if A < 0 then A := A + 2*Pi;
  if A >= 2*Pi then A := A - 2*Pi;
  Result := A;
end;

function Distance2Points(P1,P2 : DefPoint): extended;
begin
  Result := sqrt(sqr((P1.X-P2.X)) + sqr((P1.Y-P2.Y)));
end;

function PointLignePoint(P1: DefPoint; L1:DefLigne):DefPoint;
var
  R1, R2 :extended;
begin
  if (L1.Aod = 0) or (L1.Aod = Pi) then
  begin
    Result.X := P1.X;
    Result.Y := L1.Ypd;
  end
  else
  if (L1.Aod = (Pi/2)) or (L1.Aod = (3*Pi/2)) then
  begin
    Result.X := L1.Xpd;
    Result.Y := P1.Y;
  end
  else
  begin
    R1 := L1.Xpd*sqr(sin(L1.Aod))+P1.X*sqr(cos(L1.Aod));
    R2 := (P1.Y-L1.Ypd)*cos(L1.Aod)*sin(L1.Aod);
    Result.X := R1 + R2;
    R1 := P1.Y*sqr(sin(L1.Aod))+L1.Ypd*sqr(cos(L1.Aod));
    R2 := (P1.X-L1.Xpd)*cos(L1.Aod)*sin(L1.Aod);
    Result.Y := R1 + r2;
  end;
end;

function EquationDroite(L1: DefLigne): EquaLigne;
begin
  Result.A := sin(L1.Aod);
  Result.B := -cos(L1.Aod);
  Result.C := L1.Ypd*cos(L1.Aod) - L1.Xpd*sin(L1.Aod);
end;

function AngleSegment(P1,P2: DefPoint): extended;
var
  Angle : extended;
begin
  if P2.X>P1.X then Angle := ArcTan((P2.Y-P1.Y)/(P2.X-P1.X))
  else
  if P2.X<P1.X then Angle := ArcTan((P2.Y-P1.Y)/(P2.X-P1.X))+Pi
  else
  begin
    if P2.Y>=P1.Y then Angle := Pi/2
                 else Angle := 3*Pi/2;
  end;
  Angle := MiseEnFormeAngle(Angle);
  Result := Angle;
end;

function Arrondi(Valeur: extended): longint;
var
  Chaine        : string;
  PartieEntiere : string;
  Decimale      : char;
  N             : integer;
begin
  if Valeur < -999999999.0 then Result := -999999999
  else
  if Valeur > 999999998.0 then Result := 999999999
  else
  begin
    Chaine := FloatToStrF(Valeur,ffFixed,999,18);
    N := pos('.',Chaine);
    if N = 0 then
    begin
      PartieEntiere := Chaine;
      Decimale := '0';
    end
    else
    begin
      PartieEntiere := copy(Chaine,1,N-1);
      Decimale := Chaine[N+1];
    end;
    Result := StrToInt(PartieEntiere);
    if Decimale in ['5'..'9'] then inc(Result);
  end;
end;

// Points

function PNN(N1,N2:extended): DefPoint;
begin
  PasDeSol := false;
  with Result do
  begin
    X := N1;
    Y := N2;
  end;
end;

function PNA(N1,N2:extended): DefPoint;
var
  Angle : extended;
begin
  PasDeSol := false;
  Angle := DegToRad(N2);
  with Result do
  begin
    X := N1*cos(Angle);
    Y := N1*sin(Angle);
  end;
end;

function PPNN(P1:DefPoint;N1,N2:extended): DefPoint;
begin
  PasDeSol := false;
  with Result do
  begin
    X := P1.X + N1;
    Y := P1.Y + N2;
  end;
end;

function PPNA(P1:DefPoint;N1,N2:extended): DefPoint;
var
  Angle  : extended;
begin
  PasDeSol := false;
  Angle := DegToRad(N2);
  with Result do
  begin
    X := P1.X + N1*cos(Angle);
    Y := P1.Y + N1*sin(Angle);
  end;
end;

function PC(C1:DefCercle): DefPoint;
begin
  PasDeSol := false;
  with Result do
  begin
    X := C1.Xc;
    Y := C1.Yc;
  end;
end;

function PPPA(P1,P2:DefPoint;N1:extended): DefPoint;
var
  Distance : extended;
  Angle : extended;
  X0, Y0 : extended;
  DeltaX, DeltaY : extended;
  Beta : extended;
begin
  { P2 centre de rotation }
  PasDeSol := false;
  Angle := DegToRad(N1);
  if P1.X = P2.X then
  begin
    Distance := P1.Y - P2.Y;
    X0 := P2.X - (Distance*sin(Angle));
    Y0 := P2.Y + (Distance*cos(Angle));
  end
  else
  if P1.Y = P2.Y then
  begin
    Distance := P1.X - P2.X;
    X0 := P2.X + (Distance*cos(Angle));
    Y0 := P2.Y + (Distance*sin(Angle));
  end
  else
  begin
    Distance := Distance2Points(P1,P2);
    DeltaX := (P1.X-P2.X);
    DeltaY := (P1.Y-P2.Y);
    Beta := ArcCos((DeltaX/Distance));
    if (DeltaX>=0) and (DeltaY<0) then Beta := 2*Pi - Beta
    else
    if (DeltaX<0) and (DeltaY<0) then Beta := 2*Pi - Beta;
    X0 := P2.X + Distance*cos((Angle + Beta));
    Y0 := P2.Y + Distance*sin((Angle + Beta));
  end;
  with Result do
  begin
    X := X0;
    Y := Y0;
  end;
end;

function PPP(P1,P2:DefPoint): DefPoint;
begin
  { P2 point de symtrie }
  PasDeSol := false;
  with Result do
  begin
    X := (2*P2.X)-P1.X;
    Y := (2*P2.Y)-P1.Y;
  end;
end;

function PPL(P1:DefPoint;L1:DefLigne): DefPoint;
var
  P2 : DefPoint;
begin
  PasDeSol := false;
  P2 := PointLignePoint(P1,L1);
  with Result do
  begin
    X := (2*P2.X)-P1.X;
    Y := (2*P2.Y)-P1.Y;
  end;
end;

function PLL(L1,L2:DefLigne): DefPoint;
var
  E1,E2 : EquaLigne;
  Tmp   : extended;
begin
  PasDeSol := false;
  E1 := EquationDroite(L1);
  E2 := EquationDroite(L2);
  Tmp := E1.A*E2.B - E2.A*E1.B;
  if Tmp = 0 then PasDeSol := true
  else
  begin
    Result.X := (E2.C*E1.B - E1.C*E2.B)/Tmp;
    Result.Y := (E2.A*E1.C - E1.A*E2.C)/Tmp;
  end;
end;

function PLCD(L1:DefLigne;C1:DefCercle;D1:char): DefPoint;
var
  P1,P2 : DefPoint;
  Angle, ARef : extended;
  Distance, Tmp : extended;
  X1,X2,Y1,Y2 : extended;
begin
  PasDeSol := false;
  X1 := 0;
  Y1 := 0;
  X2 := 0;
  Y2 := 0;
  if (L1.Aod = 0) or (L1.Aod = Pi) then
  begin
    if (L1.Ypd > (C1.Yc + C1.Rc)) or (L1.Ypd < (C1.Yc - C1.Rc)) then
       PasDeSol := true
    else
    begin
      Angle := ArcSin((L1.Ypd-C1.Yc)/C1.Rc);
      X1 := C1.Xc + C1.Rc*cos(Angle);
      Y1 := L1.Ypd;
      X2 := C1.Xc - C1.Rc*cos(Angle);
      Y2 := L1.Ypd;
    end;
  end
  else
  if (L1.Aod = Pi/2) or (L1.Aod = 3*Pi/2) then
  begin
    if (L1.Xpd > (C1.Xc + C1.Rc)) or (L1.Xpd < (C1.Xc - C1.Rc)) then
       PasDeSol := true
    else
    begin
      Tmp := sqrt(sqr(C1.Rc)-sqr((L1.Xpd-C1.Xc)));
      X1 := L1.Xpd;
      Y1 := C1.Yc + Tmp;
      X2 := L1.Xpd;
      Y2 := C1.Yc - Tmp;
    end;
  end
  else
  begin
    P1.X := C1.Xc;
    P1.Y := C1.Yc;
    P2 := PointLignePoint(P1,L1);
    Distance := Distance2Points(P1,P2);
    if Distance > C1.Rc then PasDeSol := true
    else
    begin
      P2.X := L1.Xpd;
      P2.Y := L1.Ypd;
      ARef := AngleSegment(P2,P1);
      if Aref <= Pi then
      begin
        if Aref < L1.Aod then
        begin
          Angle := L1.Aod + Pi/2 - ArcCos(Distance/C1.Rc);
          X1 := C1.Xc + C1.Rc*cos(Angle);
          Y1 := C1.Yc + C1.Rc*sin(Angle);
          Angle := L1.Aod + Pi/2 + ArcCos(Distance/C1.Rc);
          X2 := C1.Xc + C1.Rc*cos(Angle);
          Y2 := C1.Yc + C1.Rc*sin(Angle);
        end
        else
        begin
          Angle := L1.Aod + 3*Pi/2 - ArcCos(Distance/C1.Rc);
          X1 := C1.Xc + C1.Rc*cos(Angle);
          Y1 := C1.Yc + C1.Rc*sin(Angle);
          Angle := L1.Aod + 3*Pi/2 + ArcCos(Distance/C1.Rc);
          X2 := C1.Xc + C1.Rc*cos(Angle);
          Y2 := C1.Yc + C1.Rc*sin(Angle);
        end;
      end
      else
      begin
        ARef := ARef - Pi;
        if Aref < L1.Aod then
        begin
          Angle := L1.Aod + 3*Pi/2 - ArcCos(Distance/C1.Rc);
          X1 := C1.Xc + C1.Rc*cos(Angle);
          Y1 := C1.Yc + C1.Rc*sin(Angle);
          Angle := L1.Aod + 3*Pi/2 + ArcCos(Distance/C1.Rc);
          X2 := C1.Xc + C1.Rc*cos(Angle);
          Y2 := C1.Yc + C1.Rc*sin(Angle);
        end
        else
        begin
          Angle := L1.Aod + Pi/2 - ArcCos(Distance/C1.Rc);
          X1 := C1.Xc + C1.Rc*cos(Angle);
          Y1 := C1.Yc + C1.Rc*sin(Angle);
          Angle := L1.Aod + Pi/2 + ArcCos(Distance/C1.Rc);
          X2 := C1.Xc + C1.Rc*cos(Angle);
          Y2 := C1.Yc + C1.Rc*sin(Angle);
        end;
      end;
    end;
  end;
  case D1 of
    'H' : if Y1 >= Y2 then
          begin
            Result.X := X1;
            Result.Y := Y1;
          end
          else
          begin
            Result.X := X2;
            Result.Y := Y2;
          end;
    'B' : if Y1 < Y2 then
          begin
            Result.X := X1;
            Result.Y := Y1;
          end
          else
          begin
            Result.X := X2;
            Result.Y := Y2;
          end;
    'D' : if X1 >= X2 then
          begin
            Result.X := X1;
            Result.Y := Y1;
          end
          else
          begin
            Result.X := X2;
            Result.Y := Y2;
          end;
    'G' : if X1 < X2 then
          begin
            Result.X := X1;
            Result.Y := Y1;
          end
          else
          begin
            Result.X := X2;
            Result.Y := Y2;
          end;
  end;
end;

function PCCD(C1,C2:DefCercle;D1:char): DefPoint;
var
  P1,P2 : DefPoint;
  Distance,Tmp : extended;
  Angle1,Angle2 : extended;
  X1,X2,Y1,Y2 : extended;
begin
  PasDeSol := false;
  if (C1.Xc=C2.Xc) and (C1.Yc=C2.Yc) then PasDeSol := true
  else
  begin
    P1.X := C1.Xc;
    P1.Y := C1.Yc;
    P2.X := C2.Xc;
    P2.Y := C2.Yc;
    Distance := Distance2Points(P1,P2);
    if Distance > (C1.Rc + C2.Rc) then PasDeSol := true
    else
    begin
      Angle1 := AngleSegment(P1,P2);
      Tmp := 2*Distance*C1.Rc;
      Angle2 := ArcCos((sqr(Distance)+sqr(C1.Rc)-sqr(C2.Rc))/Tmp);
      X1:= C1.Xc + C1.Rc*cos((Angle1+Angle2));
      Y1:= C1.Yc + C1.Rc*sin((Angle1+Angle2));
      X2:= C1.Xc + C1.Rc*cos((Angle1-Angle2));
      Y2:= C1.Yc + C1.Rc*sin((Angle1-Angle2));
      case D1 of
        'H' : if Y1 >= Y2 then
              begin
                Result.X := X1;
                Result.Y := Y1;
              end
              else
              begin
                Result.X := X2;
                Result.Y := Y2;
              end;
        'B' : if Y1 < Y2 then
              begin
                Result.X := X1;
                Result.Y := Y1;
              end
              else
              begin
                Result.X := X2;
                Result.Y := Y2;
              end;
        'D' : if X1 >= X2 then
              begin
                Result.X := X1;
                Result.Y := Y1;
              end
              else
              begin
                Result.X := X2;
                Result.Y := Y2;
              end;
        'G' : if X1 < X2 then
              begin
                Result.X := X1;
                Result.Y := Y1;
              end
              else
              begin
                Result.X := X2;
                Result.Y := Y2;
              end;
      end;
    end;
  end;
end;

function PPPD(P1,P2:Defpoint): DefPoint;
begin
  PasDeSol := false;
  with Result do
  begin
    X := (P1.X+P2.X)/2;
    Y := (P1.Y+P2.Y)/2;
  end;
end;

// Lignes

function LNNA(N1,N2,N3:extended): DefLigne;
begin
  PasDeSol := false;
  with Result do
  begin
    Xpd := N1;
    Ypd := N2;
    Aod := MiseEnFormeAngle(DegToRad(N3));
    Xdd := 0;
    Ydd := 0;
    Xfd := 0;
    Yfd := 0;
  end;
end;

function LPA(P1:DefPoint;N1:extended): DefLigne;
begin
  PasDeSol := false;
  with Result do
  begin
    Xpd := P1.X;
    Ypd := P1.Y;
    Aod := MiseEnFormeAngle(DegToRad(N1));
    Xdd := 0;
    Ydd := 0;
    Xfd := 0;
    Yfd := 0;
  end;
end;

function LPP(P1,P2:DefPoint): DefLigne;
var
  Angle,Distance : extended;
begin
  PasDeSol := false;
  Distance := Distance2Points(P1,P2);
  Angle := ArcCos(((P2.X-P1.X)/Distance));
  if P2.Y < P1.Y then Angle := 2*Pi - Angle;
  with Result do
  begin
    Xpd := P1.X;
    Ypd := P1.Y;
    Aod := MiseEnFormeAngle(Angle);
    Xdd := 0;
    Ydd := 0;
    Xfd := 0;
    Yfd := 0;
  end;
end;

function LPL(P1:DefPoint;L1:DefLigne): DefLigne;
begin
  PasDeSol := false;
  with Result do
  begin
    Xpd := P1.X;
    Ypd := P1.Y;
    Aod := L1.Aod;
    Xdd := 0;
    Ydd := 0;
    Xfd := 0;
    Yfd := 0;
  end;
end;

function LPLD(P1:DefPoint;L1:DefLigne): DefLigne;
var
  Angle  : extended;
begin
  PasDeSol := false;
  Angle := L1.Aod + Pi/2;
  with Result do
  begin
    Xpd := P1.X;
    Ypd := P1.Y;
    Aod := MiseEnFormeAngle(Angle);
    Xdd := 0;
    Ydd := 0;
    Xfd := 0;
    Yfd := 0;
  end;
end;

function LPCD(P1:DefPoint;C1:DefCercle;D1:char): DefLigne;
var
  P2 : DefPoint;
  Distance, Angle, Beta  : extended;
begin
  PasDeSol := false;
  Angle := 0;
  if (P1.X = C1.Xc) and (P1.Y = C1.Yc) then PasDeSol := true
  else
  begin
    P2.X := C1.Xc;
    P2.Y := C1.Yc;
    Distance := Distance2Points(P1,P2);
    if Distance < C1.Rc then PasdeSol := true
    else
    begin
      Beta := AngleSegment(P1,P2);
      case D1 of
        'H' : if p1.X < P2.X then Angle := Beta + ArcSin((C1.Rc/Distance))
                             else Angle := Beta - ArcSin((C1.Rc/Distance));
        'B' : if p1.X < P2.X then Angle := Beta - ArcSin((C1.Rc/Distance))
                             else Angle := Beta + ArcSin((C1.Rc/Distance));
        'D' : if p1.Y < P2.Y then Angle := Beta - ArcSin((C1.Rc/Distance))
                             else Angle := Beta + ArcSin((C1.Rc/Distance));
        'G' : if p1.Y < P2.Y then Angle := Beta + ArcSin((C1.Rc/Distance))
                             else Angle := Beta - ArcSin((C1.Rc/Distance));
      end;
      with Result do
      begin
        Xpd := P1.X;
        Ypd := P1.Y;
        Aod := MiseEnFormeAngle(Angle);
        Xdd := 0;
        Ydd := 0;
        Xfd := 0;
        Yfd := 0;
      end;
    end;
  end;
end;

function LND(N1:extended;D1:char): DefLigne;
begin
  PasDeSol := false;
  if D1 = 'X' then
    begin
      with Result do
      begin
        Xpd := N1;
        Ypd := 0;
        Aod := Pi/2;
        Xdd := 0;
        Ydd := 0;
        Xfd := 0;
        Yfd := 0;
      end;
    end
    else
    begin
      with Result do
      begin
        Xpd := 0;
        Ypd := N1;
        Aod := 0;
        Xdd := 0;
        Ydd := 0;
        Xfd := 0;
        Yfd := 0;
      end;
    end;
end;

function LLND(L1:DefLigne;N1:extended;D1:char): DefLigne;
var
  X1, Y1, X2, Y2 : extended;
  Angle : extended;
begin
  PasDeSol := false;
  Angle := L1.Aod;
  X1 := L1.Xpd - N1*sin(Angle);
  Y1 := L1.Ypd + N1*cos(Angle);
  X2 := L1.Xpd + N1*sin(Angle);
  Y2 := L1.Ypd - N1*cos(Angle);
  case D1 of
    'H' : if Y1 > Y2 then
          begin
            Result.Xpd := X1;
            Result.Ypd := Y1;
          end
          else
          begin
            Result.Xpd := X2;
            Result.Ypd := Y2;
          end;
    'B' : if Y1 > Y2 then
          begin
            Result.Xpd := X2;
            Result.Ypd := Y2;
          end
          else
          begin
            Result.Xpd := X1;
            Result.Ypd := Y1;
          end;
    'D' : if X1 > X2 then
          begin
            Result.Xpd := X1;
            Result.Ypd := Y1;
          end
          else
          begin
            Result.Xpd := X2;
            Result.Ypd := Y2;
          end;
    'G' : if X1 > X2 then
          begin
            Result.Xpd := X2;
            Result.Ypd := Y2;
          end
          else
          begin
            Result.Xpd := X1;
            Result.Ypd := Y1;
          end;
  end;
  with Result do
  begin
    Aod := L1.Aod;
    Xdd := 0;
    Ydd := 0;
    Xfd := 0;
    Yfd := 0;
  end;
end;

function LLCD(L1:DefLigne;C1:DefCercle;D1:char): DefLigne;
var
  X1, Y1, X2, Y2 : extended;
begin
  PasDeSol := false;
  X1 := C1.Xc - C1.Rc*sin(L1.Aod);
  Y1 := C1.Yc + C1.Rc*cos(L1.Aod);
  X2 := C1.Xc + C1.Rc*sin(L1.Aod);
  Y2 := C1.Yc - C1.Rc*cos(L1.Aod);
  case D1 of
    'H' : if Y1 > Y2 then
          begin
            Result.Xpd := X1;
            Result.Ypd := Y1;
          end
          else
          begin
            Result.Xpd := X2;
            Result.Ypd := Y2;
          end;
    'B' : if Y1 > Y2 then
          begin
            Result.Xpd := X2;
            Result.Ypd := Y2;
          end
          else
          begin
            Result.Xpd := X1;
            Result.Ypd := Y1;
          end;
    'D' : if X1 > X2 then
          begin
            Result.Xpd := X1;
            Result.Ypd := Y1;
          end
          else
          begin
            Result.Xpd := X2;
            Result.Ypd := Y2;
          end;
    'G' : if X1 > X2 then
          begin
            Result.Xpd := X2;
            Result.Ypd := Y2;
          end
          else
          begin
            Result.Xpd := X1;
            Result.Ypd := Y1;
          end;
  end;
  with Result do
  begin
    Aod := L1.Aod;
    Xdd := 0;
    Ydd := 0;
    Xfd := 0;
    Yfd := 0;
  end;
end;

function LLCDD(L1:DefLigne;C1:DefCercle;D1:char): DefLigne;
var
  X1, Y1, X2, Y2 : extended;
  Angle : extended;
begin
  PasDeSol := false;
  X1 := C1.Xc - C1.Rc*cos(L1.Aod);
  Y1 := C1.Yc - C1.Rc*sin(L1.Aod);
  X2 := C1.Xc + C1.Rc*cos(L1.Aod);
  Y2 := C1.Yc + C1.Rc*sin(L1.Aod);
  Angle := L1.Aod + Pi/2;
  case D1 of
    'H' : if Y1 > Y2 then
          begin
            Result.Xpd := X1;
            Result.Ypd := Y1;
          end
          else
          begin
            Result.Xpd := X2;
            Result.Ypd := Y2;
          end;
    'B' : if Y1 > Y2 then
          begin
            Result.Xpd := X2;
            Result.Ypd := Y2;
          end
          else
          begin
            Result.Xpd := X1;
            Result.Ypd := Y1;
          end;
    'D' : if X1 > X2 then
          begin
            Result.Xpd := X1;
            Result.Ypd := Y1;
          end
          else
          begin
            Result.Xpd := X2;
            Result.Ypd := Y2;
          end;
    'G' : if X1 > X2 then
          begin
            Result.Xpd := X2;
            Result.Ypd := Y2;
          end
          else
          begin
            Result.Xpd := X1;
            Result.Ypd := Y1;
          end;
  end;
  with Result do
  begin
    Aod := MiseEnFormeAngle(Angle);
    Xdd := 0;
    Ydd := 0;
    Xfd := 0;
    Yfd := 0;
  end;
end;

function LCCDD(C1,C2:DefCercle;D1,D2:char): DefLigne;
var
  C0 : DefCercle;
  P1, P2 : DefPoint;
  D0 : char;
  Distance, Valeur : extended;
  ARef, Angle : extended;
  X : array[1..4] of extended;
  Y : array[1..4] of extended;
  A : array[1..4] of extended;
  Xd : array[1..4] of extended;
  Yd : array[1..4] of extended;
  Xf : array[1..4] of extended;
  Yf : array[1..4] of extended;
  N, LeBon : integer;
  Ok : boolean;
begin
  PasDeSol := false;
  if (C1.Xc = C2.Xc) and (C1.Yc = C2.Yc) then PasDeSol := true
  else
  begin
    if C1.Xc > C2.Xc then
    begin
      C0 := C1;
      C1 := C2;
      C2 := C0;
      D0 := D1;
      D1 := D2;
      D2 := D0;
    end;
    P1.X := C1.Xc;
    P1.Y := C1.Yc;
    P2.X := C2.Xc;
    P2.Y := C2.Yc;
    Distance := Distance2Points(P1,P2);
    if (Distance < C1.Rc) and (Distance+C2.Rc<C1.Rc) then PasDeSol := true
    else
    begin
      ARef := AngleSegment(P1,P2);
      if C1.Rc > C2.Rc then
      begin
        Valeur := (C1.Rc - C2.Rc)/Distance;
        if (Valeur >= -1) and (Valeur <= 1) then
        begin
          Angle := MiseEnFormeAngle(ARef - ArcSin(Valeur));
          A[1] := Angle;
          Xd[1] := C1.Xc - C1.Rc*sin(A[1]);
          Yd[1] := C1.Yc + C1.Rc*cos(A[1]);
          Xf[1] := C2.Xc - C2.Rc*sin(A[1]);
          Yf[1] := C2.Yc + C2.Rc*cos(A[1]);
          X[1] := Xd[1];
          Y[1] := Yd[1];

          Angle := MiseEnFormeAngle(ARef + ArcSin(Valeur));
          A[2] := Angle;
          Xd[2] := C1.Xc + C1.Rc*sin(A[2]);
          Yd[2] := C1.Yc - C1.Rc*cos(A[2]);
          Xf[2] := C2.Xc + C2.Rc*sin(A[2]);
          Yf[2] := C2.Yc - C2.Rc*cos(A[2]);
          X[2] := Xd[2];
          Y[2] := Yd[2];
        end
        else
        begin
          A[1] := 10;
          A[2] := 10;
        end;

        Valeur := (C1.Rc + C2.Rc)/Distance;
        if (Valeur >= -1) and (Valeur <= 1) then
        begin
          Angle := MiseEnFormeAngle(ARef - ArcSin(Valeur));
          A[3] := Angle;
          Xd[3] := C1.Xc - C1.Rc*sin(A[3]);
          Yd[3] := C1.Yc + C1.Rc*cos(A[3]);
          Xf[3] := C2.Xc + C2.Rc*sin(A[3]);
          Yf[3] := C2.Yc - C2.Rc*cos(A[3]);
          X[3] := Xd[3];
          Y[3] := Yd[3];

          Angle := MiseEnFormeAngle(ARef + ArcSin(Valeur));
          A[4] := Angle;
          Xd[4] := C1.Xc + C1.Rc*sin(A[4]);
          Yd[4] := C1.Yc - C1.Rc*cos(A[4]);
          Xf[4] := C2.Xc - C2.Rc*sin(A[4]);
          Yf[4] := C2.Yc + C2.Rc*cos(A[4]);
          X[4] := Xd[4];
          Y[4] := Yd[4];
        end
        else
        begin
          A[3] := 10;
          A[4] := 10;
        end;
      end
      else
      begin
        Valeur := (C2.Rc - C1.Rc)/Distance;
        if (Valeur >= -1) and (Valeur <= 1) then
        begin
          Angle := MiseEnFormeAngle(ARef + ArcSin(Valeur));
          A[1] := Angle;
          Xd[1] := C1.Xc - C1.Rc*sin(A[1]);
          Yd[1] := C1.Yc + C1.Rc*cos(A[1]);
          Xf[1] := C2.Xc - C2.Rc*sin(A[1]);
          Yf[1] := C2.Yc + C2.Rc*cos(A[1]);
          X[1] := Xd[1];
          Y[1] := Yd[1];

          Angle := MiseEnFormeAngle(ARef - ArcSin(Valeur));
          A[2] := Angle;
          Xd[2] := C1.Xc + C1.Rc*sin(A[2]);
          Yd[2] := C1.Yc - C1.Rc*cos(A[2]);
          Xf[2] := C2.Xc + C2.Rc*sin(A[2]);
          Yf[2] := C2.Yc - C2.Rc*cos(A[2]);
          X[2] := Xd[2];
          Y[2] := Yd[2];
        end
        else
        begin
          A[1] := 10;
          A[2] := 10;
        end;

        Valeur := (C1.Rc + C2.Rc)/Distance;
        if (Valeur >= -1) and (Valeur <= 1) then
        begin
          Angle := MiseEnFormeAngle(ARef - ArcSin(Valeur));
          A[3] := Angle;
          Xd[3] := C1.Xc - C1.Rc*sin(A[3]);
          Yd[3] := C1.Yc + C1.Rc*cos(A[3]);
          Xf[3] := C2.Xc + C2.Rc*sin(A[3]);
          Yf[3] := C2.Yc - C2.Rc*cos(A[3]);
          X[3] := Xd[3];
          Y[3] := Yd[3];

          Angle := MiseEnFormeAngle(ARef + ArcSin(Valeur));
          A[4] := Angle;
          Xd[4] := C1.Xc + C1.Rc*sin(A[4]);
          Yd[4] := C1.Yc - C1.Rc*cos(A[4]);
          Xf[4] := C2.Xc - C2.Rc*sin(A[4]);
          Yf[4] := C2.Yc + C2.Rc*cos(A[4]);
          X[4] := Xd[4];
          Y[4] := Yd[4];
        end
        else
        begin
          A[3] := 10;
          A[4] := 10;
        end;
      end;
      if not PasDeSol then
      begin
        LeBon := 0;
        for N := 1 to 4 do
        if A[N] <> 10 then
        begin
          Ok := false;
          case D1 of
            'H' : if Yd[N] >= C1.Yc then Ok := true;
            'B' : if Yd[N] < C1.Yc then Ok := true;
            'G' : if Xd[N] < C1.Xc then Ok := true;
            'D' : if Xd[N] >= C1.Xc then Ok := true;
          end;
          if Ok then
          begin
            case D2 of
              'H' : if Yf[N] < C2.Yc then Ok := false;
              'B' : if Yf[N] >= C2.Yc then Ok := false;
              'G' : if Xf[N] >= C2.Xc then Ok := false;
              'D' : if Xf[N] < C2.Xc then Ok := false;
            end;
            if Ok then LeBon := N;
          end;
        end;
        if LeBon = 0 then PasDeSol := true
        else
          with Result do
          begin
            Xpd := X[LeBon];
            Ypd := Y[LeBon];
            Aod := A[LeBon];
            Xdd := Xd[LeBon];
            Ydd := Yd[LeBon];
            Xfd := Xf[LeBon];
            Yfd := Yf[LeBon];
          end;
      end;
    end;
  end;
end;

function LCAD(C1:DefCercle;N1:extended;D1:char): DefLigne;
var
  X1, Y1, X2, Y2 : extended;
  Angle : extended;
begin
  PasDeSol := false;
  Angle := DegToRad(N1);
  X1 := C1.Xc - C1.Rc*sin(Angle);
  Y1 := C1.Yc + C1.Rc*cos(Angle);
  X2 := C1.Xc + C1.Rc*sin(Angle);
  Y2 := C1.Yc - C1.Rc*cos(Angle);
  case D1 of
    'H' : if Y1 > Y2 then
          begin
            Result.Xpd := X1;
            Result.Ypd := Y1;
          end
          else
          begin
            Result.Xpd := X2;
            Result.Ypd := Y2;
          end;
    'B' : if Y1 > Y2 then
          begin
            Result.Xpd := X2;
            Result.Ypd := Y2;
          end
          else
          begin
            Result.Xpd := X1;
            Result.Ypd := Y1;
          end;
    'D' : if X1 > X2 then
          begin
            Result.Xpd := X1;
            Result.Ypd := Y1;
          end
          else
          begin
            Result.Xpd := X2;
            Result.Ypd := Y2;
          end;
    'G' : if X1 > X2 then
          begin
            Result.Xpd := X2;
            Result.Ypd := Y2;
          end
          else
          begin
            Result.Xpd := X1;
            Result.Ypd := Y1;
          end;
  end;
  with Result do
  begin
    Aod := MiseEnFormeAngle(Angle);
    Xdd := 0;
    Ydd := 0;
    Xfd := 0;
    Yfd := 0;
  end;
end;

function LLP(L1:DefLigne;P1:DefPoint): DefLigne;
var
  P2 : DefPoint;
begin
  PasDeSol := false;
  P2 := PointLignePoint(P1,L1);
  with Result do
  begin
    Xpd := 2*P1.X - P2.X;
    Ypd := 2*P1.Y - P2.Y;
    Aod := L1.Aod;
    Xdd := 0;
    Ydd := 0;
    Xfd := 0;
    Yfd := 0;
  end;
end;

function LLL(L1,L2:DefLigne): DefLigne;
var
  Eq1,Eq2 : EquaLigne;
  P1, P2 : DefPoint;
  Tmp : extended;
begin
  { L2 : droite de symtrie }
  PasDeSol := false;
  if (L1.Aod=L2.Aod) or (L1.Aod=L2.Aod+Pi) or (L1.Aod-Pi=L2.Aod) then
  begin
    P2.X := L2.Xpd;
    P2.Y := L2.Ypd;
    P1 := PointLignePoint(P2,L1);
    with Result do
    begin
      Xpd := 2*P2.X - P1.X;
      Ypd := 2*P2.Y - P1.Y;
      Aod := L1.Aod;
      Xdd := 0;
      Ydd := 0;
      Xfd := 0;
      Yfd := 0;
    end;
  end
  else
  begin
    P1.X := L1.Xpd;
    P1.Y := L1.Ypd;
    Eq1 := EquationDroite(L1);
    Eq2 := EquationDroite(L2);
    Tmp := Eq1.A*Eq2.B - Eq2.A*Eq1.B;
    if Tmp = 0 then PasDeSol := true
    else
    begin
      with Result do
      begin
        Xpd := (Eq2.C*Eq1.B - Eq1.C*Eq2.B)/Tmp;
        Ypd := (Eq2.A*Eq1.C - Eq1.A*Eq2.C)/Tmp;
        Aod := 2*L2.Aod - L1.Aod;
        Xdd := 0;
        Ydd := 0;
        Xfd := 0;
        Yfd := 0;
      end;
    end;
  end;
end;

function LLPA(L1:DefLigne;P1:DefPoint;N1:extended): DefLigne;
var
  P2: DefPoint;
  Distance, Angle, Beta : extended;
begin
  PasDeSol := false;
  Angle := DegToRad(N1);
  if (P1.X=L1.Xpd) and (P1.Y=L1.Ypd) then
  begin
    with Result do
    begin
      Xpd := L1.Xpd;
      Ypd := L1.Ypd;
      Aod := MiseEnFormeAngle(L1.Aod+Angle);
      Xdd := 0;
      Ydd := 0;
      Xfd := 0;
      Yfd := 0;
    end;
  end
  else
  begin
    P2 := PointLignePoint(P1,L1);
    Distance := sqrt(sqr(P2.X-P1.X)+sqr(P2.Y-P1.Y));
    Beta := ArcCos((P2.X-P1.X)/Distance);
    if P2.Y < P1.Y then Beta := 2*Pi-Beta;
    with Result do
    begin
      Xpd := P1.X + Distance*cos(Angle+Beta);
      Ypd := P1.Y + Distance*sin(Angle+Beta);
      Aod := MiseEnFormeAngle(L1.Aod+Angle);
      Xdd := 0;
      Ydd := 0;
      Xfd := 0;
      Yfd := 0;
    end;
  end;
end;

function LLLD(L1,L2:DefLigne): DefLigne;
var
  Eq1,Eq2 : EquaLigne;
  P1 : DefPoint;
  Angle, Tmp : extended;
begin
  PasDeSol := false;
  P1.X := L1.Xpd;
  P1.Y := L1.Ypd;
  Eq1 := EquationDroite(L1);
  Eq2 := EquationDroite(L2);
  Tmp := Eq1.A*Eq2.B - Eq2.A*Eq1.B;
  if Tmp = 0 then PasDeSol := true
  else
  begin
    Angle := (L1.Aod + L2.Aod)/2;
    if L2.Aod < L1.Aod then Angle := Angle + Pi/2;
    with Result do
    begin
      Xpd := (Eq2.C*Eq1.B - Eq1.C*Eq2.B)/Tmp;
      Ypd := (Eq2.A*Eq1.C - Eq1.A*Eq2.C)/Tmp;
      Aod := MiseEnFormeAngle(Angle);;
      Xdd := 0;
      Ydd := 0;
      Xfd := 0;
      Yfd := 0;
    end;
  end;
end;

// Cercles

function CNNN(N1,N2,N3:extended): DefCercle;
begin
  PasDeSol := false;
  with Result do
  begin
    Xc  := N1;
    Yc  := N2;
    Rc  := N3;
    Xdc := 0;
    Ydc := 0;
    Adc := 0;
    Xfc := 0;
    Yfc := 0;
    Afc := 0;
  end;
end;

function CPN(P1:DefPoint;N1:extended): DefCercle;
begin
  PasDeSol := false;
  with Result do
  begin
    Xc  := P1.X;
    Yc  := P1.Y;
    Rc  := N1;
    Xdc := 0;
    Ydc := 0;
    Adc := 0;
    Xfc := 0;
    Yfc := 0;
    Afc := 0;
  end;
end;

function CPP(P1,P2:DefPoint): DefCercle;
var
  Distance : extended;
begin
  PasDeSol := false;
  if (P1.X = P2.X) and (P1.Y = P2.Y) then PasDeSol := true
  else
  begin
    Distance := Distance2Points(P1,P2);
    with Result do
    begin
      Xc  := P1.X;
      Yc  := P1.Y;
      Rc  := Distance;
      Xdc := 0;
      Ydc := 0;
      Adc := 0;
      Xfc := 0;
      Yfc := 0;
      Afc := 0;
    end;
  end;
end;

function CPL(P1:DefPoint;L1:DefLigne): DefCercle;
var
  P2 : DefPoint;
  Equ : EquaLigne;
  Valeur : extended;
begin
  PasDeSol := false;
  Equ := EquationDroite(L1);
  Valeur := Equ.A * P1.X + Equ.B * P1.Y + Equ.C;
  if Valeur = 0 then PasDeSol := true
  else
  begin
    P2 := PointLignePoint(P1,L1);
    Valeur := Distance2Points(P1,P2);
    with Result do
    begin
      Xc  := P1.X;
      Yc  := P1.Y;
      Rc  := Valeur;
      Xdc := 0;
      Ydc := 0;
      Adc := 0;
      Xfc := 0;
      Yfc := 0;
      Afc := 0;
    end;
  end;
end;

function CPCD(P1:DefPoint;C1:DefCercle;D1:char): DefCercle;
var
  P2 : DefPoint;
  Valeur, R1, R2 : extended;
begin
  PasDeSol := false;
  Valeur := sqr(P1.X-C1.Xc) + sqr(P1.Y-C1.Yc) - sqr(C1.Rc);
  if Valeur = 0 then PasDeSol := true
  else
  begin
    P2.X := C1.Xc;
    P2.Y := C1.Yc;
    Valeur := Distance2Points(P1,P2);
    if Valeur > C1.Rc then
    begin
      R1 := Valeur - C1.Rc;
      R2 := Valeur + C1.Rc;
    end
    else
    begin
      R1 := C1.Rc - Valeur;
      R2 := C1.Rc - Valeur;
    end;
    if D1 = 'I' then
    begin
      if R1 <= R2 then Valeur := R1
                  else Valeur := R2;
    end
    else
    begin
      if R1 > R2 then Valeur := R1
                 else Valeur := R2;
    end;
    with Result do
    begin
      Xc  := P1.X;
      Yc  := P1.Y;
      Rc  := Valeur;
      Xdc := 0;
      Ydc := 0;
      Adc := 0;
      Xfc := 0;
      Yfc := 0;
      Afc := 0;
    end;
  end;
end;

function CCNN(C1:DefCercle;N1,N2:extended): DefCercle;
begin
  PasDeSol := false;
  with Result do
  begin
    Xc  := C1.Xc + N1;
    Yc  := C1.Yc + N2;
    Rc  := C1.Rc;
    Xdc := 0;
    Ydc := 0;
    Adc := 0;
    Xfc := 0;
    Yfc := 0;
    Afc := 0;
  end;
end;

function CCNA(C1:DefCercle;N1,N2:extended): DefCercle;
var
  Angle : extended;
begin
  PasDeSol := false;
  Angle := DegToRad(N2);
  with Result do
  begin
    Xc  := C1.Xc + N1 * cos(Angle);
    Yc  := C1.Yc + N1 * sin(Angle);
    Rc  := C1.Rc;
    Xdc := 0;
    Ydc := 0;
    Adc := 0;
    Xfc := 0;
    Yfc := 0;
    Afc := 0;
  end;
end;

function CPPND(P1,P2:DefPoint;N1:extended;D1:char): DefCercle;
var
  P3 : DefPoint;
  C1, C2 : DefCercle;
begin
  PasDeSol := false;
  if (P1.X=P2.X) and (P1.Y=P2.Y) then PasDeSol := true
  else
  begin
    C1 := CPN(P1,N1);
    C2 := CPN(P2,N1);
    P3 := PCCD(C1,C2,D1);
    with Result do
    begin
      Xc  := P3.X;
      Yc  := P3.Y;
      Rc  := N1;
      Xdc := 0;
      Ydc := 0;
      Adc := 0;
      Xfc := 0;
      Yfc := 0;
      Afc := 0;
    end;
  end;
end;

function CPLND(P1:DefPoint;L1:DefLigne;N1:extended;D1:char): DefCercle;
var
  Eq1:EquaLigne;
  Valeur : extended;
  X1,X2,Y1,Y2 : extended;
  P2,P3 : DefPoint;
  D2 : char;
  L2 : DefLigne;
  C1 : DefCercle;
begin
  PasDeSol := false;
  D2 := 'H';
  Eq1 := EquationDroite(L1);
  Valeur := Eq1.A*P1.X + Eq1.B*P1.Y + Eq1.C;
  if Valeur = 0 then
  begin
    X1 := P1.X - N1*sin(L1.Aod);
    Y1 := P1.Y + N1*cos(L1.Aod);
    X2 := P1.X + N1*sin(L1.Aod);
    Y2 := P1.Y - N1*cos(L1.Aod);
    case D1 of
      'H' : if Y1 > Y2 then
            begin
              P3.X := X1;
              P3.Y := Y1;
            end
            else
            begin
              P3.X := X2;
              P3.Y := Y2;
            end;
      'B' : if Y1 > Y2 then
            begin
              P3.X := X2;
              P3.Y := Y2;
            end
            else
            begin
              P3.X := X1;
              P3.Y := Y1;
            end;
      'D' : if X1 > X2 then
            begin
              P3.X := X1;
              P3.Y := Y1;
            end
            else
            begin
              P3.X := X2;
              P3.Y := Y2;
            end;
      'G' : if X1 > X2 then
            begin
              P3.X := X2;
              P3.Y := Y2;
            end
            else
            begin
              P3.X := X1;
              P3.Y := Y1;
            end;
      end;
  end
  else
  begin
    P2 := PointLignePoint(P1,L1);
    if P2.X > P1.X then D2 := 'G'
    else
    if P2.X < P1.X then D2 := 'D'
    else
    if P2.Y > P1.Y then D2 := 'B'
    else
    if P2.Y < P1.Y then D2 := 'H';
    L2 := LLND(L1,N1,D2);
    C1 := CPN(P1,N1);
    P3 := PLCD(L2,C1,D1);
  end;
  if not PasDeSol then
    with Result do
    begin
      Xc  := P3.X;
      Yc  := P3.Y;
      Rc  := N1;
      Xdc := 0;
      Ydc := 0;
      Adc := 0;
      Xfc := 0;
      Yfc := 0;
      Afc := 0;
    end;
end;

function CPCNDD(P1:DefPoint;C1:DefCercle;N1:extended;D1,D2:char): DefCercle;
var
  P2,P3 : DefPoint;
  L1 : DefLigne;
  C2,C3 : DefCercle;
  Distance : extended;
begin
  PasDeSol := false;
  P2.X := C1.Xc;
  P2.Y := C1.Yc;
  Distance := Distance2Points(P1,P2);
  C2 := CPN(P1,N1);
  if Distance = C1.Rc then
  begin
    L1 := LPP(P1,P2);
    P3 := PLCD(L1,C2,D2);
  end
  else
  begin
    if Distance > C1.Rc then
    begin
      if (Distance-C1.Rc) > N1 then PasDeSol := true
      else
      begin
        if D1='I' then C3 := CPN(P2,(N1-C1.Rc));
        if D1='E' then C3 := CPN(P2,(N1+C1.Rc));
        P3 := PCCD(C2,C3,D2);
      end;
    end
    else
    begin
      if (N1>((C1.Rc+Distance)/2)) or ((C1.Rc-Distance)>N1)
        then PasDeSol := true
      else
      begin
        C3 := CPN(P2,(C1.Rc-N1));
        P3 := PCCD(C2,C3,D2);
      end;
    end;
  end;
  if not PasDeSol then
  begin
    with Result do
    begin
      Xc  := P3.X;
      Yc  := P3.Y;
      Rc  := N1;
      Xdc := 0;
      Ydc := 0;
      Adc := 0;
      Xfc := 0;
      Yfc := 0;
      Afc := 0;
    end;
  end;
end;

function CLLNDD(L1,L2:DefLigne;N1:extended;D1,D2:char):DefCercle;
var
  P1 : DefPoint;
  L3,L4 : DefLigne;
begin
  PasDeSol := false;
  L3 := LLND(L1,N1,D1);
  L4 := LLND(L2,N1,D2);
  P1 := PLL(L3,L4);
  if not PasDeSol then
    with Result do
    begin
      Xc  := P1.X;
      Yc  := P1.Y;
      Rc  := N1;
      Xdc := 0;
      Ydc := 0;
      Adc := 0;
      Xfc := 0;
      Yfc := 0;
      Afc := 0;
    end;
end;

function CLCNDDD(L1:DefLigne;C1:DefCercle;N1:extended;D1,D2,D3:char): DefCercle;
var
  Distance : extended;
  P1,P2,P3 : Defpoint;
  L2 : DefLigne;
  C2 : DefCercle;
  D4 : char;
begin
  PasDeSol := false;
  P1.X := C1.Xc;
  P1.Y := C1.Yc;
  P2 := PointLignePoint(P1,L1);
  Distance := Distance2Points(P1,P2);
  if Distance >= C1.Rc then
  begin
    P2 := PointLignePoint(P1,L1);
    D4 := '0';
    if D1 in ['G','D'] then
    begin
      if P2.X > P1.X then D4 := 'G'
      else
      if P2.X < P1.X then D4 := 'D';
    end
    else
    begin
      if P2.Y > P1.Y then D4 := 'B'
      else
      if P2.Y < P1.Y then D4 := 'H';
    end;
    if D4 <> D1 then PasDeSol := true
    else
    begin
      L2 := LLND(L1,N1,D4);
      C2 := CPN(P1,N1 + C1.Rc);
      P3 := PLCD(L2,C2,D3);
    end;
    if not PasDeSol then
    begin
      if N1 > C1.Rc then
      begin
        C2 := CPN(P1,N1 - C1.Rc);
        P2 := PLCD(L2,C2,D3);
        if not PasDeSol then
        begin
          Distance := Distance2Points(P1,P2);
          if (Distance < N1) and (D2 = 'I') then P3 := P2;
        end;
      end
      else if D2 = 'I' then PasDeSol := true;
    end;
  end
  else
  begin
    L2 := LLND(L1,N1,D1);
    if D2 = 'E' then
    begin
      C2 := CPN(P1,C1.Rc + N1);
      P3 := PLCD(L2,C2,D3);
    end
    else
    begin
      if N1 > C1.Rc then PasDeSol := true
      else
      begin
        C2 := CPN(P1,C1.Rc - N1);
        P3 := PLCD(L2,C2,D3);
      end;
    end;
  end;
  if not PasDeSol then
    with Result do
    begin
      Xc  := P3.X;
      Yc  := P3.Y;
      Rc  := N1;
      Xdc := 0;
      Ydc := 0;
      Adc := 0;
      Xfc := 0;
      Yfc := 0;
      Afc := 0;
    end;
end;

function CCCNDDD(C1,C2:DefCercle;N1:extended;D1,D2,D3:char): DefCercle;
var
  P1,P2,P3 : DefPoint;
  Distance : extended;
  C3,C4 : DefCercle;
begin
  PasDeSol := false;
  P1.X := C1.Xc;
  P1.Y := C1.Yc;
  P2.X := C2.Xc;
  P2.Y := C2.Yc;
  if (P1.X = P2.X) and ( P1.Y = P2.Y) and (C1.Rc = C2.Rc) then PasDeSol := true;
  if not PasDeSol then
  begin
    Distance := Distance2Points(P1,P2);
    if Distance < (C1.Rc + C2.Rc) then
    begin
      if (D1 ='I') and (D2 ='I') then
      begin
        if (C1.Rc + C2.Rc - Distance)<(2*N1) then PasDeSol := true;
        if N1 > C2.Rc then PasDeSol := true;
        if PasDeSol then exit;
        C3.Xc := C1.Xc;
        C3.Yc := C1.Yc;
        C3.Rc := C1.Rc - N1;
        C4.Xc := C2.Xc;
        C4.Yc := C2.Yc;
        C4.Rc := C2.Rc - N1;
        P3 := PCCD(C3,C4,D3);
      end;

      if (D1 ='I') and (D2 ='E') then
      begin
        if (C1.Rc - C2.Rc + Distance)<(2*N1) then PasDeSol := true;
        if PasDeSol then exit;
        C3.Xc := C1.Xc;
        C3.Yc := C1.Yc;
        C3.Rc := C1.Rc - N1;
        C4.Xc := C2.Xc;
        C4.Yc := C2.Yc;
        C4.Rc := C2.Rc + N1;
        P3 := PCCD(C3,C4,D3);
      end;

      if (D1 ='E') and (D2 ='I') then
      begin
        if (C2.Rc - C1.Rc + Distance)<(2*N1) then PasDeSol := true;
        if N1 > C2.Rc then PasDeSol := true;
        if PasDeSol then exit;
        C3.Xc := C1.Xc;
        C3.Yc := C1.Yc;
        C3.Rc := C1.Rc + N1;
        C4.Xc := C2.Xc;
        C4.Yc := C2.Yc;
        C4.Rc := C2.Rc - N1;
        P3 := PCCD(C3,C4,D3);
      end;

      if (D1 ='E') and (D2 ='E') then
      begin
        C3.Xc := C1.Xc;
        C3.Yc := C1.Yc;
        C3.Rc := C1.Rc + N1;
        C4.Xc := C2.Xc;
        C4.Yc := C2.Yc;
        C4.Rc := C2.Rc + N1;
        P3 := PCCD(C3,C4,D3);
      end;
    end
    else
    begin
      if (D1 ='I') and (D2 ='I') then
      begin
        if N1 < (C1.Rc + C2.Rc + Distance) then PasDeSol := true;
        if PasDeSol then exit;
        C3.Xc := C1.Xc;
        C3.Yc := C1.Yc;
        C3.Rc := N1 - C1.Rc;
        C4.Xc := C2.Xc;
        C4.Yc := C2.Yc;
        C4.Rc := N1 - C2.Rc;
        P3 := PCCD(C3,C4,D3);
      end;

      if (D1 ='I') and (D2 ='E') then
      begin
        if N1 < (C1.Rc - C2.Rc + Distance) then PasDeSol := true;
        if PasDeSol then exit;
        C3.Xc := C1.Xc;
        C3.Yc := C1.Yc;
        C3.Rc := N1 - C1.Rc;
        C4.Xc := C2.Xc;
        C4.Yc := C2.Yc;
        C4.Rc := C2.Rc + N1;
        P3 := PCCD(C3,C4,D3);
      end;

      if (D1 ='E') and (D2 ='I') then
      begin
        if N1 < (C2.Rc - C1.Rc + Distance) then PasDeSol := true;
        if PasDeSol then exit;
        C3.Xc := C1.Xc;
        C3.Yc := C1.Yc;
        C3.Rc := C1.Rc + N1;
        C4.Xc := C2.Xc;
        C4.Yc := C2.Yc;
        C4.Rc := N1 - C2.Rc;
        P3 := PCCD(C3,C4,D3);
      end;

      if (D1 ='E') and (D2 ='E') then
      begin
        if N1 < (Distance - C1.Rc - C2.Rc) then PasDeSol := true;
        if PasDeSol then exit;
        C3.Xc := C1.Xc;
        C3.Yc := C1.Yc;
        C3.Rc := C1.Rc + N1;
        C4.Xc := C2.Xc;
        C4.Yc := C2.Yc;
        C4.Rc := C2.Rc + N1;
        P3 := PCCD(C3,C4,D3);
      end;
    end;
  end;
  if not PasDeSol then
    with Result do
    begin
      Xc  := P3.X;
      Yc  := P3.Y;
      Rc  := N1;
      Xdc := 0;
      Ydc := 0;
      Adc := 0;
      Xfc := 0;
      Yfc := 0;
      Afc := 0;
    end;
end;

function CCN(C1:DefCercle;N1:extended): DefCercle;
begin
  PasDeSol := false;
  with Result do
  begin
    Xc  := C1.Xc;
    Yc  := C1.Yc;
    Rc  := N1;
    Xdc := 0;
    Ydc := 0;
    Adc := 0;
    Xfc := 0;
    Yfc := 0;
    Afc := 0;
  end;
end;

function CCND(C1:DefCercle;N1:extended;D1:char): DefCercle;
begin
  PasDeSol := false;
  with Result do
  begin
    Xc  := C1.Xc;
    Yc  := C1.Yc;
    case D1 of
      'I' : Rc := C1.Rc - N1;
      'G' : Rc := C1.Rc + N1;
    end;
    Xdc := 0;
    Ydc := 0;
    Adc := 0;
    Xfc := 0;
    Yfc := 0;
    Afc := 0;
  end;
end;

function CPPP(P1,P2,P3:DefPoint): DefCercle;
var
  D,DA,DB,DC : extended;
  A,B,C : extended;
begin
  PasDeSol := false;
  D := P1.X*P2.Y + P1.Y*P3.X + P2.X*P3.Y;
  D := D - P3.X*P2.Y - P3.Y*P1.X - P1.Y*P2.X;
  DA := (sqr(P3.X)+sqr(P3.Y))*P2.Y + (sqr(P1.X)+sqr(P1.Y))*P3.Y;
  DA := DA + (sqr(P2.X)+sqr(P2.Y))*P1.Y - (sqr(P1.X)+sqr(P1.Y))*P2.Y;
  DA := DA - (sqr(P3.X)+sqr(P3.Y))*P1.Y - (sqr(P2.X)+sqr(P2.Y))*P3.Y;
  DB := (sqr(P2.X)+sqr(P2.Y))*P3.X + (sqr(P3.X)+sqr(P3.Y))*P1.X;
  DB := DB + (sqr(P1.X)+sqr(P1.Y))*P2.X - (sqr(P2.X)+sqr(P2.Y))*P1.X;
  DB := DB - (sqr(P1.X)+sqr(P1.Y))*P3.X - (sqr(P3.X)+sqr(P3.Y))*P2.X;
  DC := (sqr(P1.X)+sqr(P1.Y))*P3.X*P2.Y + (sqr(P2.X)+sqr(P2.Y))*P3.Y*P1.X;
  DC := DC + (sqr(P3.X)+sqr(P3.Y))*P2.X*P1.Y - (sqr(P3.X)+sqr(P3.Y))*P1.X*P2.Y;
  DC := DC - (sqr(P2.X)+sqr(P2.Y))*P1.Y*P3.X - (sqr(P1.X)+sqr(P1.Y))*P2.X*P3.Y;
  A := DA/D;
  B := DB/D;
  C := DC/D;
  with Result do
  begin
    Xc  := -A/2;
    Yc  := -B/2;
    Rc  := sqrt(sqr(Xc)+sqr(Yc)-C);
    Xdc := 0;
    Ydc := 0;
    Adc := 0;
    Xfc := 0;
    Yfc := 0;
    Afc := 0;
  end;
end;

function CCPA(C1:DefCercle;P1:DefPoint;N1:extended): DefCercle;
var
  P2,P3 : DefPoint;
begin
  PasDeSol := false;
  P2.X := C1.Xc;
  P2.Y := C1.Yc;
  P3 := PPPA(P2,P1,N1);
  with Result do
  begin
    Xc  := P3.X;
    Yc  := P3.Y;
    Rc  := C1.Rc;
    Xdc := 0;
    Ydc := 0;
    Adc := 0;
    Xfc := 0;
    Yfc := 0;
    Afc := 0;
  end;
end;

function CCP(C1:DefCercle;P1:DefPoint): DefCercle;
begin
  PasDeSol := false;
  with Result do
  begin
    Xc  := 2*P1.X - C1.Xc;
    Yc  := 2*P1.Y - C1.Yc;
    Rc  := C1.Rc;
    Xdc := 0;
    Ydc := 0;
    Adc := 0;
    Xfc := 0;
    Yfc := 0;
    Afc := 0;
  end;
end;

function CCL(C1:DefCercle;L1:DefLigne): DefCercle;
var
  P2,P3 : DefPoint;
begin
  PasDeSol := false;
  P2.X := C1.Xc;
  P2.Y := C1.Yc;
  P3 := PPL(P2,L1);
  with Result do
  begin
    Xc  := P3.X;
    Yc  := P3.Y;
    Rc  := C1.Rc;
    Xdc := 0;
    Ydc := 0;
    Adc := 0;
    Xfc := 0;
    Yfc := 0;
    Afc := 0;
  end;
end;

end.
