unit JDAbout;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, Registry, Gauges;

type
  TFAbout = class(TForm)
    BtnOk: TBitBtn;
    Logiciel: TBevel;
    Icone: TImage;
    TitreLogicielWin: TLabel;
    titreCopyright: TLabel;
    TitreProgramme: TLabel;
    TitreVersion: TLabel;
    Bevel1: TBevel;
    TitreUtilisateur: TLabel;
    Utilisateur: TLabel;
    Societe: TLabel;
    TitreSociete: TLabel;
    Bevel2: TBevel;
    Os: TLabel;
    TitreOs: TLabel;
    Bevel3: TBevel;
    TitreUtilise: TLabel;
    TitreMem: TLabel;
    TitreSwap: TLabel;
    Mem: TLabel;
    Swap: TLabel;
    GaugeMem: TGauge;
    GaugeSwap: TGauge;
    
    procedure FormShow(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    Version : string;
  end;

var
  FAbout: TFAbout;

implementation

{$R *.DFM}

function GetUtilisateur : string;
var
  Reg : TRegIniFile;
begin
  Reg := TRegIniFile.Create('');
  with Reg do
  begin
    RootKey := HKEY_LOCAL_MACHINE;
    Result := readstring('SOFTWARE\MICROSOFT\Windows\CurrentVersion',
              'RegisteredOwner','');
    free;
  end;
end;

function GetSociete : string;
var
  Reg : TRegIniFile;
begin
  Reg := TRegIniFile.Create('');
  with Reg do
  begin
    RootKey := HKEY_LOCAL_MACHINE;
    Result := readstring('SOFTWARE\MICROSOFT\Windows\CurrentVersion',
              'RegisteredOrganization','');
    free;
  end;
end;

function GetVersion : string;
var
  Reg : TRegIniFile;
begin
  Reg := TRegIniFile.Create('');
  with Reg do
  begin
    RootKey := HKEY_LOCAL_MACHINE;
    Result := readstring('SOFTWARE\MICROSOFT\Windows\CurrentVersion',
              'Version','');
    free;
  end;
end;

function GetVersionNumber : string;
var
  Reg : TRegIniFile;
begin
  Reg := TRegIniFile.Create('');
  with Reg do
  begin
    RootKey := HKEY_LOCAL_MACHINE;
    Result := readstring('SOFTWARE\MICROSOFT\Windows\CurrentVersion',
              'VersionNumber','');
    free;
  end;
end;

function GetSubVersionNumber : string;
var
  Reg : TRegIniFile;
begin
  Reg := TRegIniFile.Create('');
  with Reg do
  begin
    RootKey := HKEY_LOCAL_MACHINE;
    Result := readstring('SOFTWARE\MICROSOFT\Windows\CurrentVersion',
              'SubVersionNumber','<aucun>');
    free;
  end;
end;

procedure TFAbout.FormShow(Sender: TObject);
var
  InfoMemoire : TMemoryStatus;
begin
  FAbout.Caption := ' A propos de ' + Application.Title;
  TitreProgramme.Caption := Application.Title;
  Icone.Picture.Graphic := Application.Icon;
  TitreVersion.Caption := 'Version ' + Version;

  Utilisateur.Caption := GetUtilisateur;
  Societe.Caption := GetSociete;
  Os.Caption := GetVersion + ' Version ' + GetVersionNumber
                + ' ' + GetSubVersionNumber;

  InfoMemoire.dwLength := sizeof(InfoMemoire);
  GlobalMemoryStatus(InfoMemoire);
  Mem.Caption  := intTostr(InfoMemoire.dwTotalPhys div 1024000) + ' Mo';
  Swap.Caption := intTostr(InfoMemoire.dwTotalPageFile div 1024000) + ' Mo';
  GaugeMem.Progress := InfoMemoire.dwMemoryLoad;
  GaugeSwap.Progress := 100 -
  (InfoMemoire.dwAvailPageFile div (InfoMemoire.dwTotalPageFile div 100));
end;

end.
