unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls;

type
  TFPrincipale = class(TForm)
    TitreFichier: TLabel;
    NomFichier: TEdit;
    BtnChoix: TButton;
    OuvrirFichier: TOpenDialog;
    BtnAnnuler: TButton;
    Deroulement: TProgressBar;
    BtnOk: TButton;
    BtnQuitter: TButton;
    procedure BtnChoixClick(Sender: TObject);
    procedure BtnAnnulerClick(Sender: TObject);
    procedure BtnOkClick(Sender: TObject);
    procedure BtnQuitterClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

  procedure Convertir(NomFichier: string);

var
  FPrincipale: TFPrincipale;
  Graphique: boolean;
  NomFicEntree: string;
  NomFicSortie: string;
  FicEntree: system.textfile;
  FicSortie: system.textfile;
  BufferFichier: array [1..5120] of char;

implementation

{$R *.DFM}

procedure Conversion;
var
  Position: longint;
  F: file of char;
  NomTmp: string;
  Ligne: string;
  Actuel: longint;
  Numero: longint;
  Extension: string;

begin
  { Renome le fichier en old}
  Position:= pos('.',NomFicEntree);
  if Position=0 then NomTmp:= NomFicEntree + '.'
                else NomTmp:= copy(NomFicEntree,1,Position);
  Numero:= 0;
  Extension:= format('%3.3d',[Numero]);
  NomFicSortie:= NomTmp + Extension;
  while FileExists(NomFicSortie) do
  begin
    inc (Numero);
    Extension:= format('%3.3d',[Numero]);
    NomFicSortie:= NomTmp + Extension;
  end;
  assignfile(F,NomFicEntree);
  rename(F,NomFicSortie);

  { Inverse les noms entree et sortie : old=entree}
  NomTmp:= NomFicSortie;
  NomFicSortie:= NomFicEntree;
  NomFicEntree:= NomTmp;

  assignfile(FicEntree,NomFicEntree);
  assignfile(FicSortie,NomFicSortie);
  system.settextbuf(FicEntree,BufferFichier);
  reset(FicEntree);
  rewrite(FicSortie);
  Actuel:= 0;

  while not eof(FicEntree) do
  begin
    readln(FicEntree,Ligne);
    Actuel:= Actuel + length(Ligne)+ 2;
    if Graphique then FPrincipale.Deroulement.Position:= Actuel;
    Ligne:= Ligne + #10;
    write(FicSortie,Ligne);
  end;

  closefile(FicSortie);
  closefile(FicEntree);
end;

procedure TFPrincipale.BtnChoixClick(Sender: TObject);
begin
  if OuvrirFichier.Execute then
  begin
    NomFicEntree:= OuvrirFichier.Filename;
    NomFichier.Text:= NomFicEntree;
    BtnOK.Visible:= true;
    BtnAnnuler.Visible:=true;
    BtnQuitter.Visible:= false;
    Deroulement.Position:= 0;
    Deroulement.update;
  end;
end;

procedure TFPrincipale.BtnAnnulerClick(Sender: TObject);
begin
  close;
end;

procedure TFPrincipale.BtnOkClick(Sender: TObject);
var
  F: file of char;
begin
  screen.cursor:= crHourGlass;
  BtnOK.Visible:= false;
  BtnAnnuler.Visible:= false;

  { Defini le maxi du barregraphe}
  assignfile(F,NomFicEntree);
  reset(F);
  Deroulement.Min := 0;
  Deroulement.Max := filesize(F);
  Deroulement.Visible := true;
  closefile(F);

  NomFicEntree:= NomFichier.text;
  Conversion;

  screen.cursor:= crDefault;
  BtnQuitter.Visible:= true;
end;

procedure TFPrincipale.BtnQuitterClick(Sender: TObject);
begin
  close;
end;

procedure Convertir(NomFichier: string);
begin
  NomFicEntree:= NomFichier;
  Graphique:= false;
  Conversion;
end;

procedure TFPrincipale.FormCreate(Sender: TObject);
begin
  Graphique:= true;
end;

end.
