<?php
// -*- mode: php; coding: utf-8-unix -*-
// Time-stamp: <2005-09-27 20:22:25 alain>
// $Id:$ %

// +--------------------------------------------------------------------------+
// | Part of Convert Extension (convertext)                                   |
// |   Convert file with an extension to another one, including call made     |
// |   inside of corresponding files                                          |
// +--------------------------------------------------------------------------+
// | Author: Alain JAFFRE jack.r@free.fr                                      |
// | Contributors:                                                            |
// |                                                                          |
// +--------------------------------------------------------------------------+
// | This program is free software. You can redistribute it and/or modify it  |
// | under the terms of the GNU Public License as published by the            |
// | Free Software Foundation, either version 2 of the license, or            |
// | (at your option) any later version.                                      |
// |                                                                          |
// | This program is distributed in the hope it will be useful, but WITHOUT   |
// | ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or    |
// | FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for |
// | more details.                                                            |
// |                                                                          |
// | You should have received a copy of the GNU General Public License along  |
// | with this program, if not, write to the Free Software Foundation, Inc.,  |
// | 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                 |
// +--------------------------------------------------------------------------+
// | Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le      |
// | modifier suivant les termes de la GNU General Public License telle que   |
// | publie par la Free Software Foundation, soit la version 2 de cette       |
// | license, soit (à votre convenance) une version ultérieure.               |
// |                                                                          |
// | Ce programme est diffusé dans l'espoir qu'il sera utile, mais SANS AUCUNE|
// | GARANTIE, sans même une garantie implicite de COMMERCIALISABILITE ou     |
// | d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License |
// | pour plus de détails.                                                    |
// |                                                                          |
// | Vous devriez avoir reçu une copie de la GNU General Public License avec  |
// | ce programme, sinon, veuillez écrire à la Free Software Foundation, Inc.,|
// | 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                 |
// +--------------------------------------------------------------------------+

// +--------------------------------------------------------------------------+
// | Changes:                                                                 |
// |  2005-09-24 First release                                                |
// |  2005-09-26 Addition of constant to simplify translation if needed       |
// |             Addition of mbstring library detection and fall back         |
// |             Bug corrections due to above modification, recurse           |
// |              information not passed properly between steps               |
// |                                                                          |
// +--------------------------------------------------------------------------+


// +--------------------------------------------------------------------------+
// | Generic definition which can be adjusted / translated                    |
// +--------------------------------------------------------------------------+
// Don't forget to translate also html files

define("VERBOSE",false);
define("LANGUAGE","français");

if (LANGUAGE == "français") {
  define("DATE_FORMAT","d/m/Y H:i");
  define("SIZE_UNIT","octets");
  define("SHORT_SIZE_UNIT","o");
  
  define("PROCESSING","traitement de : <span class=\"highlight\">%1\$s</span>");
  define("CONVERSION","-> conversion de %1\$s en %2\$s");
  define("NO_CONVERSION","-> <span class=\"warning\">conversion de %1\$s en %2\$s impossible, %2\$s existe déjà !</span>");
  define("WRITE_PROTECT","<span class=\"warning\"> %1\$s n'est pas autorisé en écriture, certains fichiers (%2\$d) n'ont pu être traités ! </span>");
  define("MBSTRING_WARNING_1","ATTENTION, la librairie \"mbstring\" n'est pas installée sur ce serveur !");
  define("MBSTRING_WARNING_2","La conversion peut échouer si les fichiers sont en utf8, par exemple.");
  define("MBSTRING_WARNING_3","A utiliser en connaissance de cause ! Vous êtes prévenus !");
 }
 else {
  define("DATE_FORMAT","Y/m/d H:i");
  define("SIZE_UNIT","bytes");
  define("SHORT_SIZE_UNIT","b");
  
  define("PROCESSING","processing : <span class=\"highlight\">%1\$s</span>");
  define("CONVERSION","-> converting %1\$s into %2\$s");
  define("NO_CONVERSION","-> <span class=\"warning\">impossible to convert %1\$s into %2\$s as %2\$s already exist !</span>");
  define("WRITE_PROTECT","<span class=\"warning\"> writing in %1\$s is not allowed, some files (%2\$d) have not been process ! </span>");
  define("MBSTRING_WARNING_1","BECAREFUL, \"mbstring\" library is not installed on that server !");
  define("MBSTRING_WARNING_2","Conversion can fail in case of UTF8 encoded files, for example.");
  define("MBSTRING_WARNING_3","You have been warned! Use at your own risk !");
 }

// +--------------------------------------------------------------------------+
// | Generic files and directories functions                                  |
// +--------------------------------------------------------------------------+


/**
 * Properly format end of directory name
 *
 * @param     string $dir directory name to be adjusted
 * @return    string adjusted directory name
 */

function add_slash($dir) {
  $pos = strrpos($dir,"/");
  if ($pos != (strlen($dir)-1)) {$dir .= "/";}
  return($dir);
}


/**
 * Get file extension from a file name
 *
 * @param     string $file filename from which we need its extension
 * @return    string file extension
 */

function get_fileext($file) {
  $ext = "";
  $pos = strrpos($file,".");
  // take extension if '.' exist and not first pos
  if ($pos != false) {
	$ext = substr($file,$pos);
	$ext = strtolower($ext);
  }
  return($ext);
}


// +--------------------------------------------------------------------------+
// | Generic string functions                                                 |
// +--------------------------------------------------------------------------+


/**
 * Do a search and replace in multi byte string
 *
 * @param     string $search string which need to be replaced
 * @param     string $replace replacement string
 * @param     string $subject string in which we need to do search and replace
 * @return    string resulting string after replacement
 */

function _mb_str_replace($search, $replace, $subject)
{
  $offset = 0;
  while(!(($pos = mb_strpos($subject, $search, $offset)) === false))
	{
	  $start = mb_substr($subject, 0, $pos);
	  $end = mb_substr($subject, $pos+mb_strlen($search));
	  $subject = $start.$replace.$end;
	  $offset = $pos + mb_strlen($replace);
	}
  return $subject;
}

/**
 * Do a search and replace in string
 *
 * @param     string $search string which need to be replaced
 * @param     string $replace replacement string
 * @param     string $subject string in which we need to do search and replace
 * @return    string resulting string after replacement
 */

function _str_replace($search, $replace, $subject)
{
  $offset = 0;
  while(!(($pos = strpos($subject, $search, $offset)) === false))
	{
	  $start = substr($subject, 0, $pos);
	  $end = substr($subject, $pos+strlen($search));
	  $subject = $start.$replace.$end;
	  $offset = $pos + strlen($replace);
	}
  return $subject;
}


/**
 * Do a search and replace in multi byte string if possible
 * otherwise do it on standard string
 *
 * @param     string $search string which need to be replaced
 * @param     string $replace replacement string
 * @param     string $subject string in which we need to do search and replace
 * @return    string resulting string after replacement
 */

function my_mb_str_replace($search, $replace, $subject)
{
  if (extension_loaded('mbstring')) {
	$result = _mb_str_replace($search, $replace, $subject);
  }
  else {
	$result = _str_replace($search, $replace, $subject);
  }
  return $result;
}


/**
 * Get part of multi byte string if possible
 * otherwise do it on standard string
 *
 * @param     string $subject string in which need to take a part
 * @param     int $start from which character start the part
 * @param     int $length how long part must be taken
 * @return    string resulting string part
 */

function my_mb_substr($subject, $start, $length)
{
  if (extension_loaded('mbstring')) {
	$result = mb_substr($subject, $start, $length);
  }
  else {
	$result = substr($subject, $start, $length);
  }
  return $result;
}

// +--------------------------------------------------------------------------+
// | Specific functions                                                       |
// +--------------------------------------------------------------------------+

/**
 * Sort file name in ascending order
 *
 * @param     string $data1 array data corresponding to the first filename
 * @param     string $data2 array data corresponding to the second filename
 * @return    int <0 if $data1 is less than $data2,
 *                >0 if $data1 is greater than $data2,
 *                =0 if $data1 equal $data2
 */

function sort_filename_asc($data1,$data2) {
  $str1 = $data1["dir"];
  $str2 = $data2["dir"];
  if ($str1 == $str2) {
	$str1 = $data1["name"];
	$str2 = $data2["name"];
	if ($str1 == "..") {$val = -1;}
	else
	  if ($str2 == "..") {$val = 1;}
	  else {
		$val = strcmp($str1,$str2);
	  }
  }
  else {
	($str1 == true) ? ($val = -1) : ($val = 1);
  }
  return($val);
}


/**
 * Format a file date
 *
 * @param     int $date timestamp representing a date 
 * @return    string formated date 
 */

function format_date($date) {
  $fdate = date(DATE_FORMAT,$date);
  return($fdate);
}

/**
 * Format a file size
 *
 * @param     int $size file size in byte
 * @param     string $sizeunit long name for the size unit
 * @param     int $shortsizeunit short name for the size unit
 * @return    string formated file size
 */

function format_size($size,$sizeunit,$shortsizeunit) {
  if ($size < 1024) {$fsize = $size." ".$sizeunit;}
  else
	if ($size < (1024*1024)) {
	  $fsize = sprintf ("%.2f K%s",($size/(1024)),$shortsizeunit);
	}
	else
	  if ($size < (1024*1024*1024)) {
		$fsize = sprintf ("%.2f M%s",($size/(1024*1024)),$shortsizeunit);
	  }
	  else
		if ($size < (1024*1024*1024*1024)) {
		  $fsize = sprintf ("%.2f G%s",($size/(1024*1024*1024)),$shortsizeunit);
		}
  return($fsize);
}


/**
 * Format a file permission
 *
 * @param     int $perms file permissions
 * @return    string formated file permissions
 */

function format_perms($perms) {
  $fperms = "";
  // directory
  ($perms & 0x4000) ? ($fperms .= "d") : ($fperms .= " ");
  // user
  ($perms & 0400) ? ($fperms .= "r") : ($fperms .= "-");
  ($perms & 0200) ? ($fperms .= "w") : ($fperms .= "-");
  if ($perms & 0100) {
	// UID
	($perms & 0x800) ? ($fperms .= "s") : ($fperms .= "x");
  }
  else {$fperms .= "-";}
  // group
  $fperms .= " ";
  ($perms & 0040) ? ($fperms .= "r") : ($fperms .= "-");
  ($perms & 0020) ? ($fperms .= "w") : ($fperms .= "-");
  if ($perms & 0010) {
	// GID
	($perms & 0x400) ? ($fperms .= "s") : ($fperms .= "x");
  }
  else {$fperms .= "-";}
  // all
  $fperms .= " ";
  ($perms & 0004) ? ($fperms .= "r") : ($fperms .= "-");
  ($perms & 0002) ? ($fperms .= "w") : ($fperms .= "-");
  if ($perms & 0001) {
	// sticky bit
	($perms & 0x200) ? ($fperms .= "t") : ($fperms .= "x");
  }
  else {$fperms .= "-";}
  return($fperms);
}



// Return all files and directory from $fullpath
/**
 * Build a list of all files and directories in specified directory
 *
 * @param     string $fullpath directory on which we build the list
 * @param     string $sizeunit long name for the size unit
 * @param     int $shortsizeunit short name for the size unit
 * @return    array list of all files and directories
 */

function get_dirlist($fullpath,$sizeunit,$shortsizeunit) {
  unset ($dirlist);
  $dirlist = array();
  if (is_dir($fullpath)) {
	if (is_readable($fullpath)) {
	  $handle = opendir($fullpath);
	  $i = 0;
	  // get all files
	  while ($file = readdir($handle)) {
		if ($file != ".") {
		  $fullname = $fullpath.$file;
		  $date = filemtime($fullname);
		  $size = filesize($fullname);
		  $perms = fileperms($fullname);
		  if (is_dir($fullname)) {
			$dirlist[$i]["dir"] = true;
			if ($file == "..") {
			  $dirlist[$i]["image"] = "prevdir.gif";
			  $fullname = my_mb_substr($fullname,0,strrpos($fullname,"/"));
			  $fullname = my_mb_substr($fullname,0,strrpos($fullname,"/")+1);
			}
			else {
			  $dirlist[$i]["image"] = "dir.gif";
			}
			if (is_readable($fullname)) {
			  $dirlist[$i]["fullname"] = $fullname;
			}
			else {
			  $dirlist[$i]["image"] = "dirlock.gif";
			  $dirlist[$i]["fullname"] = "";
			}
		  }
		  else {
			$dirlist[$i]["dir"] = false;
			$dirlist[$i]["fullname"] = "";
			$dirlist[$i]["image"] = "file.gif";
		  }
		  $dirlist[$i]["name"] = $file;
		  $dirlist[$i]["size"] = $size;
		  $dirlist[$i]["fsize"] = format_size($size,$sizeunit,$shortsizeunit);
		  $dirlist[$i]["date"] = $date;
		  $dirlist[$i]["fdate"] = format_date($date);
		  $dirlist[$i]["perms"] = $perms;
		  $dirlist[$i]["fperms"] = format_perms($perms);
		  $i++;
		}
	  }
	  closedir($handle);
	}
  }
  return($dirlist);
}


// Convert concerned files in specified directory
/**
 * Convert extension and contents of concerned files in specified directory
 *
 * @param     string $fullpath string directory on which we do conversion
 * @param     string $from original file extension
 * @param     string $to replacement extension
 * @param     string $recurse did we do recursive conversion
 * @return string resulting conversion log
 */

function convert_dir($fullpath,$from,$to,$recurse,$simul) {
  unset($result);
  unset($filelist);
  if (is_dir($fullpath)) {
	$handle = opendir($fullpath);
	// Get all files
	while ($file = readdir($handle)) {
	  if (($file != '.') && ($file != '..')){
		$fullname = $fullpath.$file;
		if (is_dir($fullname)) {
		  if ($recurse == 'true') {
			$newpath = add_slash($fullname);
			$result .= convert_dir($newpath,$from,$to,$recurse,$simul);
		  }
		}
		else {
		  $fileext = get_fileext($file);
		  if ($fileext == $from) {
			  $newname =  my_mb_substr($file,0,-strlen($from)).$to;
			  $newfullname = $fullpath.$newname;
			  $filelist[] = array('old' => $fullname, 'new' => $newfullname);
			  $j++;
		  }
		}
	  }
	}
	closedir($handle);

	// Convert
	//
	  
	$max = count($filelist);
	if ($max > 0) {
	  if (is_writeable($fullpath)) {
		$result .= "\n".sprintf(PROCESSING,$fullpath)."<br />\n";
		for ($i = 0; $i < $max; $i++) {
		  $oldname = $filelist[$i]['old'];
		  $newname = $filelist[$i]['new'];
		  if (file_exists($newname)) {
			$result .= '&nbsp;'.sprintf(NO_CONVERSION,basename($oldname),basename($newname))."<br />\n";
		  }
		  else {
			if (VERBOSE) {
			  $result .= '&nbsp;'.sprintf(CONVERSION,basename($oldname),basename($newname))."<br />\n";
			}
			if (!($simul == 'true')) {
			  // Read contents
			  $contents = file_get_contents($oldname);
			  if (!($contents === FALSE)) {
				// Convert contents
				$contents = my_mb_str_replace($from,$to,$contents);
				// Write converted contents
				if ($filehandle = fopen($newname, 'w')) {
				  if (!(fwrite($filehandle, $contents) === FALSE)) {
					fclose($filehandle);
					// Delete old file
					unlink($oldname);
				  }
				}
			  }
			}
		  }
		}
	  }
	  else {
		$result .= sprintf(WRITE_PROTECT,$fullpath,$max)."<br />\n";
	  }
	}
  }
  return $result;
}

// +--------------------------------------------------------------------------+
// | Main program                                                             |
// +--------------------------------------------------------------------------+

include_once('tbs_class.php') ;

$converted = false;

$fromext = array('.php' => 0,
				 '.php3' => 0,
				 '.php4' => 0,
				 '.php5' => 0);

$toext = array('.php' => 0,
			   '.php3' => 0,
			   '.php4' => 0,
			   '.php5' => 0);

// Default values
$startdir = '';
$currentdir = '';
$convertfrom = '.php';
$convertto = '.php5';
$subdir = "false";
$simulate = "false";
$setup ='';

// Get passed values
if (isset($_POST['startdir'])) {
  $startdir = $_POST['startdir'];
 }
if (isset($_GET['startdir'])) {
  $startdir = $_GET['startdir'];
 }
if (($startdir == '') || (!is_dir($startdir))) {
  $startdir = dirname(__FILE__);
 }
$startdir = add_slash($startdir);

if (isset($_GET['currentdir'])) {
  $currentdir = $_GET['currentdir'] ;
 }
if (($currentdir == '') || (!is_dir($currentdir))) {
  $currentdir = $startdir;
 }
$currentdir = add_slash($currentdir);

// Get back conversion setup 
if (isset($_POST['setup'])) {
  $setup = $_POST['setup'];
 }
if (isset($_GET['setup'])) {
  $setup = $_GET['setup'];
 }
if ($setup) {
  $data = explode('/',$setup);
  $convertfrom = $data[0];
  $convertto = $data[1];
  $subdir = $data[2];
  $simulate = $data[3];
 }

if (isset($_POST['convertfrom'])) {
  $convertfrom = $_POST['convertfrom'];
 }
if (isset($_POST['convertto'])) {
  $convertto = $_POST['convertto'];
 }
if (isset($_POST['subdir'])) {
  $subdir = $_POST['subdir'];
 }
if (isset($_POST['simulate'])) {
  $simulate = $_POST['simulate'];
 }

$setup = $convertfrom.'/'.$convertto.'/'.$subdir.'/'.$simulate;
$fromext[$convertfrom] = 1;
$toext[$convertto] = 1;


if (isset($_GET['action'])) {
  $_POST['action']=$_GET['action'];
 }
if (!isset($_POST['action'])) {
  $_POST['action']='query';
 }

// +--------------------------------------------------------------------------+
// | Conversion required                                                      |
// +--------------------------------------------------------------------------+
  
if ($_POST['action']=='go') {

  if (($startdir <> '') && ($convertfrom <> '') && ($convertto <> '')) {
	
	// Do conversion
	$log = convert_dir($startdir,$convertfrom,$convertto,$subdir,$simulate);
	$converted = true;
	
	$TBS = new clsTinyButStrong ;
	$TBS->LoadTemplate('process.html') ;
	$TBS->Show() ;

	exit;
  }
 }

// +--------------------------------------------------------------------------+
// | Directory selection                                                      |
// +--------------------------------------------------------------------------+
  
if ($_POST['action']=='select') {
  // Get files and directory from current dir
  $dirlist = get_dirlist($currentdir,SIZE_UNIT,SHORT_SIZE_UNIT);
  if (is_array($dirlist)) {
	usort($dirlist,sort_filename_asc);
  }
  
  $TBS = new clsTinyButStrong ;
  $TBS->LoadTemplate('selectdir.html') ;
  $TBS->MergeBlock('data',$dirlist) ;
  $TBS->Show() ; 

  exit;
 }


// +--------------------------------------------------------------------------+
// | Program configuration                                                    |
// +--------------------------------------------------------------------------+

// Select what we want to do
if (!extension_loaded('mbstring')) {
  $takecare = MBSTRING_WARNING_1.'<br />'.MBSTRING_WARNING_2.'<br/>'.MBSTRING_WARNING_3;
 }
 else {
   $takecare = '';
 }

$TBS = new clsTinyButStrong ;
$TBS->LoadTemplate('convertext.html') ;
$TBS->MergeBlock('from',$fromext) ;
$TBS->MergeBlock('to',$toext) ;
$TBS->Show() ;
?>