#!/usr/bin/env tclsh
# -*- mode: tcl; coding: utf-8-unix; -*-
# Time-stamp: <2008-12-26 17:52:32 alain>%
# $Id: $
#-------------------------------------------------------------------------------
# From http://wiki.tcl.tk/593
#-------------------------------------------------------------------------------

# Check if already sourced
if {[info exists ::lock::version]} { return }

namespace eval ::lock {
	variable version 1.0.0

	variable sockets
	namespace export lock
	package provide lock $version
}



#-------------------------------------------------------------------------------
# Map LOCKID to an O/S socket
#-------------------------------------------------------------------------------

proc ::lock::portMap {LOCKID} {

	# calculate our 'unique' port number using a hash function.
	# this mapping function comes from dr. KNUTH's art of programming volume 3.

	set LEN [string length $LOCKID]
	set HASH $LEN

	for {set IDX 0} {$IDX < $LEN} {incr IDX} {
		scan [string index "$LOCKID" $IDX] "%c" ASC
		set HASH [expr (($HASH<<5)^($HASH>>27))^$ASC];
	}

	# always use a prime for remainder
	# note that the prime number used here will basicly determine the maximum
	# number of simultaneous locks

	return [expr (65535 - ($HASH % 101))]

}

#-------------------------------------------------------------------------------
# Our server call-back function (that does nothing at all)
#-------------------------------------------------------------------------------

proc ::lock::dummyAccept {newsock addr port} {

}

#-------------------------------------------------------------------------------
# Aquire a lock
#-------------------------------------------------------------------------------

proc ::lock::aquireLock {LOCKID} {

	set PORT [::lock::portMap "$LOCKID"]

	# 'socket already in use' error will be our lock detection mechanism
	if { [catch {socket -server ::lock::dummyAccept $PORT} SOCKET] } {
		return 0
	}

	set ::lock::sockets("$LOCKID") "$SOCKET"

	return 1
}

#-------------------------------------------------------------------------------
# Release a lock (assumes you actually hold the lock)
#-------------------------------------------------------------------------------

proc ::lock::releaseLock {LOCKID} {
	if { [catch {close $::lock::sockets("$LOCKID")} ERRORMSG] } {
		puts "Error '$ERRORMSG' on closing socket for lock '$LOCKID'"
		return 0
	}

	unset ::lock::sockets("$LOCKID")

	return 1
}

namespace import ::lock::aquireLock
namespace import ::lock::releaseLock


#-------------------------------------------------------------------------------
# Demo if called directly
#-------------------------------------------------------------------------------
if {[file tail [info script]] eq [file tail $argv0]} {
	if {[::lock::aquireLock Demo]} {
		puts "Lock aquired for Demo"
		puts "Press return  to finish"
		gets stdin line
		::lock::releaseLock Demo
		puts "Lock released for Demo"
	} else {
		puts "Sorry, already running"
	}
}


