unit Main;

/////////////////////////////////////////////////////////////
//                                                         //
//                     BookmarkXml                         //
//         Conversion des fichiers bookmark en Xml         //
//          Copyright (C) 2001 Alain JAFFRE                //
/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////
//                Update history                           //
//                                                         //
//  V0.0.1 First version                                   //
//  V0.1.0 IE, Netscape, Opera bookmark can be convert to  //
//         an XML file or XML + XSL file.                  //
//         If MSXML.DLL is intalled, XML file can be       //
//         Convert to HTML, Netscape or Opera bookmark     //
//  V0.2.0 Same with internal XML engine                   //
//  V0.3.0 Addition: IE bookmark creation                  //
//          Language change on the fly                     //
//          English version which can be select by /e      //
//          About box                                      //
//  V0.4.0 Addition: Engine selection (MSXML.DLL from      //
//           Internet Explorer or internal one)            //
//  V0.5.0 Change: Netscape.xsl improvement                //
//          Netscape bookmarks files management (mistake   //
//          in folder management)                          //
//          Display Xsl filename only when selecting       //
//          XML+XSL+HTML and MSXML                         //
//         Addition: Default button for xsl file reset     //
//          the xsl file name to its default value         //
//          New way of doing with internal engine to make  //
//          HTML page with CSS instead of table            //
//                                                         //
/////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

// Add a . before $ to undefine
{$DEFINE MSXML}
{$DEFINE INTERNAL}

{$IFNDEF MSXML}
  {$DEFINE INTERNAL}    // For safety in case we didn't define any
{$ENDIF}


uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, ShlObj, Registry,  Inifiles, UTCDateTime,
{$IFDEF MSXML}
  ActiveX, MSXML_TLB,
{$ENDIF}

{$IFDEF INTERNAL}
  LibXmlComps, LibXmlParser,
{$ENDIF}
  FileCtrl;



type
  TOutputMode = (Html, IE, Netscape, Opera, OldHtml);

  TFrmMain = class(TForm)
    LblBookmarkFilename: TLabel;
    EdtBookmarkFilename: TEdit;
    RgpBookmarkType: TRadioGroup;
    SbnSelectBookmarkFile: TSpeedButton;
    OpenDlg: TOpenDialog;
    BtnConvert: TButton;
    RgpOutput: TRadioGroup;
    ChbCreateBookmark: TCheckBox;
    LblXslFilename: TLabel;
    EdtXslFilename: TEdit;
    SbnSelectXslFile: TSpeedButton;
    BtnDefaultXsl: TButton;
    SbnAbout: TSpeedButton;
    BtnLanguage: TButton;
    RgpEngine: TRadioGroup;
    ChbHtmlWithTable: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure RgpOutputClick(Sender: TObject);
    procedure RgpEngineClick(Sender: TObject);
    procedure SbnSelectBookmarkFileClick(Sender: TObject);
    procedure EdtBookmarkFilenameChange(Sender: TObject);
    procedure BtnDefaultXslClick(Sender: TObject);
    procedure SbnSelectXslFileClick(Sender: TObject);
    procedure BtnConvertClick(Sender: TObject);
    procedure SbnAboutClick(Sender: TObject);
    procedure BtnLanguageClick(Sender: TObject);
  private
    { Dclarations prives }
    ApplicationDir: string;
    FrLanguage: boolean;
    Origin: integer;
    XmlFilename: string;
    XmlFile: textfile;
    XslFilename: string;
    DefaultXslFilename: string;
    BookmarkFilename: string;
    HtmlFilename: string;
    FolderCount: longint;
    Spacer: string;

    MSXMLEnabled: boolean;
    XslTransEnabled: boolean;
    CurrentDirectory: string;
    CurrentFilename: string;
{$IFDEF MSXML}
    DOMXml: IXMLDOMDocument;
    DOMXsl: IXMLDOMDocument;
{$ENDIF}

{$IFDEF INTERNAL}
    XmlScanner: TXmlScanner;
    CurType: TStringList;
    OutputMode: TOutputMode;
    OutputStringList: TStringList;
    OutputFilename: string;
    AName: string;
    AString: string;
    MainLink: boolean;
{$ENDIF}

    procedure RefreshDisplay;

    procedure WriteDefaultXsl;
    procedure XmlFileOpen(Read: boolean);
    procedure XmlFileClose;
    procedure WriteXmlProlog;
    procedure WriteXmlDtd;
    procedure WriteXmlBookmarkStart;
    procedure WriteXmlBookmarkEnd;
    procedure WriteXmlFolderStart(Name: string);
    procedure WriteXmlFolderEnd;
    procedure WriteXmlUrl(Name, Url, Date, UTC: string);
    procedure RecursiveScan(StartDir: string);
    procedure IEtoXml;
    procedure XmlToIE;
    procedure NetscapeToXml;
    procedure XmlToNetscape;
    procedure OperaToXml;
    procedure XmlToOpera;
    procedure XmlToHtml;
{$IFDEF MSXML}
    procedure MSXMLSetup;
    procedure WriteNetscapeXsl(NetscapeXslFilename: string);
    procedure MSXmlToNetscape;
    procedure WriteOperaXsl(OperaXslFilename: string);
    procedure MSXmlToOpera;
    procedure MSXmlToHtml;
{$ENDIF}

{$IFDEF INTERNAL}
    procedure XmlScannerStartTag(Sender: TObject; TagName: String;
      Attributes: TAttrList);
    procedure XmlScannerEndTag(Sender: TObject; TagName: String);
    procedure XmlScannerContent(Sender: TObject; Content: String);
    function XmlScannerTranslateEncoding(Sender: TObject; CurrentEncoding,
      Source: String): String;

    procedure InternalXmlSetup;
    procedure IEStartTag(TagName: String);
    procedure IEEndTag(TagName: String);
    procedure IEContent(Content: String);
    procedure InternalXmlToIE;
    procedure NetscapeStartTag(TagName: String);
    procedure NetscapeEndTag(TagName: String);
    procedure NetscapeContent(Content: String);
    procedure InternalXmlToNetscape;
    procedure OperaStartTag(TagName: String);
    procedure OperaEndTag(TagName: String);
    procedure OperaContent(Content: String);
    procedure InternalXmlToOpera;
    procedure HtmlStartTag(TagName: String);
    procedure HtmlEndTag(TagName: String);
    procedure HtmlContent(Content: String);
    procedure InternalXmlToHtml;
    procedure OldHtmlEndTag(TagName: String);
    procedure OldHtmlContent(Content: String);
    procedure InternalXmlToOldHtml;
{$ENDIF}
  public
    { Dclarations publiques }
  end;

const
  BaseName= 'mesliens';
  Version='0.5.0';

  TagBookmark= 'bookmark';
  TagTitle= 'title';
  TagFolder= 'folder';
  TagFolderTitle= 'foldertitle';
  TagUrl= 'url';
  TagUrlName= 'urlname';
  TagUrlAddress= 'urladdress';
  TagUrlDate= 'urldate';
  TagUrlUTC= 'urlutc';

var
  FrmMain: TFrmMain;

implementation

{$R *.DFM}

{*****************************************************************************}
{ Utilities                                                                   }
{*****************************************************************************}

function AddEndSlashToDir(Dir: string): string;
// Add '\' to Dir if needed
begin
  if length(Dir)>1 then
    if Dir[length(Dir)]<>'\' then Dir:=Dir+'\';
  result:=Dir;
end;

function GetDirUp(Dir: string):string;
// Return the upper directory
var
  DirLength: integer;
begin
  DirLength:= length(Dir);
  if DirLength > 3 then
  begin
    // Suppress char after '\'
    while (copy(Dir,DirLength,1)<>'\') and (DirLength>0) do
    begin
      delete(Dir,DirLength,1);
      dec(DirLength);
    end;
    // Suppress '\'
    if DirLength>0 then
    begin
      delete(Dir,DirLength,1);
      dec(DirLength);
    end;
    // Find previous '\'
    while (copy(Dir,DirLength,1)<>'\') and (DirLength>0) do
    begin
      delete(Dir,DirLength,1);
      dec(DirLength);
    end;
  end;
  result:= Dir;
end;

function GetSpecialFolder(Target:integer):string;
// Return the special folder location specified by its CSIDL
var
  IdList:PITEMIDLIST;
  Folder:array[0..MAX_PATH] of Char;
begin
  if SHGetSpecialFolderLocation(0, Target,IdList)=NOERROR then
  begin
    SHGetPathFromIDList(IdList, Folder);
    result:= string(Folder);
  end
  else
    result:='';
end;

function GetProgramFolder(Target:string):string;
// Return program folder stored in the registry
var
  Reg: TRegistry;
begin
  Reg:= TRegistry.Create;
  try
    Reg.RootKey := HKEY_LOCAL_MACHINE;
    if Reg.OpenKey('\Software\Microsoft\Windows\CurrentVersion\App Paths\'+ target, false)
    then result:= AddEndSlashToDir(Reg.ReadString('Path'))
    else result:= '';
  finally
    Reg.CloseKey;
    Reg.Free;
  end;
end;

function GetWidowsSystemFolder: string;
begin
  SetLength(result,MAX_PATH);
  SetLength(result,GetSystemDirectory(PChar(result),MAX_PATH));
  result:= AddEndSlashToDir(result);
end;

function MSXMLExist: boolean;
// Is MSXML.DLL present
begin
  result:= FileExists(GetWidowsSystemFolder + 'MSXML.DLL');
end;

function Normalize(AString: string): string;
// Replace all character not allowed
var
  N: longint;
begin
  for N:= 1 to length(AString) do
  begin
    if AString[N] in ['','',''] then AString[N]:= 'a'
    else
    if AString[N] in ['','','',''] then AString[N]:= 'e'
    else
    if AString[N] in ['',''] then AString[N]:= 'i'
    else
    if AString[N] in ['',''] then AString[N]:= 'o'
    else
    if AString[N] in ['','',''] then AString[N]:= 'u'
    else
    if not (AString[N] in [' ', '0'..'9', 'a'..'z', 'A'..'Z']) then
      AString[N]:= '_';
  end;
  result:= AString;
end;

{*****************************************************************************}
{ Form                                                                        }
{*****************************************************************************}

procedure TFrmMain.FormCreate(Sender: TObject);
begin
  ApplicationDir:= ExtractFilePath(Application.ExeName);
  if lowercase(paramstr(1))= '/e' then FrLanguage:= false
                                  else FrLanguage:= true;
  // Default XSL filename
  DefaultXslFilename:= ApplicationDir + BaseName + '.xsl';
  // Is MSXML.DLL used ?
  MSXMLEnabled:= false;
{$IFDEF MSXML}
  // Interface setup
  MSXMLSetup;
{$ENDIF}

{$IFDEF INTERNAL}
  // XmlScanner creation
  XmlScanner:= TXmlScanner.Create(FrmMain);
  XmlScanner.OnStartTag:= XmlScannerStartTag;
  XmlScanner.OnEndTag:= XmlScannerEndTag;
  XmlScanner.OnContent:= XmlScannerContent;
  XmlScanner.OnTranslateEncoding:= XmlScannerTranslateEncoding;
  // Interface setup
  InternalXmlSetup;
{$ENDIF}
  // Allow to convert to other bookmark type
  ChbCreateBookmark.Visible:= (not MSXMLEnabled) or XslTransEnabled;
end;

procedure TFrmMain.FormShow(Sender: TObject);
begin
  RefreshDisplay;
{$IFDEF INTERNAL}
  RgpEngine.Enabled:= MSXMLExist and XSLTransEnabled;
{$ELSE}
  RgpEngine.Enabled:= false;
  RgpEngine.ItemIndex:= 0;
{$ENDIF}
end;

procedure TFrmMain.FormDestroy(Sender: TObject);
begin
{$IFDEF MSXML}
  DOMXSL := nil;
  DOMXML := nil;
{$ENDIF}

{$IFDEF INTERNAL}
  XmlScanner.Destroy;
{$ENDIF}
end;

procedure TFrmMain.RgpOutputClick(Sender: TObject);
begin
  if MSXMLEnabled then
  begin
    case RgpOutput.ItemIndex of
      1 : begin
            SbnSelectXslFile.Visible:= false;
            LblXslFilename.Visible:= false;
            EdtXslFilename.Text:= DefaultXslFilename;
            EdtXslFilename.ReadOnly:= true;
            EdtXslFilename.Visible:= false;
            BtnDefaultXsl.Visible:= false;
            ChbHtmlWithTable.Visible:= false;
          end;
      2 : begin
            LblXslFilename.Visible:= true;
            EdtXslFilename.Text:= XslFilename;
            EdtXslFilename.ReadOnly:= false;
            EdtXslFilename.Visible:= true;
            SbnSelectXslFile.Visible:= true;
            BtnDefaultXsl.Visible:= true;
            ChbHtmlWithTable.Visible:= false;
          end;
    else
      begin
        LblXslFilename.Visible:= false;
        EdtXslFilename.Visible:= false;
        SbnSelectXslFile.Visible:= false;
        BtnDefaultXsl.Visible:= false;
        ChbHtmlWithTable.Visible:= false;
      end;
    end;
  end
  else
  begin
    LblXslFilename.Visible:= false;
    EdtXslFilename.Visible:= false;
    SbnSelectXslFile.Visible:= false;
    BtnDefaultXsl.Visible:= false;
    ChbHtmlWithTable.Visible:= RgpOutput.ItemIndex = 2;
  end;
end;

procedure TFrmMain.RgpEngineClick(Sender: TObject);
begin
  MSXMLEnabled:= RgpEngine.ItemIndex = 0;
  RgpOutputClick(Sender);
end;

procedure TFrmMain.SbnSelectBookmarkFileClick(Sender: TObject);
begin
  with OpenDlg do
  begin
    Origin:= RgpBookmarkType.ItemIndex;
    case Origin of
      0  : begin
             // Internet Explorer 5
             Filename:= 'Repertoire des favoris';
             Filter:= 'Bookmark IE 5|*.url|Tous fichiers (*.*)|*.*';
             InitialDir:= GetSpecialFolder(CSIDL_FAVORITES);
           end;
      1  : begin
             // Netscape 4
             Filename:= 'bookmark.htm';
             Filter:= 'Bookmark Netscape 4|bookmark.htm|Tous fichiers (*.*)|*.*';
             InitialDir:= GetProgramFolder('Netscape.exe')+'..\..\';
           end;
    else
      begin
        // Opera 5
        Filename:= 'Opera5.adr';
        Filter:= 'Bookmark Opera 5|Opera5.adr|Tous fichiers (*.*)|*.*';
        InitialDir:= GetProgramFolder('Opera.exe');
      end;
    end;
    if Execute then
    begin
      if Origin = 0 then
        EdtBookmarkFilename.Text:= ExtractFilePath(Filename)
      else
        EdtBookmarkFilename.Text:= Filename;
    end;
  end;
end;

procedure TFrmMain.EdtBookmarkFilenameChange(Sender: TObject);
begin
  BtnConvert.Enabled:= EdtBookmarkFilename.Text <> '';
end;

procedure TFrmMain.BtnDefaultXslClick(Sender: TObject);
begin
  EdtXslFilename.Text:= DefaultXslFilename;
end;

procedure TFrmMain.SbnSelectXslFileClick(Sender: TObject);
begin
  with OpenDlg do
  begin
    Filename:= '*.xsl';
    Filter:= 'Fichiers XSL (*.xsl)|*.xsl|Tous fichiers (*.*)|*.*';
    InitialDir:= ApplicationDir;
    if Execute then EdtXslFilename.Text:= Filename;
  end;
end;

procedure TFrmMain.BtnConvertClick(Sender: TObject);
begin
  Screen.Cursor:= crHourGlass;
  BtnConvert.Enabled:= false;
  // Create standard XSL file if needed
  if RgpOutput.ItemIndex = 1 then WriteDefaultXsl;
  if (RgpOutput.ItemIndex = 2) and (EdtXslFilename.Text = DefaultXslFilename)
    then WriteDefaultXsl;
  // Store XslFilename if needed
  if RgpOutput.ItemIndex > 0 then XslFilename:= EdtXslFilename.Text;
  // Convert bookmark to XML
  BookmarkFilename:= EdtBookmarkFilename.Text;
  XmlFileOpen(false);
  WriteXmlProlog;
//  WriteXmlDtd; //Not used as it is not a valid one. Problem with nested folder
  WriteXmlBookmarkStart;
  case Origin of
    0 : IEToXml;
    1 : NetscapeToXml;
    2 : OperaToXml;
  end;
  WriteXmlBookmarkEnd;
  XmlFileClose;
  // Convert to HTML if needed
  if RgpOutput.ItemIndex = 2 then XmlToHtml;
  // Convert to other bookmark type if needed
  if (ChbCreateBookmark.Checked) then
  begin
    if Origin <> 0 then XmlToIE;
    if Origin <> 1 then XmlToNetscape;
    if Origin <> 2 then XmlToOpera;
  end;
  // Finished
  EdtBookmarkFilename.Text:= '';
  Screen.Cursor:= crDefault;
end;

procedure TFrmMain.SbnAboutClick(Sender: TObject);
begin
  ShowMessage('                                    BookmarkXML' + #13#10 +
              '                                    Version ' + Version + #13#10 + #13#10 +
              '                             Copyright (c) 2001 A.Jaffre' + #13#10 + #13#10 +
              '' + #13#10 +
              'Tout est gnr dans le rpertoire o se trouve BookmarkXml.' + #13#10 +
              'A vous de dplacer les lments o vous le voulez.'+ #13#10 +
              'BookmarkXml /e pour avoir la version anglaise au dmarrage.'+ #13#10 +
              '' + #13#10 +
              'All is made in the BookmarkXml directory.' + #13#10 +
              'Up to you to move the result where ever you want.'+ #13#10 +
              'BookmarkXml /e to get the english interface at start up.'+ #13#10 +
              '' + #13#10 +
              '                              email: jack.r@free.fr' + #13#10 +
              '                              site : http://jack.r.free.fr');
end;

procedure TFrmMain.BtnLanguageClick(Sender: TObject);
begin
  FrLanguage:= not FrLanguage;
  RefreshDisplay;
end;

{*****************************************************************************}
{ Private                                                                     }
{*****************************************************************************}

procedure TFrmMain.RefreshDisplay;
begin
  if FrLanguage then
  begin
    FrmMain.Caption:= 'Convertisseur de bookmark';
    RgpBookmarkType.Caption:= ' Type du fichier d''origine ';
    RgpOutput.Caption:= 'Type des fichiers de sortie ';
    RgpEngine.Caption:= ' Moteur utilis ';
    RgpEngine.Items[1]:= 'Moteur interne';
    LblBookmarkFilename.Caption:= 'Nom du fichier de signets (bookmark, favoris) :';
    LblXslFilename.Caption:= 'Nom du fichier XSL pour conversion HTML:';
    BtnDefaultXsl.Caption:= 'Dfaut';
    ChbHtmlWithTable.Caption:= 'Crer un fichier HTML avec des tableaux au lieu de CSS';
    ChbCreateBookmark.Caption:= 'Crer les signets (bookmark, favoris) pour les autres navigateurs';
    BtnLanguage.Caption:= 'English';
    BtnConvert.Caption:= 'Conversion';
  end
  else
  begin
    FrmMain.Caption:= 'Bookmark converter';
    RgpBookmarkType.Caption:= ' Origin file type ';
    RgpOutput.Caption:= 'Output file type ';
    RgpEngine.Caption:= ' Engine selection ';
    RgpEngine.Items[1]:= 'Internal engine';
    LblBookmarkFilename.Caption:= 'Bookmark file name (bookmark, favoris) :';
    LblXslFilename.Caption:= 'XSL file name for HTML conversion:';
    BtnDefaultXsl.Caption:= 'Default';
    ChbHtmlWithTable.Caption:= 'Create HTML file with table instead of CSS';
    ChbCreateBookmark.Caption:= 'Create bookmarks (bookmark, favoris) for other browser';
    BtnLanguage.Caption:= 'Franais';
    BtnConvert.Caption:= 'Convert';
  end;
end;

procedure TFrmMain.WriteDefaultXsl;
var
  XslFile: textfile;
begin
  assignfile(XslFile, DefaultXslFilename);
  rewrite(XslFile);

  writeln(XslFile,'<?xml version="1.0"?>');
  writeln(XslFile,'<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">');
  writeln(XslFile,'<xsl:template match="/">');
  writeln(XslFile,'<HTML>');
  writeln(XslFile,'<BODY>');
  writeln(XslFile,'');

  writeln(XslFile,'<xsl:for-each select="' + TagBookmark + '">');
  writeln(XslFile,'<A name="top"></A>');
  writeln(XslFile,'<center>');
  writeln(XslFile,'<H1><xsl:value-of select="' + TagTitle + '"/></H1>');
  writeln(XslFile,'');

  writeln(XslFile,'<xsl:for-each select="' + TagFolder + '">');
  write(XslFile,'<A><xsl:attribute name ="href">#');
  write(XslFile,'<xsl:value-of select="' + TagFolderTitle + '"/>');
  write(XslFile,'</xsl:attribute>');
  write(XslFile,'<xsl:value-of select="' + TagFolderTitle + '"/>');
  writeln(XslFile,'</A> |');
  writeln(XslFile,'</xsl:for-each>');
  writeln(XslFile,'');

  writeln(XslFile,'</center>');
  writeln(XslFile,'<BR></BR>');
  writeln(XslFile,'<BR></BR>');
  writeln(XslFile,'');

  writeln(XslFile,'<UL>');
  writeln(XslFile,'  <xsl:for-each select="' + TagUrl + '">');
  writeln(XslFile,'    <LI><xsl:value-of select="' + TagUrlName + '"/>');
  write(XslFile,'      <A><xsl:attribute name="href">');
  write(XslFile,'<xsl:value-of select="' + TagUrlAddress + '"/>');
  write(XslFile,'</xsl:attribute>');
  write(XslFile,'<xsl:attribute name="target">_blank</xsl:attribute>');
  write(XslFile,'<xsl:value-of select="' + TagUrlAddress + '"/></A> ');
  writeln(XslFile,'<xsl:value-of select="' + TagUrlDate + '"/>');
  writeln(XslFile,'    </LI>');
  writeln(XslFile,'  </xsl:for-each>');
  writeln(XslFile,'</UL>');
  writeln(XslFile,'');

  writeln(XslFile,'<xsl:for-each select="//' + TagFolder + '">');
  writeln(XslFile,'  <UL><font color="red"><B>');
  write(XslFile,'      <A><xsl:attribute name ="name">');
  write(XslFile,'<xsl:value-of select="' + TagFolderTitle + '"/>');
  write(XslFile,'</xsl:attribute>');
  writeln(XslFile,'<xsl:value-of select="' + TagFolderTitle + '"/></A>');
  writeln(XslFile,'      </B></font>');
  writeln(XslFile,'  <xsl:for-each select="' + TagUrl + '">');
  writeln(XslFile,'    <LI><xsl:value-of select="' + TagUrlName + '"/>');
  write(XslFile,'      <A><xsl:attribute name="href">');
  write(XslFile,'<xsl:value-of select="' + TagUrlAddress + '"/>');
  write(XslFile,'</xsl:attribute>');
  write(XslFile,'<xsl:attribute name="target">_blank</xsl:attribute>');
  write(XslFile,'<xsl:value-of select="' + TagUrlAddress + '"/></A> ');
  writeln(XslFile,'<xsl:value-of select="' + TagUrlDate + '"/>');
  writeln(XslFile,'    </LI>');
  writeln(XslFile,'  </xsl:for-each>');
  writeln(XslFile,'</UL>');
  writeln(XslFile,'</xsl:for-each>');
  writeln(XslFile,'');

  writeln(XslFile,'</xsl:for-each>');
  writeln(XslFile,'');

  writeln(XslFile,'</BODY>');
  writeln(XslFile,'</HTML>');
  writeln(XslFile,'');

  writeln(XslFile,'</xsl:template>');
  writeln(XslFile,'</xsl:stylesheet>');

  closefile(XslFile);
end;


procedure TFrmMain.XmlFileOpen(Read: boolean);
begin
  XmlFilename:= ApplicationDir + BaseName + '.xml';
  assignfile(XmlFile, XmlFilename);
  if Read then reset(XmlFile)
          else rewrite(XmlFile);
end;

procedure TFrmMain.XmlFileClose;
begin
  closefile(XmlFile);
end;

procedure TFrmMain.WriteXmlProlog;
begin
  writeln(XmlFile,'<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>');
  if RgpOutput.ItemIndex = 2 then
    writeln(XmlFile,'<?xml-stylesheet href="' + ExtractFilename(XslFileName)
      + '" type="text/xsl" ?>')
  else
    writeln(XmlFile,'<?xml-stylesheet href="' + BaseName + '.xsl" type="text/xsl" ?>');
end;

procedure TFrmMain.WriteXmlDtd;
// Not used as it is not a valid one due to nested folder
// As to be solve for the futur
begin
  writeln(XmlFile,'<!DOCTYPE ' + TagBookmark + ' [');
  writeln(XmlFile,'  <!ELEMENT ' + TagBookmark + ' (' + TagTitle + '?, '+
    TagFolder + '+)+>');
  writeln(XmlFile,'  <!ELEMENT ' + TagTitle + ' (#PCDATA)>');
  writeln(XmlFile,'  <!ELEMENT ' + TagFolder + ' (' + TagFolderTitle +
    ', ' + TagUrl + '+)>');
  writeln(XmlFile,'  <!ELEMENT ' + TagFolderTitle + ' (#PCDATA)>');
  writeln(XmlFile,'  <!ELEMENT ' + TagUrl + ' (' + TagUrlName + ', ' +
    TagUrlAddress + ', ' + TagUrlDate + '?)>');
  writeln(XmlFile,'  <!ELEMENT ' + TagUrlName + ' (#PCDATA)>');
  writeln(XmlFile,'  <!ELEMENT ' + TagUrlAddress + ' (#PCDATA)>');
  writeln(XmlFile,'  <!ELEMENT ' + TagUrlDate + ' (#PCDATA)>');
  writeln(XmlFile,']>');
end;

procedure TFrmMain.WriteXmlBookmarkStart;
begin
  Spacer:= '';
  FolderCount:= 0;
  writeln(XmlFile,'<' + TagBookmark + '>');
  write(XmlFile,'<' + TagTitle + '> ');
  write(XmlFile,'Mes liens');
  writeln(XmlFile,' </' + TagTitle + '>');
end;

procedure TFrmMain.WriteXmlBookmarkEnd;
begin
  writeln(XmlFile,'</' + TagBookmark + '>');
end;

procedure TFrmMain.WriteXmlFolderStart(Name: string);
begin
  Spacer:= Spacer + '  ';
  // Folder start tag
  write(XmlFile,Spacer);
  writeln(XmlFile,'<' + TagFolder + '>');
  // Folder title
  write(XmlFile,Spacer);
  write(XmlFile,'<' + TagFolderTitle + '> ');
  write(XmlFile,Name);
  writeln(XmlFile,' </' + TagFolderTitle + '>');
  inc(FolderCount);
end;

procedure TFrmMain.WriteXmlFolderEnd;
begin
  if FolderCount > 0 then
  begin
    write(XmlFile,Spacer);
    writeln(XmlFile,'</' + TagFolder + '>');
    delete(Spacer,1,2);
    dec(FolderCount);
  end;
end;

procedure TFrmMain.WriteXmlUrl(Name, Url, Date, UTC: string);
var
  APos: longint;
  Str: string;
begin
  // Url start tag
  write(XmlFile,Spacer);
  writeln(XmlFile,'  <' + TagUrl + '>');
  // Name
  {Replace all & by &amp;}
  APos:= 1;
  while APos < length(Name) do
  begin
    if (Name[APos] = '&') and (Name[APos+1] <> '#') then
    begin
      Str:= copy(Name,APos,8);
      if pos(' ',Str) <> 0 then Str:= copy(Str,1,pos(' ',Str)-1);
      if pos(';',Str) = 0 then system.insert('amp;',Name,APos+1);
    end;
    inc(APos);
  end;

  {Replace all < by &lt;}
  APos:= pos('<',Name);
  if APos > 0 then Name:= stringreplace(Name,'<','&lt;',[rfReplaceAll]);

  {Replace all > by &gt;}
  APos:= pos('>',Name);
  if APos > 0 then
  begin
    Name:= stringreplace(Name,'>','&gt;',[rfReplaceAll]);
  end;

  write(XmlFile,Spacer);
  write(XmlFile,'    <' + TagUrlName + '> ');
  write(XmlFile,Name);
  writeln(XmlFile,' </' + TagUrlName + '>');

  // Address
  {Remove all character after an &}
  repeat
    APos:= pos('&',Url);
    if APos > 0 then Url:= copy(Url,1,APos-1);
  until APos = 0;

  write(XmlFile,Spacer);
  write(XmlFile,'    <' + TagUrlAddress + '> ');
  write(XmlFile,Url);
  writeln(XmlFile,' </' + TagUrlAddress + '>');

  // Date
  write(XmlFile,Spacer);
  write(XmlFile,'    <' + TagUrlDate + '> ');
  write(XmlFile,Date);
  writeln(XmlFile,' </' + TagUrlDate + '>');
  // UTC
  write(XmlFile,Spacer);
  write(XmlFile,'    <' + TagUrlUTC + '> ');
  write(XmlFile,UTC);
  writeln(XmlFile,' </' + TagUrlUTC + '>');

  // Url end tag
  write(XmlFile,Spacer);
  writeln(XmlFile,'  </' + TagUrl + '>');
end;

///////////////////////
// Internet Explorer //
///////////////////////

procedure TFrmMain.RecursiveScan(StartDir: string);

  procedure ScanDir(var Path: string);
  var
    SRec: TSearchRec;
    PathLength: integer;
    Target: integer;
    TargetName: string;
    IniFile: TIniFile;
    Name: string;
    Address: string;
    Date: string;
    UTC: string;

  begin
    PathLength:= length(Path);

    // Find .url files
    Target:= FindFirst(Path + '*.url',faAnyfile,SRec);
    if Target = 0 then
    try
      while Target = 0 do
      begin
        if ((SRec.Attr and faDirectory)<>faDirectory)
          and (SRec.Name<>'.') and (SRec.Name<>'..') then
        begin
          TargetName:= SRec.Name;
          // Name
          Name:= copy(TargetName,1,pos('.',TargetName)-1);
          // Date
          Date:= DateTimeToStr(trunc(FileDateToDateTime(SRec.Time)));
          UTC:= IntToStr(LocalDateTimeToUTC(FileDateToDateTime(SRec.Time)));
          // Url
          IniFile:= TIniFile.Create(Path + TargetName);
          Address:= IniFile.ReadString('InternetShortcut', 'URL', '');
          IniFile.Free;
          WriteXmlUrl(Name,Address,Date,UTC);
        end;
        Target:= FindNext(SRec);
      end;
    finally
      FindClose(SRec);
    end;
    Application.ProcessMessages;

    // Find directories
    Target:= FindFirst(Path + '*.*',faDirectory,SRec);
    if Target = 0 then
    try
      while Target = 0 do
      begin
        if ((SRec.Attr and faDirectory) = faDirectory)
          and (SRec.Name<>'.') and (SRec.Name<>'..') then
        begin
          TargetName:= SRec.Name;
          // Folder start
          WriteXmlFolderStart(TargetName);
          // Recurse
          Path:= Path + TargetName + '\';
          ScanDir(Path);
          // On remonte au precedent
          setlength(Path, PathLength);
          // Folder end
          WriteXmlFolderEnd;
        end;
        Target:= FindNext(SRec);
      end;
    finally
      FindClose(SRec);
    end;
  end;

begin
  ScanDir(StartDir);
end;

procedure TFrmMain.IEtoXml;
begin
  RecursiveScan(EdtBookmarkFilename.Text);
end;

procedure TFrmMain.XmlToIE;
begin
{$IFDEF INTERNAL}
   InternalXmlToIE;
{$ENDIF}
end;

///////////////////////
// Netscape          //
///////////////////////

procedure TFrmMain.NetscapeToXml;
var
  FileText: TStringList;
  N: longint;
  Line: string;
  Ref: string;
  APos: integer;
  Name: string;
  Address: string;
  Date: string;
  UTC: string;
begin
  FileText:= TStringList.Create;
  FileText.LoadFromFile(BookmarkFilename);
  for N:= 0 to FileText.Count-1 do
  begin
    Line:= trim(FileText.Strings[N]);
    Ref:= copy(Line,1,8);
    // Folder start
    if Ref = '<DT><H3 ' then
    begin
      delete(Line,1,8);
      APos:= pos('>',Line);
      delete(Line,1,APos);
      APos:= pos('<',Line);
      Name:= copy(Line,1,APos-1);
      WriteXmlFolderStart(Name);
    end
    else
    // Folder end
    if Ref = '</DL><p>' then WriteXmlFolderEnd
    else
    // Url
    if Ref = '<DT><A H' then
    begin
      // Default
      Name:= '';
      Address:= '';
      Date:= '0';
      UTC:= '0';

      delete(Line,1,8);
      // Address
      APos:= pos('"',Line);
      delete(Line,1,APos);
      APos:= pos('"',Line);
      Address:= copy(Line,1,APos-1);
      delete(Line,1,APos);
      // Date
      if Line[1]<>'>' then
      begin
        // ADD_DATE
        APos:= pos('"',Line);
        delete(Line,1,APos);
        APos:= pos('"',Line); // Creation date
        delete(Line,1,APos);
        if Line[1]<>'>' then
        begin
          // LAST_VISIT
          APos:= pos('"',Line);
          delete(Line,1,APos);
          APos:= pos('"',Line);
          UTC:= copy(Line,1,APos-1);
          Date:= DateTimeToStr(UTCToLocalDateTime(StrToInt(UTC))); // Last visit date
          delete(Line,1,APos);
        end;
        // Name
        APos:= pos('>',Line);
        delete(Line,1,APos);
        APos:= pos('<',Line);
        Name:= copy(Line,1,APos-1);
      end;

      WriteXmlUrl(Name,Address,Date,UTC);
    end;
  end;
  FileText.Free;
end;

procedure TFrmMain.XmlToNetscape;
begin
{$IFDEF MSXML}
   if MSXMLEnabled then MSXmlToNetscape;
{$ENDIF}

{$IFDEF INTERNAL}
   if not MSXMLEnabled then InternalXmlToNetscape;
{$ENDIF}
end;

///////////////////////
// Opera             //
///////////////////////

procedure TFrmMain.OperaToXml;
var
  FileText: TStringList;
  N: longint;
  Line: string;
  Ref: string;
  Max: longint;
  Name: string;
  Address: string;
  Date: string;
  UTC: string;
begin
  FileText:= TStringList.Create;
  FileText.LoadFromFile(BookmarkFilename);
  N:= -1;
  Max:= FileText.Count;
  while N < Max-1 do
  begin
    // Read up to next data
    repeat
      inc(N);
      Line:= trim(FileText.Strings[N]);
      Ref:= copy(Line,1,4);
    until (N >= Max-1) or (Ref = '#FOL') or (Ref = '#URL') or (Ref = '-');
    // Folder start
    if Ref = '#FOL' then
    begin
      inc(N);
      Name:= '';
      if N < Max then
      begin
        Line:= trim(FileText.Strings[N]);
        delete(Line,1,5);
        Name:= Line;
        WriteXmlFolderStart(Name);
      end;
    end
    else
    // Folder end
    if Ref = '-' then WriteXmlFolderEnd
    else
    // Url
    if Ref = '#URL' then
    begin
      // Name
      inc(N);
      Name:= '';
      if N < Max then
      begin
        Line:= trim(FileText.Strings[N]);
        delete(Line,1,5);
        Name:= Line;
      end;
      // Address
      inc(N);
      Address:= '';
      if N < Max then
      begin
        Line:= trim(FileText.Strings[N]);
        delete(Line,1,4);
        Address:= Line;
      end;
      // Date
      inc(N);
      Date:= '';
      if N < Max then
      begin
        Line:= trim(FileText.Strings[N]);
        delete(Line,1,8);
        UTC:= Line;
        Date:= DateTimeToStr(UTCToLocalDateTime(StrToInt(UTC))); // Creation date
      end;
      inc(N);
      if N < Max then
      begin
        Line:= trim(FileText.Strings[N]);
        delete(Line,1,8);
        if Line <> '0' then
        begin
          UTC:= Line;
          Date:= DateTimeToStr(UTCToLocalDateTime(StrToInt(UTC)));// Last visit date
        end;
      end;

      WriteXmlUrl(Name,Address,Date,UTC);
    end;
  end;
  FileText.Free;
end;

procedure TFrmMain.XmlToOpera;
begin
{$IFDEF MSXML}
   if MSXMLEnabled then MSXmlToOpera;
{$ENDIF}

{$IFDEF INTERNAL}
   if not MSXMLEnabled then InternalXmlToOpera;
{$ENDIF}
end;

///////////////////////
// HTML              //
///////////////////////

procedure TFrmMain.XmlToHtml;
begin
{$IFDEF MSXML}
   if MSXMLEnabled then MSXmlToHtml;
{$ENDIF}

{$IFDEF INTERNAL}
   if not MSXMLEnabled then
   begin
     if OutputMode = OldHtml then InternalXmlToOldHtml
                             else InternalXmlToHtml;
   end;
{$ENDIF}
end;

{$IFDEF MSXML}

{*****************************************************************************}
{ with MSXML.DLL                                                              }
{*****************************************************************************}

procedure TFrmMain.MSXMLSetup;
var
  hRes: HResult;
begin
  XslTransEnabled:= false;
  // Is MSXML.DLL present to convert into html
  if MSXMLExist then
  begin
    // Create DOMXml
    hRes := CoCreateInstance(CLASS_DOMDocument, nil,
      CLSCTX_INPROC_SERVER, IID_IXMLDOMDocument, DOMXml);
    if hRes = S_OK then
    begin
      // Create DOMXsl
      hRes := CoCreateInstance(CLASS_DOMDocument, nil,
        CLSCTX_INPROC_SERVER, IID_IXMLDOMDocument, DOMXsl);
      if hRes = S_OK then
      begin
        // Setup XslFilename;
        XslFilename:= DefaultXslFilename;
        // Setup HtmlFilename
        HtmlFilename:= ApplicationDir + BaseName + '.htm';
        // Enable XSL transformation
        XslTransEnabled:= true;
      end;
    end;
  end;
end;

///////////////////////
// Internet Explorer //
///////////////////////

///////////////////////
// Netscape          //
///////////////////////
procedure TFrmMain.WriteNetscapeXsl(NetscapeXslFilename: string);
var
  XslFile: textfile;
begin
  assignfile(XslFile, NetscapeXslFilename);
  rewrite(XslFile);

  writeln(XslFile,'<?xml version="1.0"?>');
  writeln(XslFile,'<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">');

  writeln(XslFile,'<xsl:template match="/">');
  writeln(XslFile,'<TITLE>Signets</TITLE>');
  writeln(XslFile,'<H1>Signets</H1>');
  writeln(XslFile,'<xsl:for-each select="bookmark">');
  writeln(XslFile,'  <DL><p>');
  writeln(XslFile,'  <xsl:for-each select="//folder">');
  write(XslFile,'    <DT><H3><xsl:attribute name="FOLDED ADD_DATE"></xsl:attribute>');
  writeln(XslFile,'<xsl:value-of select="foldertitle"/></H3></DT>');
  writeln(XslFile,'    <DL><p>');
  writeln(XslFile,'    <xsl:for-each select="url">');
  write(XslFile,'      <DT><A><xsl:attribute name="href">');
  write(XslFile,'<xsl:value-of select="urladdress"/>');
  write(XslFile,'</xsl:attribute><xsl:attribute name="ADD_DATE">');
  write(XslFile,'<xsl:value-of select="urlutc"/></xsl:attribute>');
  write(XslFile,'<xsl:attribute name="LAST_VISIT"><xsl:value-of select="urlutc"/>');
  write(XslFile,'</xsl:attribute><xsl:attribute name="LAST_MODIFIED">');
  write(XslFile,'<xsl:value-of select="urlutc"/></xsl:attribute>');
  writeln(XslFile,'<xsl:value-of select="urlname"/></A></DT>');
  writeln(XslFile,'    </xsl:for-each>');
  writeln(XslFile,'    </p></DL>');
  writeln(XslFile,'  </xsl:for-each>');
  writeln(XslFile,'  <DL><p>');
  writeln(XslFile,'  <xsl:for-each select="url">');
  write(XslFile,'    <DT><A><xsl:attribute name="href">');
  write(XslFile,'<xsl:value-of select="urladdress"/></xsl:attribute>');
  write(XslFile,'<xsl:attribute name="ADD_DATE"><xsl:value-of select="urlutc"/>');
  write(XslFile,'</xsl:attribute><xsl:attribute name="LAST_VISIT">');
  write(XslFile,'<xsl:value-of select="urlutc"/></xsl:attribute>');
  write(XslFile,'<xsl:attribute name="LAST_MODIFIED">');
  write(XslFile,'<xsl:value-of select="urlutc"/></xsl:attribute>');
  writeln(XslFile,'<xsl:value-of select="urlname"/></A></DT>');
  writeln(XslFile,'  </xsl:for-each>');
  writeln(XslFile,'  </p></DL>');
  writeln(XslFile,'  </p></DL>');
  writeln(XslFile,'</xsl:for-each>');
  writeln(XslFile,'</xsl:template>');
  writeln(XslFile,'</xsl:stylesheet>');

  closefile(XslFile);
end;

procedure TFrmMain.MSXmlToNetscape;
var
  OutputString: string;
  OutputStringStream: TStream;
  OutputFileStream: TFileStream;
  F: file;
  NetscapeFilename: string;
  OldFilename: string;
  NetscapeXslFilename: string;
begin
  NetscapeFileName:= ApplicationDir + 'bookmarks.html';
  // Rename previous if exist
  if FileExists(NetscapeFilename) then
  begin
    OldFilename:= ChangeFileExt(NetscapeFilename,'.old');
    if FileExists(OldFileName) then deletefile(OldFilename);
    system.assign(F,NetscapeFilename);
    system.rename(F,OldFilename);
  end;
  // Create XSL
  NetscapeXslFilename:= ApplicationDir + 'Netscape.xsl';
  if not FileExists(NetscapeXslFileName)
    then WriteNetscapeXsl(NetscapeXslFilename);
  // Load XML
  DomXml.validateOnParse:= false;
  if DomXml.load(XmlFilename) then
  begin
    // Load XSL
    DomXsl.validateOnParse:= false;
    if DomXsl.load(NetscapeXslFilename) then
    begin
      // Transform
      OutputString := DOMXml.TransformNode(DOMXsl);
      if OutputString = '' then  OutputString := 'error during transformation';
      // Save to adr file
      OutputFileStream := TFileStream.Create(NetscapeFilename, fmCreate);
      OutputStringStream := TStringStream.Create(OutputString);
      try
        OutputFileStream.CopyFrom(OutputStringStream, 0);
      finally
        OutputFileStream.Free;
        OutputStringStream.Free;
      end;
    end
    else MessageDlg(DOMXSL.ParseError.Reason, mtError, [mbOK], 0);
  end
  else MessageDlg(DOMXML.ParseError.Reason, mtError, [mbOK], 0);
end;

///////////////////////
// Opera             //
///////////////////////

procedure TFrmMain.WriteOperaXsl(OperaXslFilename: string);
var
  XslFile: textfile;
begin
  assignfile(XslFile, OperaXslFilename);
  rewrite(XslFile);

  writeln(XslFile,'<?xml version="1.0"?>');
  writeln(XslFile,'<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">');
  writeln(XslFile,'<xsl:template match="/">Opera Hotlist version 2.0');
  writeln(XslFile,'<xsl:for-each select="bookmark">');
  writeln(XslFile,'');
  writeln(XslFile,'<xsl:for-each select="//folder">');
  writeln(XslFile,'#FOLDER');
  writeln(XslFile,'	NAME=<xsl:value-of select="foldertitle"/>');
  writeln(XslFile,'	CREATED=0');
  writeln(XslFile,'	VISITED=0');
  writeln(XslFile,'	ORDER=0');
  writeln(XslFile,'	DESCRIPTION=');
  writeln(XslFile,'	SHORT NAME=');
  writeln(XslFile,'  <xsl:for-each select="url">');
  writeln(XslFile,'#URL');
  writeln(XslFile,'	NAME=<xsl:value-of select="urlname"/>');
  writeln(XslFile,'	URL=<xsl:value-of select="urladdress"/>');
  writeln(XslFile,'	CREATED=<xsl:value-of select="urlutc"/>');
  writeln(XslFile,'	VISITED=<xsl:value-of select="urlutc"/>');
  writeln(XslFile,'	ORDER=0');
  writeln(XslFile,'	DESCRIPTION=');
  writeln(XslFile,'	SHORT NAME=');
  writeln(XslFile,'  </xsl:for-each>');
  writeln(XslFile,'-</xsl:for-each>');
  writeln(XslFile,'');
  writeln(XslFile,'<xsl:for-each select="url">');
  writeln(XslFile,'#URL');
  writeln(XslFile,'	NAME=<xsl:value-of select="urlname"/>');
  writeln(XslFile,'	URL=<xsl:value-of select="urladdress"/>');
  writeln(XslFile,'	CREATED=<xsl:value-of select="urlutc"/>');
  writeln(XslFile,'	VISITED=<xsl:value-of select="urlutc"/>');
  writeln(XslFile,'	ORDER=0');
  writeln(XslFile,'	DESCRIPTION=');
  writeln(XslFile,'	SHORT NAME=');
  writeln(XslFile,'</xsl:for-each>');
  writeln(XslFile,'');
  writeln(XslFile,'</xsl:for-each>');
  writeln(XslFile,'');
  writeln(XslFile,'</xsl:template>');
  writeln(XslFile,'</xsl:stylesheet>');

  closefile(XslFile);
end;

procedure TFrmMain.MSXmlToOpera;
var
  OutputString: string;
  OutputStringStream: TStream;
  OutputFileStream: TFileStream;
  F: file;
  OperaFilename: string;
  OldFilename: string;
  OperaXslFilename: string;
begin
  OperaFileName:= ApplicationDir + 'opera5.adr';
  // Rename previous if exist
  if FileExists(OperaFilename) then
  begin
    OldFilename:= ChangeFileExt(OperaFilename,'.old');
    if FileExists(OldFileName) then deletefile(OldFilename);
    system.assign(F,OperaFilename);
    system.rename(F,OldFilename);
  end;
  // Create XSL
  OperaXslFilename:= ApplicationDir + 'Opera.xsl';
  if not FileExists(OperaXslFileName) then
    WriteOperaXsl(OperaXslFilename);
  // Load XML
  DomXml.validateOnParse:= false;
  if DomXml.load(XmlFilename) then
  begin
    // Load XSL
    DomXsl.validateOnParse:= false;
    if DomXsl.load(OperaXslFilename) then
    begin
      // Transform
      OutputString := DOMXml.TransformNode(DOMXsl);
      if OutputString = '' then  OutputString := 'error during transformation';
      // Save to adr file
      OutputFileStream := TFileStream.Create(OperaFilename, fmCreate);
      OutputStringStream := TStringStream.Create(OutputString);
      try
        OutputFileStream.CopyFrom(OutputStringStream, 0);
      finally
        OutputFileStream.Free;
        OutputStringStream.Free;
      end;
    end
    else MessageDlg(DOMXSL.ParseError.Reason, mtError, [mbOK], 0);
  end
  else MessageDlg(DOMXML.ParseError.Reason, mtError, [mbOK], 0);
end;

///////////////////////
// HTML              //
///////////////////////

procedure TFrmMain.MSXmlToHtml;
var
  OutputString: string;
  OutputStringStream: TStream;
  OutputFileStream: TFileStream;
begin
  // Load XML
  DomXml.validateOnParse:= false;
  if DomXml.load(XmlFilename) then
  begin
    // Load XSL
    DomXsl.validateOnParse:= false;
    if DomXsl.load(XslFilename) then
    begin
      // Transform
      OutputString := DOMXml.TransformNode(DOMXsl);
      if OutputString = '' then  OutputString := '<html><body></body></html>';
      // Save to HTML file
      OutputFileStream := TFileStream.Create(HtmlFilename, fmCreate);
      OutputStringStream := TStringStream.Create(OutputString);
      try
        OutputFileStream.CopyFrom(OutputStringStream, 0);
      finally
        OutputFileStream.Free;
        OutputStringStream.Free;
      end;
    end
    else MessageDlg(DOMXSL.ParseError.Reason, mtError, [mbOK], 0);
  end
  else MessageDlg(DOMXML.ParseError.Reason, mtError, [mbOK], 0);
end;

{$ENDIF}

{$IFDEF INTERNAL}
{*****************************************************************************}
{ with internal engine                                                        }
{*****************************************************************************}

procedure TFrmMain.InternalXmlSetup;
begin
  // Setup XslFilename;
  XslFilename:= DefaultXslFilename;
  // Setup HtmlFilename
  HtmlFilename:= ApplicationDir + BaseName + '.htm';
  // Setup XmlScanner
  XmlScanner.OnContent:= XmlScannerContent;
  XmlScanner.OnEndTag:= XmlScannerEndTag;
  XmlScanner.OnStartTag:= XmlScannerStartTag;
  XmlScanner.OnTranslateEncoding:= XmlScannerTranslateEncoding;
end;

///////////////////////
// Internet Explorer //
///////////////////////

procedure TFrmMain.IEStartTag(TagName: String);
var
  AType: string;
begin
  AType:= CurType.Strings[CurType.Count-1];
  if AType = TagUrl then
  begin
    CurrentFilename:= '';
    OutputStringList.Clear;
    OutputStringList.Add('[InternetShortcut]');
  end;
end;

procedure TFrmMain.IEEndTag(TagName: String);
var
  AType: string;
begin
  AType:= CurType.Strings[CurType.Count-1];
  if AType = TagFolder then CurrentDirectory:= GetDirUp(CurrentDirectory);
  if AType = TagUrl then
  begin
    if CurrentFilename <> '' then
       OutputStringList.SaveToFile(CurrentDirectory + CurrentFilename);
  end;
  CurType.Delete(CurType.Count-1);
end;

procedure TFrmMain.IEContent(Content: String);
var
  AType: string;
begin
  AType:= CurType.Strings[CurType.Count-1];
  if AType = TagFolderTitle then
  begin
    // Change to lower case
    Content:= AnsiLowerCase(Content);
    // Replace all character not allowed
    Content:= Normalize(Content);
    // Set the current directory
    CurrentDirectory:= CurrentDirectory + Content + '\';
    // Create directory
    try
      if not DirectoryExists(CurrentDirectory) then MkDir(CurrentDirectory);
    except
      MessageDlg(CurrentDirectory, mtError, [mbOk], 0);
    end;
  end;
  if AType = TagUrlName then
  begin
    // Remove http://
    Content:= StringReplace(Content,'http://','',[rfIgnoreCase,rfReplaceAll]);
    // Replace all character not allowed
    Content:= Normalize(Content);
    CurrentFilename:= Content + '.url';
  end;
  if AType = TagUrlAddress then OutputStringList.Add('URL=' + Content);
end;

procedure TFrmMain.InternalXmlToIE;
begin
  OutputMode:= IE;
  // Set the current directory
  CurrentDirectory:= ApplicationDir + 'IEFavoris\';
  // Create directory
  if not DirectoryExists(CurrentDirectory) then MkDir(CurrentDirectory);
  // Create string list for url file
  OutputStringList:= TStringList.Create;
  // Load XML file
  XmlScanner.Filename:= XmlFilename;
  // Scan XML file
  CurType:= TStringList.Create;
  XmlScanner.Execute;
  CurType.Free;
  // Remove string list for url file
  OutputStringList.Free;
end;

///////////////////////
// Netscape          //
///////////////////////

procedure TFrmMain.NetscapeStartTag(TagName: String);
begin
// nothing to do
end;

procedure TFrmMain.NetscapeEndTag(TagName: String);
var
  AType: string;
begin
  AType:= CurType.Strings[CurType.Count-1];
  if AType = TagFolder then OutputStringList.Add('</DL><p>');
  CurType.Delete(CurType.Count-1);
end;

procedure TFrmMain.NetscapeContent(Content: String);
var
  AType: string;
begin
  AType:= CurType.Strings[CurType.Count-1];
  if AType = TagFolderTitle then
  begin
    OutputStringList.Add('<DT><H3 FOLDED ADD_DATE="">' + Content + '</H3>');
    OutputStringList.Add('<DL><p>');
  end;
  if AType = TagUrlName then AName:= Content;
  if AType = TagUrlAddress then AString:= '<DT><A HREF="' + Content + '" ';
  if AType = TagUrlUtc then
  begin
    AString:= AString + 'ADD_DATE="' + Content + '" ';
    AString:= AString + 'LAST_VISIT="' + Content + '" ';
    AString:= AString + 'LAST_MODIFIED="' + Content + '">';
    OutputStringList.Add(AString + AName + '</A>');
  end;
end;

procedure TFrmMain.InternalXmlToNetscape;
var
  OldFilename: string;
  F: file;
begin
  OutputFileName:= ApplicationDir + 'bookmarks.html';
  OutputMode:= Netscape;
  // Rename previous if exist
  if FileExists(OutputFilename) then
  begin
    OldFilename:= ChangeFileExt(OutputFilename,'.old');
    if FileExists(OldFileName) then deletefile(OldFilename);
    system.assign(F,OutputFilename);
    system.rename(F,OldFilename);
  end;
  // Create Netscape file
  OutputStringList:= TStringList.Create;
  // Write Netscape header
  OutputStringList.Add('<!DOCTYPE NETSCAPE-Bookmark-file-1>');
  OutputStringList.Add('<!-- Ce fichier est gnr automatiquement.');
  OutputStringList.Add('Il sera lu et cras.');
  OutputStringList.Add('Ne pas modifier ! -->');
  OutputStringList.Add('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=UTF-8">');
  OutputStringList.Add('<TITLE>Signets</TITLE>');
  OutputStringList.Add('<H1>Signets</H1>');
  OutputStringList.Add('<DL><p>');
  // Load XML file
  XmlScanner.Filename:= XmlFilename;
  // Scan XML file
  CurType:= TStringList.Create;
  XmlScanner.Execute;
  CurType.Free;
  // Write Netscape footer
  OutputStringList.Add('</DL><p>');
  // Write Netscape file
  OutputStringList.SaveToFile(OutputFilename);
  OutputStringList.Free;
end;

///////////////////////
// Opera             //
///////////////////////

procedure TFrmMain.OperaStartTag(TagName: String);
begin
// nothing to do
end;

procedure TFrmMain.OperaEndTag(TagName: String);
var
  AType: string;
begin
  AType:= CurType.Strings[CurType.Count-1];
  if AType = TagBookmark then OutputStringList.Add('-');
  if AType = TagFolder then OutputStringList.Add('-');
  if AType = TagUrl then
  begin
    OutputStringList.Add('  ORDER=0');
    OutputStringList.Add('  DESCRIPTION=');
    OutputStringList.Add('  SHORT NAME=');
    OutputStringList.Add('');
  end;

  CurType.Delete(CurType.Count-1);
end;

procedure TFrmMain.OperaContent(Content: String);
var
  AType: string;
begin
  AType:= CurType.Strings[CurType.Count-1];
  if AType = TagFolderTitle then
  begin
    OutputStringList.Add('#FOLDER');
    OutputStringList.Add('  NAME=' + Content);
    OutputStringList.Add('  CREATED=0');
    OutputStringList.Add('  VISITED=0');
    OutputStringList.Add('  ORDER=0');
    OutputStringList.Add('  DESCRIPTION=');
    OutputStringList.Add('  SHORT NAME=');
    OutputStringList.Add('');
  end;
  if AType = TagUrlName then
  begin
    OutputStringList.Add('#URL');
    OutputStringList.Add('  NAME=' + Content);
  end;
  if AType = TagUrlAddress then OutputStringList.Add('  URL=' + Content);
  if AType = TagUrlUTC then
  begin
    OutputStringList.Add('  CREATED=' + Content);
    OutputStringList.Add('  VISITED=' + Content);
  end;;
end;

procedure TFrmMain.InternalXmlToOpera;
var
  OldFilename: string;
  F: file;
begin
  OutputFilename:= ApplicationDir + 'opera5.adr';
  OutputMode:= Opera;
  // Rename previous if exist
  if FileExists(OutputFilename) then
  begin
    OldFilename:= ChangeFileExt(OutputFilename,'.old');
    if FileExists(OldFileName) then deletefile(OldFilename);
    system.assign(F,OutputFilename);
    system.rename(F,OldFilename);
  end;
  // Create Opera file
  OutputStringList:= TStringList.Create;
  // Write Opera header
  OutputStringList.Add('Opera Hotlist version 2.0');
  OutputStringList.Add('');
  // Load XML file
  XmlScanner.Filename:= XmlFilename;
  // Scan XML file
  CurType:= TStringList.Create;
  XmlScanner.Execute;
  CurType.Free;
  // Write Opera file
  OutputStringList.SaveToFile(OutputFilename);
  OutputStringList.Free;
end;

///////////////////////
// HTML              //
///////////////////////

{ New way of doing with CSS }
/////////////////////////////

procedure TFrmMain.HtmlStartTag(TagName: String);
var
  AType: string;
begin
  AType:= CurType.Strings[CurType.Count-1];
  if not MainLink then
  begin
    if AType = TagFolder then
    begin
      OutputStringList.Add('<DIV CLASS="f' + IntToStr(CurType.Count-1) +  '">');
    end;
    if AType = TagUrl then OutputStringList.Add('<DIV CLASS="url">');
  end;
end;

procedure TFrmMain.HtmlEndTag(TagName: String);
var
  AType: string;
  Tmp:   string;
begin
  AType:= CurType.Strings[CurType.Count-1];
  if not MainLink then
  begin
    if AType = TagFolder then OutputStringList.Add('</DIV>');
    if AType = TagUrl then OutputStringList.Add('</LI></DIV>');
  end;
  CurType.Delete(CurType.Count-1);
end;

procedure TFrmMain.HtmlContent(Content: String);
var
  AType: string;
  Tmp:   string;
begin
  AType:= CurType.Strings[CurType.Count-1];
  if MainLink then
  begin
     if (AType = TagFolderTitle) and (CurType.Count = 3) then
     begin
       OutputStringList.Add('<A href="#' + Content + '">' + Content + '</A>');
     end;
  end
  else
  begin
    if AType = TagFolderTitle then
    begin
      Tmp:= '&nbsp;<B><A name="' + Content + '">' + Content + '</A></B>';
      if (CurType.Count = 3) then
        Tmp:= Tmp + '&nbsp;&nbsp;&nbsp;&nbsp;<A class="main" href="#top">Top</A>';
      OutputStringList.Add(Tmp);
    end;
    if AType = TagUrlName then OutputStringList.Add('<LI>' + Content);
    if AType = TagUrlAddress then
    begin
      OutputStringList.Add('<A href="' + Content + '" target="_blank">');
      OutputStringList.Add(Content + '</A>');
    end;
    if AType = TagUrlDate then OutputStringList.Add(Content);
  end;
end;

procedure TFrmMain.InternalXmlToHtml;
var
  OldFilename: string;
  F: file;
begin
  if ChbHtmlWithTable.Checked then OutputMode:= OldHtml
  else OutputMode:= Html;
  // Rename previous if exist
  if FileExists(HtmlFileName) then
  begin
    OldFilename:= ChangeFileExt(HtmlFilename,'.old');
    if FileExists(OldFileName) then deletefile(OldFilename);
    system.assign(F,HtmlFilename);
    system.rename(F,OldFilename);
  end;
  // Create HTML file
  OutputStringList:= TStringList.Create;
  // Write HTML header
  OutputStringList.Add('<HTML>');
  OutputStringList.Add('<HEAD>');
  OutputStringList.Add('<link rel=stylesheet type="text/css" href="mesliens.css">');
  OutputStringList.Add('</HEAD>');
  OutputStringList.Add('<BODY bgcolor="#CCDBED">');
  OutputStringList.Add('<CENTER>');
  OutputStringList.Add('<A name="top"></A>');
  OutputStringList.Add('<H1>Mes liens</H1>');

  OutputStringList.Add('</CENTER>');
  // Load XML file
  XmlScanner.Filename:= XmlFilename;
  // Scan XML file
  CurType:= TStringList.Create;
  MainLink:= true;
  OutputStringList.Add('<CENTER>');
  XmlScanner.Execute;
  OutputStringList.Add('</CENTER>');
  OutputStringList.Add('<BR></BR>');
  Mainlink:= false;
  XmlScanner.Execute;
  CurType.Free;
  // Write HTML footer
  OutputStringList.Add('</BODY>');
  OutputStringList.Add('</HTML>');
  // Write HTML file
  OutputStringList.SaveToFile(HtmlFilename);
  OutputStringList.Free;
end;

{ Old way of doing with table }
///////////////////////////////

procedure TFrmMain.OldHtmlEndTag(TagName: String);
var
  AType: string;
begin
  AType:= CurType.Strings[CurType.Count-1];
  if AType = TagFolder then
  begin
    OutputStringList.Add('</UL>');
    OutputStringList.Add('</TD>');
    OutputStringList.Add('</TR>');
    OutputStringList.Add('<TR>');
    OutputStringList.Add('<TD colspan="2" align="right"><A href="#top">Top</A></TD>');
    OutputStringList.Add('</TR>');
    OutputStringList.Add('</TABLE>');
    OutputStringList.Add('<BR></BR>');
    if CurType.Count > 3 then
    begin
      OutputStringList.Add('</TD>');
      OutputStringList.Add('</TR>');
    end;
  end;
  if AType = TagUrl then OutputStringList.Add('</LI>');

  CurType.Delete(CurType.Count-1);
end;

procedure TFrmMain.OldHtmlContent(Content: String);
var
  AType: string;
begin
  AType:= CurType.Strings[CurType.Count-1];
  if AType = TagFolderTitle then
  begin
    if CurType.Count > 3 then
    begin
      OutputStringList.Add('<TR>');
      OutputStringList.Add('<TD colspan="2">');
    end;
    OutputStringList.Add('<TABLE border="0" cellPadding="5" cellSpacing="0" bgColor="#FFFFFF" width="100%">');
    OutputStringList.Add('<TR>');
    if CurType.Count > 3 then OutputStringList.Add('<TD colspan="2" bgColor="#FFE0E0"><font color="red"><B>')
                         else OutputStringList.Add('<TD colspan="2" bgColor="#D0FFE0"><font color="red"><B>');
    OutputStringList.Add('<A name="' + Content + '">' + Content + '</A>');
    OutputStringList.Add('</B></font>');
    OutputStringList.Add('</TD>');
    OutputStringList.Add('</TR>');
    OutputStringList.Add('<TR>');
    OutputStringList.Add('<TD><font color="#FFFFFF">.</font></TD>');
    OutputStringList.Add('<TD>');
    OutputStringList.Add('<UL>');
  end;
  if AType = TagUrlName then OutputStringList.Add('<LI>' + Content);
  if AType = TagUrlAddress then
  begin
    OutputStringList.Add('<A href="' + Content + '" target="_blank">');
    OutputStringList.Add(Content + '</A>');
  end;
  if AType = TagUrlDate then OutputStringList.Add(Content);
end;

procedure TFrmMain.InternalXmlToOldHtml;
var
  OldFilename: string;
  F: file;
begin
  OutputMode:= Html;
  // Rename previous if exist
  if FileExists(HtmlFileName) then
  begin
    OldFilename:= ChangeFileExt(HtmlFilename,'.old');
    if FileExists(OldFileName) then deletefile(OldFilename);
    system.assign(F,HtmlFilename);
    system.rename(F,OldFilename);
  end;
  // Create HTML file
  OutputStringList:= TStringList.Create;
  // Write HTML header
  OutputStringList.Add('<HTML>');
  OutputStringList.Add('<HEAD>');
  OutputStringList.Add('<link rel=stylesheet type="text/css" href="mesliens.css">');
  OutputStringList.Add('</HEAD>');
  OutputStringList.Add('<BODY bgcolor="#CCDBED">');
  OutputStringList.Add('<center>');
  OutputStringList.Add('<A name="top"></A>');
  OutputStringList.Add('<H1>Mes liens</H1>');

  OutputStringList.Add('</center>');
  OutputStringList.Add('<BR></BR>');
  OutputStringList.Add('<BR></BR>');
  // Load XML file
  XmlScanner.Filename:= XmlFilename;
  // Scan XML file
  CurType:= TStringList.Create;
  XmlScanner.Execute;
  CurType.Free;
  // Write HTML footer
  OutputStringList.Add('</BODY>');
  OutputStringList.Add('</HTML>');
  // Write HTML file
  OutputStringList.SaveToFile(HtmlFilename);
  OutputStringList.Free;
end;

procedure TFrmMain.XmlScannerStartTag(Sender: TObject; TagName: String;
  Attributes: TAttrList);
begin
  CurType.Add(TagName);
  case OutputMode of
    IE       : IEStartTag(TagName);
    Netscape : NetscapeStartTag(TagName);
    Opera    : OperaStartTag(TagName);
    OldHtml  : ;
  else
    HtmlStartTag(TagName);
  end;
end;

procedure TFrmMain.XmlScannerEndTag(Sender: TObject; TagName: String);
begin
  case OutputMode of
    IE       : IEEndTag(TagName);
    Netscape : NetscapeEndTag(TagName);
    Opera    : OperaEndTag(TagName);
    OldHtml  : OldHtmlEndTag(TagName);
  else
    HtmlEndTag(TagName);
  end;
end;

procedure TFrmMain.XmlScannerContent(Sender: TObject; Content: String);
begin
  case OutputMode of
    IE       : IEContent(Content);
    Netscape : NetscapeContent(Content);
    Opera    : OperaContent(Content);
    OldHtml  : OldHtmlContent(Content);
  else
    HtmlContent(Content);
  end;
end;

function TFrmMain.XmlScannerTranslateEncoding(Sender: TObject;
  CurrentEncoding, Source: String): String;
begin
  Result:= Source;
end;

{$ENDIF}

end.



