unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TFPrincipale = class(TForm)
    BtnConversion: TButton;
    DlgOuvrir: TOpenDialog;
    TitreBookmark: TLabel;
    EdtBookmark: TEdit;
    BtnChoix: TButton;
    procedure BtnConversionClick(Sender: TObject);
    procedure BtnChoixClick(Sender: TObject);
    procedure EdtBookmarkChange(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  FPrincipale: TFPrincipale;

implementation

{$R *.DFM}

var
  Origine: TextFile;
  Final: TextFile;
  Ligne: string;
  GroupeEnCours: boolean;
  Niveau: byte;

procedure DebutHtml;
begin
  writeln(Final,'<HTML>');
  writeln(Final,'<HEAD>');
  writeln(Final,'<TITLE>Mes liens</TITLE>');
  writeln(Final,'<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=ISO-8859-1">');
  writeln(Final,'</HEAD>');
  writeln(Final,'<BODY BGCOLOR="#CCDBED">');
  writeln(Final,'<BASEFONT SIZE="3" COLOR="#000000">');
end;

procedure FinHtml;
begin
  writeln(Final,'<!---->');
  writeln(Final,'<HR>');
  write(Final,'<P><FONT SIZE="-1">Derni&egrave;re mise &agrave; jour:');
  writeln(Final,DateToStr(Date)+'</FONT> </P>');
  writeln(Final,'</BODY>');
  writeln(Final,'</HTML>');
end;

procedure DebutGroupe(Nom: string);
begin
  writeln(Final,'<!--'+Nom+'-->');
  writeln(Final,'<P><A NAME="'+Nom+'"></A>&nbsp;</P>');
  writeln(Final,'<TABLE CELLPADDING="5" WIDTH="100%" BGCOLOR="#9CADC6">');
  writeln(Final,'<TR>');
  writeln(Final,'<TD> <TABLE BORDER="0" CELLSPACING="0" WIDTH="100%">');
  writeln(Final,'<TR>');
  writeln(Final,'<TD ALIGN="LEFT"> <H2> &nbsp;'+Nom+'</H2>');
  writeln(Final,'</TD>');
  writeln(Final,'</TR>');
  writeln(Final,'<TR>');
  writeln(Final,'<TD BGCOLOR="#FFFFFF"> ');
  writeln(Final,'<TABLE FRAME="BORDER" CELLPADDING="4" WIDTH="100%" BORDER="1">');
end;

procedure FinGroupe;
begin
  writeln(Final,'<!---->');
  writeln(Final,'</TABLE>');
  writeln(Final,'</TD>');
  writeln(Final,'</TR>');
  writeln(Final,'</TABLE>');
  writeln(Final,'</TD>');
  writeln(Final,'</TR>');
  writeln(Final,'</TABLE>');
  GroupeEnCours:= false;
end;

procedure DebutSousGroupe(Nom: string);
begin
  writeln(Final,'<!--'+Nom+'-->');
  writeln(Final,'<TR>');
  write(Final,'<TD ALIGN="LEFT" COLSPAN="2" BGCOLOR="#D0FFE0">');
  writeln(Final,'<B>'+Nom+'</B></TD>');
  writeln(Final,'</TR>');
end;

procedure FinSousGroupe;
begin
  writeln(Final,'<TR>');
  write(Final,'<TD ALIGN="LEFT" COLSPAN="2" BGCOLOR="#D0FFE0">&nbsp;</TD>');
  writeln(Final,'</TR>');
end;

procedure AjouteLigne(Nom, Adresse: string);
begin
  writeln(Final,'<!--'+Nom+'-->');
  writeln(Final,'<TR>');
  writeln(Final,'<TD VALIGN="MIDDLE">'+Nom+'</TD>');
  write(Final,'<TD VALIGN="MIDDLE"><A HREF="'+Adresse+'" TARGET="_blank">');
  writeln(Final,Adresse+'</A></TD>');
  writeln(Final,'</TR>');
end;

procedure DecodeGroupe;
var
  N: integer;
begin
  inc(Niveau);
  GroupeEnCours:= true;
  delete(Ligne,1,7);
  N:= pos('>',Ligne);
  delete(Ligne,1,N);
  N:= pos('<',Ligne);
  if Niveau= 1 then DebutGroupe(copy(Ligne,1,N-1))
               else DebutSousGroupe(copy(Ligne,1,N-1));
end;

procedure DecodeFinGroupe;
begin
  case Niveau of
    1 : FinGroupe;
    2 : FinSousGroupe;
  end;
  dec(Niveau);
end;

procedure ElimineGuillemets;
var
  N: integer;
  LigneSuiv: string;
begin
  N:= pos('"',Ligne);
  if N= 0 then
  begin
    readln(Origine,LigneSuiv);
    Ligne:= Ligne + LigneSuiv;
    N:= pos('"',Ligne);
  end;
  delete(Ligne,1,N);
end;

procedure DecodeLigne;
var
  N: integer;
  Nom: string;
  Adresse: string;
  LigneSuiv: string;
begin
  delete(Ligne,1,7);
  N:= pos('"',Ligne);
  delete(Ligne,1,N);
  N:= pos('"',Ligne);
  Adresse:= copy(Ligne,1,N-1);
  delete(Ligne,1,N);
  //ADD_DATE
  ElimineGuillemets;
  ElimineGuillemets;
  //LAST_VISIT
  ElimineGuillemets;
  ElimineGuillemets;
  //LAST_MODIFIED
  ElimineGuillemets;
  ElimineGuillemets;
  N:= pos('>',Ligne);
  delete(Ligne,1,N);
  N:= pos('<',Ligne);
  if N= 0 then
  begin
    readln(Origine,LigneSuiv);
    Ligne:= Ligne + LigneSuiv;
    N:= pos('<',Ligne);
  end;
  Nom:= copy(Ligne,1,N-1);
  AjouteLigne(Nom, Adresse);
end;

procedure DecodeOrigine;
var
 S: string;
begin
  while not Eof(Origine) do
  begin
    readln(Origine,Ligne);
    Ligne:= trim(Ligne);
    S:= copy(Ligne,1,7);

    if S= '</DL><p' then DecodeFinGroupe
    else
    if S= '<DT><H3' then DecodeGroupe
    else
    if S= '<DT><A ' then DecodeLigne;
  end;
end;

procedure TFPrincipale.BtnConversionClick(Sender: TObject);
begin
  if EdtBookmark.Text<> '' then
  begin
    AssignFile(Final,'Mesliens.html');
    Rewrite(Final);
    AssignFile(Origine,EdtBookmark.Text);
    Reset(Origine);
    GroupeEnCours:= false;
    Niveau:= 0;
    DebutHtml;
    DecodeOrigine;
    FinHtml;
    CloseFile(Final);
    CloseFile(Origine);
    ShowMessage('Termin');
  end;
end;

procedure TFPrincipale.BtnChoixClick(Sender: TObject);
begin
  if DlgOuvrir.Execute then
  begin
    EdtBookmark.Text:= DlgOuvrir.FileName;
  end;
end;

procedure TFPrincipale.EdtBookmarkChange(Sender: TObject);
begin
  BtnConversion.Enabled:= EdtBookmark.Text<>'';
end;

end.
