unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids;

type
  TFPrincipale = class(TForm)
    BtnConversion: TButton;
    DlgOuvrir: TOpenDialog;
    TitreBookmark: TLabel;
    EdtBookmark: TEdit;
    BtnChoix: TButton;
    Grille: TStringGrid;
    procedure BtnConversionClick(Sender: TObject);
    procedure BtnChoixClick(Sender: TObject);
    procedure EdtBookmarkChange(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  FPrincipale: TFPrincipale;

implementation

{$R *.DFM}

var
  Origine: TextFile;
  Final: TextFile;
  Ligne: string;
  Niveau: byte;
  NiveauMax: byte;
  Num: longint;
  Indice: array[1..10] of byte;
  Etiquette: string;
  RubriqueOuverte: boolean;
  LienOuvert: boolean;


{----------------------------------------------------------}
{  Utilitaires divers                                      }
{----------------------------------------------------------}

procedure InitialiseGrille;
var
  N: byte;
begin
  with FPrincipale.Grille do
  begin
    Cells[0,0]:= 'Type';
    Cells[1,0]:= 'N menu';
    Cells[2,0]:= 'Nom';
    Cells[3,0]:= 'Lien';
  end;
  Num:= 0;
  Niveau:= 0;
  for N:= 1 to 10 do Indice[N]:= 0;
end;

procedure AjouteUneLigne;
begin
  inc(Num);
  FPrincipale.Grille.RowCount:= Num+1;
end;

procedure AugmenteNiveau;
begin
  inc(Niveau);
  if Niveau>NiveauMax then NiveauMax:= Niveau;
end;

procedure DiminueNiveau;
begin
  Indice[Niveau]:= 0;
  dec(Niveau);
  //if Niveau=1 then inc(Indice[1]);
end;

function CalculEtiquette: string;
var
  N: byte;
  Chaine: string;
begin
  Chaine:= IntToStr(Indice[1]);
  N:= 2;
  while (N<=Niveau) and (Indice[N]<>0) do
  begin
    Chaine:= Chaine + '_' + IntToStr(Indice[N]);
    inc(N);
  end;
  Result:= Chaine;
end;

procedure ElimineGuillemets;
var
  N: integer;
  LigneSuiv: string;
begin
  N:= pos('"',Ligne);
  if N= 0 then
  begin
    readln(Origine,LigneSuiv);
    Ligne:= Ligne + LigneSuiv;
    N:= pos('"',Ligne);
  end;
  delete(Ligne,1,N);
end;

{----------------------------------------------------------}
{  Decryptage du fichier des bookmarks                     }
{----------------------------------------------------------}

procedure AjouteTitre;
var
  N: integer;
begin
  inc(Indice[Niveau]);
  delete(Ligne,1,7);
  N:= pos('>',Ligne);
  delete(Ligne,1,N);
  N:= pos('<',Ligne);
  AjouteUneLigne;
  Etiquette:= CalculEtiquette;
  with FPrincipale.Grille do
  begin
    Cells[0,Num]:= '1';
    Cells[1,Num]:= Etiquette;
    Cells[2,Num]:= copy(Ligne,1,N-1);
    Cells[4,Num]:= IntToStr(Niveau);
  end;
end;

procedure DecodeLigne(var Nom,Adresse: string);
var
  N: integer;
  LigneSuiv: string;
begin
  delete(Ligne,1,7);
  N:= pos('"',Ligne);
  delete(Ligne,1,N);
  N:= pos('"',Ligne);
  Adresse:= copy(Ligne,1,N-1);
  delete(Ligne,1,N);
  //ADD_DATE
  ElimineGuillemets;
  ElimineGuillemets;
  //LAST_VISIT
  ElimineGuillemets;
  ElimineGuillemets;
  //LAST_MODIFIED
  ElimineGuillemets;
  ElimineGuillemets;
  N:= pos('>',Ligne);
  delete(Ligne,1,N);
  N:= pos('<',Ligne);
  if N= 0 then
  begin
    readln(Origine,LigneSuiv);
    Ligne:= Ligne + LigneSuiv;
    N:= pos('<',Ligne);
  end;
  Nom:= copy(Ligne,1,N-1);
end;

procedure AjouteLien;
var
  Nom: string;
  Adresse: string;
begin
  if Niveau>1 then inc(Indice[Niveau]);
  AjouteUneLigne;
  Etiquette:= CalculEtiquette;
  DecodeLigne(Nom,Adresse);
  with FPrincipale.Grille do
  begin
    Cells[0,Num]:= '0';
    Cells[1,Num]:= Etiquette;
    Cells[2,Num]:= Nom;
    Cells[3,Num]:= Adresse;
    Cells[4,Num]:= IntToStr(Niveau);
  end;
end;

procedure AjouteSeparateur;
begin
  AjouteUneLigne;
  with FPrincipale.Grille do
  begin
    Cells[0,Num]:= '2';
    Cells[1,Num]:= Etiquette;
    Cells[4,Num]:= IntToStr(Niveau);
  end;
end;

procedure LectureFichier;
var
 S: string;
begin
  while not Eof(Origine) do
  begin
    readln(Origine,Ligne);
    Ligne:= trim(Ligne);
    S:= copy(Ligne,1,7);

    if S= '<DL><p>' then AugmenteNiveau
    else
    if S= '</DL><p' then DiminueNiveau
    else
    if S= '<DT><H3' then AjouteTitre
    else
    if S= '<DT><A ' then AjouteLien
    else
    if s= '<HR>' then AjouteSeparateur;
  end;
end;

{----------------------------------------------------------}
{  Cration fichier HTML                                   }
{----------------------------------------------------------}

procedure DebutHtml;
begin
  writeln(Final,'<HTML>');
  writeln(Final,'<HEAD>');
  writeln(Final,'<TITLE>Mes liens</TITLE>');
  writeln(Final,'<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=ISO-8859-1">');
  writeln(Final,'</HEAD>');
  writeln(Final,'<BODY BGCOLOR="#CCDBED">');
  writeln(Final,'<BASEFONT SIZE="3" COLOR="#000000">');
  writeln(Final,'<H2><CENTER>Mes liens</CENTER></H2>');
end;

procedure FinHtml;
begin
  writeln(Final,'<!---->');
  writeln(Final,'<HR>');
  write(Final,'<P><FONT SIZE="-1">Derni&egrave;re mise &agrave; jour:');
  writeln(Final,DateToStr(Date)+'</FONT> </P>');
  writeln(Final,'</BODY>');
  writeln(Final,'</HTML>');
end;

procedure DebutTableau;
const
  Larg='100%';
begin
  writeln(Final,'<TABLE CELLPADDING="5" WIDTH="100%" BGCOLOR="#9CADC6">');
  writeln(Final,'<TR>');
  writeln(Final,'<TD> <TABLE BORDER="0" CELLSPACING="0" WIDTH="100%">');
  writeln(Final,'<TR>');
  writeln(Final,'<TD BGCOLOR="#000000"> ');
  writeln(Final,'<TABLE CELLSPACING="2" CELLPADDING="0" WIDTH="100%" BORDER="0" >');
  writeln(Final,'<TR>');
  writeln(Final,'<TD BGCOLOR="#CFEFFF"> ');
  writeln(Final,'<TABLE CELLSPACING="1" CELLPADDING="4" WIDTH="100%" BORDER="0">');
end;

procedure FinTableau;
begin
  writeln(Final,'<!---->');
  writeln(Final,'</TABLE>');
  writeln(Final,'</TD>');
  writeln(Final,'</TR>');
  writeln(Final,'</TABLE>');
  writeln(Final,'</TD>');
  writeln(Final,'</TR>');
  writeln(Final,'</TABLE>');
  writeln(Final,'</TD>');
  writeln(Final,'</TR>');
  writeln(Final,'</TABLE>');
  writeln(Final,'&nbsp;<BR>');
end;

procedure EcritRubrique(Nom,Niveau: string;Premier: boolean);
var
  N: integer;
  Num: integer;
begin
  writeln(Final,'<!--'+Nom+'-->');

  Num:= StrToInt(Niveau);
  dec(Num);
  if Num=0 then
  begin
    if not Premier then
    begin
      writeln(Final,'<TR>');
      writeln(Final,'<TD COLSPAN="4">&nbsp</TD>');
    end;
    writeln(Final,'<TR BGCOLOR="#D0FFE0">');
    writeln(Final,'<TD VALIGN="TOP" COLSPAN="4">');
    writeln(Final,'<B>'+Nom+'</B></TD>');
    //writeln(Final,'<TD VALIGN="TOP" COLSPAN="3">&nbsp;</TD>');
  end
  else
  begin
    writeln(Final,'<TR BGCOLOR="#CFEFFF">');
    writeln(Final,'<TD VALIGN="TOP">');
    for N:=1 to Num do writeln(Final,'&nbsp;&nbsp;&nbsp;');
    write(Final,'<IMG SRC="triangle.gif" WIDTH=10 HEIGHT=10>&nbsp;&nbsp;');
    writeln(Final,'<B>'+Nom+'</B></TD>');
    writeln(Final,'<TD VALIGN="TOP" COLSPAN="3">&nbsp;</TD>');
  end;
  writeln(Final,'</TR>');
end;

procedure EcritLien(Nom,Adresse,Niveau: string);
begin
  if Adresse='' then Adresse:='&nbsp;';
  writeln(Final,'<TR>');
  writeln(Final,'<TD>&nbsp;</TD>');
  writeln(Final,'<TD BGCOLOR="#FFFFFF" VALIGN="MIDDLE">'+Nom+'</TD>');
  write(Final,'<TD BGCOLOR="#FFFFFF"VALIGN="MIDDLE"><A HREF="'+Adresse+'" TARGET="_blank">');
  writeln(Final,Adresse+'</A></TD>');
  writeln(Final,'<TD>&nbsp;</TD>');
  writeln(Final,'</TR>');
end;

procedure LigneVide;
begin
  writeln(Final,'<TR>');
  writeln(Final,'<TD COLSPAN="4">&nbsp;</TD>');
  writeln(Final,'</TR>');
end;

procedure GenereHtml;
var
  N: longint;
  Genre: integer;
begin
  DebutHtml;
  DebutTableau;
  RubriqueOuverte:= false;
  LienOuvert:= false;
  with FPrincipale.Grille do
  begin
    for N:= 1 to RowCount-1 do
    begin
      Genre:= StrToInt(Cells[0,N]);
      case Genre of
          0: EcritLien(Cells[2,N],Cells[3,N],Cells[4,N]);
          1: if N=1 then EcritRubrique(Cells[2,N],Cells[4,N],true)
                    else EcritRubrique(Cells[2,N],Cells[4,N],false);
      end;
    end;
  end;
  LigneVide;
  FinTableau;
  FinHtml;
end;

{----------------------------------------------------------}
{  Fiche                                                   }
{----------------------------------------------------------}

procedure TFPrincipale.BtnConversionClick(Sender: TObject);
begin
  if EdtBookmark.Text<> '' then
  begin
    AssignFile(Origine,EdtBookmark.Text);
    Reset(Origine);
    InitialiseGrille;
    LectureFichier;
    CloseFile(Origine);

    AssignFile(Final,'Mesliens.html');
    Rewrite(Final);
    GenereHtml;
    CloseFile(Final);

    //ShowMessage('Termin');
    Close;
  end;
end;

procedure TFPrincipale.BtnChoixClick(Sender: TObject);
begin
  if DlgOuvrir.Execute then
  begin
    EdtBookmark.Text:= DlgOuvrir.FileName;
  end;
end;

procedure TFPrincipale.EdtBookmarkChange(Sender: TObject);
begin
  BtnConversion.Enabled:= EdtBookmark.Text<>'';
end;

end.
