unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids;

type
  TFPrincipale = class(TForm)
    BtnConversion: TButton;
    DlgOuvrir: TOpenDialog;
    TitreBookmark: TLabel;
    EdtBookmark: TEdit;
    BtnChoix: TButton;
    Grille: TStringGrid;
    procedure BtnConversionClick(Sender: TObject);
    procedure BtnChoixClick(Sender: TObject);
    procedure EdtBookmarkChange(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  FPrincipale: TFPrincipale;

implementation

{$R *.DFM}

var
  Origine: TextFile;
  Final: TextFile;
  Ligne: string;
  Niveau: byte;
  NiveauMax: byte;
  Num: longint;
  Indice: array[1..10] of byte;
  Etiquette: string;

{----------------------------------------------------------}
{  Utilitaires divers                                      }
{----------------------------------------------------------}

procedure InitialiseGrille;
var
  N: byte;
begin
  with FPrincipale.Grille do
  begin
    Cells[0,0]:= 'Type';
    Cells[1,0]:= 'N menu';
    Cells[2,0]:= 'Nom';
    Cells[3,0]:= 'Lien';
  end;
  Num:= 0;
  Niveau:= 0;
  for N:= 1 to 10 do Indice[N]:= 0;
end;

procedure AjouteUneLigne;
begin
  inc(Num);
  FPrincipale.Grille.RowCount:= Num+1;
end;

procedure AugmenteNiveau;
begin
  inc(Niveau);
  if Niveau>NiveauMax then NiveauMax:= Niveau;
end;

procedure DiminueNiveau;
begin
  Indice[Niveau]:= 0;
  dec(Niveau);
  //if Niveau=1 then inc(Indice[1]);
end;

function CalculEtiquette: string;
var
  N: byte;
  Chaine: string;
begin
  Chaine:= IntToStr(Indice[1]);
  N:= 2;
  while (N<=Niveau) and (Indice[N]<>0) do
  begin
    Chaine:= Chaine + '_' + IntToStr(Indice[N]);
    inc(N);
  end;
  Result:= Chaine;
end;

procedure ElimineGuillemets;
var
  N: integer;
  LigneSuiv: string;
begin
  N:= pos('"',Ligne);
  if N= 0 then
  begin
    readln(Origine,LigneSuiv);
    Ligne:= Ligne + LigneSuiv;
    N:= pos('"',Ligne);
  end;
  delete(Ligne,1,N);
end;

{----------------------------------------------------------}
{  Decryptage du fichier des bookmarks                     }
{----------------------------------------------------------}

procedure AjouteTitre;
var
  N: integer;
begin
  inc(Indice[Niveau]);
  delete(Ligne,1,7);
  N:= pos('>',Ligne);
  delete(Ligne,1,N);
  N:= pos('<',Ligne);
  AjouteUneLigne;
  Etiquette:= CalculEtiquette;
  with FPrincipale.Grille do
  begin
    Cells[0,Num]:= '1';
    Cells[1,Num]:= Etiquette;
    Cells[2,Num]:= copy(Ligne,1,N-1);
    Cells[4,Num]:= IntToStr(Niveau);
  end;
end;

procedure DecodeLigne(var Nom,Adresse: string);
var
  N: integer;
  LigneSuiv: string;
begin
  delete(Ligne,1,7);
  N:= pos('"',Ligne);
  delete(Ligne,1,N);
  N:= pos('"',Ligne);
  Adresse:= copy(Ligne,1,N-1);
  delete(Ligne,1,N);
  //ADD_DATE
  ElimineGuillemets;
  ElimineGuillemets;
  //LAST_VISIT
  ElimineGuillemets;
  ElimineGuillemets;
  //LAST_MODIFIED
  ElimineGuillemets;
  ElimineGuillemets;
  N:= pos('>',Ligne);
  delete(Ligne,1,N);
  N:= pos('<',Ligne);
  if N= 0 then
  begin
    readln(Origine,LigneSuiv);
    Ligne:= Ligne + LigneSuiv;
    N:= pos('<',Ligne);
  end;
  Nom:= copy(Ligne,1,N-1);
end;

procedure AjouteLien;
var
  Nom: string;
  Adresse: string;
begin
  if Niveau>1 then inc(Indice[Niveau]);
  AjouteUneLigne;
  Etiquette:= CalculEtiquette;
  DecodeLigne(Nom,Adresse);
  with FPrincipale.Grille do
  begin
    Cells[0,Num]:= '0';
    Cells[1,Num]:= Etiquette;
    Cells[2,Num]:= Nom;
    Cells[3,Num]:= Adresse;
    Cells[4,Num]:= IntToStr(Niveau);
  end;
end;

procedure AjouteSeparateur;
begin
  AjouteUneLigne;
  with FPrincipale.Grille do
  begin
    Cells[0,Num]:= '2';
    Cells[1,Num]:= Etiquette;
    Cells[4,Num]:= IntToStr(Niveau);
  end;
end;

procedure LectureFichier;
var
 S: string;
begin
  while not Eof(Origine) do
  begin
    readln(Origine,Ligne);
    Ligne:= trim(Ligne);
    S:= copy(Ligne,1,7);

    if S= '<DL><p>' then AugmenteNiveau
    else
    if S= '</DL><p' then DiminueNiveau
    else
    if S= '<DT><H3' then AjouteTitre
    else
    if S= '<DT><A ' then AjouteLien
    else
    if s= '<HR>' then AjouteSeparateur;
  end;
end;

{----------------------------------------------------------}
{  Cration fichier HTML                                   }
{----------------------------------------------------------}

procedure LesScripts;
begin
  writeln(Final,'');
  writeln(Final,'<SCRIPT LANGUAGE="JavaScript" TYPE="text/javascript">');
  writeln(Final,'<!--');
  writeln(Final,'     NS4 = (document.layers);');
  writeln(Final,'     IE4 = (document.all);');
  writeln(Final,'    ver4 = (NS4 || IE4);');
  writeln(Final,'	 IE5 = (IE4 && navigator.appVersion.indexOf("5.")!=-1);');
  writeln(Final,'   isMac = (navigator.appVersion.indexOf("Mac") != -1);');
  writeln(Final,'  isMenu = (NS4 || (IE4 && !isMac) || (IE5 && isMac));');
  writeln(Final,'function popUp(){return};');
  writeln(Final,'function popDown(){return};');
  writeln(Final,'if (!ver4) event=null;');
  writeln(Final,'//-->');
  writeln(Final,'</SCRIPT>');
  writeln(Final,'<SCRIPT LANGUAGE="JavaScript1.2" TYPE="text/javascript">');
  writeln(Final,'<!--');
  writeln(Final,'if (isMenu) {');
  writeln(Final,'menuVersion = 3;');
  writeln(Final,'menuWidth = 120;');
  writeln(Final,'childOverlap = 20;');
  writeln(Final,'childOffset = 5;');
  writeln(Final,'perCentOver = null;');
  writeln(Final,'secondsVisible = .5;');
  writeln(Final,'fntCol = "blue";');
  writeln(Final,'fntSiz = "10";');
  writeln(Final,'fntBold = false;');
  writeln(Final,'fntItal = false;');
  writeln(Final,'fntFam = "Arial,sans-serif";');
  writeln(Final,'backCol = "#DDDDDD";');
  writeln(Final,'overCol = "#FFCCCC";');
  writeln(Final,'overFnt = "purple";');
  writeln(Final,'borWid = 2;');
  writeln(Final,'borCol = "black";');
  writeln(Final,'borSty = "solid";');
  writeln(Final,'itemPad = 3;');
  writeln(Final,'imgSrc = "tri.gif";');
  writeln(Final,'imgSiz = 10;');
  writeln(Final,'separator = 1;');
  writeln(Final,'separatorCol = "black";');
  writeln(Final,'isFrames = false;');
  writeln(Final,'keepHilite = true;');
  writeln(Final,'clickStart = false;');
  writeln(Final,'clickKill = true;');
  writeln(Final,'}');
  writeln(Final,'//-->');
  writeln(Final,'</SCRIPT>');
  writeln(Final,'<SCRIPT LANGUAGE="JavaScript1.2" TYPE="text/javascript">');
  writeln(Final,'<!--');
  writeln(Final,'if (isMenu) {');
  writeln(Final,'document.write("<SCRIPT LANGUAGE=''JavaScript1.2'' SRC=''hierArrays.js'' TYPE=''text/javascript''><\/SCRIPT>");');
  writeln(Final,'}');
  writeln(Final,'//-->');
  writeln(Final,'</SCRIPT>');
  writeln(Final,'');
  writeln(Final,'<SCRIPT LANGUAGE="JavaScript1.2" TYPE="text/javascript">');
  writeln(Final,'<!--');
  writeln(Final,'if (isMenu) {');
  writeln(Final,'document.write("<SCRIPT LANGUAGE=''JavaScript1.2'' SRC=''hierMenus.js'' TYPE=''text/javascript''><\/SCRIPT>");');
  writeln(Final,'}');
  writeln(Final,'//-->');
  writeln(Final,'</SCRIPT>');
  writeln(Final,'');
end;

procedure DebutHtml;
begin
  writeln(Final,'<HTML>');
  writeln(Final,'<HEAD>');
  writeln(Final,'<TITLE>Mes liens</TITLE>');
  writeln(Final,'<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=ISO-8859-1">');
  writeln(Final,'</HEAD>');
  LesScripts;
  writeln(Final,'<BODY BGCOLOR="#CCDBED">');
  writeln(Final,'<BASEFONT SIZE="3" COLOR="#000000">');
end;

procedure FinHtml;
begin
  writeln(Final,'<!---->');
  writeln(Final,'<HR>');
  write(Final,'<P><FONT SIZE="-1">Derni&egrave;re mise &agrave; jour:');
  writeln(Final,DateToStr(Date)+'</FONT> </P>');
  writeln(Final,'</BODY>');
  writeln(Final,'</HTML>');
end;

procedure DebutTableau;
const
  Larg='100%';
begin
  writeln(Final,'<TABLE BGCOLOR="#9CADC6" CELLPADDING="5" WIDTH="'+Larg+'">');
  writeln(Final,'<TR>');

  writeln(Final,'<TD><TABLE WIDTH="100%" CELLSPACING="0" BORDER="0">');
  writeln(Final,'<TR>');
  writeln(Final,'<TD BGCOLOR="#FFFFFF" ALIGN="JUSTIFY">');

  writeln(Final,'<TABLE WIDTH="'+Larg+'" CELLPADDING="4" BORDER="1"></TD>');
  writeln(Final,'<TR>');
  writeln(Final,'<TD BGCOLOR="#D0FFE0" ALIGN="CENTER"><FONT COLOR="#000000" SIZE="4"><B>Mes liens</B></FONT></TD>');
  writeln(Final,'</TR>');
end;

procedure LigneTableau(Genre, NumMenu, Nom, Adresse: string);
begin
  if Genre='0' then
  begin
    writeln(Final,'<TR>');
    writeln(Final,'<TD>'+Nom+': <A HREF="'+Adresse+'"> '+Adresse+' </A> </TD>');
  end
  else
  if Genre='1' then
  begin
    writeln(Final,'<TR>');
    writeln(Final,'<TD>');
    write(Final,'<A HREF="javascript:void(0)" onMouseOver="popUp(''elMenu'+NumMenu);
    write(Final,''',event)" onMouseOut="popDown(''elMenu'+NumMenu);
    writeln(Final,''')" onClick="return false">'+Nom);
    writeln(Final,'</A>');
    writeln(Final,'<IMG SRC="tri.gif" ALT="->" WIDTH="10" HEIGHT="10" BORDER="0">');
    writeln(Final,'</TD>');
{  end
  else
  if Genre='2' then
  begin
    writeln(Final,'<TR>');
    writeln(Final,'<TD COLSPAN="2"><HR></TD>');}
  end;
end;

procedure FinTableau;
begin
  writeln(Final,'</TABLE>');
  writeln(Final,'</TD>');
  writeln(Final,'</TR>');
  writeln(Final,'</TABLE>');
  writeln(Final,'</TD>');
  writeln(Final,'</TR>');
  writeln(Final,'</TABLE>');
  writeln(Final,'&nbsp;<BR>');
end;

procedure GenereHtml;
var
  N: longint;
begin
  DebutHtml;
  DebutTableau;
  with FPrincipale.Grille do
  begin
    for N:= 1 to RowCount do
    begin
      if Cells[4,N]= '1' then LigneTableau(Cells[0,N],Cells[1,N],Cells[2,N],Cells[3,N]);
    end;
  end;
  FinTableau;
  FinHtml;
end;

{----------------------------------------------------------}
{  Cration fichier hierArrays.js                          }
{----------------------------------------------------------}

procedure DebutMenu(NumMenu: string);
begin
  writeln(Final,'arMenu'+NumMenu+' = new Array(');
  writeln(Final,'250,');//largeur menu
  writeln(Final,'"150","",');//gauche, haut
  writeln(Final,'"","",');//coul. texte, coul. texte select
  writeln(Final,'"","",');//coul. fond, coul. fond select
  write(Final,'"",""');//coul. encadrement, coul. separateur
end;

procedure FinMenu;
begin
  writeln(Final,'');// dernier element sans virgule finale
  writeln(Final,')');
  write(Final,#10);
end;

procedure AjouteLigne(Genre,Nom,Adresse: string; Virgule: boolean);
begin
  if Virgule then writeln(Final,',');// virgule de la ligne precedente
//             else writeln(Final,'');
  write(Final,'"'+Nom+'","'+Adresse+'",'+Genre);
end;

procedure DebutSousMenu(NumMenu: string);
begin
  writeln(Final,'arMenu'+NumMenu+' = new Array(');
end;

procedure GenereJs;
var
  M,N: longint;
  Long: longint;
  NumMenu: string;
  Virgule: boolean;
begin
  with FPrincipale.Grille do
  begin
    // Menu principaux
    NumMenu:= '';
    for N:= 1 to RowCount do
    begin
      if Cells[4,N]= '2' then
      begin
        Etiquette:= Cells[1,N];
        Etiquette:= copy(Etiquette,1,pos('_',Etiquette)-1);
        if NumMenu<>Etiquette then
        begin
          if NumMenu <> '' then FinMenu;
          NumMenu:= Etiquette;
          DebutMenu(NumMenu);
        end;
        AjouteLigne(Cells[0,N],Cells[2,N],Cells[3,N],true);
      end;
    end;
    FinMenu;

    // Sous menus
    for M:= 3 to NiveauMax do
    begin
      NumMenu:= '';
      for N:= 1 to RowCount do
      begin
        if Cells[4,N]= IntToStr(M) then
        begin
          Etiquette:= Cells[1,N];
          Long:= length(Etiquette);
          while (Etiquette[Long]<>'_') and (Long>0) do
          begin
            delete(Etiquette,Long,1);
            Long:= length(Etiquette);
          end;
          if Long>0 then delete(Etiquette,Long,1);
          if NumMenu<>Etiquette then
          begin
            if NumMenu <> '' then FinMenu;
            NumMenu:= Etiquette;
            DebutSousMenu(NumMenu);
            Virgule:= false;
          end;
          AjouteLigne(Cells[0,N],Cells[2,N],Cells[3,N],Virgule);
          Virgule:= true;
        end;
      end;
      if NumMenu<>'' then FinMenu;
    end;
  end;
end;

{----------------------------------------------------------}
{  Fiche                                                   }
{----------------------------------------------------------}

procedure TFPrincipale.BtnConversionClick(Sender: TObject);
begin
  if EdtBookmark.Text<> '' then
  begin
    AssignFile(Origine,EdtBookmark.Text);
    Reset(Origine);
    InitialiseGrille;
    LectureFichier;
    CloseFile(Origine);

    AssignFile(Final,'Mesliens.html');
    Rewrite(Final);
    GenereHtml;
    CloseFile(Final);

    AssignFile(Final,'hierArrays.js');
    Rewrite(Final);
    GenereJs;
    CloseFile(Final);
    //ShowMessage('Termin');
  end;
end;

procedure TFPrincipale.BtnChoixClick(Sender: TObject);
begin
  if DlgOuvrir.Execute then
  begin
    EdtBookmark.Text:= DlgOuvrir.FileName;
  end;
end;

procedure TFPrincipale.EdtBookmarkChange(Sender: TObject);
begin
  BtnConversion.Enabled:= EdtBookmark.Text<>'';
end;

end.
