{

                           AJSOURIS  Version 1.0

                         Creation Alain JAFFRE 1995

  ͸
                   Unite ecrite pour TURBO PASCAL 7.0                     
                                                                          
                             Alain JAFFRE                                 
  ;

}

{$I AJSOURIS.DOC }

IMPLEMENTATION

{}

Var

  Reg     : registers;
  Curseur : SouGrPtr;

{}

Procedure RazSouris;

Begin
  with Reg do
  Begin
    AX := 0;
    BX := 0;
    intr(IntSouris, Reg);
    LaSouris.Existe := (AX <> 0);
    LaSouris.NbBouton := BX;
  End;
End;

{}

Procedure MontreSouris;

Begin
  if (SourisUtil and not SourisVis) then
  Begin
    Reg.AX := 1;
    intr(IntSouris, Reg);
    SourisVis := true;
  End;
End;

{}

Procedure CacheSouris;

Begin
  if (SourisUtil and SourisVis) then
  Begin
    Reg.AX := 2;
    intr(IntSouris, Reg);
    SourisVis := false;
  End;
End;

{}

Procedure PosSouris (Var Souris : PosRec);

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 3;
    intr(IntSouris, Reg);
    with Souris do
    Begin
      Bouton  := BX;
      Nombre  := -1;
      Colonne := CX;
      Ligne   := DX;
    End;
  End;
End;

{}

Procedure DeplaceSouris (H , V : word);

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 4;
    CX := H;
    DX := V;
    intr(IntSouris, Reg);
  End;
End;

{}

Procedure SourisPressee (Bouton : byte ; Var Souris : PosRec);

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 5;
    case Bouton of
      BoutonGauche : BX := 0;
      BoutonDroit  : BX := 1;
      BoutonMilieu : BX := 2;
    end;
    intr(IntSouris, Reg);
    with Souris do
    Begin
      Bouton  := AX;
      Nombre  := BX;
      Colonne := CX;
      Ligne   := DX;
    End;
  End;
End;

{}

Procedure SourisRelachee (Bouton : byte ; Var Souris : PosRec);

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 6;
    case Bouton of
      BoutonGauche : BX := 0;
      BoutonDroit  : BX := 1;
      BoutonMilieu : BX := 2;
    end;
    intr(IntSouris, Reg);
    with Souris do
    Begin
      Bouton  := AX;
      Nombre  := BX;
      Colonne := CX;
      Ligne   := DX;
    End;
  End;
End;

{}

Procedure ZoneHSouris (Min , Max : word);

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 7;
    CX := MiniEntier(Min,Max);
    DX := MaxiEntier(Min,Max);
    intr(IntSouris, Reg);
  End;
End;

{}

Procedure ZoneVSouris (Min , Max : word);

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 8;
    CX := MiniEntier(Min,Max);
    DX := MaxiEntier(Min,Max);
    intr(IntSouris, Reg);
  End;
End;

{}

Procedure SourisGr(Souris : SouGrPtr);

Begin
  if SourisUtil then
  with Reg , Souris^ do
  Begin
    AX := 9;
    BX := XPoint;
    CX := YPoint;
    DX := ofs(Ligne);
    ES := seg(Ligne);
    intr(IntSouris, Reg);
  End;
End;

{}

Procedure SourisTxHard(LDebut , LFin : word);

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 10;
    BX := 1;
    CX := LDebut;
    DX := LFin;
    intr(IntSouris, Reg);
  End;
End;


{}

Procedure SourisTxSoft(ClFond , ClTexte : byte; Caractere : char);

Var
  Valeur : word;

Begin
  if SourisUtil then
  Begin
    Valeur := (ClTexte + (ClFond * 16)) * 256 + ord(Caractere);
    with Reg do
    Begin
      AX := 10;
      BX := 0;
      CX := $0000;
      DX := Valeur;
      intr(IntSouris, Reg);
    End;
  End;
End;

{}

Procedure MouvementSouris(Var Mouvement : MouvRec);

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 11;
    intr(IntSouris, Reg);
    Mouvement.DeplaceH := integer(CX);
    Mouvement.DeplaceV := integer(DX);
  End;
End;

{}

Procedure ChangeISRSouris(Masque : word;Interup : pointer);

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 12;
    CX := Masque;
    DX := ofs(Interup^);
    ES := seg(Interup^);
    intr(IntSouris, Reg);
  End;
End;

{}

Procedure StyloOptiqueMarche;

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 13;
    intr(IntSouris, Reg);
  End;
End;

{}

Procedure StyloOptiqueArret;

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 14;
    intr(IntSouris, Reg);
  End;
End;

{}

Procedure RatioSouris (Horiz , Vert : word);

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 15;
    CX := Horiz;
    DX := Vert;
    intr(IntSouris, Reg);
  End;
End;

{}

Procedure CacheSourisDsZone(X1,Y1,X2,Y2 : word);

Var
  Tmp1 : integer;
  Tmp2 : integer;

Begin
  if SourisUtil then
  Begin
    Tmp1 := MiniEntier(X1,X2);
    Tmp2 := MaxiEntier(X1,X2);
    X1 := Tmp1;
    X2 := Tmp2;
    Tmp1 := MiniEntier(Y1,Y2);
    Tmp2 := MaxiEntier(Y1,Y2);
    Y1 := Tmp1;
    Y2 := Tmp2;
    with Reg do
    Begin
      AX := 16;
      CX := X1;
      DX := X2;
      SI := Y1;
      DI := Y2;
      intr(IntSouris, Reg);
    End;
  End;
End;

{}

Procedure DoubleVitesseSouris(Seuil : word);

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 19;
    DX := Seuil;
    intr(IntSouris, Reg);
  End;
End;

{}

Procedure EchangeISRSouris(Var Masque : word;Var Interup : pointer);

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 20;
    CX := Masque;
    DX := ofs(Interup^);
    ES := seg(Interup^);
    intr(IntSouris, Reg);
    Masque := CX;
    Interup := ptr(ES,DX);
  End;
End;

{}

Function TailleEtatSouris : integer;

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 21;
    intr(IntSouris, Reg);
    TailleEtatSouris := BX;
  End;
End;

{}

Procedure SauveEtatSouris(Var Buffer : pointer);

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 22;
    DX := ofs(Buffer^);
    ES := seg(Buffer^);
    intr(IntSouris, Reg);
  End;
End;

{}

Procedure RestitueEtatSouris(Var Buffer : pointer);

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 23;
    DX := ofs(Buffer^);
    ES := seg(Buffer^);
    intr(IntSouris, Reg);
  End;
End;

{}

Procedure SensibiliteSouris(Horiz, Vert,Seuil : word);

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 26;
    BX := Horiz;
    CX := Vert;
    DX := Seuil;
    intr(IntSouris, Reg);
  End;
End;

{}

Procedure LitSensibiliteSouris(Horiz, Vert,Seuil : word);

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 27;
    BX := Horiz;
    CX := Vert;
    DX := Seuil;
    intr(IntSouris, Reg);
  End;
End;

{}

Procedure ChangePageSouris(Page : word);

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 29;
    BX := Page;
    intr(IntSouris, Reg);
  End;
End;

{}

Function PageSouris : word;

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 30;
    intr(IntSouris, Reg);
    PageSouris := BX;
  End;
End;

{}

Function ClickSouris(Var Bouton : byte) : boolean;

Begin
  if SourisUtil then
  with Reg do
  Begin
    AX := 3;
    intr(IntSouris, Reg);
    Bouton := BX;
    ClickSouris := (Bouton and 7) <> 0;
  End;
End;

{}

Function ClickSourisDsZone(Var Souris : PosRec;X1,Y1,X2,Y2 : word) : boolean;

Var
  Tmp1 : integer;
  Tmp2 : integer;

Begin
  if SourisUtil then
  Begin
    Tmp1 := MiniEntier(X1,X2);
    Tmp2 := MaxiEntier(X1,X2);
    X1 := Tmp1;
    X2 := Tmp2;
    Tmp1 := MiniEntier(Y1,Y2);
    Tmp2 := MaxiEntier(Y1,Y2);
    Y1 := Tmp1;
    Y2 := Tmp2;
    with Reg, Souris do
    Begin
      AX := 3;
      intr(IntSouris, Reg);
      Bouton  := BX;
      Nombre  := -1;
      Colonne := CX;
      Ligne   := DX;
      ClickSourisDsZone := false;
      if (Bouton and 7) <> 0 then
        if (Colonne >= X1) and (Colonne <= X2) then
          if (Ligne >= Y1) and (Ligne <= Y2) then ClickSourisDsZone := true;
    End;
  End;
End;

{}

Procedure DelaiSouris (Delai : word);

Var
  Heures,Minutes,Secondes,Centiemes : Word;
  Fin    : longint;
  Actuel : longint;
  Bouton : byte;
  Ecoule : boolean;

Begin
  gettime(Heures,Minutes,Secondes,Centiemes);
  Fin := Heures * 36000 + Minutes * 6000 + Secondes * 100 + Centiemes + Delai;
  repeat
    gettime(Heures,Minutes,Secondes,Centiemes);
    Actuel := Heures * 36000 + Minutes * 6000 + Secondes * 100 + Centiemes;
    Ecoule := Actuel >= Fin;
  until (not ClickSouris(Bouton)) or Ecoule;
End;

{}
{ Ligne[1] a Ligne[16] masque ecran : les zeros affichent la couleur de fond }
{ les uns affichent ce qui est ecrit                                         }
{ Ligne[17] a Ligne[32] masque curseur : les uns s'affichent en blanc        }
{}

Procedure CurseurFleche;

Begin
  if SourisUtil then
  Begin
    with Curseur^ do
    Begin
      Ligne[1] := $3FFF;
      Ligne[2] := $1FFF;
      Ligne[3] := $0FFF;
      Ligne[4] := $07FF;
      Ligne[5] := $03FF;
      Ligne[6] := $01FF;
      Ligne[7] := $00FF;
      Ligne[8] := $007F;
      Ligne[9] := $003F;
      Ligne[10] := $001F;
      Ligne[11] := $01FF;
      Ligne[12] := $10FF;
      Ligne[13] := $30FF;
      Ligne[14] := $F87F;
      Ligne[15] := $F87F;
      Ligne[16] := $FC3F;

      Ligne[17] := $0000;
      Ligne[18] := $4000;
      Ligne[19] := $6000;
      Ligne[20] := $7000;
      Ligne[21] := $7800;
      Ligne[22] := $7C00;
      Ligne[23] := $7E00;
      Ligne[24] := $7F00;
      Ligne[25] := $7F80;
      Ligne[26] := $7FC0;
      Ligne[27] := $7C00;
      Ligne[28] := $4600;
      Ligne[29] := $0600;
      Ligne[30] := $0300;
      Ligne[31] := $0300;
      Ligne[32] := $0000;

      XPoint := 0;
      YPoint := 0;
    End;
    SourisGr(Curseur);
  End;
End;

{}

Procedure CurseurFlecheHaute;

Begin
  if SourisUtil then
  Begin
    with Curseur^ do
    Begin
      Ligne[1] := $FE7F;
      Ligne[2] := $FC3F;
      Ligne[3] := $FC3F;
      Ligne[4] := $F81F;
      Ligne[5] := $F81F;
      Ligne[6] := $F00F;
      Ligne[7] := $F00F;
      Ligne[8] := $E007;
      Ligne[9] := $E007;
      Ligne[10] := $C003;
      Ligne[11] := $FC3F;
      Ligne[12] := $FC3F;
      Ligne[13] := $FC3F;
      Ligne[14] := $FC3F;
      Ligne[15] := $FC3F;
      Ligne[16] := $FC3F;

      Ligne[17] := $0000;
      Ligne[18] := $0180;
      Ligne[19] := $0180;
      Ligne[20] := $03C0;
      Ligne[21] := $03C0;
      Ligne[22] := $07E0;
      Ligne[23] := $07E0;
      Ligne[24] := $0FF0;
      Ligne[25] := $0FF0;
      Ligne[26] := $0180;
      Ligne[27] := $0180;
      Ligne[28] := $0180;
      Ligne[29] := $0180;
      Ligne[30] := $0180;
      Ligne[31] := $0180;
      Ligne[32] := $0000;

      XPoint := 7;
      YPoint := 1;
    End;
    SourisGr(Curseur);
  End;
End;

{}

Procedure CurseurFlecheBasse;

Begin
  if SourisUtil then
  Begin
    with Curseur^ do
    Begin
      Ligne[1] := $FC3F;
      Ligne[2] := $FC3F;
      Ligne[3] := $FC3F;
      Ligne[4] := $FC3F;
      Ligne[5] := $FC3F;
      Ligne[6] := $FC3F;
      Ligne[7] := $C003;
      Ligne[8] := $E007;
      Ligne[9] := $E007;
      Ligne[10] := $F00F;
      Ligne[11] := $F00F;
      Ligne[12] := $F81F;
      Ligne[13] := $F81F;
      Ligne[14] := $FC3F;
      Ligne[15] := $FC3F;
      Ligne[16] := $FE7F;

      Ligne[17] := $0000;
      Ligne[18] := $0180;
      Ligne[19] := $0180;
      Ligne[20] := $0180;
      Ligne[21] := $0180;
      Ligne[22] := $0180;
      Ligne[23] := $0180;
      Ligne[24] := $0FF0;
      Ligne[25] := $0FF0;
      Ligne[26] := $07E0;
      Ligne[27] := $07E0;
      Ligne[28] := $03C0;
      Ligne[29] := $03C0;
      Ligne[30] := $0180;
      Ligne[31] := $0180;
      Ligne[32] := $0000;

      XPoint := 7;
      YPoint := 14;
    End;
    SourisGr(Curseur);
  End;
End;

{}

Procedure CurseurFlecheGauche;

Begin
  if SourisUtil then
  Begin
    with Curseur^ do
    Begin
      Ligne[1] := $FFFF;
      Ligne[2] := $FFFF;
      Ligne[3] := $FFFF;
      Ligne[4] := $FE7F;
      Ligne[5] := $F83F;
      Ligne[6] := $E03F;
      Ligne[7] := $8000;
      Ligne[8] := $0000;
      Ligne[9] := $0000;
      Ligne[10] := $8000;
      Ligne[11] := $E03F;
      Ligne[12] := $F83F;
      Ligne[13] := $FE7F;
      Ligne[14] := $FFFF;
      Ligne[15] := $FFFF;
      Ligne[16] := $FFFF;

      Ligne[17] := $0000;
      Ligne[18] := $0000;
      Ligne[19] := $0000;
      Ligne[20] := $0000;
      Ligne[21] := $0180;
      Ligne[22] := $0780;
      Ligne[23] := $1F80;
      Ligne[24] := $7FFE;
      Ligne[25] := $7FFE;
      Ligne[26] := $1F80;
      Ligne[27] := $0780;
      Ligne[28] := $0180;
      Ligne[29] := $0000;
      Ligne[30] := $0000;
      Ligne[31] := $0000;
      Ligne[32] := $0000;

      XPoint := 1;
      YPoint := 7;
    End;
    SourisGr(Curseur);
  End;
End;

{}

Procedure CurseurFlecheDroite;

Begin
  if SourisUtil then
  Begin
    with Curseur^ do
    Begin
      Ligne[1] := $FFFF;
      Ligne[2] := $FFFF;
      Ligne[3] := $FFFF;
      Ligne[4] := $FE7F;
      Ligne[5] := $FC1F;
      Ligne[6] := $FC07;
      Ligne[7] := $0001;
      Ligne[8] := $0000;
      Ligne[9] := $0000;
      Ligne[10] := $0001;
      Ligne[11] := $FC07;
      Ligne[12] := $FC1F;
      Ligne[13] := $FE7F;
      Ligne[14] := $FFFF;
      Ligne[15] := $FFFF;
      Ligne[16] := $FFFF;

      Ligne[17] := $0000;
      Ligne[18] := $0000;
      Ligne[19] := $0000;
      Ligne[20] := $0000;
      Ligne[21] := $0180;
      Ligne[22] := $01E0;
      Ligne[23] := $01F8;
      Ligne[24] := $7FFE;
      Ligne[25] := $7FFE;
      Ligne[26] := $01F8;
      Ligne[27] := $01E0;
      Ligne[28] := $0180;
      Ligne[29] := $0000;
      Ligne[30] := $0000;
      Ligne[31] := $0000;
      Ligne[32] := $0000;

      XPoint := 15;
      YPoint := 7;
    End;
    SourisGr(Curseur);
  End;
End;

{}

Procedure CurseurCroix;

Begin
  if SourisUtil then
  Begin
    with Curseur^ do
    Begin
      Ligne[1] := $FFFF;
      Ligne[2] := $FFFF;
      Ligne[3] := $FFFF;
      Ligne[4] := $FFFF;
      Ligne[5] := $FFFF;
      Ligne[6] := $FFFF;
      Ligne[7] := $FFFF;
      Ligne[8] := $FFFF;
      Ligne[9] := $FFFF;
      Ligne[10] := $FFFF;
      Ligne[11] := $FFFF;
      Ligne[12] := $FFFF;
      Ligne[13] := $FFFF;
      Ligne[14] := $FFFF;
      Ligne[15] := $FFFF;
      Ligne[16] := $FFFF;

      Ligne[17] := $0100;
      Ligne[18] := $0100;
      Ligne[19] := $0100;
      Ligne[20] := $0100;
      Ligne[21] := $0100;
      Ligne[22] := $0100;
      Ligne[23] := $0100;
      Ligne[24] := $FFFE;
      Ligne[25] := $0100;
      Ligne[26] := $0100;
      Ligne[27] := $0100;
      Ligne[28] := $0100;
      Ligne[29] := $0100;
      Ligne[30] := $0100;
      Ligne[31] := $0100;
      Ligne[32] := $0000;

      XPoint := 7;
      YPoint := 7;
    End;
    SourisGr(Curseur);
  End;
End;

{}

Procedure CurseurMainHaute;

Begin
  if SourisUtil then
  Begin
    with Curseur^ do
    Begin
      Ligne[1] := $F3FF;
      Ligne[2] := $E1FF;
      Ligne[3] := $C0FF;
      Ligne[4] := $C0FF;
      Ligne[5] := $C049;
      Ligne[6] := $C000;
      Ligne[7] := $C000;
      Ligne[8] := $8000;
      Ligne[9] := $0000;
      Ligne[10] := $0000;
      Ligne[11] := $0000;
      Ligne[12] := $0000;
      Ligne[13] := $0000;
      Ligne[14] := $0000;
      Ligne[15] := $8001;
      Ligne[16] := $C003;

      Ligne[17] := $0000;
      Ligne[18] := $0C00;
      Ligne[19] := $1200;
      Ligne[20] := $1200;
      Ligne[21] := $1200;
      Ligne[22] := $13B6;
      Ligne[23] := $124A;
      Ligne[24] := $124A;
      Ligne[25] := $724A;
      Ligne[26] := $7002;
      Ligne[27] := $5002;
      Ligne[28] := $5002;
      Ligne[29] := $4002;
      Ligne[30] := $4002;
      Ligne[31] := $3FFC;
      Ligne[32] := $0000;

      XPoint := 5;
      YPoint := 0;
    End;
    SourisGr(Curseur);
  End;
End;

{}

Procedure CurseurMainBasse;

Begin
  if SourisUtil then
  Begin
    with Curseur^ do
    Begin
      Ligne[1] := $C003;
      Ligne[2] := $8001;
      Ligne[3] := $0000;
      Ligne[4] := $0000;
      Ligne[5] := $0000;
      Ligne[6] := $0000;
      Ligne[7] := $0000;
      Ligne[8] := $0000;
      Ligne[9] := $8000;
      Ligne[10] := $C000;
      Ligne[11] := $C000;
      Ligne[12] := $C049;
      Ligne[13] := $C0FF;
      Ligne[14] := $C0FF;
      Ligne[15] := $E1FF;
      Ligne[16] := $F3FF;

      Ligne[17] := $0000;
      Ligne[18] := $3FFC;
      Ligne[19] := $4002;
      Ligne[20] := $4002;
      Ligne[21] := $5002;
      Ligne[22] := $5002;
      Ligne[23] := $7002;
      Ligne[24] := $724A;
      Ligne[25] := $124A;
      Ligne[26] := $124A;
      Ligne[27] := $13B6;
      Ligne[28] := $1200;
      Ligne[29] := $1200;
      Ligne[30] := $1200;
      Ligne[31] := $0C00;
      Ligne[32] := $0000;

      XPoint := 5;
      YPoint := 15;
    End;
    SourisGr(Curseur);
  End;
End;

{}

Procedure CurseurMainGauche;

Begin
  if SourisUtil then
  Begin
    with Curseur^ do
    Begin
      Ligne[1] := $FFFF;
      Ligne[2] := $FF8F;
      Ligne[3] := $FF07;
      Ligne[4] := $FF03;
      Ligne[5] := $FF81;
      Ligne[6] := $8000;
      Ligne[7] := $0000;
      Ligne[8] := $0000;
      Ligne[9] := $0000;
      Ligne[10] := $8000;
      Ligne[11] := $F000;
      Ligne[12] := $F800;
      Ligne[13] := $F800;
      Ligne[14] := $FC00;
      Ligne[15] := $FC01;
      Ligne[16] := $FC03;

      Ligne[17] := $0000;
      Ligne[18] := $0000;
      Ligne[19] := $0070;
      Ligne[20] := $0048;
      Ligne[21] := $0024;
      Ligne[22] := $0032;
      Ligne[23] := $7FF2;
      Ligne[24] := $800A;
      Ligne[25] := $7FF6;
      Ligne[26] := $0412;
      Ligne[27] := $07F2;
      Ligne[28] := $0212;
      Ligne[29] := $03F2;
      Ligne[30] := $0116;
      Ligne[31] := $01FC;
      Ligne[32] := $0000;

      XPoint := 0;
      YPoint := 7;
    End;
    SourisGr(Curseur);
  End;
End;

{}

Procedure CurseurMainDroite;

Begin
  if SourisUtil then
  Begin
    with Curseur^ do
    Begin
      Ligne[1] := $FFFF;
      Ligne[2] := $F1FF;
      Ligne[3] := $E0FF;
      Ligne[4] := $C0FF;
      Ligne[5] := $81FF;
      Ligne[6] := $0001;
      Ligne[7] := $0000;
      Ligne[8] := $0000;
      Ligne[9] := $0000;
      Ligne[10] := $0001;
      Ligne[11] := $000F;
      Ligne[12] := $001F;
      Ligne[13] := $001F;
      Ligne[14] := $003F;
      Ligne[15] := $803F;
      Ligne[16] := $C03F;

      Ligne[17] := $0000;
      Ligne[18] := $0000;
      Ligne[19] := $0E00;
      Ligne[20] := $1200;
      Ligne[21] := $2400;
      Ligne[22] := $4C00;
      Ligne[23] := $4FFE;
      Ligne[24] := $5001;
      Ligne[25] := $6FFE;
      Ligne[26] := $4820;
      Ligne[27] := $4FE0;
      Ligne[28] := $4840;
      Ligne[29] := $4FC0;
      Ligne[30] := $6880;
      Ligne[31] := $3F80;
      Ligne[32] := $0000;

      XPoint := 15;
      YPoint := 7;
    End;
    SourisGr(Curseur);
  End;
End;

{}

Procedure CurseurMainStop;

Begin
  if SourisUtil then
  Begin
    with Curseur^ do
    Begin
      Ligne[1] := $FE3F;
      Ligne[2] := $F80F;
      Ligne[3] := $F007;
      Ligne[4] := $F003;
      Ligne[5] := $F001;
      Ligne[6] := $F001;
      Ligne[7] := $0001;
      Ligne[8] := $0001;
      Ligne[9] := $0010;
      Ligne[10] := $0001;
      Ligne[11] := $8001;
      Ligne[12] := $C001;
      Ligne[13] := $C001;
      Ligne[14] := $E003;
      Ligne[15] := $F007;
      Ligne[16] := $F80F;

      Ligne[17] := $0000;
      Ligne[18] := $01C0;
      Ligne[19] := $0770;
      Ligne[20] := $0550;
      Ligne[21] := $055C;
      Ligne[22] := $0554;
      Ligne[23] := $0554;
      Ligne[24] := $7554;
      Ligne[25] := $5554;
      Ligne[26] := $4FFC;
      Ligne[27] := $2804;
      Ligne[28] := $1004;
      Ligne[29] := $180C;
      Ligne[30] := $0C18;
      Ligne[31] := $07F0;
      Ligne[32] := $0000;

      XPoint := 7;
      YPoint := 7;
    End;
    SourisGr(Curseur);
  End;
End;

{}

Procedure CurseurSablier;

Begin
  if SourisUtil then
  Begin
    with Curseur^ do
    Begin
      Ligne[1] := $0000;
      Ligne[2] := $0000;
      Ligne[3] := $0000;
      Ligne[4] := $8001;
      Ligne[5] := $C003;
      Ligne[6] := $E007;
      Ligne[7] := $F00F;
      Ligne[8] := $F81F;
      Ligne[9] := $F81F;
      Ligne[10] := $F00F;
      Ligne[11] := $E007;
      Ligne[12] := $C003;
      Ligne[13] := $8001;
      Ligne[14] := $0000;
      Ligne[15] := $0000;
      Ligne[16] := $0000;

      Ligne[17] := $0000;
      Ligne[18] := $7FFE;
      Ligne[19] := $6006;
      Ligne[20] := $300C;
      Ligne[21] := $1818;
      Ligne[22] := $0C30;
      Ligne[23] := $0660;
      Ligne[24] := $0240;
      Ligne[25] := $0240;
      Ligne[26] := $0660;
      Ligne[27] := $0DB0;
      Ligne[28] := $1BD8;
      Ligne[29] := $37EC;
      Ligne[30] := $67E6;
      Ligne[31] := $7FFE;
      Ligne[32] := $0000;

      XPoint := 0;
      YPoint := 0;
    End;
    SourisGr(Curseur);
  End;
End;

{}

Procedure CurseurInser;

Begin
  if SourisUtil then
  Begin
    with Curseur^ do
    Begin
      Ligne[1] := $FFFF;
      Ligne[2] := $FDBF;
      Ligne[3] := $F99F;
      Ligne[4] := $F18F;
      Ligne[5] := $E187;
      Ligne[6] := $C003;
      Ligne[7] := $8001;
      Ligne[8] := $0000;
      Ligne[9] := $0000;
      Ligne[10] := $8001;
      Ligne[11] := $C003;
      Ligne[12] := $E187;
      Ligne[13] := $F18F;
      Ligne[14] := $F99F;
      Ligne[15] := $FDBF;
      Ligne[16] := $FFFF;

      Ligne[17] := $0000;
      Ligne[18] := $0000;
      Ligne[19] := $0000;
      Ligne[20] := $0420;
      Ligne[21] := $0C30;
      Ligne[22] := $1C38;
      Ligne[23] := $3FFC;
      Ligne[24] := $7FFE;
      Ligne[25] := $7FFE;
      Ligne[26] := $3FFC;
      Ligne[27] := $1C38;
      Ligne[28] := $0C30;
      Ligne[29] := $0420;
      Ligne[30] := $0000;
      Ligne[31] := $0000;
      Ligne[32] := $0000;

      XPoint := 7;
      YPoint := 7;
    End;
    SourisGr(Curseur);
  End;
End;

{}

Procedure CurseurCoche;

Begin
  if SourisUtil then
  Begin
    with Curseur^ do
    Begin
      Ligne[1] := $FFF0;
      Ligne[2] := $FFE0;
      Ligne[3] := $FFC0;
      Ligne[4] := $FF81;
      Ligne[5] := $FF03;
      Ligne[6] := $0607;
      Ligne[7] := $000F;
      Ligne[8] := $001F;
      Ligne[9] := $C03F;
      Ligne[10] := $F07F;
      Ligne[11] := $FFFF;
      Ligne[12] := $FFFF;
      Ligne[13] := $FFFF;
      Ligne[14] := $FFFF;
      Ligne[15] := $FFFF;
      Ligne[16] := $FFFF;

      Ligne[17] := $0000;
      Ligne[18] := $0006;
      Ligne[19] := $000C;
      Ligne[20] := $0018;
      Ligne[21] := $0030;
      Ligne[22] := $0060;
      Ligne[23] := $70C0;
      Ligne[24] := $1D80;
      Ligne[25] := $0700;
      Ligne[26] := $0000;
      Ligne[27] := $0000;
      Ligne[28] := $0000;
      Ligne[29] := $0000;
      Ligne[30] := $0000;
      Ligne[31] := $0000;
      Ligne[32] := $0000;

      XPoint := 6;
      YPoint := 7;
    End;
    SourisGr(Curseur);
  End;
End;

{}

Procedure CurseurMontre;

Begin
  if SourisUtil then
  Begin
    with Curseur^ do
    Begin
      Ligne[1] := $E007;
      Ligne[2] := $E007;
      Ligne[3] := $E007;
      Ligne[4] := $C003;
      Ligne[5] := $8001;
      Ligne[6] := $8001;
      Ligne[7] := $8000;
      Ligne[8] := $8000;
      Ligne[9] := $8000;
      Ligne[10] := $8000;
      Ligne[11] := $8001;
      Ligne[12] := $8001;
      Ligne[13] := $C003;
      Ligne[14] := $E007;
      Ligne[15] := $E007;
      Ligne[16] := $E007;

      Ligne[17] := $0000;
      Ligne[18] := $0FF0;
      Ligne[19] := $0FF0;
      Ligne[20] := $0FF0;
      Ligne[21] := $1008;
      Ligne[22] := $2084;
      Ligne[23] := $2084;
      Ligne[24] := $2086;
      Ligne[25] := $2F86;
      Ligne[26] := $2004;
      Ligne[27] := $2004;
      Ligne[28] := $1008;
      Ligne[29] := $0FF0;
      Ligne[30] := $0FF0;
      Ligne[31] := $0FF0;
      Ligne[32] := $0000;

      XPoint := 7;
      YPoint := 7;
    End;
    SourisGr(Curseur);
  End;
End;

{}

Procedure CurseurPendule;

Begin
  if SourisUtil then
  Begin
    with Curseur^ do
    Begin
      Ligne[1] := $FFFF;
      Ligne[2] := $C003;
      Ligne[3] := $8001;
      Ligne[4] := $0000;
      Ligne[5] := $0000;
      Ligne[6] := $0000;
      Ligne[7] := $0000;
      Ligne[8] := $0000;
      Ligne[9] := $0000;
      Ligne[10] := $0000;
      Ligne[11] := $0000;
      Ligne[12] := $0000;
      Ligne[13] := $0000;
      Ligne[14] := $8001;
      Ligne[15] := $C003;
      Ligne[16] := $FFFF;

      Ligne[17] := $0000;
      Ligne[18] := $0000;
      Ligne[19] := $1FF8;
      Ligne[20] := $2004;
      Ligne[21] := $4992;
      Ligne[22] := $4022;
      Ligne[23] := $4042;
      Ligne[24] := $518A;
      Ligne[25] := $4782;
      Ligne[26] := $4002;
      Ligne[27] := $4992;
      Ligne[28] := $4002;
      Ligne[29] := $2004;
      Ligne[30] := $1FF8;
      Ligne[31] := $0000;
      Ligne[32] := $0000;

      XPoint := 7;
      YPoint := 7;
    End;
    SourisGr(Curseur);
  End;
End;

{}

Procedure CurseurSpe;

Begin
  if SourisUtil then
  Begin
    with Curseur^ do
    Begin
      Ligne[1] := $FFFF;
      Ligne[2] := $E00F;
      Ligne[3] := $C007;
      Ligne[4] := $8003;
      Ligne[5] := $0001;
      Ligne[6] := $0001;
      Ligne[7] := $0001;
      Ligne[8] := $0001;
      Ligne[9] := $0001;
      Ligne[10] := $0001;
      Ligne[11] := $0001;
      Ligne[12] := $0001;
      Ligne[13] := $0001;
      Ligne[14] := $8003;
      Ligne[15] := $C007;
      Ligne[16] := $E00F;

      Ligne[17] := $0000;
      Ligne[18] := $0000;
      Ligne[19] := $1FF0;
      Ligne[20] := $3FF8;
      Ligne[21] := $783C;
      Ligne[22] := $739C;
      Ligne[23] := $739C;
      Ligne[24] := $7F3C;
      Ligne[25] := $7E7C;
      Ligne[26] := $7E7C;
      Ligne[27] := $7FFC;
      Ligne[28] := $7E7C;
      Ligne[29] := $7E7C;
      Ligne[30] := $3FF8;
      Ligne[31] := $1FF0;
      Ligne[32] := $0000;

      XPoint := 7;
      YPoint := 7;
    End;
    SourisGr(Curseur);
  End;
End;

{}

Procedure PosSourisPosTx(Xs,Ys : word;VAR X,Y : byte);

Begin
  X := (Xs div 8) + 1;
  Y := (Ys div 8) + 1;
End;

{}

Procedure PosTxPosSouris(X,Y : byte;VAR Xs,Ys : word);

Begin
  Xs := (X - 1) * 8;
  Ys := (Y - 1) * 8;
End;

{}

Function SourisDsZone(X,Y,X1,Y1,X2,Y2 : word):boolean;

Var
  Ok   : boolean;
  Tmp1 : integer;
  Tmp2 : integer;

Begin
  Ok := false;
  Tmp1 := MiniEntier(X1,X2);
  Tmp2 := MaxiEntier(X1,X2);
  X1 := Tmp1;
  X2 := Tmp2;
  Tmp1 := MiniEntier(Y1,Y2);
  Tmp2 := MaxiEntier(Y1,Y2);
  Y1 := Tmp1;
  Y2 := Tmp2;
  if (X >= X1) and (X <= X2) then
    if (Y >= Y1) and (Y <= Y2) then Ok := true;
  SourisDsZone := Ok;
End;

{}

Begin
  new(Curseur);
  SourisVis := false;
  TempoSouris := 200;
End.
