{

                            ALRS232  Version 1.0

                         Creation Alain JAFFRE 1995

  ͸
                   Unite ecrite pour TURBO PASCAL 7.0                     
                                                                          
                             Alain JAFFRE                                 
  ;

}

{$I AJRS232.DOC }

IMPLEMENTATION

{}

Type
  Buffer = array[1..65535] of byte;
  PortSerie = record
                Existe    : boolean;    { Port present ? }
                Ouvert    : boolean;    { Port ouvert ? }
                Adresse   : word;       { Adresse du port }
                Irq       : byte;       { Interruption utilisee }
                OldIrq    : byte;       { Valeur precedente de Irq }
                OldVect   : pointer;    { Vecteur de OldIrq }
                Vitesse   : longint;    { 50,75,110,150,300,600,1200,2400,
                                          4800,9600,19200,38400,57600,115200 }
                Parite    : char;       { None,Odd,Even,Mark,Space }
                BitDonnee : byte;       { 5,6,7,8 }
                BitStop   : byte;       { 1,2 }
                CtsRts    : boolean;    { Handshake }
                Buf       : ^Buffer;    { Buffer }
                TailleBuf : word;       { Taille du buffer }
                NbCarEnt  : word;       { Nombre de caractere en entree }
                NbCarSor  : word;       { Nombre de caractere en sortie }
                Registre0 : byte;       { Registre 0 de UART }
                Registre1 : array [1..2] of byte; { Registres 1 de UART }
                Registre2 : byte;       { Registre 2 de UART }
                Registre3 : byte;       { Registre 3 de UART }
                Registre4 : byte;       { Registre 4 de UART }
                Registre5 : byte;       { Registre 5 de UART }
                Registre6 : byte;       { Registre 6 de UART }
              end;
Const
  MaxCom = 4;
  THR    = 0; { Transmitter Holding Register offset }
  RDR    = 0; { Receiver Data Register offset }
  BRDL   = 0; { Baud Rate Divisor Low byte offset }
  BRDH   = 1; { Baud Rate Divisor High byte offset }
  IER    = 1; { Interrupt Enable Register offset }
  IIR    = 2; { Interrupt Identification Register offset }
  LCR    = 3; { Line Control Register offset }
  MCR    = 4; { Modem Control Register offset }
  LSR    = 5; { Line Status Register offset }
  MSR    = 6; { Modem Status Register offset }

  Commande8259 = $20; { Adresse de commande du 8259 }
  Masque8259   = $21; { Adresse de masque du 8259 }
  EOI          = $20;

Var
  Com : array[1..MaxCom] of PortSerie;
  OldExitProc   : pointer;
  OldMasque8259 : byte;

{}

Procedure ArreteInterruptions;

Begin
  inline($FA);
End;

{}

Procedure AutoriseInterruptions;

Begin
  inline($FB);
End;

{}

Procedure IntPort1; interrupt;

Begin
  with Com[1] do
  Begin
    Buf^[NbCarEnt] := port[Adresse];
    inc(NbCarEnt);
    if NbCarEnt > TailleBuf then  NbCarEnt := 1;
  End;
  port[Commande8259] := EOI;
End;

{}

Procedure IntPort2; interrupt;

Begin
  with Com[2] do
  Begin
    Buf^[NbCarEnt] := port[Adresse];
    inc(NbCarEnt);
    if NbCarEnt > TailleBuf then  NbCarEnt := 1;
  End;
  port[Commande8259] := EOI;
End;

{}

Procedure IntPort3; interrupt;

Begin
  with Com[3] do
  Begin
    Buf^[NbCarEnt] := port[Adresse];
    inc(NbCarEnt);
    if NbCarEnt > TailleBuf then  NbCarEnt := 1;
  End;
  port[Commande8259] := EOI;
End;

{}

Procedure IntPort4; interrupt;

Begin
  with Com[4] do
  Begin
    Buf^[NbCarEnt] := port[Adresse];
    inc(NbCarEnt);
    if NbCarEnt > TailleBuf then  NbCarEnt := 1;
  End;
  port[Commande8259] := EOI;
End;

{}

Function DetecteAdresseCom(Num : byte) : word;

Begin
  if Num > Machine.NbSeries then DetecteAdresseCom := 0000
    else
    DetecteAdresseCom := memw[$0000:$0400 + pred(Num) * 2];
End;

{}

Procedure DetecteAdresses;

Var
  N : byte;

Begin
  for N := 1 to Machine.NbSeries do
  Begin
    Com[N].Adresse := memw[$0000:$0400 + pred(N) * 2];
    Com[N].Existe := true;
  End;
  if Machine.NbSeries < MaxCom then
    for N := (Machine.NbSeries + 1) to MaxCom do
    Begin
      Com[N].Adresse := 0000;
      Com[N].Existe := false;
    End;
End;

{}

Function InitCom(Num : byte):byte;

Var
  Diviseur : word;
  Reglage  : byte;

Begin
  if not Com[Num].Existe then InitCom := 1
  else
  with Com[Num] do
  Begin
    Diviseur := 115200 div Vitesse;
    Port[Adresse + LCR] := 128;
    Port[Adresse + BRDL] := lo(Diviseur);
    Port[Adresse + BRDH] := hi(Diviseur);

    Reglage := BitDonnee - 5;

    if BitStop = 2 then Reglage := Reglage or 4;

    case Parite of
      'O' : Reglage := Reglage or 8;
      'E' : Reglage := Reglage or 24;
      'M' : Reglage := Reglage or 40;
      'S' : Reglage := Reglage or 56;
    end;
    Port[Adresse + LCR] := Reglage;
    InitCom := 0;
  End;
End;

{}

Function ChangeReglageCom(Num : byte;Speed: longint;Parity: char;
                Data,Stop : byte;HandShake : boolean; Taille : word):byte;

Var
  Tmp : byte;

Begin
  if Com[Num].Ouvert then
  Begin
    with Com[Num] do
    Begin
      for Tmp := 1 to 2 do WriteCom(Num,0);
      Vitesse   := Speed;
      Parite    := Parity;
      BitDonnee := Data;
      BitStop   := Stop;
      CtsRts    := HandShake;
      TailleBuf := Taille;
    End;
    ChangeReglageCom := InitCom(Num);
  End
  else ChangeReglageCom := 2;
End;

{}

Procedure InitBuffer(Num : byte);

Begin
  with Com[Num] do
  Begin
    NbCarEnt  := 1;
    NbCarSor  := 1;
  End;
End;

{}

Procedure FixePrioriteIrq(Num : byte);

Var
  Valeur : byte;

Begin
  if Num = 0 then Valeur := 199
             else Valeur := 191 + Num;
  ArreteInterruptions;
  Port[Commande8259] := Valeur;
  AutoriseInterruptions;
End;

{}
Function OuvreCom(Num : byte;Speed: longint;Parity: char;
                Data,Stop : byte;HandShake : boolean; Taille : word):byte;

Var
  IntVect : pointer;

Begin
  if Com[Num].Existe then
    with Com[Num] do
    if Ouvert then OuvreCom := 3
    else
    Begin
      Vitesse   := Speed;
      Parite    := Parity;
      BitDonnee := Data;
      BitStop   := Stop;
      CtsRts    := HandShake;
      TailleBuf := Taille;
      InitBuffer(Num);

      getmem(Buf,TailleBuf);
      getintvec($08 + Irq,OldVect);
      OldIrq := port[Masque8259] or not (1 shl Irq);

      Registre1[1] := port[Adresse + IER];
      Registre4 := port[Adresse + MCR];
      Registre6 := port[Adresse + MSR];
      Registre3 := port[Adresse + LCR];

      port[Adresse + LCR] := 128;
      Registre0 := port[Adresse + BRDL];
      Registre1[2] := port[Adresse + BRDH];
      port[Adresse + LCR] := Registre3;

      case Num of
        1 : IntVect := @IntPort1;
        2 : IntVect := @IntPort2;
        3 : IntVect := @IntPort3;
        4 : IntVect := @IntPort4;
      end;

      ArreteInterruptions;
      setintvec($08 + Irq,IntVect);
      port[Adresse + MCR] := 8;
      port[Adresse + IER] := 1;
      port[Masque8259] := port[Masque8259] and not (1 shl Irq);
      AutoriseInterruptions;

      OuvreCom := InitCom(Num);

      if port[Adresse + RDR] = 0 then; { Suppression caracteres presents }
      if port[Adresse + LSR] = 0 then; { Raz du LSR }
      port[Adresse + MCR] := port[Adresse + MCR] or 1; { DTR }

      Ouvert := true;
    End
    else OuvreCom := 1;
End;

{}

Function FermeCom(Num : byte):byte;

Var
  Tmp : byte;

Begin
  if Com[Num].Ouvert then
    with Com[Num] do
    Begin
      for Tmp := 1 to 2 do WriteCom(Num,0);

      freemem(Buf,TailleBuf);

      ArreteInterruptions;
      port[Masque8259] := port[Masque8259] or (1 shl Irq) and OldIrq;
      port[Adresse + MCR] := Registre4;
      port[Adresse + IER] := Registre1[1];
      setintvec($08 + Irq,OldVect);
      AutoriseInterruptions;

      port[Adresse + LCR] := 128;
      port[Adresse + BRDL] := Registre0;
      port[Adresse + BRDH] := Registre1[2];
      port[Adresse + LCR] := Registre3;
      port[Adresse + MSR] := Registre6;

      Ouvert := false;
      FermeCom := 0;
    End
    else FermeCom := 2;
End;

{}

Function ResetCom(Num : byte):byte;

Begin
  if not Com[Num].Existe then ResetCom := 1
   else if not Com[Num].Ouvert then ResetCom := 2
   else
    with Com[Num] do
    Begin
      InitBuffer(Num);
      ResetCom := InitCom(Num);
      if port[Adresse + RDR] = 0 then; { Suppression caracteres presents }
      if port[Adresse + LSR] = 0 then; { Raz du LSR }
    End;
End;

{}

Function WriteCom(Num : byte;Valeur : byte):byte;

Var
  Compteur : integer;

Begin
  if Com[Num].Ouvert then
  with Com[Num] do
  Begin
    WriteCom := 0;
    while Port[Adresse + LSR] and 32 = 0 do;   { Attente caractere }
    if not CtsRts then Port[Adresse] := Valeur
    else
    Begin
      Port[Adresse + MCR] := 11;  { Met DTR,RTS,OUT 2 }

      Compteur := MaxInt;
      while (Port[Adresse +MSR] and 16 = 0) and (Compteur <> 0) do
        dec(Compteur);  { Attente CTS }
      if Compteur <> 0 then Port[Adresse] := Valeur
                       else WriteCom := 4;
    End;
  End
  else WriteCom := 2;
End;

{}

Function ReadCom(Num : byte;Var Valeur : byte):byte;

Begin
  if Com[Num].Ouvert then
  with Com[Num] do
  Begin
    if NbCarEnt <> NbCarSor then    { caractere present ? }
    Begin
      Valeur := Buf^[NbCarSor];
      inc(NbCarSor);
      if NbCarSor > TailleBuf then NbCarSor := 1;
      ReadCom := 0;
    End
    else ReadCom := 5;
  End
  else ReadCom := 2;
End;

{}

Function ChangeComAdresse(Num : byte;Adr : word):byte;

Begin
  if Com[Num].Existe then
    with Com[Num] do
    Begin
      Adresse := Adr;
      ChangeComAdresse := 0;
    End
    else ChangeComAdresse := 1;
End;

{}

Function LitComAdresse(Num : byte;Var Adr : word):byte;

Begin
  if Com[Num].Existe then
    with Com[Num] do
    Begin
      Adr := Adresse;
      LitComAdresse := 0;
    End
    else LitComAdresse := 1;
End;

{}

Function ChangeComIrq(Num : byte;Inter : byte):byte;

Begin
  if Com[Num].Existe then
    with Com[Num] do
    Begin
      Irq := Inter;
      ChangeComIrq := 0;
    End
    else ChangeComIrq := 1;
End;

{}

Function LitComIrq(Num : byte;Var Inter : byte):byte;

Begin
  if Com[Num].Existe then
    with Com[Num] do
    Begin
      Inter := Irq;
      LitComIrq := 0;
    End
    else LitComIrq := 1;
End;

{}

Function ChangeComConfig(Num : byte;Speed: longint;Parity: char;
                Data,Stop : byte;HandShake : boolean; Taille : word):byte;

Begin
  if Com[Num].Existe then
  Begin
    with Com[Num] do
    Begin
      Vitesse   := Speed;
      Parite    := Parity;
      BitDonnee := Data;
      BitStop   := Stop;
      CtsRts    := HandShake;
      TailleBuf := Taille;
    End;
    ChangeComConfig := 0;
  End
  else ChangeComConfig := 1;
End;

{}

Function LitComConfig(Num : byte;Var Speed: longint;Var Parity: char;
        Var Data,Stop : byte;Var HandShake : boolean;Var Taille : word):byte;

Begin
  if Com[Num].Existe then
    with Com[Num] do
    Begin
      Speed     := Vitesse;
      Parity    := Parite;
      Data      := BitDonnee;
      Stop      := BitStop;
      HandShake := CtsRts;
      Taille    := TailleBuf;
      LitComConfig := 0;
    End
    else LitComConfig := 1;
End;

{}

Procedure DeInit;

Var
  N : byte;

Begin
  for N := 1 to MaxCom do FermeCom(N);
  ArreteInterruptions;
  Port[Masque8259] := OldMasque8259;
  Port[Commande8259] := 199;
  AutoriseInterruptions;
  ExitProc := OldExitProc;
End;

{}

Procedure Init;

Var
  N : byte;

Begin
  OldExitProc := ExitProc;
  ExitProc    := @DeInit;
  OldMasque8259 := Port[Masque8259];

  for N := 1 to MaxCom do
    with Com[N] do
    Begin
      if N in [1,3] then Irq := 4;
      if N in [2,4] then Irq := 3;
      Vitesse   := 110;
      Parite    := 'E';
      BitDonnee := 7;
      BitStop   := 1;
      CtsRts    := true;
      TailleBuf := 4096;
    End;
    DetecteAdresses;
End;

{}

Begin
  Init;
End.