{

                           AJMENUTX  Version 1.0

                         Creation Alain JAFFRE 1996

  ͸
                   Unite ecrite pour TURBO PASCAL 7.0                     
                                                                          
                             Alain JAFFRE                                 
  ;

}

{$I AJMENUTX.DOC }

IMPLEMENTATION

Var
  SousMenu1      : DialogRecTx;
  SousMenu2      : DialogRecTx;
  SauveMenu1     : TypeSauveTx;
  AncienneAide   : RecLigneAide;

{}

Procedure InitMenuTx(Var Menu : BarreMenuTxPtr);

Begin
  if MemAvail > sizeof(Menu) then
  Begin
    new(Menu);
    with Menu^ do
    Begin
      NbPeres      := 0;
      PereActif    := 0;
      AncienPere   := 0;
      NbSsMenu     := 0;
      SsMenuOuvert := 0;
    End;
  End
  else
  Begin
    PlusDeMemoireTx;
    Halt(1);
  End;
End;

{}

Procedure LibereMenuTx(Var Menu : BarreMenuTxPtr);

Var
  M,N : byte;

Begin
  with Menu^ do
  Begin
    if NbPeres <> 0 then
      for M := 1 to NbPeres do
      Begin
        with Pere[M] do
          if NbFils <> 0 then
            for N := 1 to NbFils do dispose(Fils[N]);
      End;
      if NbSsMenu <> 0 then
      Begin
        for M := (MaxPeres + 1) to (MaxPeres + NbSsMenu) do
        Begin
          with Pere[M] do
            if NbFils <> 0 then
              for N := 1 to NbFils do dispose(Fils[N]);
        End;
      End;
  End;
  dispose(Menu);
End;

{}

Function AjoutePereTx(Var Menu : BarreMenuTxPtr; Nom,Aide : Str80) : byte;

Var
  Compte : byte;
  NomTmp : Str80;

Begin
  with Menu^ do
  Begin
    if PereActif = 0 then PereActif := 1;
    inc(NbPeres);
    with Pere[NbPeres] do
    Begin
      NomTmp := Nom;
      while pos('&',NomTmp) <> 0 do delete(NomTmp,pos('&',NomTmp),1);
      Texte     := NomTmp;
      AideLigne := Aide;
      Compte    := pos('&',Nom);
      if Compte = 0 then Raccourci := CarNul
                    else Raccourci := Nom[Compte + 1];
      if NbPeres = 1 then PosX := 1
      else
        PosX := Pere[NbPeres-1].PosX + length(Pere[NbPeres-1].Texte) + 2;
      PosY      := 1;
      LargFils  := 0;
      HautFils  := 0;
      NbFils    := 0;
      FilsActif := 0;
    End;
    AjoutePereTx := NbPeres;
  End;
End;

{}

Function AjouteSsMenuTx(Var Menu : BarreMenuTxPtr;DuPere,DuFils:byte) : byte;

Var
  Compte : byte;
  Position : byte;
  NomTmp : Str80;

Begin
  with Menu^ do
  Begin
    inc(NbSsMenu);
    with Pere[(MaxPeres+NbSsMenu)] do
    Begin
      NomTmp := IntToStr(DuPere);
      NomTmp := NomTmp + IntToStr(DuFils);
      Texte     := NomTmp;
      Raccourci := CarNul;
      with Pere[DuPere] do
      Begin
        Compte := PosX + LargFils + 2;
        if Compte > 80 then Position := 80 - LargFils - 1
                       else Position := PosX;
      End;
      PosX      := Position + 2;
      PosY      := Pere[DuPere].PosY + DuFils + 1;
      LargFils  := 0;
      HautFils  := 0;
      NbFils    := 0;
      FilsActif := 0;
    End;
    with Pere[DuPere] do
    Begin
      with Fils[DuFils]^ do
      Begin
        SousMenu := (MaxPeres + NbSsMenu);
        Compte := length(Texte) + 4;
      End;
      if LargFils <= Compte then LargFils := Compte;
      with Fils[DuFils]^ do
        Texte := ElargiADte(Texte,(Largfils - 4)) + ' ' + #16;
    End;
    AjouteSsMenuTx := (MaxPeres + NbSsMenu);
  End;
End;

{}

Function AjouteFilsTx(Var Menu : BarreMenuTxPtr; NumPere : byte;
                                   Nom,Aide : Str80;Select : boolean) : byte;

Var
  Compte : byte;
  NomTmp : Str80;

Begin
  with Menu^.Pere[NumPere] do
  Begin
    if FilsActif = 0 then FilsActif := 1;
    inc(NbFils);
    new(Fils[NbFils]);
    with Fils[NbFils]^ do
    Begin
      NomTmp := Nom;
      while pos('&',NomTmp) <> 0 do delete(NomTmp,pos('&',NomTmp),1);
      Texte     := NomTmp;
      AideLigne := Aide;
      Compte    := pos('&',Nom);
      if Compte = 0 then Raccourci := CarNul
                    else Raccourci := Nom[Compte + 1];
      NonSelect := not Select;
      SousMenu  := 0;
    End;
    Compte := length(Nom);
    if LargFils <= Compte then LargFils := Compte;
    inc(HautFils);
    AjouteFilsTx := NbFils;
  End;
End;

{}

Procedure AfficheBarreMenuTx(Menu : BarreMenuTxPtr);

Var
  M,N   : byte;
  S     : TypeSauveTx;
  Ligne : Str80;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  with Menu^ do
  Begin
    gotoxy(1,1);
    CoulFondTx(CoulMenu.Fond);
    CoulEncreTx(CoulMenu.Encre);
    fillchar(Ligne,sizeof(Ligne),' ');
    Ligne[0] := #80;
    write(Ligne);
    for N := 1 to NbPeres do
      with Pere[N] do
      Begin
        gotoxy(PosX,PosY);
        CoulFondTx(CoulMenu.Fond);
        CoulEncreTx(CoulMenu.Encre);
        write(' ',Texte,' ');
        if Raccourci <> CarNul then
        Begin
          M := pos(Raccourci,Texte);
          gotoxy(PosX + M,PosY);
          CoulFondTx(CoulCarMenu.Fond);
          CoulEncreTx(CoulCarMenu.Encre);
          write(Raccourci);
        End;
      End;
  End;
  RestaureTx(S);
End;

{}

Procedure AfficheSeparateur(X,Y,Larg : byte);

Var
  N : byte;

Begin
  CoulFondTx(CoulMenu.Fond);
  CoulEncreTx(CoulMenu.Encre);
  gotoxy(X - 1,Y);
  write('');
  for N := 1 to Larg do write('');
  write('');
End;

{}

Procedure AfficheUnFils(X,Y,Larg : byte;LeFils : FilsTxRec;Actif : boolean);

Var
  N            : byte;
  LeTexte      : Str40;

Begin
  with LeFils do
  Begin
    LeTexte := ElargiADte(Texte,Larg-1);
    gotoxy(X + 1,Y);
    if Actif then
    Begin
      CoulFondTx(CoulMenuSelec.Fond);
      if NonSelect then CoulEncreTx(CoulMenuNonSelec.Encre)
                   else CoulEncreTx(CoulMenuSelec.Encre);
      if AideLigne = '' then LigneAide.Texte := AideStd
        else LigneAide.Texte := AideStd + '  ' + AideLigne;
      AfficheLigneAideTx(true);
    End
    else
    Begin
      CoulFondTx(CoulMenu.Fond);
      if NonSelect then CoulEncreTx(CoulMenuNonSelec.Encre)
                   else CoulEncreTx(CoulMenu.Encre);
    End;
    write(' ',LeTexte);
    if (Raccourci <> CarNul) and not NonSelect then
    Begin
      N := pos(Raccourci,Texte);
      gotoxy(X + N + 1,Y);
      if Actif then CoulFondTx(CoulMenuSelec.Fond)
               else CoulFondTx(CoulMenu.Fond);
      CoulEncreTx(CoulCarMenu.Encre);
      write(Raccourci);
    End;
  End;
End;

{}

Procedure OuvreLePere(Menu : BarreMenuTxPtr; NumPere : byte);

Var
  Compte, N : byte;
  Position  : byte;

Begin
  with Menu^.Pere[NumPere] do
  Begin
    if (LargFils <> 0) and (HautFils <> 0) then
    Begin
      Compte := PosX + LargFils + 2;
      if Compte > 80 then Position := 80 - LargFils - 1
                     else Position := PosX;
      with SousMenu1 do
      Begin
        X     := Position;
        Y     := PosY + 1;
        Tip   := Ombre1;
        Coul  := CoulMenu;
        Titre := '';
      End;
      CalculLargDialogTx(LargFils,SousMenu1);
      CalculHautDialogTx(HautFils,SousMenu1);
      OuvreDialogTx(SousMenu1);
      for N := 1 to NbFils do
        if Fils[N]^.Texte = '-' then
          AfficheSeparateur(Position + 1,PosY + N + 1,LargFils)
        else
          if N = FilsActif then
            AfficheUnFils(Position,PosY+ N+1,LargFils,Fils[N]^,true)
          else
            AfficheUnFils(Position,PosY+ N+1,LargFils,Fils[N]^,false);
    End;
  End;
End;

{}

Procedure FermeLePere(Menu : BarreMenuTxPtr; NumPere : byte);

Begin
  FermeDialogTx(SousMenu1);
End;

{}

Procedure OuvreLeSsMenu(Menu : BarreMenuTxPtr; NumPere : byte);

Var
  Compte, N : byte;
  Position  : byte;

Begin
  with Menu^.Pere[NumPere] do
  Begin
    if (LargFils <> 0) and (HautFils <> 0) then
    Begin
      Compte := PosX + LargFils + 2;
      if Compte > 80 then Position := 80 - LargFils - 1
                     else Position := PosX;
      Compte := PosY + HautFils + 2;
      if Compte > 24 then PosY := PosY - HautFils - 4;
      with SousMenu2 do
      Begin
        X     := Position;
        Y     := PosY + 1;
        Tip   := Ombre1;
        Coul  := CoulMenu;
        Titre := '';
      End;
      CalculLargDialogTx(LargFils,SousMenu2);
      CalculHautDialogTx(HautFils,SousMenu2);
      OuvreDialogTx(SousMenu2);
      for N := 1 to NbFils do
        if Fils[N]^.Texte = '-' then
          AfficheSeparateur(Position + 1,PosY + N + 1,LargFils)
        else
          if N = FilsActif then
            AfficheUnFils(Position,PosY+ N+1,LargFils,Fils[N]^,true)
          else
            AfficheUnFils(Position,PosY+ N+1,LargFils,Fils[N]^,false);
    End;
  End;
  Menu^.AncienPere := Menu^.PereActif;
  Menu^.PereActif := NumPere;
End;

{}

Procedure FermeLeSsMenu(Menu : BarreMenuTxPtr; NumPere : byte);

Begin
  FermeDialogTx(SousMenu2);
  Menu^.SsMenuOuvert := 0;
  Menu^.PereActif := Menu^.AncienPere;
  Menu^.AncienPere := 0;
End;

{}

Procedure OuvrePereTx(Menu : BarreMenuTxPtr; NumPere : byte);

Var
  M : byte;

Begin
  CacheSouris;
  with Menu^ do
  Begin
    with Pere[NumPere] do
    Begin
      gotoxy(PosX,PosY);
      CoulFondTx(CoulMenuSelec.Fond);
      CoulEncreTx(CoulMenuSelec.Encre);
      write(' ',Texte,' ');
      if Raccourci <> CarNul then
      Begin
        M := pos(Raccourci,Texte);
        gotoxy(PosX + M,PosY);
        CoulFondTx(CoulMenuSelec.Fond);
        CoulEncreTx(CoulCarMenu.Encre);
        write(Raccourci);
      End;
      if NbFils <> 0 then OuvreLePere(Menu,NumPere)
      else
      Begin
        if AideLigne = '' then LigneAide.Texte := AideStd
                          else LigneAide.Texte := AideStd + '  ' + AideLigne;
        AfficheLigneAideTx(true);
      End;
    End;
  End;
  MontreSouris;
End;

{}

Procedure FermePereTx(Menu : BarreMenuTxPtr; NumPere : byte);

Var
  M : byte;

Begin
  CacheSouris;
  with Menu^ do
  Begin
    with Pere[NumPere] do
    Begin
      gotoxy(PosX,PosY);
      CoulFondTx(CoulMenu.Fond);
      CoulEncreTx(CoulMenu.Encre);
      write(' ',Texte,' ');
      if Raccourci <> CarNul then
      Begin
        M := pos(Raccourci,Texte);
        gotoxy(PosX + M,PosY);
        CoulFondTx(CoulMenu.Fond);
        CoulEncreTx(CoulCarMenu.Encre);
        write(Raccourci);
      End;
    End;
  End;
  if Menu^.Pere[NumPere].NbFils <> 0 then FermeLePere(Menu,NumPere);
End;

{}

Procedure GereMenuTx(Var Menu : BarreMenuTxPtr;Var UnPere,UnFils : byte);

Var
  Abandon      : boolean;          { sortie de la gestion du menu }
  LeCar        : char;             { caractere venant d'etre frappe }
  InfoSouris   : PosRec;           { position souris lors du dernier clic }

  (**)
  Procedure VaDroite;

  Begin
    with Menu^ do
      if SsMenuOuvert <> 0 then FermeLeSsMenu(Menu,SsMenuOuvert);
    FermePereTx(Menu,Menu^.PereActif);
    with Menu^ do
      if PereActif = NbPeres then PereActif := 1
                             else inc(PereActif);
    OuvrePereTx(Menu,Menu^.PereActif);
  End;

  (**)
  Procedure VaGauche;

  Begin
    with Menu^ do
      if SsMenuOuvert <> 0 then FermeLeSsMenu(Menu,SsMenuOuvert);
    FermePereTx(Menu,Menu^.PereActif);
    with Menu^ do
      if PereActif = 1 then PereActif := NbPeres
                       else dec(PereActif);
    OuvrePereTx(Menu,Menu^.PereActif);
  End;

  (**)
  Procedure VaBas;

  Var
    Compte, N : byte;
    Position  : byte;

  Begin
    with Menu^.Pere[Menu^.PereActif] do
    Begin
      Compte := PosX + LargFils + 2;
      if Compte > 80 then Position := 80 - LargFils - 1
                     else Position := PosX;
      CacheSouris;
      AfficheUnFils(Position,PosY+FilsActif+1,LargFils,Fils[FilsActif]^,false);
      repeat
        if FilsActif = NbFils then FilsActif := 1
                              else inc(FilsActif);
      until Fils[FilsActif]^.Texte <> '-';
      AfficheUnFils(Position,PosY+FilsActif+1,LargFils,Fils[FilsActif]^,true);
      MontreSouris;
    End;
  End;

  (**)
  Procedure VaHaut;

  Var
    Compte, N : byte;
    Position  : byte;

  Begin
    with Menu^.Pere[Menu^.PereActif] do
    Begin
      Compte := PosX + LargFils + 2;
      if Compte > 80 then Position := 80 - LargFils - 1
                     else Position := PosX;
      CacheSouris;
      AfficheUnFils(Position,PosY+FilsActif+1,LargFils,Fils[FilsActif]^,false);
      repeat
        if FilsActif = 1 then FilsActif := NbFils
                         else dec(FilsActif);
      until Fils[FilsActif]^.Texte <> '-';
      AfficheUnFils(Position,PosY+FilsActif+1,LargFils,Fils[FilsActif]^,true);
      MontreSouris;
    End;
  End;

  (**)
  Procedure VaDebut;

  Var
    Compte, N : byte;
    Position  : byte;

  Begin
    with Menu^.Pere[Menu^.PereActif] do
    Begin
      Compte := PosX + LargFils + 2;
      if Compte > 80 then Position := 80 - LargFils - 1
                     else Position := PosX;
      CacheSouris;
      AfficheUnFils(Position,PosY+FilsActif+1,LargFils,Fils[FilsActif]^,false);
      FilsActif := 1;
      AfficheUnFils(Position,PosY+FilsActif+1,LargFils,Fils[FilsActif]^,true);
      MontreSouris;
    End;
  End;

  (**)
  Procedure VaFin;

  Var
    Compte, N : byte;
    Position  : byte;

  Begin
    with Menu^.Pere[Menu^.PereActif] do
    Begin
      Compte := PosX + LargFils + 2;
      if Compte > 80 then Position := 80 - LargFils - 1
                     else Position := PosX;
      CacheSouris;
      AfficheUnFils(Position,PosY+FilsActif+1,LargFils,Fils[FilsActif]^,false);
      FilsActif := NbFils;
      AfficheUnFils(Position,PosY+FilsActif+1,LargFils,Fils[FilsActif]^,true);
      MontreSouris;
    End;
  End;

  (**)
  Procedure PereUnique;

  Begin
    with Menu^ do UnPere := PereActif;
    UnFils := 0;
    Abandon := true;
  End;

  (**)
  Procedure Selection;

  Begin
    with Menu^ do if Pere[PereActif].NbFils = 0 then PereUnique;
    with Menu^ do
    Begin
      with Pere[PereActif] do
      if not Fils[FilsActif]^.NonSelect then
      Begin
        if Pere[PereActif].Fils[FilsActif]^.SousMenu = 0 then
        Begin
          UnPere := PereActif;
          UnFils := Pere[PereActif].FilsActif;
          Abandon := true;
          if SsMenuOuvert <> 0 then FermeLeSsMenu(Menu,SsMenuOuvert);
        End
        else
        Begin
          SsMenuOuvert := Pere[PereActif].Fils[FilsActif]^.SousMenu;
          OuvreLeSsMenu(Menu,SsMenuOuvert);
        End;
      End;
    End;
  End;

  (**)
  Procedure Echappe;

  Begin
    with Menu^ do
    if SsMenuOuvert <> 0 then FermeLeSsMenu(Menu,SsMenuOuvert)
                         else Abandon := true;
  End;

  (**)
  Procedure RaccourciPere;

  Var
    PereActuel,Memo : byte;

  Begin
    PereActuel := Menu^.PereActif;
    if CarDsBarreMenuTx(Menu,LeCar) then
    Begin
      with Menu^ do
        if SsMenuOuvert <> 0 then
        Begin
          Memo := Menu^.PereActif;
          FermeLeSsMenu(Menu,SsMenuOuvert);
          PereActuel := Menu^.PereActif;
          Menu^.PereActif := Memo;
        End;
      FermePereTx(Menu,PereActuel);
      OuvrePereTx(Menu,Menu^.PereActif);
      with Menu^ do if Pere[PereActif].NbFils = 0 then PereUnique;
    End;
  End;

  (**)
  Procedure RaccourciFils;

  Var
    X1,N : byte;

  Begin
    with Menu^ do
    with Pere[PereActif] do
      if NbFils <> 0 then
      Begin
        N := PosX + LargFils + 2;
        if N > 80 then X1 := 80 - LargFils - 1
                  else X1 := PosX;
        for N := 1 to NbFils do
          if Majuscules(Fils[N]^.Raccourci) = Majuscules(LeCar) then
          Begin
            CacheSouris;
            AfficheUnFils(X1,PosY+FilsActif+1,LargFils,Fils[FilsActif]^,false);
            FilsActif := N;
            AfficheUnFils(X1,PosY+FilsActif+1,LargFils,Fils[FilsActif]^,true);
            MontreSouris;
            LeCar := CarReturn;
          End;
      End;
  End;

  (**)
  Procedure GereClavier;

  Begin
    if ToucheFct then
    Begin
      case LeCar of
        FlchDroite : VaDroite;
        FlchGauche : VaGauche;
        FlchBas    : with Menu^ do
                     if Pere[PereActif].NbFils <> 0 then VaBas;
        FlchHaut   : with Menu^ do
                     if Pere[PereActif].NbFils <> 0 then VaHaut;
        FlchDebut  : with Menu^ do
                     if Pere[PereActif].NbFils <> 0 then VaDebut;
        FlchFin    : with Menu^ do
                     if Pere[PereActif].NbFils <> 0 then VaFin;
        ShiftF1    : BoiteAProposTx;
        AltX       : Begin
                       Sortie := true;
                       Abandon := true;
                     End;
      end;
      RaccourciPere;
    End
    else
    Begin
      RaccourciFils;
      case LeCar of
        CarEsc     : Echappe;
        CarReturn  : Selection;
      end;
    End;
  End;

  (**)
  Procedure SourisDsFils;

  Var
    X,Y    : byte;   { position texte de la souris }
    X1,Y1  : byte;   { coin haut gauche du sousmenu }
    X2,Y2  : byte;   { coin bas droit du sousmenu }
    N      : byte;

  Begin
    if InfoSouris.Bouton = BoutonGauche then
    Begin
      with InfoSouris do PosSourisPosTx(Colonne,Ligne,X,Y);
      with Menu^ do
        with Pere[PereActif] do
        Begin
          N := PosX + LargFils + 2;
          if N > 80 then X1 := 80 - LargFils - 1
                    else X1 := PosX;
          X2 := X1 + LargFils + 1;
          Y1 := PosY ;
          Y2 := PosY + HautFils + 2;
          if ((X = X1) or (X = X2)) and (Y > Y1) and (Y < Y2) then LeCar := #0
          else
          if (Y = Y1) or (Y = Y2) and (X >= X1) and (X <= X2) then LeCar := #0
          else
          if (X > X1) and (X < X2) then
          Begin
            if (Y > Y1) and (Y < Y2) then
            Begin
              N := Y - (PosY + 1);
              if N <> 0 then with Fils[N]^ do
              if Texte <> '-' then
              Begin
                CacheSouris;
    AfficheUnFils(X1,PosY+FilsActif+1,LargFils,Fils[FilsActif]^,false);
                FilsActif := N;
    AfficheUnFils(X1,PosY+FilsActif+1,LargFils,Fils[FilsActif]^,true);
                MontreSouris;
                LeCar := CarReturn;
              End;
            End
            else
            Begin
              LeCar := #0;
              Abandon := true;
            End;
          End
          else
          Begin
            LeCar := #0;
            Abandon := true;
          End;
        End;
    End;
  End;

  (**)
  Procedure GereSouris;

  Var
    PereActuel,Memo : byte;

  Begin
    DelaiSouris(TempoSouris);
    PereActuel := Menu^.PereActif;
    if SourisDsBarreMenuTx(Menu,InfoSouris) then
    Begin
      with Menu^ do
      Begin
        if SsMenuOuvert <> 0 then
        Begin
          Memo := Menu^.PereActif;
          FermeLeSsMenu(Menu,SsMenuOuvert);
          PereActuel := Menu^.PereActif;
          Menu^.PereActif := Memo;
        End;
      End;
      FermePereTx(Menu,PereActuel);
      OuvrePereTx(Menu,Menu^.PereActif);
      with Menu^ do if Pere[PereActif].NbFils = 0 then PereUnique;
    End
    else SourisDsFils;
  End;

Begin
  Abandon := false;
  AncienneAide := LigneAide;
  SauvegardeTx(SauveMenu1);
  CacheCurseurTx;
  MontreSouris;
  OuvrePereTx(Menu,Menu^.PereActif);
  with Menu^ do if Pere[PereActif].NbFils = 0 then PereUnique;
  while not Abandon do
  Begin
    if AttendActionTx(LeCar,InfoSouris) then GereSouris;
    if LeCar <> #0 then GereClavier;
  End;
  FermePereTx(Menu,Menu^.PereActif);
  RestaureTx(SauveMenu1);
  LigneAide := AncienneAide;
  AfficheLigneAideTx(true);
End;

{}

Function SourisDsBarreMenuTx(Var Menu : BarreMenuTxPtr;
                                                InfoSouris : PosRec):boolean;

Var
  X,Y   : byte;   { position texte de la souris }
  X1,X2 : byte;   { debut et fin du pere        }
  N     : byte;

Begin
  SourisDsBarreMenuTx := false;
  if InfoSouris.Bouton = BoutonGauche then
  Begin
    with InfoSouris do PosSourisPosTx(Colonne,Ligne,X,Y);
    if Y = 1 then
    Begin
      X1 := 0;
      X2 := 0;
      with Menu^ do
        for N := 1 to NbPeres do
        with Pere[N] do
        Begin
          X1 := X2 + 1;
          X2 := X2 + length(Texte) + 2;
          if (X >= X1) and (X <= X2) then
          Begin
            Menu^.PereActif := N;
            N := NbPeres;
            SourisDsBarreMenuTx := true;
          End;
        End;
    End;
  End;
End;

{}

Function ConversionToucheFct(UnCar : char) : char;

Begin
  case UnCar of
    AltA : ConversionToucheFct := 'A';
    AltB : ConversionToucheFct := 'B';
    AltC : ConversionToucheFct := 'C';
    AltD : ConversionToucheFct := 'D';
    AltE : ConversionToucheFct := 'E';
    AltF : ConversionToucheFct := 'F';
    AltG : ConversionToucheFct := 'G';
    AltH : ConversionToucheFct := 'H';
    AltI : ConversionToucheFct := 'I';
    AltJ : ConversionToucheFct := 'J';
    AltK : ConversionToucheFct := 'K';
    AltL : ConversionToucheFct := 'L';
    AltM : ConversionToucheFct := 'M';
    AltN : ConversionToucheFct := 'N';
    AltO : ConversionToucheFct := 'O';
    AltP : ConversionToucheFct := 'P';
    AltQ : ConversionToucheFct := 'Q';
    AltR : ConversionToucheFct := 'R';
    AltS : ConversionToucheFct := 'S';
    AltT : ConversionToucheFct := 'T';
    AltU : ConversionToucheFct := 'U';
    AltV : ConversionToucheFct := 'V';
    AltW : ConversionToucheFct := 'W';
    AltX : ConversionToucheFct := 'X';
    AltY : ConversionToucheFct := 'Y';
    AltZ : ConversionToucheFct := 'Z';
  end;
End;

{}

Function CarDsBarreMenuTx(Var Menu : BarreMenuTxPtr;LeCar : char):boolean;

Var
  N : byte;

Begin
  CarDsBarreMenuTx := false;
  if ToucheFct then
  Begin
    LeCar := ConversionToucheFct(LeCar);
    with Menu^ do
      for N := 1 to NbPeres do
        with Pere[N] do
        Begin
          if LeCar = Majuscules(Raccourci) then
          Begin
            Menu^.PereActif := N;
            N := NbPeres;
            CarDsBarreMenuTx := true;
          End;
      End;
  End;
End;

{}

Procedure SelectFilsMenuTx(Var Menu : BarreMenuTxPtr;UnPere,UnFils : byte);

Begin
  with Menu^ do
    Pere[UnPere].Fils[UnFils]^.NonSelect := false;
End;

{}

Procedure DeSelectFilsMenuTx(Var Menu : BarreMenuTxPtr;UnPere,UnFils : byte);

Begin
  with Menu^ do
    Pere[UnPere].Fils[UnFils]^.NonSelect := true;
End;

{}

Begin

End.