{

                            AJMATH  Version 1.0

                         Creation Alain JAFFRE 1995

  ͸
                   Unite ecrite pour TURBO PASCAL 7.0                     
                                                                          
                             Alain JAFFRE                                 
  ;

}

{$I AJMATH.DOC }

IMPLEMENTATION

Var
  RadiansParDegres : real;
  DegresParRadians : real;

{}

Function DegToRad(Angle : real) : real;

Begin
  DegToRad := Angle * RadiansParDegres;
End;

{}

Function RadToDeg(Angle : real) : real;

Begin
  RadToDeg := Angle * DegresParRadians;
End;

{}

Procedure DegToDMS(Angle : real;Var Degres,Minutes, Secondes : real);

Begin
  Degres   := int(Angle);
  Angle    := (Angle - Degres) * 60;
  Minutes  := int(Angle);
  Angle    := (Angle - Minutes) * 60;
  Secondes := Angle;
End;

{}

Function DMSToDeg(Degres,Minutes, Secondes : real) : real;

Begin
  DMSToDeg := Degres + (Minutes / 60) + (Secondes / 3600);
End;

{}

Function BaseToInt(Car : char) : integer;

Begin
  if Car <= '9' then BaseToInt := Ord(Car) - Ord('0')
                else BaseToInt := Ord(Upcase(Car)) - Ord('A') + 10;
End;

{}

Function IntToBase(Valeur : integer) : char;

Begin
  if Valeur <= 9 then IntToBase := chr(Valeur + ord('0'))
                 else IntToBase := chr(Valeur - 10 + ord('A'));
End;

{}

Function BaseToDec(Entree : Str80;Base : integer) : longint;

Var
  N        : byte;
  Chiffre  : byte;
  Digit    : integer;
  Resultat : real;

Begin
  resultat := 0;
  for N := length(Entree) downto 1 do
  Begin
    Digit := BaseToInt(Entree[N]);
    Resultat := Resultat + Digit * Puissance(Base,(N-1));
  End;
  BaseToDec := round(Resultat);
End;

{}

Function DecToBase (Valeur : longint;Base : byte) : Str80;

Var
  Chiffre : byte;
  Compte   : byte;
  Resultat : Str80;
  Reste    : longint;
  Tmp      : longint;

Begin
  Resultat := '';
  Chiffre := 0;
  if Valeur > 0 then
  Begin
    Chiffre := 0;
    inc(Valeur);
    Tmp := round(Puissance(Base,Chiffre));
    while Valeur > Tmp do                     { Calcul du nombre de chiffre }
    Begin
      inc(Chiffre);
      Tmp := round(Puissance(Base,Chiffre));
    End;
    dec(Chiffre);                { On enleve 1 pour avoir la puissance maxi }
    dec(Valeur);

    Reste := Valeur;
    while (Reste > 0) or (Chiffre <> 255) do
    Begin
      Compte := 0;
      Tmp := round(Puissance(Base,Chiffre));
      while Reste >= Tmp do
      Begin
        Reste := Reste - Tmp;
        inc(Compte);
      End;
      Resultat := Resultat + IntToBase(Compte);
      dec(Chiffre);
    End;
  End
  else Resultat := '0';
  DecToBase := Resultat;
End;

{}

Function BaseToBase (Valeur : Str80;Base1,Base2 : byte) : Str80;

Var
  ValDecimale : longint;

Begin
  ValDecimale := BaseToDec(Valeur,Base1);
  BaseToBase := DecToBase(ValDecimale,Base2);
End;

(**)

Function Tan(Angle : real) : real;

Var
  LeCos    : real;
  LeSin    : real;
  Tangente : real;

Begin
  LeCos := cos(Angle);
  LeSin := sin(Angle);
  if LeCos = 0.0 then
  Begin
    if LeSin = 1 then Tan := Infini
                 else Tan := -Infini;
  End
  else
  Begin
    Tangente := sin(Angle) / cos(Angle);
    Tan := Tangente;
    if (Tangente < -Infini) then Tan := -Infini;
    if (Tangente > Infini) then Tan := Infini;
  End;
End;

{}

Function Cotan(Angle : real) : real;

Var
  LeCos      : real;
  LeSin      : real;
  Cotangente : real;

Begin
  LeCos := cos(Angle);
  LeSin := sin(Angle);

  if LeSin = 0.0 then
  Begin
    if LeCos = 1 then Cotan := Infini
                 else Cotan := -Infini;
  End
  else
  Begin
    Cotangente := cos(Angle) / sin(Angle);
    Cotan := Cotangente;
    if (Cotangente < -Infini) then Cotan := -Infini;
    if (Cotangente > Infini) then Cotan := Infini;
  End;
End;

{}

Function ArcCos(Valeur : real) : real;

Var
  Tmp : real;

Begin
  if Valeur = 0 then ArcCos := (Pi / 2)
    else if Valeur = 1 then ArcCos := 0
      else if Valeur = -1 then ArcCos := Pi
     else
     begin
       Tmp := Valeur * Valeur;
       Tmp := 1 - Tmp;
       Tmp := sqrt(Tmp);
       Tmp := Tmp / Valeur;
       ArcCos := ArcTan(Tmp);
     end;
End;

{}

Function ArcSin(Valeur : real) : real;

Var
  Tmp : real;

Begin
  if Valeur = 0 then ArcSin := 0
    else if Valeur = 1 then ArcSin := (Pi / 2)
      else if Valeur = -1 then ArcSin := (3 * Pi / 2)
        else
        Begin
          Tmp := Valeur * Valeur;
          Tmp := 1 - Tmp;
          Tmp := sqrt(Tmp);
          Tmp := Valeur / Tmp;
          ArcSin := ArcTan(Tmp);
       End;
End;

{}

Function ArcCotan(Valeur : real) : real;

Begin
  ArcCotan := arctan(Valeur) + (Pi / 2.0);
End;

{}
(*?????????*)
Function ArcSec(Valeur : real) : real;

Begin
  if Valeur <= 0 then
    ArcSec := arctan(Valeur / sqrt(Valeur * Valeur - 1.0)) - (Pi / 2.0)
  else
    ArcSec := arctan(Valeur / sqrt(Valeur * Valeur - 1.0));
End;

{}
(*?????????*)
Function ArcCsc(Valeur : real) : real;

Begin
  if Valeur = 0 then
    ArcCsc := arctan(Valeur / sqrt(Valeur * Valeur - 1.0)) - (Pi / 2.0)
  else
    if Valeur > 0 then
      ArcCsc := arctan(Valeur / sqrt(Valeur * Valeur - 1.0))
    else
      ArcCsc := arctan(Valeur / sqrt(Valeur * Valeur - 1.0)) - Pi;
End;

(**)

Function SinDeg(Angle : real) : real;

Begin
  SinDeg := Sin(DegToRad(Angle));
End;

{}

Function CosDeg(Angle : real) : real;

Begin
  CosDeg := Cos(DegToRad(Angle));
End;

{}

Function TanDeg(Angle : real) : real;

Begin
  TanDeg := Tan(DegToRad(Angle));
End;

{}

Function CotanDeg(Angle : real) : real;

Begin
  CotanDeg := Cotan(DegToRad(Angle));
End;

{}

Function ArcSinDeg(Valeur : real) : real;

Begin
  ArcSinDeg := RadToDeg(ArcSin(Valeur));
End;

{}

Function ArcCosDeg(Valeur : real) : real;

Begin
  ArcCosDeg := RadToDeg(ArcCos(Valeur));
End;

{}

Function ArcTanDeg(Valeur : real) : real;

Begin
  ArcTanDeg := RadToDeg(ArcTan(Valeur));
End;

{}

Function ArcCotanDeg(Valeur : real) : real;

Begin
  ArcCotanDeg := RadToDeg(ArcCotan(Valeur));
End;

(**)

Function SinH(Angle : real) : real;

Const
  AngleMaxi = 88.029691931;

Var
  Signe : real;

Begin
  Signe := 1.0;
  if Angle < 0 then
  Begin
    Signe := -1.0;
    Angle := - Angle;
  End;
  if Angle > AngleMaxi then SinH := Infini
  else SinH := (exp(Angle) - exp(- Angle)) / 2.0 * Signe;
End;

{}

Function CosH(Angle : real) : real;

Const
  AngleMaxi = 88.029691931;

Begin
  Angle := abs(Angle);
  if Angle > AngleMaxi then CosH := Infini
  else CosH := (exp(Angle) + exp(- Angle)) / 2.0;
End;

{}

Function TanH(Angle : real) : real;

Begin
  TanH := SinH(Angle) / CosH(Angle);
End;

{}

Function CotanH(Angle : real) : real;

Begin
  CotanH := CosH(Angle) / SinH(Angle);
End;

{}

Function ArcSinH(Valeur : real) : real;

Var
  Signe : real;

Begin
  Signe := 1.0;
  if Valeur < 0 then
  Begin
    Signe := -1.0;
    Valeur := -Valeur;
  End;
  ArcSinH := ln(Valeur + sqrt(Valeur * Valeur + 1)) * Signe;
End;

{}

Function ArcCosH(Valeur : real) : real;

Var
  Signe : real;

Begin
  Signe := 1.0;
  if Valeur < 0 then
  Begin
    Signe := -1.0;
    Valeur := -Valeur;
  End;
  ArcCosH := ln(Valeur + sqrt(Valeur * Valeur - 1)) * Signe;
End;

{}

Function ArcTanH(Valeur : real) : real;

Var
  Signe : real;

Begin
  Signe := 1.0;
  if Valeur < 0 then
  Begin
    Signe := -1.0;
    Valeur := -Valeur;
  End;
  ArcTanH := ln((1 + Valeur) / (1 - Valeur)) / 2.0 * Signe;
End;

{}

Function ArcCotanH(Valeur : real) : real;

Begin
  ArcCotanH := ArcTanH(1.0 / Valeur);
End;

{}
(*?????????*)
Function SecH(Valeur : real) : real;

Begin
  SecH := 1.0 / CosH(Valeur);
End;

{}
(*?????????*)
Function CscH(Valeur : real) : real;

Begin
  CscH := 1.0 / SinH(Valeur);
End;

{}
(*?????????*)
Function ArcSecH(Valeur : real) : real;

Begin
  ArcSecH := ArcCosH(1.0 / Valeur);
End;

{}
(*?????????*)
Function ArcCscH(Valeur : real) : real;

Begin
  ArcCscH := ArcSinH(1.0 / Valeur);
End;

(**)

Function Puissance(Valeur,Exposant : real) : real;

Var
  Tmp : real;

Begin
  Valeur := abs(Valeur);
  if Valeur = 0.0 then Puissance := 1
  else
  Begin
    Tmp := Exposant * ln(Valeur);
    Puissance := Exp(Tmp);
  End;
End;

{}

Function Racine(Valeur,N : real) : real;

Var
  Tmp : real;

Begin
  Tmp := 1.0 / N;
  Racine := Puissance(Valeur,Tmp);
End;

{}

Function Log10(Valeur : real) : real;

Begin
  Log10 := Ln(Valeur) / Ln(10.0);
End;

{}

Function Log(Valeur,Base : real) : real;

Begin
  Log := Ln(Valeur) / Ln(Base);
End;

{}

Function Factoriel(Valeur : integer) : real;

Var
  Tmp : real;
  I   : integer;

Begin
  Tmp := 1;
  for I := 2 to Valeur do Tmp := Tmp * I;
  Factoriel := Tmp;
end;

{}

Function EstPremier(Valeur : integer) : boolean;

Var
  Premier : boolean;
  Test    : integer;

Begin
  Premier := true;
  Test := 2;
  while Premier and (Test <= Int(sqrt(Valeur))) do
    if (Valeur mod Test) = 0 then Premier := false
                             else inc(Test);
  EstPremier := Premier;
End;

{}

Begin
  RadiansParDegres := Pi / 180.0;
  DegresParRadians := 180.0 / Pi;
End.