{

                           AJIMP  Version 1.0

                         Creation Alain JAFFRE 1996

  ͸
                   Unite ecrite pour TURBO PASCAL 7.0                     
                                                                          
                             Alain JAFFRE                                 
  ;

}

{$I AJIMP.DOC }

IMPLEMENTATION

{}

Function ChoixImp(Num : byte) : boolean;

Begin
  ChoixImp := true;
  if Num > Machine.NbParalleles then ChoixImp := false
                                else Imprimante.Numero := Num;
End;

{}

Procedure TestEtatImp;

Var
  Regs : registers;
  Etat : byte;

Begin
  with Regs do
  Begin
    AH := 2;
    DX := Imprimante.Numero;
    intr($17,Regs);
    Etat := AH;
  End;
  with EtatImp do
  Begin
    TimeOut      := TestBit(0,Etat);
    Erreur       := TestBit(3,Etat);
    Ready        := TestBit(4,Etat);
    PlusDePapier := TestBit(5,Etat);
    NonOccupe    := TestBit(7,Etat);
  End;
End;

{}

Function ImprimantePrete : Boolean;

Begin
  ImprimantePrete := false;
  TestEtatImp;
  with EtatImp do
  Begin
    ImprimantePrete := not PlusDePapier and not Erreur and
      not TimeOut and Ready and NonOccupe;
  End;
End;

{}

Procedure InitImp;

Var
  Regs : registers;

Begin
  with Regs do
  Begin
    AH := 1;
    DX := Imprimante.Numero;
    intr($17,Regs);
  End;
End;

{}

Function PrintCar(LeCar : char) : boolean;

Var
  Regs : registers;
  Etat : byte;

Begin
  with Regs do
  Begin
    AL := ord(LeCar);
    AH := 0;
    DX := Imprimante.Numero;
    intr($17,Regs);
    Etat := AH;
  End;
  if TestBit(4,Etat) then
  Begin
    PrintCar := true;
    if LeCar = SautDeLigne then inc(Imprimante.LigEnCours);
    if LeCar = SautDePage then Imprimante.LigEnCours := 0;
  End
  else
  Begin
    with EtatImp do
    Begin
      TimeOut      := TestBit(0,Etat);
      Erreur       := TestBit(3,Etat);
      Ready        := false;
      PlusDePapier := TestBit(5,Etat);
      NonOccupe    := TestBit(7,Etat);
    End;
    PrintCar := false;
  End;
End;

{}

Function PrintStr(Ligne : string) : boolean;

Var
  Long   : byte;
  Num    : byte;
  Retour : boolean;

Begin
  with Imprimante do
  Begin
    Long := length(Ligne);
    if Long > 0 then
    Begin
      Num := 0;
      repeat
        inc(Num);
        if (((Num mod CarParLig) = 0) and (Ligne[Num] <> SautDeLigne)) then
          inc(LigEnCours);
        if (LigEnCours = LigParPage) then Retour := PrintCar(SautDePage);
        Retour := PrintCar(Ligne[Num]);
      until (Num = Long) or (not Retour);
    End
    else Retour := true;
    PrintStr := Retour;
  End;
End;

{}

Function PrintLnStr(Ligne : string) : boolean;

Var
  Retour : boolean;

Begin
  Retour := PrintStr(Ligne);
  if Retour then
  Begin
    Retour := PrintCar(RetourLigne);
    Retour := PrintCar(SautDeLigne);
  End;
End;

{}

Begin
  with Imprimante do
  Begin
    Numero     := 0;
    CarParLig  := 80;
    LigParPage := 50;
    LigEnCours := 0;
  End;
  fillchar(EtatImp,sizeof(EtatImpRec),#0);
End.