{

                            AJGLOB  Version 1.0

                         Creation Alain JAFFRE 1995

  ͸
                   Unite ecrite pour TURBO PASCAL 7.0                     
                                                                          
                             Alain JAFFRE                                 
  ;

}

{$I AJGLOB.DOC }

IMPLEMENTATION

{}

Function ReserveMem (Var P : pointer;Taille : word):boolean;

Begin
  if MemAvail > Taille then
  Begin
    getmem(P,Taille);
    ReserveMem := true;
  End
  else ReserveMem := false;
End;

{}

Procedure Beep;

Begin
  if FaitBip then
  Begin
    sound (100);
    delay (100);
    nosound;
  End;
End;

{}

Procedure Bip;

Begin
  if FaitBip then
  Begin
    sound(600);
    delay(50);
    nosound;
  End;
End;

{}

Procedure Beeper;

Begin
  if FaitBip then
  Begin
    sound(550);
    delay(200);
    nosound;
  End;
End;

{}

Procedure AppelTache;

Begin
  if TachePrg <> nil then
    inline ($FF/$1E/TachePrg);   {   CALL FAR [TachePrg]   ; Tche programme }
End;

{}

Procedure SaisirCar (Var Car : char);

Begin
  repeat
    AppelTache;
  until keypressed;
  Car := readkey;
  if Car = #0 then
  Begin                              { une touche de fonction a t appuye }
    Car := readkey;                  { lecture du second code }
    ToucheFct := true;
  End
  else ToucheFct := false;
End;

{}

Function TestBit(NumBit , Octet : byte) : boolean;

Begin
  TestBit := odd(Octet shr NumBit);
End;

{}

Procedure TestClavier;

Var
  Regs : registers;
  Etat : byte;

Begin
  fillchar(Clavier,sizeof(ClavierRec),#0);
  with Regs do
  Begin
    AH := 2;
    AL := $FF;
    intr($16,Regs);
    Etat := AL;
  End;
  with Clavier do
  Begin
    ShiftGauche := TestBit(0,Etat);
    ShiftDroit  := TestBit(1,Etat);
    Controle    := TestBit(2,Etat);
    Alt         := TestBit(3,Etat);
    ScrollLock  := TestBit(4,Etat);
    NumLock     := TestBit(5,Etat);
    CapsLock    := TestBit(6,Etat);
    InsertLock  := TestBit(7,Etat);
  End;
End;

{}

Procedure ErreurFichierMessage(Nom : NomRep;NumeroLigne : word);

Begin
  clrscr;
  write(LigneErreurFi);
  write(Nom);
  write(LigneErreurEn);
  write(NumeroLigne);
  Halt(2);
End;

{}

Function LitFichierMsg(Nom : NomRep;Var Liste : MsgRec) : boolean;

Var
  FichierMsg  : text;
  MsgTmp      : Str80;
  NumTmp      : Str80;
  Numero      : integer;
  LigneNumero : word;

Begin
  assign (FichierMsg,Nom);
{$I-}
  reset (FichierMsg);
{$I+}
  if ioresult = 0 then
  Begin
    Numero := 1;
    while Numero <= MaxMsg do
    Begin
      if MemAvail > sizeof(Liste[Numero]) then
      Begin
        new(Liste[Numero]);
        Liste[Numero]^ := '';
      End
      else
      Begin
        write(LignePlusDeMem);
        Halt(1);
      End;
      inc(Numero);
    End;
    Numero := 0;
    LigneNumero := 0;
    while not (Eof(FichierMsg) or (Numero > MaxMsg)) do
    Begin
       repeat
         readln (FichierMsg,MsgTmp);
         inc(LigneNumero);
       until (pos('#',MsgTmp) <> 0) or Eof(FichierMsg);
       if not Eof(FichierMsg) then
       Begin
         if pos('*',MsgTmp) = 0 then ErreurFichierMessage(Nom,LigneNumero);
         NumTmp := Compresse(copy(MsgTmp,1,pos('*',MsgTmp) - 1));
         Numero := StrToInt(NumTmp);
         delete (MsgTmp,1,pos('#',MsgTmp));
         MSgTmp := Compresse(MsgTmp);
         Liste[Numero]^ := MsgTmp;
       End;
    End;
    close (FichierMsg);
    if Numero = 0 then ErreurFichierMessage(Nom,LigneNumero)
                  else LitFichierMsg := true;
  End
  else  LitFichierMsg := false;
End;

{}

Procedure EffaceMsg(Var Liste : MsgRec);

Var
  Numero  : integer;

Begin
  Numero := 1;
  while Numero <= MaxMsg do
  Begin
    if Liste[Numero]<> nil then
    Begin
      Liste[Numero]^ := '';
      dispose(Liste[Numero]);
    End;
    inc(Numero);
  End;
End;

{}

Procedure InitTampon(Var Tampon : TamponPtr);

Var
  N : byte;

Begin
  new(Tampon);
  with Tampon^ do
  Begin
    Pos := 0;
    for N := 1 to 10 do Valeur[N] := '';
  End;
End;

{}

Procedure AjouteTampon(Var Tampon : TamponPtr;UneValeur : Str80);

Var
  N : byte;

Begin
  with Tampon^ do
  Begin
    for N := 10 downto 2 do Valeur[N] := Valeur[(N - 1)];
    Valeur[1] := UneValeur;
    if Pos < 10 then inc(Pos);
  End;
End;

{}

Function LitTampon(Var Tampon : TamponPtr;EnRemontant : boolean): Str80;

Begin
  with Tampon^ do
  if Pos = 0 then LitTampon := ''
  else
  Begin
    if EnRemontant then
    Begin
      if (Pos = 10) or (Valeur[Pos + 1] = '') then Beep
                                              else inc(Pos);
      LitTampon := Valeur[Pos];
    End
    else
    Begin
      if Pos = 1 then Beep
                 else dec(Pos);
      LitTampon := Valeur[Pos];
    End;
  End;
End;

{}

Procedure RandomiseTP6;

Var
  Reg : registers;

Begin
  Reg.AH := $2C;
  msdos(Reg);
  RandseedTP6 := Reg.DX;
  RandseedTP6 := (RandseedTP6 shl 16) or Reg.CX;
End;

{}

Function RandomTP6(Limite : word) : word;

Begin
  RandseedTP6 := RandseedTP6 * 134775813 + 1;
  RandomTP6 := (RandseedTP6 shr 16) mod Limite;
End;

{}

Function Wildcards(Texte : string) : boolean;

Begin
  Wildcards := (pos('*',Texte) <> 0) or (pos('?',Texte) <> 0);
End;

(**)

Procedure LitRepPrg;

Begin
  RepPrg     := paramstr(0);
  if pos(':',RepPrg) > 0 then
  Begin
    while not (RepPrg[length(RepPrg)] in [':','\']) do
      delete(RepPrg,length(RepPrg),1);
  End
  else getdir(0,RepPrg);
  if RepPrg[length(RepPrg)] <> '\' then RepPrg := RepPrg + '\';
End;

{}

Function CteMemoire : word;

Var
  Regs : registers;

Begin
  with Regs do
  Begin
    intr($12,Regs);
    CteMemoire := AX;
  End;
End;

{}

Function CteEMS : word;

Var
  Regs : registers;

Begin
  with Regs do
  Begin
    AH := $88;
    intr($15,Regs);
    CteEMS := AX;
  End;
End;

{}

Function CarteEnCouleur (Reg : registers) : boolean;

Var
  Couleur : boolean;

Begin
  with Reg do
  Begin
    Couleur := (AL AND $30 <> $30);
    if Couleur then BaseEcran := $B800
               else BaseEcran := $B000;
  End;
  CarteEnCouleur := Couleur;
End;

{}

Function CteLecteurs(Reg : registers) : byte;

Var
  Nb : byte;

Begin;
  with Reg do
  Begin
    if (AL and $C0) Shr 6 = 0 then Nb := 1
    else
      if ((AL and $C0) Shr 6 = 1) and ((AL and 1) = 1) then Nb := 2;
  End;
  CteLecteurs := Nb;
End;

{}

Function TypeEcran: string;

Var
  Regs    : registers;
  Driver  : integer;
  Mode    : integer;
  Temp    : string[20];

Begin
  detectgraph(Driver,Mode);
  case Driver of
    1 : TypeEcran := 'CGA';{CGA}
    2 : TypeEcran := 'MCGA';{MCGA}
    3 : TypeEcran := 'EGA';{EGA}
    4 : TypeEcran := 'EGA  64';{EGA64}
    9 : TypeEcran := 'VGA';{VGA}
  else
  Begin
    str(Driver,Temp);
    Temp := 'Inconnue (' + Temp + ')';
    TypeEcran := Temp;
  End;
  End;
End;

{}

Function VersionDeDos : str4;

Var
  Ver: word;
  N1, N2: string[2];

Begin
  Ver := DosVersion;
  str(Lo(Ver),N1);
  str(Hi(Ver),N2);
  VersionDeDos := N1 + '.' + N2;
End;

{}

Procedure Environnement;

Var
  Regs : registers;

Begin
  FillChar(machine,SizeOf(machineRec),#0);
  with machine do
  Begin
    TailleMemoire := CteMemoire;
    MemoireEMS    := CteEMS;
    with Regs do
    Begin
      intr($11,Regs);
      CarteCouleur  := CarteEnCouleur(Regs);
      NbLecteurs    := CteLecteurs(Regs);
      NbParalleles  := (AH AND $C0) Shr 6;
      NbSeries      := (AH AND $0E) Shr 1;
      CoprocessMath := (AL AND 2 = 2);
    End;
    ModeCouleur   := (Mem[$40:$49] IN [1,3,4]);
    TypeCarte     := TypeEcran;
    VerDos        := VersionDeDos;
  End;
End;

(**)

Function EstUnEntier (Phrase : string;  Long : boolean) : boolean;

Var
   LMax, N : byte;
   Bool : boolean;

Begin
  EstUnEntier := false;
  if Long then LMax := 10
          else LMax := 5;
  if length(Phrase) > 0 then
  Begin
    if length(Phrase) <= LMax then
      Begin
        N := 0;
        repeat
          inc(N);
          Bool := Phrase[N] in ['0'..'9','-'];
        until (not Bool) or (N = length(Phrase));
        if Bool then
        Begin
          N := NbDeCar(Phrase,'-');
          if N = 0 then EstUnEntier := True
          else
            if N = 1 then EstUnEntier := Phrase[1] = '-';
        End;
      End;
  End;
End;

{}

Function IntToStr (N : longint) : NumAlpha;

Var
  S : NumAlpha;

Begin
  str(N,S);
  IntToStr := S;
End;

{}

Function StrToInt (S : numAlpha) : longint;

Var
  I : longint;
  Resultat : integer;

Begin
  val(S,I,Resultat);
  StrToInt := I;
End;

{}

Function MiniEntier (E1 , E2 : integer) : integer;

Begin
  if E1 <= E2 then MiniEntier := E1
              else MiniEntier := E2;
End;

{}

Function MaxiEntier (E1 , E2 : integer) : integer;

Begin
  if E2 >= E1 then MaxiEntier := E2
              else MaxiEntier := E1;
End;

{}

Function EstUnReel (Phrase : string) : boolean;

Var
   NbE, NbMoins, N : byte;
   Bool : boolean;
   SPrim : string;

Begin
  EstUnReel := false;
  if length(Phrase) > 0 then
  Begin
    SPrim := Majuscules(Phrase);
    if length(SPrim) <= 12 then
    Begin
      N := 0;
      repeat
        inc(N);
        Bool := SPrim[N] in ['0'..'9','-','+','E'];
      until (not Bool) or (N = length(SPrim));
      if Bool then
      Begin
        NbMoins := NbDeCar(SPrim,'-');
        NbE := NbDeCar(SPrim,'E');
        if NbMoins = 0 then EstUnReel := true
        else
          if NbMoins = 1 then
            EstUnReel := (Phrase[1] = '-') or
                         (Phrase[pos('E',Phrase)+1] = '-')
          else
            if NbMoins = 2 then
              EstUnReel := (Phrase[1] = '-') and
                           (Phrase[pos('E',Phrase)+1] = '-');
      End;
    End;
  End;
End;

{}

Function RealToStr (N : REAL; Long, Precision : byte) : NumAlpha;

Var
  Mantisse : byte;
  S : NumAlpha;

Begin
  if Long > Precision then Mantisse := Long - Precision - 1
                      else Mantisse := 0;
  str(N:Mantisse:Precision,S);
  S := Compresse(S);
(*  if (pos('.',S) <> 0) and (pos('.',S) < length(S)) then
  while S[length(S)] = '0' do delete(S,length(S),1);
  if S[length(S)] = '.' then delete(S,length(S),1);*)
  S := copy(S,1,Long);
  RealToStr := S;
End;

{}

Function StrToreal (S : NumAlpha) : real;

Var
  Valeur : real;
  Code   : integer;

Begin
  if S[1] = '.' then S := '0' + S;
  val(S,Valeur,Code);
  StrToreal := Valeur;
End;

{}

Procedure EchangeEntier(Var Entier1,Entier2 : longint);

Var
  EntierTmp : longint;

Begin
  EntierTmp := Entier1;
  Entier1 := Entier2;
  Entier2 := EntierTmp;
End;

{}

Procedure EchangeReel(Var Reel1,Reel2 : real);

Var
  ReelTmp : real;

Begin
  ReelTmp := Reel1;
  Reel1 := Reel2;
  Reel2 := ReelTmp;
End;

{}

Procedure EchangeChaine(Var Chaine1,Chaine2 : string);

Var
  ChaineTmp : string;

Begin
  ChaineTmp := Chaine1;
  Chaine1 := Chaine2;
  Chaine2 := ChaineTmp;
End;

{}

Function MiniReel (R1 , R2 : real) : real;

Begin
  if R1 <= R2 then MiniReel := R1
              else MiniReel := R2;
End;

{}

Function MaxiReel (R1 , R2 : real) : real;

Begin
  if R2 >= R1 then MaxiReel := R2
              else MaxiReel := R1;
End;

{}

Function NbDeCar (Phrase : string; LeCar : char) : byte;

Var
   N,Nb : byte;

Begin
  Nb := 0;
  if length(Phrase) > 0 then
    for N := 1 to length(Phrase) do
      if Phrase[N] = LeCar then inc(Nb);
  NbDeCar := Nb;
End;

{}

Function Compresse (Phrase : str80) : str80;

Var
  Long : byte;

Begin
  if Phrase <> '' then
  Begin
    Long := length(Phrase);
    while (Phrase[Long] = ' ') and (Long > 1) do
    Begin
      delete(Phrase,Long,1);
      dec(Long);
    End;
    while (Phrase[1] = ' ') and (Phrase <> '') do delete(Phrase,1,1);
  End;
  Compresse := Phrase;
End;

{}

Function Majuscules (Phrase : string) : string;

Var
  N : integer;
  C : char;

Begin
  for N := 1 to length(Phrase) do
  Begin
    C := Phrase[N];
    if C in ['a'..'z'] then C := chr (ord(C)+ord('A')-ord('a'))
    else if C in ['','','','','','','',
                  '','','','','','','',''] then
           case C of
             '','',''     : C := 'A';
             '','','','' : C := 'E';
             '',''         : C := 'I';
             '',''         : C := 'O';
             '','',''     : C := 'U';
             ''             : C := 'C';
           end;
    Phrase[N] := C;
  End;
  Majuscules := Phrase;
End;

{}

Function Elargi (Phrase : string; Long : byte) : string;

Begin
  if Long > length(Phrase) then
  Begin
    while length(Phrase) < Long do
    Begin
      Phrase := ' ' + Phrase;
      if length(Phrase) < Long then Phrase := Phrase + ' ';
    End;
  End
  else
  Phrase := copy(Phrase,1,Long);
  Elargi := Phrase;
End;

{}

Function ElargiADte (Phrase : string;   Long : byte) : string;

Begin
  if Long > length(Phrase) then
  Begin
    while length(Phrase) < Long do Phrase := Phrase + ' ';
  End
  else Phrase := copy(Phrase,1,Long);
  ElargiADte := Phrase;
End;

{}

Function ElargiAGch (Phrase : string; Long : byte) : string;

Begin
  if Long > length(Phrase) then
  Begin
    while length(Phrase) < Long do Phrase := ' ' + Phrase;
  End
  else Phrase := copy(Phrase,1,Long);
  ElargiAGch := Phrase;
End;

{}

Function HeureEnTexte (Heures, Minutes, Secondes : word) : str80;

Var
  HStr, MStr, SStr : string[2];

Begin
  HStr := IntToStr(Heures);
  while length(HStr) < 2 do HStr := '0' + HStr;
  MStr := IntToStr(Minutes);
  while length(MStr) < 2 do MStr := '0' + MStr;
  SStr := IntToStr(Secondes);
  while length(SStr) < 2 do SStr := '0' + SStr;
  HeureEnTexte := HStr+':'+MStr+':'+SStr;
End;

{}

Function DateEnTexte (Annee, Mois, Jour, JourSemaine : word) : str80;

Var
  JourStr, MoisStr : string[10];

Begin
  case JourSemaine of
    0 : JourStr := 'Dimanche';
    1 : JourStr := 'Lundi';
    2 : JourStr := 'Mardi';
    3 : JourStr := 'Mercredi';
    4 : JourStr := 'Jeudi';
    5 : JourStr := 'Vendredi';
    6 : JourStr := 'Samedi';
    else JourStr := '?';
  end;
  case Mois of
    1 : MoisStr := 'Janvier';
    2 : MoisStr := 'Fvrier';
    3 : MoisStr := 'Mars';
    4 : MoisStr := 'Avril';
    5 : MoisStr := 'Mai';
    6 : MoisStr := 'Juin';
    7 : MoisStr := 'Juillet';
    8 : MoisStr := 'Aout';
    9 : MoisStr := 'Septembre';
   10 : MoisStr := 'Octobre';
   11 : MoisStr := 'Novembre';
   12 : MoisStr := 'Dcembre';
   else MoisStr := '?';
  end;
  DateEnTexte :=JourStr+' '+IntToStr(Jour)+' '+MoisStr+' '+IntToStr(Annee);
End;

(**)

Function FicExiste (NomFichier : Str80) : boolean;

Var
  Rec : searchrec;

Begin
  findfirst(NomFichier,anyfile,Rec);
  FicExiste := (DosError = 0);
End;

{}

Function ChangeExtension(NomFichier : Str80;Extension : Str4) : Str80;

Var
  PosPoint : byte;

Begin
  if (length(Extension) = 4) and (Extension[1] <> '.') then
    Extension := copy(Extension,1,3);
  if length(Extension) <= 3 then Extension := '.' + Extension;
  PosPoint := Pos('.',NomFichier);
  if PosPoint <> 0 then NomFichier := copy(NomFichier,1,PosPoint - 1);
  ChangeExtension := NomFichier + Extension;
End;

{}

Function RepExiste (Repertoire : NomRep) : boolean;

Var
  RepCourant : NomRep;

Begin
  if Repertoire[length(Repertoire)] = '\'
    then delete(Repertoire,length(Repertoire),1);
  getdir(0,RepCourant);
{$I-}
  chdir(Repertoire);
{$I+}
  RepExiste := (ioresult = 0);
  chdir(RepCourant);
End;

{}

Function CreeRep (Repertoire : NomRep) : NomRep;

Var
  Long   : byte;
  Nombre : byte;
  RepTmp : NomRep;
  Reussi : boolean;

Begin
  Long := length(Repertoire);
  Nombre := 0;
  repeat
    RepTmp := copy(Repertoire,1,Nombre);
    inc(Nombre);
    repeat
      RepTmp := RepTmp + Repertoire[Nombre];
      inc(Nombre);
    until Repertoire[Nombre] = '\';
    if not RepExiste(RepTmp) then
    Begin
      {$I-}
      mkdir(RepTmp);
      if ioresult = 0 then Reussi := true
                      else Reussi := false;
      {$I+}
    End;
  until (Nombre = Long) or (not Reussi);
  if Reussi then CreeRep := RepTmp + '\'
            else CreeRep := RepTmp;
End;

{}

Function LecteurExiste (Lecteur : char) : byte;

Var
  F : text;
  Resultat : byte;

Begin
  Lecteur := upcase(Lecteur);
  if (Lecteur = 'B') and (Machine.NbLecteurs = 1) then Resultat := 3
  else
  Begin
  {$I-}
    assign(F,Lecteur+':\@@@@@@@@.@@@');
    reset(F);
  {$I+}
    Resultat := ioresult;
    if Resultat = 0 then close(F);
    if Resultat = 2 then Resultat := 0;
  End;
  LecteurExiste := Resultat;
End;
(*
Var
  S : searchrec;
  P : pointer;
  Reg : registers;
  Resultat : byte;

Begin
  if not (Lecteur in ['A','B']) then
  Begin
    findfirst(Lecteur + ':*.*',anyfile,S);
    Resultat := doserror;
  End
  else
  with Reg do
  Begin
    getmem(P,512);
    AH := 2;
    DL := ord(Lecteur) - ord('A');
    DH := 0;
    CH := 0;
    CL := 1;
    AL := 1;
    ES := seg(P^);
    BX := ofs(P^);
    intr($13,Reg);
    Resultat := AH;
    freemem(P,512);
  End;
  if Resultat = 6 then Resultat := 0;
  LecteurExiste := Resultat;
End;*)

{}

Function NomFichierCorrect(NomFichier : Str80;Wildcards : boolean) : boolean;

Var
  Correct : boolean;
  Nom : NomFic;
  Ext : NomFic;
  M, N : byte;

  Function CaractereCorrect(Car : char) : boolean;

  Var
    CarCorrect : boolean;

  Begin
    CarCorrect := true;
    if not (Car in ['0'..'9']) then
      if not (Car in ['A'..'Z']) then
        if not (Car in ['a'..'z']) then
          if not (Car in ['#'..'&']) then
            if not (Car in ['_','^','~','!','-','{','}','(',')']) then
               CarCorrect := false;
    if Wildcards and (Car in ['*','?']) then CarCorrect := true;
    CaractereCorrect := CarCorrect;
  End;

Begin
  Correct := true;
  while pos(':',NomFichier) <> 0 do delete(NomFichier,1,pos(':',NomFichier));
  while pos('\',NomFichier) <> 0 do delete(NomFichier,1,pos('\',NomFichier));
  N := pos('.',NomFichier);
  if N = 0 then
  Begin
    Nom := NomFichier;
    Ext := '';
    if length(Nom) > 8 then Correct := false;
    for M := 1 to length(Nom) do
      if not CaractereCorrect(Nom[M]) then Correct := false;
  End
  else
  Begin
    Nom := copy(NomFichier,1,N - 1);
    Ext := copy(NomFichier,N + 1,length(NomFichier) - N);
    if length(Nom) > 8 then Correct := false;
    if length(Ext) > 3 then Correct := false;
    for M := 1 to length(Nom) do
      if not CaractereCorrect(Nom[M]) then Correct := false;
    for M := 1 to length(Ext) do
      if not CaractereCorrect(Ext[M]) then Correct := false;
  End;
  NomFichierCorrect := Correct;
End;

{}

Function TesteFichier (NomFichier : Str80) : byte;

Var
  Rec : searchrec;

Begin
  findfirst(NomFichier,anyFile,Rec);
  TesteFichier := Rec.attr;
End;

{}

Function TailleFic (NomFichier : Str80) : longint;

Var
  Rec : searchrec;

Begin
     findfirst(NomFichier,anyFile,Rec);
     TailleFic := Rec.size;
End;

{}

Function NbFicType (Repertoire : NomRep; Extension : ExtFic) : byte;

Var
  Rec : searchrec;
  Nb : byte;

Begin
  Nb := 0;
  if not (Repertoire[length(Repertoire)] = '\') then
    Repertoire := Repertoire + '\';
  findfirst(Repertoire + '*.' + Extension,anyFile,Rec);
  if doserror = 0 then
  repeat
     inc(Nb);
     findnext(Rec);
  until doserror <> 0;
  NbFicType := Nb;
End;

{}

Procedure ListeRep (LeRep : LstRepPtr);

Var
  Rec : searchrec;
  Err : boolean;

  Procedure Stocke;

  Begin
    with LeRep^ do
    Begin
      if (Rec.attr and directory) = 0 then   { fichier }
      Begin
        inc (NbFic);
        ListeDsFic[NbFic] := Rec;
      End
      else
      if (Rec.Name <> '.') and (Rec.Name <> '..') then
      Begin
        inc(NbRep);
        ListeDuRep[NbRep] := Rec;
      End;
    End;
  End;

  Procedure LectRep;

  Begin
    with LeRep^ do
    Begin
      findfirst(Repertoire + Masque,Attribut,Rec);
      if DosError = 0 then
      Begin
        if (Rec.attr and Attribut) = Rec.attr then Stocke;

        repeat
          findnext(Rec);               { bug dans FindNext (rec.attr ignor) }
          if (Rec.attr and Attribut) = Rec.attr then        { alors on teste }
          Begin
            Err := (NbRep = MaxFiles) or (NbFic = MaxFiles)
                                      or (DosError <> 0);
            if not Err then Stocke;
          End
          else
          Err := doserror <> 0;
        until Err;

        if DosError = 0 then ErreurES := 3
                        else ErreurES := 0;
      End
      else ErreurES := 2;
    End;
  End;

Begin
  with LeRep^ do
  Begin
    NbFic := 0;
    NbRep := 0;
    if Repertoire[length(Repertoire)] <> '\' then
             Repertoire := Repertoire + '\';
    if not RepExiste(Repertoire) then ErreurES := 1
                                 else LectRep;
  End;
End;

(**)

Function HMS_to_S (Heures,Minutes,Secondes : word) : longint;

Var
  Temp : longint;

Begin
  Temp := Heures * 3600;
  Temp := Temp + Minutes * 60;
  Temp := Temp + Secondes;
  HMS_to_S := Temp;
End;

{}

Procedure Timer_Init (var Timer : longint);

Var
  Heure    : word;
  Minute   : word;
  Seconde  : word;
  Centieme : word;

Begin
  gettime(Heure,Minute,Seconde,Centieme);
  Timer := HMS_to_S(Heure,Minute,Seconde);
End;

{}

Function Timer_Lect(Timer1 : longint) : longint;

Var
  Heure    : word;
  Minute   : word;
  Seconde  : word;
  Centieme : word;
  Timer2   : longint;
  Ecart    : longint;

Begin
  gettime(Heure,Minute,Seconde,Centieme);
  Timer2 := HMS_to_S(Heure,Minute,Seconde);
  if Timer2 < Timer1 then Timer2 := Timer2 + 86400;
  Ecart := Timer2 - Timer1;
  Timer_Lect := Ecart;
End;

(**)

Begin
  LitRepPrg;
  Environnement;

  TachePrg   := nil;
  Alphanumerique := [#32 .. #168];

  CurseurVis := true;
  CurseurOve := false;
  SourisUtil := false;
  ModeGr     := false;

  FaitBip    := true;
  AffiAide   := true;
  Sortie     := false;

  with Soft do
  Begin
    Nom     := '';
    Version := '';
    Info1   := '';
    Info2   := '';
  End;

  LongStd := 10;
  PrecisStd := 4;

  TempoAlarme := 0;
  TempoDefile := 50;

  InitTampon(TamponEntier);
  InitTampon(TamponReel);
  InitTampon(TamponChaine);

  with LigneAide do
  Begin
    Normal.Fond  := GrisClair;
    Normal.Encre := Noir;
    Surligne.Fond  := GrisClair;
    Surligne.Encre := Rouge;
    Texte := '';
  end;

  AideSaisie := ' ~Alt X~ Sortie  ~F3~ Defaut  ~F5~ Vide  ~ESC~ Abandon';
  AideChoix  := ' ~Alt X~ Sortie  ~Entree~  Valide  ~ESC~ Abandon';
  AideChoixMultiple := ' ~Alt X~ Sortie  ~Alt Espace~ Selection/Deselection  ~Entree~ Valide  ~ESC~ Abandon';
  AideStd    := ' ~Alt X~ Sortie';
  LigneSuite := ' Appuyez sur une touche pour continuer ';
  LigneMemLibre := ' octets de mmoire libre ';
  LignePlusDeMem := ' Pas assez de memoire pour effectuer cette opration ';
  LigneErreurFi := ' Erreur fichier : ';
  LigneErreurEn := ' en ligne : ';
End.