{

                           AJGENTX  Version 1.0

                         Creation Alain JAFFRE 1995

  ͸
                   Unite ecrite pour TURBO PASCAL 7.0                     
                                                                          
                             Alain JAFFRE                                 
  ;

}

{$I AJGENTX.DOC }

IMPLEMENTATION

{}

Function AttendActionTx(Var Car : char;Var Souris : PosRec):boolean;

Var
  ActionSouris  : boolean;
  ActionClavier : boolean;
  Bouton        : byte;

Begin
  ActionSouris := false;
  ActionClavier := false;
  repeat
    AppelTache;
    if SourisUtil then
    Begin
      if ClickSouris(Bouton) then
      Begin
        SourisPressee(Bouton,Souris);
        ActionSouris := (Souris.Nombre <> 0);
      End;
    End;
    ActionClavier := keypressed ;
  until ActionSouris or ActionClavier;
  if ActionClavier then
  Begin
    Car := readkey;
    if Car = #0 then
    Begin                            { une touche de fonction a t appuye }
      Car := readkey;                { lecture du second code }
      ToucheFct := true;
    End
    else ToucheFct := false;
  End
  else
  Begin
    Car := #0;
    ToucheFct := false;
  End;
  AttendActionTx := ActionSouris;
End;

{}

Procedure PasseTexte;

Begin
  if ModeGr then
  Begin
    RestoreCrtMode;
    if CurseurVis then MontreCurseurTx
                  else CacheCurseurTx;
    if SourisVis then
    Begin
      CacheSouris;
      RazSouris;
      MontreSouris;
    End;
    ModeGr := false;
  End;
End;

{}

Procedure PlusDeMemoireTx;

Begin
  with CoulAlarme do
  Begin
    MessageTx(Fond,Encre,24,LignePlusDeMem,false);
    MessageTx(Fond,Encre,25,LigneSuite,true);
  End;
End;

{}

Procedure AfficheLigneAideTx(Oui : boolean);

Var
  S         : TypeSauveTx;
  N         : byte;
  Surligner : boolean;
  TexteTmp  : Str80;

  Procedure ChangeCouleur;

  Begin
    with LigneAide do
    if Surligner then
    Begin
      CoulFondTx(Normal.Fond);
      CoulEncreTx(Normal.Encre);
    End
    else
    Begin
      CoulFondTx(Surligne.Fond);
      CoulEncreTx(Surligne.Encre);
    End;
    Surligner := not Surligner;
  End;

  Function CompteTilde : byte;

  Var
    NbTilde, Z : byte;

  Begin
    with LigneAide do
    Begin
      NbTilde := 0;
      for Z := 1 to length(Texte) do
        if Texte[Z] = '~' then inc(NbTilde);
    End;
    CompteTilde := NbTilde;
  End;

Begin
  if not AffiAide then exit;
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  with LigneAide do
    if Oui then
    Begin
      gotoxy(1,25);
      N := 80 + CompteTilde;
      Texte := ElargiADte(Texte,N);
      CoulFondTx(Normal.Fond);
      CoulEncreTx(Normal.Encre);
      Surligner := false;
      for N := 1 to (length(Texte) - 1) do
      Begin
        if Texte[N] = '~' then ChangeCouleur
                          else write(Texte[N]);
      End;
      if Surligner then Write2580(Texte[N],Surligne.Fond,Surligne.Encre)
                   else Write2580(Texte[N],Normal.Fond,Normal.Encre);
    End
    else
    Begin
      TexteTmp := '';
      gotoxy(1,25);
      TexteTmp := ElargiADte(TexteTmp,79);
      CoulFondTx(Normal.Fond);
      CoulEncreTx(Normal.Encre);
      write(TexteTmp);
      Write2580(' ',Normal.Fond,Normal.Encre);
    End;
  RestaureTx(S);
End;

(**)

Procedure CacheCurseurTx;

Var
  Reg     : registers;

Begin
  with Reg do
  Begin
    AX := $0100;
    CX := (32 shl 8) + 0;
    intr($10,reg);
  End;
  CurseurVis := false;
End;

{}

Procedure MontreCurseurTx;

Var
  Reg     : registers;
  Driver  : integer;
  Mode    : integer;

BEGIN
  detectgraph(Driver,Mode);
  with Reg do
  Begin
    AX := $0100;
    if not CurseurOve then
    Begin
      if Driver in [1,2,3,4,9] then
      Begin
        if Driver = 1 then CX := (6 shl 8) + 7;{CGA}
        if Driver = 2 then CX := (13 shl 8) + 14;{MCGA}
        if Driver = 3 then CX := (6 shl 8) + 7;{EGA}
        if Driver = 4 then CX := (11 shl 8) + 12;{EGA64}
        if Driver = 9 then CX := (6 shl 8) + 7;{VGA}
      End
      else CX := (6 shl 8) + 7;
    End;
    if CurseurOve then
    Begin
      if Driver in [1,2,3,4,9] then
      Begin
        if Driver = 1 then CX := (1 shl 8) + 7;{CGA}
        if Driver = 2 then CX := (1 shl 8) + 14;{MCGA}
        if Driver = 3 then CX := (1 shl 8) + 7;{EGA}
        if Driver = 4 then CX := (1 shl 8) + 12;{EGA64}
        if Driver = 9 then CX := (0 shl 8) + 7;{VGA}
      End
      else CX := (0 shl 8) + 7;
    End;
    intr($10,reg);
  End;
  CurseurVis := true;
End;

{}

Procedure EcritXYTx(X,Y : byte;S : string;Std : boolean);

Var
  VideoPtr : ^word;
  Compte   : byte;
  Attrib   : word;

Begin
  Attrib := swap(textattr);
  VideoPtr := ptr(BaseEcran, 2 * (80 * pred(Y) + pred(X)));
  for Compte := 1 to length(S) do
  Begin
    if Std and (ord(S[Compte]) < 32) then S[Compte] := ' ';
    VideoPtr^ := Attrib or byte(S[Compte]);
    inc(VideoPtr);
  End;
End;

{}

Procedure EcritCarSpeTx (Caractere : char);

Var
  Reg : registers;

Begin
  with Reg do
  Begin
    AH := $09;
    AL := ord(Caractere);
    BH := 0;
    BL := textattr;
    CX := 1;
    intr($10,reg);
  End;
End;

{}

Procedure LitCarTx (X,Y : integer;Var Caractere : char;Var Attr : byte);

Var
  S     : TypeSauvetx;
  Reg   : registers;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  gotoxy(X,Y);
  with Reg do
  Begin
    AH := $08;
    BH := 0;
    intr($10,reg);
    Caractere := chr(AL);
    Attr      := AH;
  End;
  RestaureTx(S);
End;

{}

Procedure SauvegardeTx (var S : TypeSauveTx);

Begin
  with S do
  Begin
    Attribut := textattr;
    CurseurX := wherex;
    CurseurY := wherey;
    CVisible := CurseurVis;
    COverwri := CurseurOve;
    SVisible := SourisVis;
  End;
End;

{}

Procedure RestaureTx (S : TypeSauveTx);

Begin
  with S do
  Begin
    textattr := Attribut;
    gotoxy(CurseurX,CurseurY);
    if CVisible then MontreCurseurTx
                else CacheCurseurTx;
    CurseurOve := COverwri;
    if SVisible then MontreSouris
                else CacheSouris;
  End;
End;

{}

Procedure EcritEcranTx (NomFichier : Str80);

Var
  S          : TypeSauveTx;
  EnregEcran : integer;
  FicEcran   : file;
  Reg        : registers;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  assign(FicEcran,NomFichier);
  {$I-}
  rewrite(FicEcran);
  {$I+}
  if ioresult = 0 then
  with Reg do
  Begin
    EnregEcran := TailleEcran div 128;
    if (EnregEcran mod 128) <> 0 then inc(EnregEcran);
    blockwrite(FicEcran,Ptr(BaseEcran,0)^,EnregEcran);
    close(FicEcran);
  End;
  RestaureTx(S);
End;

{}

Procedure LitEcranTx (NomFichier : Str80; EffaceFic : boolean);

Var
  S          : TypeSauveTx;
  EnregEcran : integer;
  FicEcran   : file;
  Reg        : registers;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  assign(FicEcran,NomFichier);
  {$I-}
  reset(FicEcran);
  {$I+}
  if ioresult = 0 then
  with Reg do
  Begin
    EnregEcran := TailleEcran div 128;
    if (EnregEcran mod 128) <> 0 then inc(EnregEcran);
    blockread(FicEcran,Ptr(BaseEcran,0)^,EnregEcran);
    close(FicEcran);
    if EffaceFic then erase(FicEcran);
  End;
  RestaureTx(S);
End;

{}

Procedure CopieEcranRamTx;

Var
  S : TypeSauveTx;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  move(mem[BaseEcran:0],TamponEcr^,TailleEcran);
  RestaureTx(S);
End;

{}

Procedure CopieRamEcranTx;

Var
  S : TypeSauveTx;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  move(TamponEcr^,mem[BaseEcran:0],TailleEcran);
  RestaureTx(S);
End;

{}

Procedure SauveLigneTx (Ligne : byte; Var LePtr : pointer);

Var
  S : TypeSauveTx;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  if LePtr <> nil then
  Begin
    (*move(mem[BaseEcran:(Ligne-1)*160],
    mem[seg(LePtr^):ofs(LePtr^)], 80 * 2);*)
    move(mem[BaseEcran:(Ligne-1)*160],
    mem[seg(LePtr^):ofs(LePtr^)], 160);
  End;
  RestaureTx(S);
End;

{}

Procedure LitLigneTx (Ligne : byte; Var LePtr : pointer);

Var
 S : TypeSauveTx;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  if LePtr <> nil then
  Begin
    (*move(mem[seg(LePtr^):ofs(LePtr^)],
    mem[BaseEcran:(Ligne-1)*160], 80 * 2);*)
    move(mem[seg(LePtr^):ofs(LePtr^)],
    mem[BaseEcran:(Ligne-1)*160], 160);
  End
  else beep;
  RestaureTx(S);
End;

{}

Procedure SauveRectTx (X1, Y1, X2, Y2 : byte; Var LePtr : pointer);

Var
  S       : TypeSauveTx;
  Largeur : byte;
  DoubleL : byte;
  Hauteur : byte;
  N       : byte;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  if LePtr <> nil then
  Begin
    Largeur := X2 - X1 + 1;
    DoubleL := 2 * Largeur;
    Hauteur := Y2 - Y1;
    for N := 0 to Hauteur do
      (*move(mem[BaseEcran:(Y1+N-1)*160+(X1-1)*2],
      mem[seg(LePtr^):ofs(LePtr^)+N*Largeur*2], Largeur * 2);*)
      move(mem[BaseEcran:(Y1+N-1)*160+(X1+X1-2)],
      mem[seg(LePtr^):ofs(LePtr^)+N*DoubleL], DoubleL);
  End;
  RestaureTx(S);
End;

{}

Procedure LitRectTx (X1, Y1, X2, Y2 : byte; Var LePtr : pointer);

Var
  S       : TypeSauveTx;
  Largeur : byte;
  DoubleL : byte;
  Hauteur : byte;
  N       : byte;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  if LePtr <> nil then
  Begin
    Largeur := X2 - X1 + 1;
    DoubleL := 2 * Largeur;
    Hauteur := Y2 - Y1;
    for N := 0 to Hauteur do
      (*move(mem[seg(LePtr^):ofs(LePtr^)+N*Largeur*2],
      mem[BaseEcran:(Y1+N-1)*160+(X1-1)*2], Largeur * 2);*)
      move(mem[seg(LePtr^):ofs(LePtr^)+N*DoubleL],
      mem[BaseEcran:(Y1+N-1)*160+(X1+X1-2)], DoubleL);
  End;
  RestaureTx(S);
End;

(**)

Procedure CoulEncreTx (Coul : Couleur);

Begin
  if Machine.ModeCouleur then textcolor(Coul)
                         else textcolor(Blanc);
End;

{}

Procedure CoulFondTx (Coul : Couleur);

Begin
  if Machine.ModeCouleur then textbackground(Coul)
                         else textbackground(Noir);
End;

{}

Procedure InverseCarTx(X,Y : byte);

Var
  Index  : integer;
  Masque : byte;

Begin
  (*Index := ((X - 1) * 2) + (160 * (Y - 1)) + 1;*)
  Index := (X + X - 2) + (160 * (Y - 1)) + 1;
  if Machine.ModeCouleur then Masque := $77
                         else Masque := $7F;
  mem[BaseEcran:Index] := mem[BaseEcran:Index] xor Masque;
End;

{}

Procedure InverseTexteTx(X,Y,Long : byte);

Var
  Index  : integer;
  Masque : byte;
  Num    : byte;

Begin
  (*Index := ((X - 1) * 2) + (160 * (Y - 1)) + 1;*)
  Index := (X + X - 2) + (160 * (Y - 1)) + 1;
  if Machine.ModeCouleur then Masque := $77
                         else Masque := $7F;
  for Num := 1 to Long do
  Begin
    mem[BaseEcran:Index] := mem[BaseEcran:Index] xor Masque;
    Index := Index + 2;
  End;
End;

{}

Procedure CentreTexteTx(PosY : byte; Texte : Str80);

Var
  Mil  : byte;
  Long : byte;

Begin
  Long := length(texte) div 2;
  Mil := (lo(windmax) - lo(windmin)) div 2 + 1;
  gotoXY(Mil - Long,PosY);
  if (PosY = 25) and (length(Texte) >= 80) then
  Begin
    write(copy(Texte,1,79));
    Write2580(Texte[80],hi(textattr),lo(textattr));
  End
  else write(Texte);
End;

{}

Procedure MessageTx(Fond,Encre : Couleur;PosY : byte;Texte : Str80;
                                       Reponse : boolean);

Begin
  CoulEncreTx(Encre);
  CoulFondTx(Fond);
  CentreTexteTx(PosY,Texte);
  if Reponse then SaisirCar(CarReponse);
End;

{}

Procedure AfficheTx(Texte : str80;Longueur : byte);

Begin
  Texte := ElargiADte(Texte,Longueur);
  write(Texte);
end;

{}

Procedure EffaceTx(X1,Y1,X2,Y2 : byte);

Begin
  window (X1,Y1,X2,Y2);
  clrscr;
  window (1,1,80,25);
End;

{}

Procedure Write2580(Car : char;Fond,Encre : byte);

Var
  Coul : byte;

Begin
  (*mem[BaseEcran: 24 * 160 + 79 * 2] := ord(Car);*)
  mem[BaseEcran: 3998] := ord(Car);
  Coul := Fond * 16 + Encre;
  (*mem[BaseEcran: 24 * 160 + 79 * 2 + 1] := Coul;*)
  mem[BaseEcran: 3999] := Coul;
End;

{}

Procedure ScrollHautTx(Nombre,CGauche,LHaut,Larg,Haut,Rempli : byte);

Var
  Reg : registers;

Begin
  with Reg do
  Begin
    AH := $06;
    AL := Nombre;
    CL := pred(CGauche);
    CH := pred(LHaut);
    DL := CGauche + Larg - 2;
    DH := LHaut + Haut - 2;
    BH := Rempli;
    intr($10,reg);
  End;
End;

{}

Procedure ScrollBasTx(Nombre,CGauche,LHaut,Larg,Haut,Rempli : byte);

Var
  Reg : registers;

Begin
  with Reg do
  Begin
    AH := $07;
    AL := Nombre;
    CL := pred(CGauche);
    CH := pred(LHaut);
    DL := CGauche + Larg - 2;
    DH := LHaut + Haut - 2;
    BH := Rempli;
    intr($10,reg);
  End;
End;

{}

Procedure ScrollDroitTx(Nombre,CGauche,LHaut,Larg,Haut,Rempli : byte);

Var
  P      : array [1..160]of byte;
  DbL    : byte;
  Decal  : byte;
  M,N    : byte;

Begin
  if Nombre > Larg then Nombre := Larg;
  DbL := Larg + Larg;
  Decal := Nombre + Nombre;
  for N := 0 to (Haut - 1) do
  Begin
    move(mem[BaseEcran:(LHaut+N-1)*160+(CGauche+CGauche-2)],P,DbL);
    for M := Dbl downto 1 do P[M + Decal] := P[M];
    for M := 1 to Decal do
    Begin
      P[M] := 32;
      inc(M);
      P[M] := textattr;
    End;
    move(P,mem[BaseEcran:(LHaut+N-1)*160+(CGauche+CGauche-2)],Dbl);
  End;
End;

{}

Procedure ScrollGaucheTx(Nombre,CGauche,LHaut,Larg,Haut,Rempli : byte);

Var
  P      : array [1..160]of byte;
  DbL    : byte;
  Decal  : byte;
  M,N    : byte;

Begin
  if Nombre > Larg then Nombre := Larg;
  DbL := Larg + Larg;
  Decal := Nombre + Nombre;
  for N := 0 to (Haut - 1) do
  Begin
    move(mem[BaseEcran:(LHaut+N-1)*160+(CGauche+CGauche-2)],P,DbL);
    for M := 1 to (Dbl - Decal) do P[M] := P[M + Decal];
    for M := 1 to Decal do
    Begin
      P[M + Dbl - Decal] := 32;
      inc(M);
      P[M + Dbl - Decal] := textattr;
    End;
    move(P,mem[BaseEcran:(LHaut+N-1)*160+(CGauche+CGauche-2)],Dbl);
  End;
End;

{}

Procedure CoinHautGauche(X,Y : byte;Tip : TypeBoite);

Begin
  gotoxy(X,Y);
  case Tip of
    Cadre1  : write('');
    Cadre2  : write('');
    Cadre3  : write('');
    Cadre4  : write('');
    Ombre1  : write('');
    Ombre2  : write('');
    Ombre3  : write('');
    Ombre4  : write('');
  end;
End;

{}

Procedure CoinHautDroit(X,Y : byte;Tip : TypeBoite);

Begin
  gotoxy(X,Y);
  case Tip of
    Cadre1  : write('');
    Cadre2  : write('');
    Cadre3  : write('');
    Cadre4  : write('');
    Ombre1  : write('');
    Ombre2  : write('');
    Ombre3  : write('');
    Ombre4  : write('');
  end;
End;

{}

Procedure CoinBasGauche(X,Y : byte;Tip : TypeBoite);

Begin
  gotoxy(X,Y);
  case Tip of
    Cadre1  : write('');
    Cadre2  : write('');
    Cadre3  : write('');
    Cadre4  : write('');
    Ombre1  : write('');
    Ombre2  : write('');
    Ombre3  : write('');
    Ombre4  : write('');
  end;
End;

{}

Procedure CoinBasDroit(X,Y : byte;Tip : TypeBoite);

Begin
  if (X = 80) and (Y = 25) then
  Begin
    case Tip of
      Cadre1  : Write2580('',hi(textattr),lo(textattr));
      Cadre2  : Write2580('',hi(textattr),lo(textattr));
      Cadre3  : Write2580('',hi(textattr),lo(textattr));
      Cadre4  : Write2580('',hi(textattr),lo(textattr));
      Ombre1  : Write2580('',hi(textattr),lo(textattr));
      Ombre2  : Write2580('',hi(textattr),lo(textattr));
      Ombre3  : Write2580('',hi(textattr),lo(textattr));
      Ombre4  : Write2580('',hi(textattr),lo(textattr));
    end;
  End
  else
  Begin
    gotoxy(X,Y);
    case Tip of
      Cadre1  : write('');
      Cadre2  : write('');
      Cadre3  : write('');
      Cadre4  : write('');
      Ombre1  : write('');
      Ombre2  : write('');
      Ombre3  : write('');
      Ombre4  : write('');
    end;
  End
End;

{}

Procedure Ligne(X,Y,Larg : byte;Tip : TypeBoite);

Var
  N : byte;

Begin
  gotoxy(X,Y);
  for N := 1 to Larg do
  case Tip of
    Cadre1  : write('');
    Cadre2  : write('');
    Cadre3  : write('');
    Cadre4  : write('');
    Ombre1  : write('');
    Ombre2  : write('');
    Ombre3  : write('');
    Ombre4  : write('');
  end;
End;

{}

Procedure LigneMilieu(X,Y,Larg : byte;Tip : TypeBoite;Plein : boolean);

Var
  N     : byte;
  Ligne : Str80;

  Procedure Cote;

  Begin
    case Tip of
      Cadre1  : write('');
      Cadre2  : write('');
      Cadre3  : write('');
      Cadre4  : write('');
      Ombre1  : write('');
      Ombre2  : write('');
      Ombre3  : write('');
      Ombre4  : write('');
    end;
  End;

Begin
  if Plein then
  Begin
    fillchar(Ligne,Larg + 1,' ');
    Ligne[0] := chr(Larg);
  End;
  gotoxy(X,Y);
  Cote;
  if Plein then write(Ligne);
  gotoxy(X + Larg + 1,Y);
  Cote;
End;

{}

Procedure Ombrage(X,Y,Larg,Haut : byte);

Var
  N : byte;
  XTmp , YTmp : byte;
  Ligne : Str80;

  (**************************)
  Procedure Ombre(X,Y : byte);

  Var
    Pos   : integer;

  Begin
    (* ecriture gris sur noir *)
    if X <= 80 then
    Begin
      Pos := (Y - 1) * 160 + (X - 1) * 2 +1;
      mem[BaseEcran: Pos] := Gris;
    End;
  End;
  (**************************)

Begin
  CoulFondTx(Noir);
  XTmp := X + Larg;
  for N := 1 to Haut do
  Begin
    YTmp := Y + N;
    Ombre(XTmp,YTmp);
    Ombre(XTmp + 1,YTmp);
  End;
  YTmp := Y + Haut;
  for N := 1 to (Larg + 1) do
  Begin
    XTmp := X + N;
    Ombre(XTmp,YTmp);
  End;
End;

{}

Procedure TitreBoiteTx(X,Y,Larg : byte;Titre : Str80);

Var
  XTitre : byte;

Begin
  if length(Titre) > (Larg - 2) then Titre := copy(Titre,1,(Larg - 2));
  XTitre := X + (Larg div 2) - (length(Titre) div 2) + 1;
  gotoxy(XTitre,Y);
  write(Titre);
End;

{}

Procedure BoiteTx(X,Y,Larg,Haut : byte;Tip : TypeBoite; Coul : CoupleCoul;
                                   Plein : boolean;TitreSup,TitreInf : Str80);

Var
  N : byte;

Begin
  CoulEncreTx(Coul.Encre);
  CoulFondTx(Coul.Fond);
  if Tip in [CadreSS,OmbreSS] then
  Begin
    if Larg > (81 - X) then Larg := (81 - X);
    if Haut > (26 - Y) then Haut := (26 - Y);
    for N := 1 to Haut do LigneMilieu(X,Y + N - 1,Larg,Tip,Plein);
  End
  else
  Begin
    (*if Larg > (80 - 1 - X) then Larg := (80 - 1 - X);
    if Haut > (25 - 1 - Y) then Haut := (25 - 1 - Y);*)
    if Larg > (79 - X) then Larg := (79 - X);
    if Haut > (24 - Y) then Haut := (24 - Y);
    CoinHautGauche(X,Y,Tip);
    Ligne(X + 1,Y,Larg,Tip);
    CoinHautDroit(X + Larg + 1,Y,Tip);
    for N := 1 to Haut do LigneMilieu(X,Y + N,Larg,Tip,Plein);
    CoinBasGauche(X,Y + Haut + 1,Tip);
    Ligne(X + 1,Y + Haut + 1,Larg,Tip);
    CoinBasDroit(X+ Larg + 1,Y + Haut + 1,Tip);
  End;
  if TitreSup <> '' then TitreBoiteTx(X,Y,Larg,TitreSup);
  if TitreInf <> '' then TitreBoiteTx(X,Y + Haut + 1,Larg,TitreInf);
  if Tip in [Ombre1,Ombre2,Ombre3,Ombre4] then Ombrage(X,Y,Larg + 2,Haut + 2);
  if Tip = OmbreSs then Ombrage(X,Y,Larg,Haut);
End;

{}

Procedure BarreGrapheTx(Var UnBarreGraphe : BarreGrapheRecTx;Valeur : longint;
                                                         UneAction : Action);

Var
  S            : TypeSauveTx;

  (**)
  Procedure Affichage;

  Var
    N : byte;
    S : Str80;

  Begin
    with UnBarreGraphe do
    Begin
      Ancien := 0;
      if X + Larg > 80 then Larg := 80 - X + 1;
      if Y > 25 then Y := 25;
      S := '';
      for N := 1 to Larg do S := S + '';
      EcritXYTx(X,Y,S,true);
(*      gotoxy(X,Y);
      for N := 1 to Larg do
        if (Y = 25) and (X + N - 1 = 80) then
           with CoulbarreGraphe do Write2580('',Fond,Encre)
        else write('');*)
    End;
  End;

  (**)
  Procedure Utilisation;

  Var
    N      : byte;
    Nombre : longint;
    S      : Str80;

  Begin
    with UnBarreGraphe do
    Begin
      if Valeur = Maxi then Nombre := Larg
                       else Nombre := trunc(Larg * Valeur / Maxi);
      if Nombre > Ancien then
      Begin
        S := '';
        for N := 1 to Nombre do S := S + '';
        EcritXYTx(X,Y,S,true);
        Ancien := Nombre;
      End;
(*      gotoxy(X,Y);
      for N := 1 to Nombre do
        if (Y = 25) and (X + N - 1 = 80) then
          with CoulBarreGraphe do Write2580('',Fond,Encre)
                                 else write('');*)
    End;
  End;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  CoulFondTx(CoulBarreGraphe.Fond);
  CoulEncreTx(CoulBarreGraphe.Encre);
  case UneAction of
    Afficher : Affichage;
    Utiliser : Utilisation;
  end;
  RestaureTx(S);
End;

{}

Procedure FondEcranTx(Car : char;Fond , Encre : Couleur);

Var
  S       : TypeSauveTx;
(*  Colonne : byte;
  Ligne   : byte;*)
  Reg     : registers;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  CoulFondTx(Fond);
  CoulEncreTx(Encre);
(*  for Ligne := 1 to 24 do
  Begin
    gotoxy(1,Ligne);
    for Colonne := 1 to 80 do write(Car);
  End;
  gotoxy(1,25);
  for Colonne := 1 to 79 do write(Car);
  Write2580(Car,Fond,Encre);*)
  gotoxy(1,1);
  with Reg do
  Begin
    AH := $09;
    BL := textattr;
    BH := 0;
    AL := ord(Car);
    CX := 2000;
    intr($10,reg);
  End;
  RestaureTx(S);
End;

{}

Procedure BoiteAProposTx;

Var
  S             : TypeSauveTx;
  PosX          : byte;               { Coordonnee en X du coin haut gauche }
  PosY          : byte;               { Coordonnee en Y du coin haut gauche }
  Largeur       : byte;               { Largeur de la boite                 }
  Hauteur       : byte;               { Hauteur de la boite                 }
  Taille        : word;               { Taille des donnees recouvertes      }
  Donnees       : pointer;            { Donnees recouvertes                 }
  UnBouton      : BoutonTxPtr;        { Bouton OK            }

  (**)
  Procedure Initialisation;

  Var
    Long : byte;
    Mil  : byte;
    X,Y  : byte;

  Begin
    Largeur := 46;
    Hauteur := 16;

    Long := Largeur div 2;
    Mil := (lo(windmax) - lo(windmin)) div 2 + 1;
    PosX := Mil - Long + 1;

    Long := Hauteur div 2;
    Mil := (hi(windmax) - hi(windmin)) div 2 + 1;
    PosY := Mil - Long;

    Taille := (Largeur + 1) * (Hauteur + 1) * 2;
    if not ReserveMem(Donnees,Taille) then PlusDeMemoireTx;
    SauveRectTx (PosX, PosY, PosX + Largeur, PosY + Hauteur,Donnees);


    X := PosX + (Largeur div 2) - 4;
    Y := PosY + 12;
    InitBoutonTx(UnBouton,'&Ok',X,Y,6,true,true);
  End;

  (**)
  Procedure Affichage;

  Var
    Long : byte;
    Tmp  : Str40;

  Begin
    BoiteTx(PosX,PosY,Largeur - 4,Hauteur - 3,Ombre2,CoulBtSaisie,true,'','');
    CoulFondTx(CoulBtAPropos.Fond);
    CoulEncreTx(CoulBtAPropos.Encre);
    Long := Largeur - 6;
    gotoxy(PosX + 2, PosY + 2);
    write(Elargi(Soft.Nom,Long));
    gotoxy(PosX + 2, PosY + 4);
    write(Elargi(Soft.Version,Long));
    gotoxy(PosX + 2, PosY + 6);
    write(Elargi(Soft.Info1,Long));
    gotoxy(PosX + 2, PosY + 8);
    write(Elargi(Soft.Info2,Long));
    str(MemAvail,Tmp);
    Tmp := Tmp + LigneMemLibre;
    gotoxy(PosX + 2, PosY + 10);
    write(Elargi(Tmp,Long));
    AfficheBoutonTx(UnBouton);
  End;

  (**)
  Procedure Attente;

  Var
    Ok     : boolean;
    Car    : char;
    Souris : PosRec;
    XTmp   : byte;
    YTmp   : byte;

  Begin
    MontreSouris;
    Ok := false;
    XTmp := 0;
    YTmp := 0;
    repeat
      if AttendActionTx(Car,Souris) then
      Begin
        DelaiSouris(TempoSouris);
        if SourisDsBoutonTx(UnBouton,Souris) then Car := CarReturn;
      End;
      if ToucheFct and (Car = AltO) then Car := CarReturn;
      Ok := Car = CarReturn;
    until Ok;
    CacheSouris;
  End;

  (**)
  Procedure Efface;

  Begin
    LitRectTx (PosX, PosY, PosX + Largeur, PosY + Hauteur,Donnees);
    freemem(Donnees,Taille);
    Donnees := nil;
    LibereBoutonTx(UnBouton);
  End;

Begin
  with Soft do
    if (Nom = '') and (Version = '') and (Info1 = '') and
                                         (Info2 = '') then exit;
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  Initialisation;
  Affichage;
  Attente;
  Efface;
  RestaureTx(S);
End;

(**)

Function SaisieTx(X,Y,Long : byte;Tip : Donnee;UneAction : Action;
                                                       Autre : boolean):char;

Var
  S            : TypesauveTx;      { sauvegarde de parametre }
  Souligne     : Str80;            { soulignement de 80 caracteres }
  ValParDefaut : Str80;            { stockage valeur par defaut }
  PremierCar   : boolean;          { est-ce le premier caractere ? }
  Fin          : boolean;          { une donnee vient d'etre validee }
  Abandon      : boolean;          { demande d'abandon }
  Insertion    : boolean;          { en mode insertion ? }
  NumCar       : byte;             { n du caractere curseur dans la chaine }
  LeCar        : char;             { caractere venant d'etre frappe }
  InfoSouris   : PosRec;           { position souris lors du dernier clic }
  XTmp         : byte;             { position temporaire en X }
  YTmp         : byte;             { position temporaire en Y }
  Tmp          : byte;             { valeur temporaire }

  (**)
  Procedure Convertir;

  Begin
    case Tip of
      Entier : UneChaine := IntToStr(UnEntier);
      Reel   : UneChaine := RealToStr(UnReel,LongStd,PrecisStd);
    end;
    if length(UneChaine) > Long then UneChaine := copy(UneChaine,1,Long);
  End; { Convertir }

  (**)
  Procedure SaisieVide;

  Begin
    fillchar (Souligne,81,' ');
    Souligne[0] := #80;
    CoulFondTx(CoulSaisie.Fond);
    gotoxy (X,Y);
    write (' ',copy(Souligne,1,Long),' ');
  End; { SaisieVide }

  (**)
  Procedure InitSaisie;

  Begin
    CoulFondTx(CoulInitSaisie.Fond);
    CoulEncreTx(CoulInitSaisie.Encre);
    PremierCar := true;
    fillchar (Souligne,81,'_');
    Souligne[0] := #80;
    ValParDefaut := UneChaine;
    NumCar := 1;
    Fin := false;
    Abandon := false;
    Insertion := not CurseurOve;
  End; { InitSaisie }

  (**)
  Procedure Position;

  Begin
    if NumCar >= 1 then gotoxy ((X + NumCar),Y)
                   else Beep;
  End; { Position }

  (**)
  Procedure AfficheValeur;

  Begin
    CacheSouris;
    gotoxy ((X + 1),Y);
    write (UneChaine,copy(Souligne,1,Long - length(UneChaine)));
    Position;
    MontreSouris;
  End; { AfficheValeur }

  (**)
  Procedure AfficheDefaut;

  Begin
    UneChaine := ValParDefaut;
    PremierCar := false;
    NumCar := 1;
    AfficheValeur;
  End; { AfficheDefaut }

  (**)
  Procedure RemonteTampon;

  Var
    AncienneChaine : Str80;

  Begin
    AncienneChaine := UneChaine;
    case Tip of
      Chaine : UneChaine := LitTampon(TamponChaine,true);
      Entier : UneChaine := LitTampon(TamponEntier,true);
      Reel   : UneChaine := LitTampon(TamponReel,true);
    end;
    if UneChaine = '' then
    Begin
      UneChaine := AncienneChaine;
      Beep;
    End;
    NumCar := 1;
    AfficheValeur;
  End; { RemonteTampon }

  (**)
  Procedure DescendTampon;

  Var
    AncienneChaine : Str80;

  Begin
    AncienneChaine := UneChaine;
    case Tip of
      Chaine : UneChaine := LitTampon(TamponChaine,false);
      Entier : UneChaine := LitTampon(TamponEntier,false);
      Reel   : UneChaine := LitTampon(TamponReel,false);
    end;
    if UneChaine = '' then
    Begin
      UneChaine := AncienneChaine;
      Beep;
    End;
    NumCar := 1;
    AfficheValeur;
  End; { DescendTampon }

  (**)
  Procedure TestPremierCar;

  Begin
    if PremierCar then
    Begin
      PremierCar := false;
      AfficheValeur;
    End;
  End; { TestPremierCar }

  (**)
  Procedure DebutLigne;

  Begin
    NumCar := 1;
    Position;
    TestPremierCar;
  End; { DebutLigne }

  (**)
  Procedure FinLigne;

  Begin
    NumCar := length(UneChaine) + 1;
    Position;
    TestPremierCar;
  End; { FinLigne }

  (**)
  Procedure VaGauche;

  Begin
    if NumCar > 1 then
    Begin
      dec(NumCar);
      Position;
    End
    else Beep;
    TestPremierCar;
  End; { VaGauche }

  (**)
  Procedure VaDroite;

  Begin
    if (NumCar < Long) and (NumCar < (length(UneChaine) + 1)) then
    Begin
      inc(NumCar);
      Position;
    End
    else Beep;
    TestPremierCar;
  End; { VaDroite }

  (**)
  Procedure RemiseAZero;

  Begin
    UneChaine := '';
    DebutLigne;
    AfficheValeur;
  End; { RemiseAZero }

  (**)
  Procedure Supprime;

  Begin
    if (NumCar >= 1) and (UneChaine <> '') then
    Begin
      delete(UneChaine,NumCar,1);
      AfficheValeur;
    End
    else Beep;
  End; { Supprime }

  (**)
  Procedure InsertionOverwrite;

  Begin
    CurseurOve := not CurseurOve;
    Insertion := not CurseurOve;
    MontreCurseurTx;
  End; { InsertionOverwrite }

  (**)
  Procedure Corrige;

  Begin
    if NumCar > 1 then
    Begin
      delete(UneChaine,(NumCar - 1),1);
      dec(NumCar);
      AfficheValeur;
    End
    else Beep;
  End; { Corrige }

  (**)
  Procedure Ajouter;

  Begin
    if NumCar <= Long then
    Begin
      if NumCar > length(UneChaine) then
         UneChaine := concat(UneChaine,LeCar)
      else UneChaine[NumCar] := LeCar;
      inc(NumCar);
      Affichevaleur;
    End
    else Beep;
  End; { Ajouter }

  (**)
  Procedure Inserer;

  Begin
    if length(UneChaine) < Long then
    Begin
      insert (LeCar,UneChaine,NumCar);
      inc(NumCar);
      AfficheValeur;
    End
    else Beep;
  End; { Inserer }

  (**)
  Function CaractereValide : boolean;

  Var
    Ok : boolean;

  Begin
    Ok := false;
    case Tip of
      Chaine : Ok := (LeCar >= ' ');
      Entier : Begin
                 if LeCar in ['0'..'9'] then Ok := true;
                 if (LeCar in ['+','-']) and (NumCar = 1) then Ok := true;
               End;
      Reel   : Begin
                 if LeCar in ['0'..'9'] then Ok := true;
                 if (LeCar in ['+','-']) and (NumCar = 1) then Ok := true;
                 if (LeCar = '.') and (pos('.',UneChaine) = 0) then Ok := true;
               End;
    end;
    if (not Ok) and (LeCar <> #0) then Beep;
    CaractereValide := Ok;
  End; { CaractereValide }

  (**)
  Procedure Reconvertir;

  Begin
    case Tip of
      Entier : UnEntier := StrToInt(UneChaine);
      Reel   : UnReel := StrToReal(UneChaine);
    end;
  End; { Reconvertir }

  (**)
  Procedure AfficheFinal;

  Begin
    CacheSouris;
    gotoxy ((X + 1),Y);
    write (ElargiADte(UneChaine,Long));
    MontreSouris;
  End;

  (**)
  Procedure StockeTampon;

  Begin
    case Tip of
      Chaine : AjouteTampon(TamponChaine,UneChaine);
      Entier : AjouteTampon(TamponEntier,UneChaine);
      Reel   : AjouteTampon(TamponReel,UneChaine);
    end;
  End;

  (**)
  Function SourisDsSaisie:boolean;

  Var
    Exact : boolean;

  Begin
    Exact := false;
    if Ytmp = Y then
    Begin
      Tmp := XTmp - X;
      if Tmp <= Long then Exact := true;
    End;
    SourisDsSaisie := Exact;
  End;

  (**)
  Procedure Affichage;

  Begin
    Convertir;
    SaisieVide;
    InitSaisie;
    CoulFondTx(CoulSaisie.Fond);
    CoulEncreTx(CoulSaisie.Encre);
    AfficheFinal;
    SaisieTx := #255;
  End;

  (**)
  Procedure Utilisation;

  Begin
    Convertir;
    SaisieVide;
    InitSaisie;
    AfficheValeur;
    LigneAide.Texte := AideSaisie;
    AfficheLigneAideTx(true);
    repeat
      if PremierCar then
      Begin
        CoulFondTx(CoulSaisie.Fond);
        CoulEncreTx(CoulSaisie.Encre);
      End;

      if AttendActionTx(LeCar,InfoSouris) then
      Begin
        DelaiSouris(TempoSouris);
        PosSourisPosTx(InfoSouris.Colonne,InfoSouris.Ligne,Xtmp,YTmp);
        if (InfoSouris.Bouton = BoutonGauche) then
        Begin
          if SourisDsSaisie then
          Begin
            if Tmp <= length(UneChaine) then
            Begin
              NumCar := Tmp;
              TestPremierCar;
              Position;
            End
            else Beep;
          End
          else
          if Autre then
          Begin
            LeCar := #00;
            Fin := true;
          End;
        End;
(*        if (InfoSouris.Bouton = BoutonDroit) then LeCar := CarReturn;*)
      End;

      if ToucheFct then
      Begin
        case LeCar of
          FlchDebut  : DebutLigne ;
          FlchFin    : FinLigne ;
          FlchGauche : VaGauche;
          FlchDroite : VaDroite;
          FlchHaut   : RemonteTampon;
          FlchBas    : DescendTampon;
          TchSuppr   : Supprime;
          TchInser   : InsertionOverwrite;
          F3         : AfficheDefaut;
          F5         : RemiseAZero;
          ShiftTab   : if Autre then Fin := true
                                else Beep;
          ShiftF1    : BoiteAProposTx;
          AltX       : Begin
                         Sortie := true;
                         Abandon := true;
                       End;
          else
          if (LeCar in [AltQ..AltP,AltA..AltL,AltZ,AltC..AltM]) and Autre
             then Fin := true
             else Beep;
        end;
      End
      else
      Begin
        case LeCar of
          TchBS     : Corrige;
          CarReturn : Begin
                        StockeTampon;
                        Fin := true;
                      End;
          CarEsc    : Abandon := true;
          Tab       : if Autre then Fin := true
                               else Beep;
          else
          if CaractereValide then
          Begin
            if PremierCar then UneChaine := '';
            if Insertion and (NumCar < length(UneChaine)) then Inserer
                                                          else Ajouter;
            TestPremierCar;
          End;
        end;
      End;
    until Fin or Abandon;
    if Fin then Reconvertir;
    AfficheFinal;
    SaisieTx := LeCar;
  End;

Begin
  SauvegardeTx(S);
  MontreCurseurTx;
  CacheSouris;
  case UneAction of
    Afficher : Affichage;
    Utiliser : Utilisation;
  end;
  RestaureTx(s);
End;

{}

Function LireChaineTx(Titre : Str80;X,Y,Long : byte;UneAction : Action;
                                                       Autre : boolean):char;

Var
  S    : TypesauveTx;      { sauvegarde de parametre }
  XTmp : byte;             { valeur de X pour la saisie }

Begin
  SauvegardeTx(S);
  gotoxy(X,Y);
  write(Titre);
  XTmp := X + length(Titre);
  LireChaineTx := SaisieTx(XTmp,Y,Long,Chaine,UneAction,Autre);
  RestaureTx(S);
End;

{}

Function LireEntierTx(Titre : Str80;X,Y,Long : byte;UneAction : Action;
                                     Autre : boolean;Min,Max : longint):char;

Var
  S    : TypesauveTx;      { sauvegarde de parametre }
  XTmp : byte;             { valeur de X pour la saisie }
  Tmp  : char;             { caractere temporaire }
  Ok   : boolean;          { touche ESC ou AltX actionnee }

  Procedure Utilisation;

  Begin
    repeat
      Tmp := SaisieTx(XTmp,Y,Long,Entier,UneAction,Autre);
      if not ((UnEntier >= Min) and (UnEntier <= Max)) then Beep;
      Ok := (Tmp = CarEsc) or Sortie;
    until (((UnEntier >= Min) and (UnEntier <= Max))) or  Ok;
  End;

Begin
  SauvegardeTx(S);
  gotoxy(X,Y);
  write(Titre);
  XTmp := X + length(Titre);
  case UneAction of
    Afficher : Tmp := SaisieTx(XTmp,Y,Long,Entier,UneAction,Autre);
    Utiliser : Utilisation;
  end;
  LireEntierTx := Tmp;
  RestaureTx(S);
End;

{}

Function LireReelTx(Titre : Str80;X,Y,Long : byte;UneAction : Action;
                                        Autre : boolean;Min,Max : real):char;

Var
  S    : TypesauveTx;      { sauvegarde de parametre }
  XTmp : byte;             { valeur de X pour la saisie }
  Tmp  : char;             { caractere temporaire }
  Ok   : boolean;          { touche ESC ou AltX actionnee }

  Procedure Utilisation;

  Begin
    repeat
      Tmp := SaisieTx(XTmp,Y,Long,Reel,UneAction,Autre);
      if not ((UnReel >= Min) and (UnReel <= Max)) then Beep;
      Ok := (Tmp = CarEsc) or Sortie;
    until ((UnReel >= Min) and (UnReel <= Max)) or Ok;
  End;

Begin
  SauvegardeTx(S);
  gotoxy(X,Y);
  write(Titre);
  XTmp := X + length(Titre);
  case UneAction of
    Afficher : Tmp := SaisieTx(XTmp,Y,Long,Reel,UneAction,Autre);
    Utiliser : Utilisation;
  end;
  LireReelTx := Tmp;
  RestaureTx(S);
End;

{}

Function ChoixCtrlTx(Var ChoixCtrl : ChoixCtrlRecTx;Var Liste : ListeRec;
                                    UneAction : Action;Autre : boolean):char;

Var
  S            : TypeSauveTx;
  XTmp         : byte;
  YTmp         : byte;
  W            : integer;          { variable de comptage }
  Nombre       : integer;          { nombre d'elements de la liste }
  Largeur      : byte;             { largeur de la zone liste }
  Hauteur      : byte;             { hauteur de la zone liste }
  Fin          : boolean;          { une donnee vient d'etre validee }
  Abandon      : boolean;          { demande d'abandon }
  LeCar        : char;             { caractere venant d'etre frappe }
  InfoSouris   : PosRec;           { position souris lors du dernier clic }
  PremierAffi  : integer;          { numero du premier element affiche }
  NumEnCours   : integer;          { numero de l'element selectionee }
  Reafficher   : boolean;          { reaffichage necessaire }
  ChaineRech   : Str80;            { chaine recherchee }
  PosTxListe   : CoinRectangle;    { position de la liste }

  (**)
  Procedure CalculLargeur;

  Var
    N : integer;

  Begin
    Largeur := 0;
    Nombre := 0;
    for N := 1 to MaxChoix do
      if Liste[N]^.Texte <> '' then
      Begin
        if length(Liste[N]^.Texte) > Largeur then
          Largeur := length(Liste[N]^.Texte);
        inc(Nombre);
      End;
    Largeur := Largeur + 2;
  End;

  (**)
  Procedure AfficheAscenceur;

  Var
    S1   : TypeSauveTx;
    N    : byte;
    XBas : byte;
    YBas : byte;
    Pos  : byte;

  Begin
    with ChoixCtrl do
    Begin
      if not Ascenseur then exit;
      SauvegardeTx(S1);
      CacheSouris;
      if MaxVisible >= 3 then
      Begin
        CoulFondTx(CoulAscenceur.Fond);
        CoulEncreTx(CoulAscenceur.Encre);
        gotoxy(X + Largeur,Y);
        write('');
        for N := 2 to (Hauteur - 1) do
        Begin
          gotoxy(X + Largeur,Y + N - 1);
          write('');
        End;
        XBas := X + Largeur;
        YBas:= Y + Hauteur - 1;
        if (XBas = 80) and (YBas = 25) then
          with CoulAscenceur do Write2580('',Fond,Encre)
        else
        Begin
          gotoxy(X + Largeur,Y + Hauteur - 1);
          write('');
        End;
        Pos := trunc((NumEnCours / Nombre) * (Hauteur - 2));
        if NumEnCours = 1 then Pos := 1;
        if Pos = 0 then Pos := 1;
        if Pos > (Hauteur - 2) then Pos := (Hauteur - 2);
        gotoxy(X + Largeur,Y + Pos);
        write('');
      End;
      RestaureTx(S1);
    End;
  End;

  (**)
  Procedure TrieListe(Debut,Fin : integer;Ascendant : boolean);

  Var
    Bas        : integer;
    Haut       : integer;
    Separateur : Str80;
    Tmp        : EltListe;

  Begin
    Bas := Debut;
    Haut := Fin;
    Separateur := Liste[(Debut + Fin) div 2]^.Texte;

    repeat
      Begin
        if Ascendant then
        Begin
          while (Liste[Bas]^.Texte < Separateur) do inc(Bas);
          while (Liste[Haut]^.Texte > Separateur) do dec(Haut);
        End
        else
        Begin
          while (Liste[Bas]^.Texte > Separateur) do inc(Bas);
          while (Liste[Haut]^.Texte < Separateur) do dec(Haut);
        End;
        if Bas <= Haut then
        Begin
          Tmp := Liste[Bas]^;
          Liste[Bas]^ := Liste[Haut]^;
          Liste[Haut]^ := Tmp;
          inc(Bas);
          dec(Haut);
        End;
      End;
    until (Bas > Haut);

    if Debut < Haut then TrieListe(Debut,Haut,Ascendant);
    if Bas < Fin then TrieListe(Bas,Fin,Ascendant);
  End;

  (**)
  Procedure AfficheListe;

  Var
    S1         : TypeSauveTx;
    Select     : byte;
    N          : integer;
    FenetreMin : word;
    FenetreMax : word;

  Begin
    with ChoixCtrl do
    Begin
      SauvegardeTx(S1);
      CacheSouris;
      CoulFondTx(CoulChoixCtrl.Fond);
      CoulEncreTx(CoulChoixCtrl.Encre);
      FenetreMin := windmin;
      FenetreMax := windmax;
      window(X,Y,X + Largeur - 1,Y + Hauteur - 1);
      clrscr;
      windmin := FenetreMin;
      windmax := FenetreMax;
      for N := 1 to MaxVisible do
      Begin
        gotoxy(X, Y + N - 1);
        if Liste[(N + PremierAffi - 1)]^.Selectionne then
        Begin
          CoulFondTx(CoulChoixSelec.Fond);
          CoulEncreTx(CoulChoixSelec.Encre);
        End
        else
        Begin
          CoulFondTx(CoulChoixCtrl.Fond);
          CoulEncreTx(CoulChoixCtrl.Encre);
        End;
        write(' ',ElargiADte(Liste[(N + PremierAffi - 1)]^.Texte,Largeur - 1));
      End;
      Select := NumEnCours - PremierAffi + 1;
      InverseTexteTx(X,Y + Select - 1,Largeur);
      RestaureTx(S1);
    End;
  End;

  (**)
  Procedure ReafficheListe;

  Var
    S1         : TypeSauveTx;
    Select     : byte;
    N          : integer;
    FenetreMin : word;
    FenetreMax : word;

  Begin
    with ChoixCtrl do
    Begin
      SauvegardeTx(S1);
      CacheSouris;
      for N := 1 to MaxVisible do
      Begin
        gotoxy(X, Y + N - 1);
        if Liste[(N + PremierAffi - 1)]^.Selectionne then
        Begin
          CoulFondTx(CoulChoixSelec.Fond);
          CoulEncreTx(CoulChoixSelec.Encre);
        End
        else
        Begin
          CoulFondTx(CoulChoixCtrl.Fond);
          CoulEncreTx(CoulChoixCtrl.Encre);
        End;
        write(' ',ElargiADte(Liste[(N + PremierAffi - 1)]^.Texte,Largeur - 1));
      End;
      Select := NumEnCours - PremierAffi + 1;
      InverseTexteTx(X,Y + Select - 1,Largeur);
      RestaureTx(S1);
    End;
  End;

  (**)
  Procedure VaDebut;

  Begin
    if (PremierAffi = 1) and (NumEnCours = 1) then Reafficher := false
                                              else Reafficher := true;
    PremierAffi := 1;
    NumEnCours := 1;
    ChaineRech := '';
  End;

  (**)
  Procedure VaFin;

  Var
    Tmp : integer;

  Begin
    with ChoixCtrl do
    Begin
      Tmp := Nombre - Hauteur + 1;
      if (PremierAffi = Tmp) and (NumEnCours = Nombre)
        then Reafficher := false
        else Reafficher := true;
      if Nombre > MaxVisible then PremierAffi := Tmp
                             else PremierAffi := 1;
      NumEnCours := Nombre;
      ChaineRech := '';
    End;
  End;

  (**)
  Procedure VaBas;

  Begin
    if NumEnCours < Nombre then
    Begin
      inc(NumEnCours);
      Reafficher := true;
    End;
    if NumEnCours > (PremierAffi + ChoixCtrl.MaxVisible - 1) then
       inc(PremierAffi);
    ChaineRech := '';
  End;

  (**)
  Procedure VaHaut;

  Begin
    if NumEnCours > 1 then
    Begin
      dec(NumEnCours);
      Reafficher := true;
    End;
    if NumEnCours < PremierAffi then dec(PremierAffi);
    ChaineRech := '';
  End;

  (**)
  Procedure VaPgBas;

  Var
    Tmp : integer;

  Begin
    with ChoixCtrl do
    Begin
      if NumEnCours < Nombre then
      Begin
        Reafficher := true;
        Tmp := PremierAffi + MaxVisible + MaxVisible  - 1;
        if Tmp <= Nombre then
          Begin
            PremierAffi := PremierAffi + MaxVisible;
            NumEnCours := NumEnCours + MaxVisible;
          End
          else
          Begin
            if Nombre > MaxVisible then
               PremierAffi := Nombre - MaxVisible + 1;
            NumEnCours := Nombre;
          End;
      End;
      ChaineRech := '';
    End;
  End;

  (**)
  Procedure VaPgHaut;

  Begin
    with ChoixCtrl do
    Begin
      if NumEnCours > 1 then
      Begin
        Reafficher := true;
        if PremierAffi > MaxVisible then
          Begin
            PremierAffi := PremierAffi - MaxVisible;
            NumEnCours := NumEnCours - MaxVisible;
          End
          else
          Begin
            PremierAffi := 1;
            NumEnCours := 1;
          End;
      End;
      ChaineRech := '';
    End;
  End;

  (**)
  Procedure ChangeSelection;

  Begin
    Liste[NumEnCours]^.Selectionne := not Liste[NumEnCours]^.Selectionne;
    Reafficher := true;
  End;

  (**)
  Procedure VaNumero(Num : integer);

  Var
    Tmp : integer;

  Begin
    with ChoixCtrl do
    Begin
      Reafficher := true;
      if (Num in [PremierAffi .. (PremierAffi + MaxVisible - 1)]) then
        NumEnCours := Num
      else
      Begin
        Tmp := Nombre - Num;
        if Tmp < MaxVisible then
        Begin
          if Nombre > MaxVisible
            then PremierAffi := Nombre -  MaxVisible + 1
            else PremierAffi := 1;
          NumEnCours := Num;
        End
        else
        Begin
          if not (Num in [PremierAffi .. (PremierAffi + MaxVisible - 1)]) then
             PremierAffi := Num;
          NumEnCours := Num;
        End;
      End;
    End;
  End;

  (**)
  Procedure RechercheChaine;

  Var
    Long      : byte;
    ChaineTmp : Str80;
    NumRech   : integer;

    {}
    Procedure Avance;

    Begin
      repeat
        inc(NumRech);
        ChaineTmp := copy(Liste[NumRech]^.Texte,1,Long);
      until (ChaineTmp >= ChaineRech) or (NumRech = Nombre);
    End;

    {}
    Procedure Recule;

    Begin
      repeat
        dec(NumRech);
        ChaineTmp := copy(Liste[NumRech]^.Texte,1,Long);
      until (ChaineTmp < ChaineRech) or (NumRech = 1);
      if (ChaineTmp < ChaineRech) then inc(NumRech);
      ChaineTmp := copy(Liste[NumRech]^.Texte,1,Long);
    End;


  Begin
    if ChoixCtrl.Trie = Sans then
    Begin
      Beep;
      exit;
    End;
    ChaineRech := ChaineRech + LeCar;
    Long := length(ChaineRech);
    NumRech := NumEnCours;
    ChaineTmp := copy(Liste[NumRech]^.Texte,1,Long);
    if ChaineTmp < ChaineRech then Avance
      else if ChaineTmp > ChaineRech then Recule;
    if ChaineTmp = ChaineRech then VaNumero(NumRech)
    else
    Begin
      ChaineRech := copy(ChaineRech,1,Long - 1);
      Beep;
    End;
  End;

  (**)
  Procedure TesteSouris;

  Var
    NumTmp : integer;

    {}
    Procedure SourisVaHaut;

    Begin
      repeat
        VaHaut;
        if Reafficher then
        Begin
        AfficheAscenceur;
        ReafficheListe;
        End
        else Beep;
        delay(TempoDefile);
        SourisRelachee(BoutonGauche,InfoSouris);
      until (InfoSouris.Bouton <> BoutonGauche) or (NumEnCours = 1);
      if NumEnCours = 1 then Beep;
    End;

    {}
    Procedure SourisVaBas;

    Begin
      repeat
        VaBas;
        if Reafficher then
        Begin
        AfficheAscenceur;
        ReafficheListe;
        End
        else Beep;
        delay(TempoDefile);
        SourisRelachee(BoutonGauche,InfoSouris);
      until (InfoSouris.Bouton <> BoutonGauche) or (NumEnCours = Nombre);
      if NumEnCours = Nombre then Beep;
    End;

    {}
    Procedure SourisAscenceur;

    Begin
      with ChoixCtrl do
      Begin
        if not Ascenseur then exit;
        if YTmp = Y then SourisVaHaut;
        if YTmp = (Y + Hauteur - 1) then SourisVaBas;
        if YTmp in [(Y+1) .. (Y + Hauteur - 2)] then
        Begin
          NumTmp := (YTmp - Y);
          if NumTmp = 1 then VaNumero(1)
          else
          Begin
            NumTmp := NumTmp * Nombre div (Hauteur - 2) + 1;
            if NumTmp > Nombre then NumTmp := Nombre;
            VaNumero(NumTmp);
          End;
        End;
        if (Autre and not (YTmp in [Y.. (Y + Hauteur - 1)])) then
        Begin
          LeCar := #00;
          Fin := true;
        End
        else LeCar := #255;
      End;
    End;

    {}
    Procedure SourisListe;

    Begin
      DelaiSouris(TempoSouris);
      with PosTxListe do
      if SourisDsZone(XTmp,YTmp,X1,Y1,X2,Y2) then
      Begin
        if ChoixCtrl.Multiple then
        Begin
          NumTmp := PremierAffi + YTmp - Y1;
          if Compresse(Liste[NumTmp]^.Texte) = '' then LeCar := #255
          else
          Begin
            VaNumero(NumTmp);
            ChangeSelection;
            LeCar := #255;
          End;
        End
        else
        Begin
          NumTmp := PremierAffi + YTmp - Y1;
          if Compresse(Liste[NumTmp]^.Texte) = '' then LeCar := #255
          else
          Begin
            VaNumero(NumTmp);
            LeCar := CarReturn;
          End;
        End;
      End
      else if Autre then
      Begin
        LeCar := #00;
        Fin := true;
      End;
    End;
    {}

  Begin
    if InfoSouris.Nombre <> 0 then
    with ChoixCtrl do
    Begin
      case InfoSouris.Bouton of
        BoutonGauche : if XTmp = (X + Largeur) then SourisAscenceur
                                               else SourisListe;
        BoutonDroit  : if ChoixCtrl.Multiple then LeCar := CarReturn;
      end;
      if Reafficher then
      Begin
        AfficheAscenceur;
        ReafficheListe;
      End
      else if (LeCar <> CarReturn) and not Fin then Beep;
      ChaineRech := '';
      if LeCar = CarReturn then Fin := true;
    End;
  End;

  (**)
  Procedure TesteTouche;

  Begin
    Reafficher := false;
    if ToucheFct then
    Begin
      case LeCar of
        FlchDebut  : VaDebut;
        FlchFin    : VaFin;
        FlchBas    : VaBas;
        FlchHaut   : VaHaut;
        FlchGauche : VaPgHaut;
        FlchDroite : VaPgBas;
        FlchPgHaut : VaPgHaut;
        FlchPgBas  : VaPgBas;
        ShiftTab   : if Autre then Fin := true
                              else Beep;
        ShiftF1    : BoiteAProposTx;
        AltX       : Begin
                       Sortie := true;
                       Abandon := true;
                     End;
        else
          if (LeCar in [AltQ..AltP,AltA..AltL,AltZ,AltC..AltM]) and Autre
             then Fin := true
             else Beep;
      end;
      if Reafficher then
      Begin
        AfficheAscenceur;
        ReafficheListe;
      End
      else
      if not (LeCar in [ShiftTab,AltQ..AltP,AltA..AltL,AltZ..AltM]) then Beep;
    End
    else
    Begin
      TestClavier;
      if ChoixCtrl.EnMaj then LeCar := UpCase(LeCar);
      if (LeCar in Alphanumerique) and not ((LeCar = Espace) and Clavier.Alt)
         then RechercheChaine
      else
      case LeCar of
        CarReturn : Fin := true;
        CarEsc    : Abandon := true;
        Espace    : if ChoixCtrl.Multiple then ChangeSelection
                                          else Beep;
        Tab       : if Autre then Fin := true
                             else Beep;
        #255      :;
        #00       : if not Autre then Beep;
        else Beep;
      end;
      if Reafficher then
      Begin
        AfficheAscenceur;
        ReafficheListe;
      End;
    End;
  End;

  (**)
  Procedure Affichage;

  Begin
    with ChoixCtrl do
    Begin
      if Pos > Nombre then Pos := 1;
      PremierAffi := 1;
      NumEnCours := Pos;
      if NumEnCours > MaxVisible then VaNumero(NumEnCours);
    End;
    ChaineRech := '';
    AfficheAscenceur;
    AfficheListe;
    ChoixCtrlTx := #255;
  End;

  (**)
  Procedure Utilisation;

  Begin
    with ChoixCtrl do
    Begin
      if Pos > Nombre then Pos := 1;
      PremierAffi := 1;
      NumEnCours := Pos;
      if NumEnCours > MaxVisible then VaNumero(NumEnCours);
      ChaineRech := '';
      if Multiple then LigneAide.Texte := AideChoixMultiple
                  else LigneAide.Texte := AideChoix;
      AfficheAscenceur;
      AfficheListe;
      AfficheLigneAideTx(true);
      Fin := false;
      Abandon := false;
      MontreSouris;
      repeat
        if AttendActionTx(LeCar,InfoSouris) then
        Begin
          PosSourisPosTx(InfoSouris.Colonne,InfoSouris.Ligne,Xtmp,YTmp);
          TesteSouris;
        End
        else TesteTouche;
      until Fin or Abandon;
      if not Multiple then Liste[NumEnCours]^.Selectionne := true;
      Pos := NumEnCours;
      ChoixCtrlTx := LeCar;
    End;
  End;

Begin
  with ChoixCtrl do
  Begin
    SauvegardeTx(S);
    CacheCurseurTx;
    CalculLargeur;
    Larg := Largeur;
    if Ascenseur then inc(Larg);
    if MaxVisible > 25 then MaxVisible := 25;
    Hauteur := MaxVisible;
    Haut := Hauteur;
    if (Y + Hauteur) > hi(windmax) then Y := hi(windmax) - Hauteur + 2;
    if (X + Largeur) > lo(windmax) then X := lo(windmax) - Largeur + 1;
    with PosTxListe do
        Begin
          X1 := X;
          Y1 := Y;
          X2 := X + Largeur - 1;
          Y2 := Y + Hauteur - 1;
        End;
    if not (UneAction = Initialiser) then
    Begin
      if Trie = Ascendant then TrieListe(1,Nombre,true);
      if Trie = Descendant then TrieListe(1,Nombre,false);
    End;
    case UneAction of
      Afficher : Affichage;
      Utiliser : Utilisation;
    end;
    delay(100);
    RestaureTx(S);
  End;
End;

{}

Function ChoixFichierTx(Var ChoixFic : ChoixFicRecTx;Var UnRepertoire : NomRep;
              Var UnMasque : NomFic;UneAction : Action;Autre : boolean):char;

Var
  S            : TypeSauveTx;
  XTmp         : byte;
  YTmp         : byte;
  Liste        : ListeFicRec;      { liste des fichiers }
  Nombre       : integer;          { nombre d'elements de la liste }
  Largeur      : byte;             { largeur de la zone liste }
  Hauteur      : byte;             { hauteur de la zone liste }
  Fin          : boolean;          { une donnee vient d'etre validee }
  Abandon      : boolean;          { demande d'abandon }
  LeCar        : char;             { caractere venant d'etre frappe }
  InfoSouris   : PosRec;           { position souris lors du dernier clic }
  PremierAffi  : integer;          { numero du premier element affiche }
  NumEnCours   : integer;          { numero de l'element selectionee }
  Reafficher   : boolean;          { reaffichage necessaire }
  PosTxListe   : CoinRectangle;    { position de la liste }

  (**)
  Procedure TrieAlpha(Debut,Fin : integer;Ascendant : boolean);

  Var
    Bas        : integer;
    Haut       : integer;
    Separateur : Str80;
    Tmp        : EltListeFic;

  Begin
    Bas := Debut;
    Haut := Fin;
    Separateur := Liste[(Debut + Fin) div 2]^.Texte;

    repeat
      Begin
        if Ascendant then
        Begin
          while (Liste[Bas]^.Texte < Separateur) do inc(Bas);
          while (Liste[Haut]^.Texte > Separateur) do dec(Haut);
        End
        else
        Begin
          while (Liste[Bas]^.Texte > Separateur) do inc(Bas);
          while (Liste[Haut]^.Texte < Separateur) do dec(Haut);
        End;
        if Bas <= Haut then
        Begin
          Tmp := Liste[Bas]^;
          Liste[Bas]^ := Liste[Haut]^;
          Liste[Haut]^ := Tmp;
          inc(Bas);
          dec(Haut);
        End;
      End;
    until (Bas > Haut);

    if Debut < Haut then TrieAlpha(Debut,Haut,Ascendant);
    if Bas < Fin then TrieAlpha(Bas,Fin,Ascendant);
  End;

  (**)
  Procedure TrieExtension(Debut,Fin : integer;Ascendant : boolean);

  Var
    Bas        : integer;
    Haut       : integer;
    Separateur : Str80;
    Tmp        : EltListeFic;

    {}
    Function ChaineRef(Chaine : Str80 ) : Str80;

    Var
      N   : integer;
      Tmp : Str80;

    Begin
      N := pos('.',Chaine);
      if N = 0 then ChaineRef := Chaine
               else
               Begin
                 Tmp := copy(Chaine,N,length(Chaine) - N);
                 delete(Chaine,N,length(Chaine) - N);
                 ChaineRef := Tmp + Chaine;
               End;
    End;

  Begin
    Bas := Debut;
    Haut := Fin;
    Separateur := ChaineRef(Liste[(Debut + Fin) div 2]^.Texte);

    repeat
      Begin
        if Ascendant then
        Begin
          while (ChaineRef(Liste[Bas]^.Texte) < Separateur) do inc(Bas);
          while (ChaineRef(Liste[Haut]^.Texte) > Separateur) do dec(Haut);
        End
        else
        Begin
          while (ChaineRef(Liste[Bas]^.Texte) > Separateur) do inc(Bas);
          while (ChaineRef(Liste[Haut]^.Texte) < Separateur) do dec(Haut);
        End;
        if Bas <= Haut then
        Begin
          Tmp := Liste[Bas]^;
          Liste[Bas]^ := Liste[Haut]^;
          Liste[Haut]^ := Tmp;
          inc(Bas);
          dec(Haut);
        End;
      End;
    until (Bas > Haut);

    if Debut < Haut then TrieExtension(Debut,Haut,Ascendant);
    if Bas < Fin then TrieExtension(Bas,Fin,Ascendant);
  End;

  (**)
  Procedure TrieDate(Debut,Fin : integer;Ascendant : boolean);

  Var
    Bas        : integer;
    Haut       : integer;
    Separateur : longint;
    Tmp        : EltListeFic;

  Begin
    Bas := Debut;
    Haut := Fin;
    Separateur := Liste[(Debut + Fin) div 2]^.Date;

    repeat
      Begin
        if Ascendant then
        Begin
          while (Liste[Bas]^.Date < Separateur) do inc(Bas);
          while (Liste[Haut]^.Date > Separateur) do dec(Haut);
        End
        else
        Begin
          while (Liste[Bas]^.Date > Separateur) do inc(Bas);
          while (Liste[Haut]^.Date < Separateur) do dec(Haut);
        End;
        if Bas <= Haut then
        Begin
          Tmp := Liste[Bas]^;
          Liste[Bas]^ := Liste[Haut]^;
          Liste[Haut]^ := Tmp;
          inc(Bas);
          dec(Haut);
        End;
      End;
    until (Bas > Haut);

    if Debut < Haut then TrieDate(Debut,Haut,Ascendant);
    if Bas < Fin then TrieDate(Bas,Fin,Ascendant);
  End;

  (**)
  Procedure TrieTaille(Debut,Fin : integer;Ascendant : boolean);

  Var
    Bas        : integer;
    Haut       : integer;
    Separateur : longint;
    Tmp        : EltListeFic;

  Begin
    Bas := Debut;
    Haut := Fin;
    Separateur := Liste[(Debut + Fin) div 2]^.Taille;

    repeat
      Begin
        if Ascendant then
        Begin
          while (Liste[Bas]^.Taille < Separateur) do inc(Bas);
          while (Liste[Haut]^.Taille > Separateur) do dec(Haut);
        End
        else
        Begin
          while (Liste[Bas]^.Taille > Separateur) do inc(Bas);
          while (Liste[Haut]^.Taille < Separateur) do dec(Haut);
        End;
        if Bas <= Haut then
        Begin
          Tmp := Liste[Bas]^;
          Liste[Bas]^ := Liste[Haut]^;
          Liste[Haut]^ := Tmp;
          inc(Bas);
          dec(Haut);
        End;
      End;
    until (Bas > Haut);

    if Debut < Haut then TrieTaille(Debut,Haut,Ascendant);
    if Bas < Fin then TrieTaille(Bas,Fin,Ascendant);
  End;

  (**)
  Procedure CreeListe;

  Var
    LeRep : LstRepPtr;
    W     : integer;

    {}
    Procedure StockeRepertoireSource;

    Var
      N   : integer;
      Tmp : NomRep;
      Rec : searchrec;

    Begin
      if MemAvail > sizeof(Liste[Nombre]) then new(Liste[Nombre])
                                          else PlusDeMemoireTx;
      if UnRepertoire[length(UnRepertoire)] = '\' then
        delete(UnRepertoire,length(UnRepertoire),1);
      N := length(UnRepertoire);
      while not (UnRepertoire[N] in ['\',':']) do dec(N);
      if UnRepertoire[N] = ':' then
        Begin
          Tmp := copy(UnRepertoire,1,N);
          Liste[Nombre]^.Texte :=  ' ' + Tmp;
          Liste[Nombre]^.Date     := 0;
          Liste[Nombre]^.Taille   := disksize(ord(UnRepertoire[N - 1]) - 64);
          Liste[Nombre]^.Attribut := 255;
        End
        else
        Begin
          Tmp := copy(UnRepertoire,N + 1,length(UnRepertoire) - N);
          Liste[Nombre]^.Texte := #17 + ' ' + Tmp;
          FindFirst(UnRepertoire,Directory,Rec);
          Liste[Nombre]^.Date     := Rec.Time;
          Liste[Nombre]^.Taille   := Rec.Size;
          Liste[Nombre]^.Attribut := Rec.Attr;
        End;
      Liste[Nombre]^.Selectionne := false;
    End;

    {}
    Procedure StockeRepertoire;

    Var
      N       : integer;
      Premier : integer;
      Dernier : integer;

    Begin
      Premier := 0;
      with LeRep^ do
      Begin
        Attribut   := Directory;
        Repertoire := UnRepertoire;
        Masque     := '*.*';
      End;
      ListeRep(LeRep);
      with LeRep^ do
      if (ErreurES <> 1) and (NbRep > 0) then
      Begin
        Premier := Nombre + 1;
        for N := 1 to NbRep do
        Begin
          inc(Nombre);
          if MemAvail > sizeof(Liste[Nombre]) then new(Liste[Nombre])
                                              else PlusDeMemoireTx;
          Liste[Nombre]^.Texte    := #16 + ' ' + ListeDuRep[N].Name;
          Liste[Nombre]^.Date     := ListeDuRep[N].Time;
          Liste[Nombre]^.Taille   := ListeDuRep[N].Size;
          Liste[Nombre]^.Attribut := ListeDuRep[N].Attr;
          Liste[Nombre]^.Selectionne := false;
        End;
        Dernier := Nombre;
      End;
      if (Premier > 0) then
        case ChoixFic.Trie of
          Ascendant  : TrieAlpha(Premier,Dernier,true);
          Descendant : TrieAlpha(Premier,Dernier,false);
        end;
    End;

    {}
    Procedure TrieFichier(Premier,Dernier : integer);

    Begin
      if (Premier > 0) then
        case ChoixFic.TypeTrie of
          Nom       : case ChoixFic.Trie of
                        Ascendant  : TrieAlpha(Premier,Dernier,true);
                        Descendant : TrieAlpha(Premier,Dernier,false);
                      end;
          Date      : case ChoixFic.Trie of
                        Ascendant  : TrieDate(Premier,Dernier,true);
                        Descendant : TrieDate(Premier,Dernier,false);
                      end;
          Taille    : case ChoixFic.Trie of
                        Ascendant  : TrieTaille(Premier,Dernier,true);
                        Descendant : TrieTaille(Premier,Dernier,false);
                      end;
          Extension : case ChoixFic.Trie of
                        Ascendant  : TrieExtension(Premier,Dernier,true);
                        Descendant : TrieExtension(Premier,Dernier,false);
                      end;
        end;
    End;
    {}
    Procedure StockeFichier;

    Var
      N       : integer;
      Premier : integer;
      Dernier : integer;

    Begin
      Premier := 0;
      with LeRep^ do
      Begin
        Attribut   := Archive;
        Repertoire := UnRepertoire;
        Masque     := UnMasque;
      End;
      ListeRep(LeRep);
      with LeRep^ do
      if (ErreurES <> 1) and (NbFic > 0) then
      Begin
        Premier := Nombre + 1;
        for N := 1 to NbFic do
        Begin
          inc(Nombre);
          if MemAvail > sizeof(Liste[Nombre]) then new(Liste[Nombre])
                                              else PlusDeMemoireTx;
          Liste[Nombre]^.Texte := ' ' + ListeDsFic[N].Name;
          Liste[Nombre]^.Date     := ListeDsFic[N].Time;
          Liste[Nombre]^.Taille   := ListeDsFic[N].Size;
          Liste[Nombre]^.Attribut := ListeDsFic[N].Attr;
          Liste[Nombre]^.Selectionne := false;
        End;
        Dernier := Nombre;
      End;
      TrieFichier(Premier,Dernier);
    End;

  Begin
    Nombre := 1;
    StockeRepertoireSource;
    if MemAvail > sizeof(LeRep) then new(LeRep)
                                else PlusDeMemoireTx;
    StockeRepertoire;
    StockeFichier;
    dispose(LeRep);
    if Nombre < ChoixFic.MaxVisible then
      for W := (Nombre + 1) to ChoixFic.MaxVisible do
      Begin
        if MemAvail > sizeof(Liste[W]) then new(Liste[W])
                                       else PlusDeMemoireTx;
        Liste[W]^.Texte := ' ';
        Liste[W]^.Selectionne := false;
      End;
    while keypressed do readkey;
  End;

  (**)
  Procedure EffaceListe;

  Var
    N : integer;

  Begin
    for N := Nombre downto 1 do dispose(Liste[N]);
    Nombre := 0;
  End;

  (**)
  Procedure AfficheAscenceur;

  Var
    S1   : TypeSauveTx;
    N    : byte;
    XBas : byte;
    YBas : byte;
    PosAscenseur  : byte;

  Begin
    with ChoixFic do
    Begin
      if not Ascenseur then exit;
      SauvegardeTx(S1);
      CacheSouris;
      if MaxVisible >= 3 then
      Begin
        CoulFondTx(CoulAscenceur.Fond);
        CoulEncreTx(CoulAscenceur.Encre);
        gotoxy(X + Largeur,Y);
        write('');
        for N := 2 to (Hauteur - 1) do
        Begin
          gotoxy(X + Largeur,Y + N - 1);
          write('');
        End;
        XBas := X + Largeur;
        YBas:= Y + Hauteur - 1;
        if (XBas = 80) and (YBas = 25) then
          with CoulAscenceur do Write2580('',Fond,Encre)
        else
        Begin
          gotoxy(X + Largeur,Y + Hauteur - 1);
          write('');
        End;
        PosAscenseur := trunc((NumEnCours / Nombre) * (Hauteur - 2));
        if NumEnCours = 1 then PosAscenseur := 1;
        if PosAscenseur = 0 then PosAscenseur := 1;
        if PosAscenseur > (Hauteur - 2) then PosAscenseur := (Hauteur - 2);
        gotoxy(X + Largeur,Y + PosAscenseur);
        write('');
      End;
      RestaureTx(S1);
    End;
  End;

  (**)
  Procedure AfficheInfo;

  Var
    S1         : TypeSauveTx;
    FenetreMin : word;
    FenetreMax : word;
    DateHeure  : datetime;

    {}
    Function DecrypteTaille(Taille : longint) : Str80;

    Var
      Tmp       : Str80;

    Begin
      str(Taille : 9,Tmp);
      Tmp := Tmp + ' octets';
      DecrypteTaille := ElargiADte(Tmp,Largeur);
    End;

    {}
    Function DecrypteDateHeure(Date : longint) : Str80;

    Var
      DateHeure : datetime;
      Chaine    : Str80;
      Tmp       : Str80;

    Begin
      unpacktime(Liste[NumEnCours]^.Date,DateHeure);
      str(DateHeure.Day : 2,Tmp);
      if Tmp[1] = ' ' then Tmp[1] := '0';
      Chaine := Tmp + '/';
      str(DateHeure.Month : 2,Tmp);
      if Tmp[1] = ' ' then Tmp[1] := '0';
      Chaine := Chaine + Tmp + '/';
      str(DateHeure.Year : 2,Tmp);
      Chaine := Chaine + Tmp + ' ';
      str(DateHeure.Hour : 2,Tmp);
      if Tmp[1] = ' ' then Tmp[1] := '0';
      Chaine := Chaine + Tmp + ':';
      str(DateHeure.Min : 2,Tmp);
      if Tmp[1] = ' ' then Tmp[1] := '0';
      Chaine := Chaine + Tmp;
      DecrypteDateHeure := ElargiADte(Chaine,Largeur);
    End;

  Begin
    with ChoixFic do
    if Info then
    Begin
      SauvegardeTx(S1);
      CacheSouris;
      CoulFondTx(CoulInfoFic.Fond);
      CoulEncreTx(CoulInfoFic.Encre);
      FenetreMin := windmin;
      FenetreMax := windmax;
      window(X,Y + Hauteur + 1,X + Largeur,Y + Hauteur + 2);
      clrscr;
      windmin := FenetreMin;
      windmax := FenetreMax;
      gotoxy(X + 1, Y + Hauteur + 1);
      if not (Liste[NumEnCours]^.Attribut = Directory)
         then write(DecrypteTaille(Liste[NumEnCours]^.Taille));
      gotoxy(X + 1, Y + Hauteur + 2);
      if not (Liste[NumEnCours]^.Attribut = 255)
         then write(DecrypteDateHeure(Liste[NumEnCours]^.Date));
      RestaureTx(S1);
    End;
  End;

  (**)
  Procedure AfficheListe;

  Var
    S1         : TypeSauveTx;
    Select     : byte;
    N          : integer;
    FenetreMin : word;
    FenetreMax : word;

  Begin
    with ChoixFic do
    Begin
      SauvegardeTx(S1);
      CacheSouris;
      CoulFondTx(CoulChoixCtrl.Fond);
      CoulEncreTx(CoulChoixCtrl.Encre);
      FenetreMin := windmin;
      FenetreMax := windmax;
      window(X,Y,X + Largeur - 1,Y + Hauteur - 1);
      clrscr;
      windmin := FenetreMin;
      windmax := FenetreMax;
      for N := 1 to MaxVisible do
      Begin
        gotoxy(X, Y + N - 1);
        if Liste[(N + PremierAffi - 1)]^.Selectionne then
        Begin
          CoulFondTx(CoulChoixSelec.Fond);
          CoulEncreTx(CoulChoixSelec.Encre);
        End
        else
        Begin
          CoulFondTx(CoulChoixCtrl.Fond);
          CoulEncreTx(CoulChoixCtrl.Encre);
        End;
        write(' ',ElargiADte(Liste[(N + PremierAffi - 1)]^.Texte,Largeur - 1));
      End;
      Select := NumEnCours - PremierAffi + 1;
      InverseTexteTx(X,Y + Select - 1,Largeur);
      RestaureTx(S1);
    End;
    AfficheInfo;
  End;

  (**)
  Procedure ReafficheListe;

  Var
    S1         : TypeSauveTx;
    Select     : byte;
    N          : integer;
    FenetreMin : word;
    FenetreMax : word;

  Begin
    with ChoixFic do
    Begin
      SauvegardeTx(S1);
      CacheSouris;
      for N := 1 to MaxVisible do
      Begin
        gotoxy(X, Y + N - 1);
        if Liste[(N + PremierAffi - 1)]^.Selectionne then
        Begin
          CoulFondTx(CoulChoixSelec.Fond);
          CoulEncreTx(CoulChoixSelec.Encre);
        End
        else
        Begin
          CoulFondTx(CoulChoixCtrl.Fond);
          CoulEncreTx(CoulChoixCtrl.Encre);
        End;
        write(' ',ElargiADte(Liste[(N + PremierAffi - 1)]^.Texte,Largeur - 1));
      End;
      Select := NumEnCours - PremierAffi + 1;
      InverseTexteTx(X,Y + Select - 1,Largeur);
      RestaureTx(S1);
    End;
    AfficheInfo;
  End;

  (**)
  Procedure VaDebut;

  Begin
    if (PremierAffi = 1) and (NumEnCours = 1) then Reafficher := false
                                              else Reafficher := true;
    PremierAffi := 1;
    NumEnCours := 1;
  End;

  (**)
  Procedure VaFin;

  Var
    Tmp : integer;

  Begin
    with ChoixFic do
    Begin
      Tmp := Nombre - Hauteur + 1;
      if (PremierAffi = Tmp) and (NumEnCours = Nombre)
         then Reafficher := false
         else Reafficher := true;
      if Nombre > MaxVisible then PremierAffi := Tmp
                             else PremierAffi := 1;
      NumEnCours := Nombre;
    End;
  End;

  (**)
  Procedure VaBas;

  Begin
    if NumEnCours < Nombre then
    Begin
      inc(NumEnCours);
      Reafficher := true;
    End;
    if NumEnCours > (PremierAffi + ChoixFic.MaxVisible - 1) then
       inc(PremierAffi);
  End;

  (**)
  Procedure VaHaut;

  Begin
    if NumEnCours > 1 then
    Begin
      dec(NumEnCours);
      Reafficher := true;
    End;
    if NumEnCours < PremierAffi then dec(PremierAffi);
  End;

  (**)
  Procedure VaPgBas;

  Var
    Tmp : integer;

  Begin
    with ChoixFic do
    Begin
      if NumEnCours < Nombre then
      Begin
        Reafficher := true;
        Tmp := PremierAffi + MaxVisible + MaxVisible  - 1;
        if Tmp <= Nombre then
          Begin
            PremierAffi := PremierAffi + MaxVisible;
            NumEnCours := NumEnCours + MaxVisible;
          End
          else
          Begin
            if Nombre > MaxVisible
              then PremierAffi := Nombre - MaxVisible + 1;
            NumEnCours := Nombre;
          End;
      End;
    End;
  End;

  (**)
  Procedure VaPgHaut;

  Begin
    with ChoixFic do
    Begin
      if NumEnCours > 1 then
      Begin
        Reafficher := true;
        if PremierAffi > MaxVisible then
          Begin
            PremierAffi := PremierAffi - MaxVisible;
            NumEnCours := NumEnCours - MaxVisible;
          End
          else
          Begin
            PremierAffi := 1;
            NumEnCours := 1;
          End;
      End;
    End;
  End;

  (**)
  Procedure VaNumero(Num : integer);

  Var
    Tmp : integer;

  Begin
    with ChoixFic do
    Begin
      Reafficher := true;
      if (Num in [PremierAffi .. (PremierAffi + MaxVisible - 1)]) then
        NumEnCours := Num
      else
      Begin
        Tmp := Nombre - Num;
        if Tmp < MaxVisible then
        Begin
          if Nombre > MaxVisible then PremierAffi := Nombre -  MaxVisible + 1
                                 else PremierAffi := 1;
          NumEnCours := Num;
        End
        else
        Begin
          PremierAffi := Num;
          NumEnCours := Num;
        End;
      End;
    End;
  End;

  (**)
  Procedure TesteSouris;

  Var
    NumTmp : integer;

    {}
    Procedure SourisVaHaut;

    Begin
      repeat
        VaHaut;
        if Reafficher then
        Begin
        AfficheAscenceur;
        ReafficheListe;
        End
        else Beep;
        delay(TempoDefile);
        SourisRelachee(BoutonGauche,InfoSouris);
      until (InfoSouris.Bouton <> BoutonGauche) or (NumEnCours = 1);
      if NumEnCours = 1 then Beep;
    End;

    {}
    Procedure SourisVaBas;

    Begin
      repeat
        VaBas;
        if Reafficher then
        Begin
        AfficheAscenceur;
        ReafficheListe;
        End
        else Beep;
        delay(TempoDefile);
        SourisRelachee(BoutonGauche,InfoSouris);
      until (InfoSouris.Bouton <> BoutonGauche) or (NumEnCours = Nombre);
      if NumEnCours = Nombre then Beep;
    End;

    {}
    Procedure SourisAscenceur;

    Begin
      with ChoixFic do
      Begin
        if not Ascenseur then exit;
        if YTmp = Y then SourisVaHaut;
        if YTmp = (Y + Hauteur - 1) then SourisVaBas;
        if YTmp in [(Y+1) .. (Y + Hauteur - 2)] then
        Begin
          DelaiSouris(TempoSouris);
          NumTmp := (YTmp - Y);
          if NumTmp = 1 then VaNumero(1)
          else
          Begin
            NumTmp := NumTmp * Nombre div (Hauteur - 2) + 1;
            if NumTmp > Nombre then NumTmp := Nombre;
            VaNumero(NumTmp);
          End;
        End;
        if (Autre and not (YTmp in [Y.. (Y + Hauteur - 1)])) then
        Begin
          LeCar := #00;
          Fin := true;
        End
        else LeCar := #255;
      End;
    End;

    {}
    Procedure SourisListe;

    Begin
      DelaiSouris(TempoSouris);
      with PosTxListe do
      if SourisDsZone(XTmp,YTmp,X1,Y1,X2,Y2) then
      Begin
        NumTmp := PremierAffi + YTmp - Y1;
        if Compresse(Liste[NumTmp]^.Texte) = '' then LeCar := #255
        else
        Begin
          VaNumero(NumTmp);
          LeCar := CarReturn;
        End;
      End
      else if Autre then
      Begin
        LeCar := #00;
        Fin := true;
      End;
    End;
    {}

  Begin
    if InfoSouris.Nombre <> 0 then
    with ChoixFic do
    Begin
      case InfoSouris.Bouton of
        BoutonGauche : if XTmp = (X + Largeur) then SourisAscenceur
                                               else SourisListe;
      end;
      if Reafficher then
      Begin
        AfficheAscenceur;
        ReafficheListe;
      End
      else if (LeCar <> CarReturn) and not Fin then Beep;
      if LeCar = CarReturn then Fin := true;
    End;
  End;

  (**)
  Procedure TesteTouche;

  Begin
    Reafficher := false;
    if ToucheFct then
    Begin
      case LeCar of
        FlchDebut  : VaDebut;
        FlchFin    : VaFin;
        FlchBas    : VaBas;
        FlchHaut   : VaHaut;
        FlchGauche : VaPgHaut;
        FlchDroite : VaPgBas;
        FlchPgHaut : VaPgHaut;
        FlchPgBas  : VaPgBas;
        ShiftTab   : if Autre then Fin := true
                              else Beep;
        ShiftF1    : BoiteAProposTx;
        AltX       : Begin
                       Sortie := true;
                       Abandon := true;
                     End;
        else
          if (LeCar in [AltQ..AltP,AltA..AltL,AltZ,AltC..AltM]) and Autre
             then Fin := true
             else Beep;
      end;
      if Reafficher then
      Begin
        AfficheAscenceur;
        ReafficheListe;
      End
      else
      if not (LeCar in [ShiftTab,AltQ..AltP,AltA..AltL,AltZ..AltM]) then Beep;
    End
    else
    Begin
      case LeCar of
        CarReturn : Fin := true;
        CarEsc    : Abandon := true;
        Tab       : if Autre then Fin := true
                             else Beep;
        #255      :;
        #00       : if not Autre then Beep;
        else Beep;
      end;
      if Reafficher then
      Begin
        AfficheAscenceur;
        ReafficheListe;
      End;
    End;
  End;

  (**)
  Procedure ChangeRepertoire;

  Var
    N   : integer;
    Tmp : Str80;

  Begin
    if Liste[NumEnCours]^.Texte[1] = #17 then
      Begin
        N := length(UnRepertoire);
        while not (UnRepertoire[N] in ['\',':']) do dec(N);
        UnRepertoire := copy(UnRepertoire,1,N);
      End
      else
      Begin
        Tmp := Liste[NumEnCours]^.Texte;
        Tmp := copy(Tmp,3,length(Tmp) - 2);
        UnRepertoire := UnRepertoire + '\' + Tmp;
      End;
    EffaceListe;
    CreeListe;
    PremierAffi := 1;
    NumEnCours := 1;
    ReafficheListe;
    Fin := false;
  End;

  (**)
  Procedure ChangeLecteur;

  Var
    Lecteur : char;
    W       : integer;

  Begin
    EffaceListe;
    Nombre := 0;
    for Lecteur := 'A' to 'Z' do
      if LecteurExiste(Lecteur) = 0 then
      Begin
        inc(Nombre);
        if MemAvail > sizeof(Liste[Nombre]) then new(Liste[Nombre])
                                            else PlusDeMemoireTx;
        Liste[Nombre]^.Texte       := Lecteur + ':';
        Liste[Nombre]^.Date        := 0;
        Liste[Nombre]^.Taille      := disksize(ord(Lecteur) - 64);
        Liste[Nombre]^.Attribut    := 255;
        Liste[Nombre]^.Selectionne := false;
      End;
    if Nombre < ChoixFic.MaxVisible then
      for W := (Nombre + 1) to ChoixFic.MaxVisible do
      Begin
        if MemAvail > sizeof(Liste[W]) then new(Liste[W])
                                       else PlusDeMemoireTx;
        Liste[W]^.Texte := ' ';
        Liste[W]^.Selectionne := false;
      End;
    while keypressed do readkey;
    PremierAffi := 1;
    NumEnCours := 1;
    ReafficheListe;
    Fin := false;
    repeat
      if AttendActionTx(LeCar,InfoSouris) then
        PosSourisPosTx(InfoSouris.Colonne,InfoSouris.Ligne,Xtmp,YTmp);
        TesteSouris;
        TesteTouche;
    until Fin or Abandon;

    if (LeCar = CarReturn) then
      Begin
        UnRepertoire := Liste[NumEnCours]^.Texte;
        EffaceListe;
        CreeListe;
        PremierAffi := 1;
        NumEnCours := 1;
        ReafficheListe;
      End;
    Fin := false;
  End;

  (**)
  Procedure Affichage;

  Begin
    with ChoixFic do
    Begin
      if Pos > Nombre then Pos := 1;
      PremierAffi := 1;
      NumEnCours := Pos;
      if NumEnCours > MaxVisible then VaNumero(NumEnCours);
      AfficheAscenceur;
      AfficheListe;
    End;
    ChoixFichierTx := #255;
  End;

  (**)
  Procedure Utilisation;

  Begin
    with ChoixFic do
    Begin
      if Pos > Nombre then Pos := 1;
      PremierAffi := 1;
      NumEnCours := Pos;
      if NumEnCours > MaxVisible then VaNumero(NumEnCours);
      LigneAide.Texte := AideChoix;
      AfficheAscenceur;
      AfficheListe;
      AfficheLigneAideTx(true);
      Fin := false;
      Abandon := false;
      MontreSouris;
      repeat
        repeat
          if Immediat then
          Begin
            PosSouris(InfoSouris);
            InfoSouris.Bouton := BoutonGauche;
            PosSourisPosTx(InfoSouris.Colonne,InfoSouris.Ligne,Xtmp,YTmp);
            TesteSouris;
            Immediat := false;
          End
          else
          Begin
            if AttendActionTx(LeCar,InfoSouris) then
            Begin
              PosSourisPosTx(InfoSouris.Colonne,InfoSouris.Ligne,Xtmp,YTmp);
              TesteSouris;
            End
            else TesteTouche;
          End;
        until Fin or Abandon;
        if (LeCar = CarReturn) then
          case Liste[NumEnCours]^.Attribut of
            directory : ChangeRepertoire;
            255       : ChangeLecteur;
          end;
      until Fin or Abandon;
      if LeCar = CarReturn then
      Begin
         UnRepertoire := UnRepertoire + '\';
         UnMasque := Compresse(Liste[NumEnCours]^.Texte);
      End;
      Pos := NumEnCours;
      ChoixFichierTx := LeCar;
    End;
  End;


Begin
  with ChoixFic do
  Begin
    SauvegardeTx(S);
    CacheCurseurTx;
    UnRepertoire := Majuscules(UnRepertoire);
    Largeur := 17;
    Larg := Largeur;
    if Ascenseur then inc(Larg);
    if MaxVisible > 25 then MaxVisible := 25;
    Hauteur := MaxVisible;
    Haut := Hauteur;
    if (Y + Hauteur) > hi(windmax) then Y := hi(windmax) - Hauteur + 2;
    if (X + Largeur) > lo(windmax) then X := lo(windmax) - Largeur + 1;
    with PosTxListe do
        Begin
          X1 := X;
          Y1 := Y;
          X2 := X + Largeur - 1;
          Y2 := Y + Hauteur - 1;
        End;
    if not (UneAction = Initialiser) then CreeListe;
    case UneAction of
      Afficher : Affichage;
      Utiliser : Utilisation;
    end;
    if not (UneAction = Initialiser) then EffaceListe;
    RestaureTx(S);
  End;
End;

(**)
Procedure InitBoutonTx(Var UnBouton : BoutonTxPtr;Nom : str40;
                                X,Y,Largeur : byte;Ombrage,Active : boolean);

Var
  Compte : byte;
  NomTmp : Str40;

Begin
  if MemAvail > sizeof(UnBouton) then
  Begin
    new(UnBouton);
    with UnBouton^ do
    Begin
      Actif     := Active;
      PosX      := X;
      PosY      := Y;
      Larg      := Largeur;
      Ombre     := Ombrage;
      if Ombre then if (PosX + Larg + 1) > 80 then Larg := 80 - PosX - 1
               else if (PosX + Larg) > 80 then Larg := 80 - PosX;
      NomTmp := Nom;
      while pos('&',NomTmp) <> 0 do delete(NomTmp,pos('&',NomTmp),1);
      Texte     := NomTmp;
      if (length(Texte) + 2) > Larg then Texte := copy(Texte,1,(Larg - 2));
      Compte    := pos('&',Nom);
      if Compte = 0 then Raccourci := CarNul
                    else Raccourci := Nom[Compte + 1];
    End;
  End
  else
  Begin
    PlusDeMemoireTx;
    Halt(1);
  End;

End;

{}

Procedure LibereBoutonTx(Var UnBouton : BoutonTxPtr);

Begin
  if UnBouton <> nil then
  Begin
    dispose(UnBouton);
    UnBouton := nil;
  End;
End;

{}

Procedure AfficheBoutonTx(Var UnBouton : BoutonTxPtr);

Var
  M      : byte;
  NomTmp : Str40;

  (**)
  Procedure AfficheOmbre;

  Var
    X,Y,Z   : byte;
    Fond    : byte;
    Adresse : longint;

  Begin
    with UnBouton^ do
    Begin
      X := PosX;
      Y := PosY;
      X := X + Larg;
      (*Adresse := (Y - 1) * 160 + (X - 1) * 2 + 1;*)
      Adresse := (Y - 1) * 160 + X + X - 1;
      Fond := mem[BaseEcran: Adresse] div 16;
      gotoxy(X,Y);
      write('');
      mem[BaseEcran: Adresse] := Fond * 16 + Noir;
      X := X - Larg + 1;
      inc(Y);
      gotoxy(X,Y);
      for Z := 1 to Larg do
      Begin
        (*Adresse := (Y - 1) * 160 + (X - 1) * 2 + 1;*)
        Adresse := (Y - 1) * 160 + X + X - 1;
        Fond := mem[BaseEcran: Adresse] div 16;
        write('');
        mem[BaseEcran: Adresse] := Fond * 16 + Noir;
        inc(X);
      End;
    End;
  End;

Begin
  with UnBouton^ do
  Begin
    gotoxy(PosX,PosY);
    if Actif then
    Begin
      CoulEncreTx(CoulBoutonSelec.Encre);
      CoulFondTx(CoulBoutonSelec.Fond);
    End
    else
    Begin
      CoulEncreTx(CoulBouton.Encre);
      CoulFondTx(CoulBouton.Fond);
    End;
    NomTmp := Elargi(Texte,Larg);
    write(NomTmp);
    if Raccourci <> CarNul then
    Begin
      M := pos(Raccourci,NomTmp);
      dec(M);
      gotoxy(PosX + M,PosY);
      CoulEncreTx(CoulCarBouton.Encre);
      CoulFondTx(CoulCarBouton.Fond);
      write(Raccourci);
    End;
    if Ombre then AfficheOmbre;
  End;
End;

{}

Function SourisDsBoutonTx(Var UnBouton : BoutonTxPtr;
                                              InfoSouris : PosRec) : boolean;

Var
  X,Y,X1,Y1,X2,Y2 : byte;

Begin
  with UnBouton^ do
  Begin
    X1 := PosX;
    X2 := PosX + Larg - 1;
    Y1 := PosY;
    Y2 := PosY;
  End;
  with InfoSouris do PosSourisPosTx(Colonne,Ligne,X,Y);
  SourisDsBoutonTx := SourisDsZone(X,Y,X1,Y1,X2,Y2);
End;

{}

Function ToucheDuBoutonTx(Var UnBouton : BoutonTxPtr;Car : char) : boolean;

Var
  ToucheRef : char;
  ChTmp     : string[1];
  CarTmp    : char;

Begin
  ToucheDuBoutonTx := false;
  with UnBouton^ do
  if Raccourci <> #0 then
  Begin
    ChTmp := Majuscules(Raccourci);
    CarTmp := ChTmp[1];
    case CarTmp of
      'A' : ToucheRef := AltA;
      'B' : ToucheRef := AltB;
      'C' : ToucheRef := AltC;
      'D' : ToucheRef := AltD;
      'E' : ToucheRef := AltE;
      'F' : ToucheRef := AltF;
      'G' : ToucheRef := AltG;
      'H' : ToucheRef := AltH;
      'I' : ToucheRef := AltI;
      'J' : ToucheRef := AltJ;
      'K' : ToucheRef := AltK;
      'L' : ToucheRef := AltL;
      'M' : ToucheRef := AltM;
      'N' : ToucheRef := AltN;
      'O' : ToucheRef := AltO;
      'P' : ToucheRef := AltP;
      'Q' : ToucheRef := AltQ;
      'R' : ToucheRef := AltR;
      'S' : ToucheRef := AltS;
      'T' : ToucheRef := AltT;
      'U' : ToucheRef := AltU;
      'V' : ToucheRef := AltV;
      'W' : ToucheRef := AltW;
      'X' : ToucheRef := AltX;
      'Y' : ToucheRef := AltY;
      'Z' : ToucheRef := AltZ;
    end;
    ToucheDuBoutonTx := (Car = ToucheRef);
  End;
End;

(**)

Procedure InitBteABoutonTx(Var UneBoite : BteABoutonTxPtr;Nom : Str40;
                                         X,Y,Largeur : byte;Multi : boolean);

Begin
  if MemAvail > sizeof(UneBoite) then
  Begin
    new(UneBoite);
    with UneBoite^ do
    Begin
      Texte     := Nom;
      Active    := false;
      AideLigne := '';
      NbBouton  := 0;
      BtActif   := 0;
      PosX      := X;
      PosY      := Y;
      Larg      := Largeur;
      LargTexte := 0;
      NbEnX     := 1;
      NbEnY     := 0;
      MultiCol  := Multi;
      if (PosX + Larg) > 80 then Larg := 80 - PosX;
      if length(Texte) > Larg then Texte := copy(Texte,1,Larg);
    End;
  End
  else
  Begin
    PlusDeMemoireTx;
    Halt(1);
  End;
End;

{}

Procedure LibereBteABoutonTx(Var UneBoite : BteABoutonTxPtr);

Begin
  if UneBoite <> nil then
  Begin
    dispose(UneBoite);
    UneBoite := nil;
  End;
End;

{}

Procedure AjouteBoutonDsBteTx(Var UneBoite : BteABoutonTxPtr; Nom : Str40);

Var
  Compte : byte;
  NomTmp : Str80;

Begin
  with UneBoite^ do
  Begin
    inc(NbBouton);
    with Bouton[NbBouton] do
    Begin
      NomTmp := Nom;
      while pos('&',NomTmp) <> 0 do delete(NomTmp,pos('&',NomTmp),1);
      Texte     := NomTmp;
      if (length(Texte) + 6) > Larg then Texte := copy(Texte,1,(Larg - 6));
      Compte    := pos('&',Nom);
      if Compte = 0 then Raccourci := CarNul
                    else Raccourci := Nom[Compte + 1];
      Compte := length(Texte) + 5;
    End;
    if LargTexte < Compte then LargTexte := Compte;
    if MultiCol then
      Begin
        if (Larg mod LargTexte) = 0 then NbEnX := (Larg - 1) div LargTexte
                                    else NbEnX := Larg div LargTexte;
        NbEnY := (NbBouton  + NbEnX - 1) div NbEnX;
      End
      else inc(NbEnY);
    if NbBouton = 1 then BtActif := 1;
  End;
End;

{}

Procedure AfficheUnBouton(UneBoite : BteABoutonTxPtr; Numero : byte);

Var
  N,X,Y  : byte;
  Select : boolean;

Begin
  with UneBoite^ do
  Begin
    Select := Numero = BtActif;
    if MultiCol then
    Begin
      X := PosX + ((Numero-1) mod NbEnX) * LargTexte;
      Y := PosY + ((Numero - 1) div NbEnX) + 1;
    End
    else
    Begin
      X := PosX;
      Y := PosY + Numero;
    End;
    CoulFondTx(CoulBteABouton.Fond);
    if (Select and Active) then CoulEncreTx(CoulBteABoutonSelec.Encre)
                           else CoulEncreTx(CoulBteABouton.Encre);
    with Bouton[Numero] do
    Begin
      gotoxy(X,Y);
      write(' ( ) ',Texte);
      if Select then
      Begin
        gotoxy(X + 2,Y);
        EcritCarSpeTx(#7);
      End;
      if (Raccourci <> CarNul) then
      Begin
        N := pos(Raccourci,Texte);
        gotoxy(X + N + 4,Y);
        CoulEncreTx(CoulCarBteABouton.Encre);
        write(Raccourci);
      End;
    End;
  End;
End;

{}

Procedure AfficheBoiteABoutonTx(Var UneBoite : BteABoutonTxPtr);

Var
  S      : TypeSauveTx;
  N      : byte;
  CarTmp : char;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  with UneBoite^ do
  if NbBouton <> 0 then
  Begin
    LitCarTx (PosX,PosY,CarTmp,N);
    textattr := N;
    gotoxy(PosX,PosY);
    if Active then CoulEncreTx(CoulBteABoutonSelec.Encre)
              else CoulEncreTx(CoulBteABouton.Encre);
    write(Texte);
    BoiteTx(PosX,PosY + 1,Larg,NbEnY,CadreSS,CoulBteABouton,true,'','');
    if MultiCol then
    Begin
      N := (Larg - (LargTexte * NbEnX) - 1) div NbEnX;
      if N > 0 then LargTexte := LargTexte + N;
    End;
    for N := 1 to NbBouton do AfficheUnBouton(UneBoite,N);
  End;
  RestaureTx(S);
End;

{}

Procedure GereBteABoutonTx(Var UneBoite : BteABoutonTxPtr;Var LeCar : char;
                                                    Var InfoSouris : PosRec);

Var
  Abandon      : boolean;          { sortie de la gestion de la boite }
  S            : TypeSauveTx;

  (**)
  Procedure VaDroite;

  Var
    Ancien : byte;

  Begin
    with UneBoite^ do
    Begin
      Ancien := BtActif;
      inc(BtActif);
      if BtActif > NbBouton then BtActif := 1;
      CacheSouris;
      AfficheUnBouton(UneBoite,Ancien);
      AfficheUnBouton(UneBoite,BtActif);
      MontreSouris;
    End;
  End;

  (**)
  Procedure VaGauche;

  Var
    Ancien : byte;

  Begin
    with UneBoite^ do
    Begin
      Ancien := BtActif;
      dec(BtActif);
      if BtActif = 0 then BtActif := NbBouton;
      CacheSouris;
      AfficheUnBouton(UneBoite,Ancien);
      AfficheUnBouton(UneBoite,BtActif);
      MontreSouris;
    End;
  End;

  (**)
  Procedure VaBas;

  Var
    Ancien,Tmp : byte;

  Begin
    with UneBoite^ do
    Begin
      Ancien := BtActif;
      inc(BtActif,NbEnX);
      if BtActif > NbBouton then
      Begin
        Tmp := NbEnX * NbEnY;
        if BtActif <= Tmp then inc(BtActif,NbEnX);
        BtActif := BtActif - Tmp;
      End;
      CacheSouris;
      AfficheUnBouton(UneBoite,Ancien);
      AfficheUnBouton(UneBoite,BtActif);
      MontreSouris;
    End;
  End;

  (**)
  Procedure VaHaut;

  Var
    Ancien,Tmp : byte;

  Begin
    with UneBoite^ do
    Begin
      Ancien := BtActif;
      if BtActif > NbEnX then dec(BtActif,NbEnX)
      else
      Begin
        Tmp := NbEnX * (NbEnY - 1) + BtActif;
        if Tmp > NbBouton then dec(Tmp,NbEnX);
        BtActif := Tmp;
      End;
      CacheSouris;
      AfficheUnBouton(UneBoite,Ancien);
      AfficheUnBouton(UneBoite,BtActif);
      MontreSouris;
    End;
  End;

  (**)
  Procedure RaccourciBouton;

  Var
    N : byte;
    Ancien,Tmp : byte;

  Begin
    with UneBoite^ do
    Begin
      Ancien := BtActif;
      for N := 1 to NbBouton do
      with Bouton[N] do
        if Majuscules(LeCar) = Majuscules(Raccourci) then
        Begin
          BtActif := N;
          CacheSouris;
          AfficheUnBouton(UneBoite,Ancien);
          AfficheUnBouton(UneBoite,BtActif);
          MontreSouris;
        End;
    End;
  End;

  (**)
  Procedure GereSouris;

  Var
    Ancien : byte;

  Begin
    Ancien := UneBoite^.BtActif;
    if SourisDsBteABoutonTx(UneBoite,InfoSouris) then
    Begin
      CacheSouris;
      AfficheUnBouton(UneBoite,Ancien);
      AfficheUnBouton(UneBoite,UneBoite^.BtActif);
      MontreSouris;
    End
    else Abandon := true;
    LeCar := #0;
  End;

  (**)
  Procedure GereClavier;

  Begin
    if ToucheFct then
      case LeCar of
        FlchDroite : VaDroite;
        FlchGauche : VaGauche;
        FlchBas    : VaBas;
        FlchHaut   : VaHaut;
        ShiftTab   : Abandon := true;
        ShiftF1    : BoiteAProposTx;
        AltX       : Begin
                       Sortie := true;
                       Abandon := true;
                     End;
        else Abandon := true;
      end
    else
    Begin
      case LeCar of
        Tab        : Abandon := true;
        CarEsc     : Abandon := true;
        CarReturn  : Abandon := true;
      else RaccourciBouton;
      end;
    End;
  End;

  (**)

Begin
  Abandon := false;
  SauvegardeTx(S);
  CacheCurseurTx;
  MontreSouris;
  UneBoite^.Active := true;
  AfficheBoiteABoutonTx(UneBoite);
  while not Abandon do
  Begin
    if AttendActionTx(LeCar,InfoSouris) then GereSouris;
    if LeCar <> #0 then GereClavier;
  End;
  UneBoite^.Active := false;
  AfficheBoiteABoutonTx(UneBoite);
  RestaureTx(S);
End;

{}

Function SourisDsBteABoutonTx(Var UneBoite : BteABoutonTxPtr;
                                              InfoSouris : PosRec) : boolean;

Var
  X,Y   : byte;   { position texte de la souris }
  X1,X2 : byte;   { debut et fin du bouton      }
  N     : byte;

Begin
  SourisDsBteABoutonTx := false;
  if InfoSouris.Bouton = BoutonGauche then
  Begin
    with InfoSouris do PosSourisPosTx(Colonne,Ligne,X,Y);
    with UneBoite^ do
    Begin
      Active := false;
      if (Y >= PosY) and (Y <= (PosY + NbEnY)) then
      Begin
        Active := ((X >= PosX) and (X <= (PosX + Larg)));
        if (Active and (Y <> PosY)) then
        Begin
          N := PosX + NbEnX * LargTexte;
          if X < N then
          Begin
            N := (Y - PosY - 1) * NbEnX;
            N := N + ((X - PosX) div LargTexte + 1);
            if N <= NbBouton then BtActif := N;
          End;
        End;
      End;
      SourisDsBteABoutonTx := Active;
    End;
  End;
End;

(**)

Procedure InitBteCaseACocherTx(Var UneBoite : BteCaseACocherTxPtr;
                             Nom : str40;X,Y,Largeur : byte;Multi : boolean);

Begin
  if MemAvail > sizeof(UneBoite) then
  Begin
    new(UneBoite);
    with UneBoite^ do
    Begin
      Texte     := Nom;
      Active    := false;
      AideLigne := '';
      NbCase    := 0;
      CaActive  := 0;
      PosX      := X;
      PosY      := Y;
      Larg      := Largeur;
      LargTexte := 0;
      NbEnX     := 1;
      NbEnY     := 0;
      MultiCol  := Multi;
      if (PosX + Larg) > 80 then Larg := 80 - PosX;
      if length(Texte) > Larg then Texte := copy(Texte,1,Larg);
    End;
  End
  else
  Begin
    PlusDeMemoireTx;
    Halt(1);
  End;
End;

{}

Procedure LibereBteCaseACocherTx(Var UneBoite : BteCaseACocherTxPtr);

Begin
  if UneBoite <> nil then
  Begin
    dispose(UneBoite);
    UneBoite := nil;
  End;
End;

{}

Procedure AjouteCaseCocherDsBteTx(Var UneBoite : BteCaseACocherTxPtr;
                                                                Nom : Str40);
Var
  Compte : byte;
  NomTmp : Str80;

Begin
  with UneBoite^ do
  Begin
    inc(NbCase);
    with CaseCocher[NbCase] do
    Begin
      NomTmp := Nom;
      while pos('&',NomTmp) <> 0 do delete(NomTmp,pos('&',NomTmp),1);
      Texte     := NomTmp;
      if (length(Texte) + 6) > Larg then Texte := copy(Texte,1,(Larg - 6));
      Compte    := pos('&',Nom);
      if Compte = 0 then Raccourci := CarNul
                    else Raccourci := Nom[Compte + 1];
      Compte := length(Texte) + 5;
      Select := false;
    End;
    if LargTexte < Compte then LargTexte := Compte;
    if MultiCol then
      Begin
        if (Larg mod LargTexte) = 0 then NbEnX := (Larg - 1) div LargTexte
                                    else NbEnX := Larg div LargTexte;
        NbEnY := (NbCase  + NbEnX - 1) div NbEnX;
      End
      else inc(NbEnY);
    if NbCase = 1 then CaActive := 1;
  End;
End;

{}

Procedure AfficheCaseACocher(UneBoite : BteCaseACocherTxPtr; Numero : byte);

Var
  N,X,Y  : byte;

Begin
  with UneBoite^ do
  Begin
    if MultiCol then
    Begin
      X := PosX + ((Numero-1) mod NbEnX) * LargTexte;
      Y := PosY + ((Numero - 1) div NbEnX) + 1;
    End
    else
    Begin
      X := PosX;
      Y := PosY + Numero;
    End;
    CoulFondTx(CoulBteCaCocher.Fond);
    with CaseCocher[Numero] do
    Begin
      if Numero = CaActive then CoulEncreTx(CoulBteCaCocherSelec.Encre)
                           else CoulEncreTx(CoulBteCaCocher.Encre);
      gotoxy(X,Y);
      write(' [ ] ',Texte);
      if Select then
      Begin
        gotoxy(X + 2,Y);
        write('X');
      End;
      if (Raccourci <> CarNul) then
      Begin
        N := pos(Raccourci,Texte);
        gotoxy(X + N + 4,Y);
        CoulEncreTx(CoulCarBteCaCocher.Encre);
        write(Raccourci);
      End;
    End;
  End;
End;

{}

Procedure AfficheBoiteCaseACocherTx(Var UneBoite : BteCaseACocherTxPtr);

Var
  S      : TypeSauveTx;
  N      : byte;
  CarTmp : char;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  with UneBoite^ do
  if NbCase <> 0 then
  Begin
    LitCarTx (PosX,PosY,CarTmp,N);
    textattr := N;
    gotoxy(PosX,PosY);
    if Active then CoulEncreTx(CoulBteCaCocherSelec.Encre)
              else CoulEncreTx(CoulBteCaCocher.Encre);
    write(Texte);
    BoiteTx(PosX,PosY + 1,Larg,NbEnY,CadreSS,CoulBteCaCocher,true,'','');
    if MultiCol then
    Begin
      N := (Larg - (LargTexte * NbEnX) - 1) div NbEnX;
      if N > 0 then LargTexte := LargTexte + N;
    End;
    for N := 1 to NbCase do AfficheCaseACocher(UneBoite,N);
  End;
  RestaureTx(S);
End;

{}

Procedure GereBteCaseACocherTx(Var UneBoite : BteCaseACocherTxPtr;
                                   Var LeCar : char;Var InfoSouris : PosRec);

Var
  Abandon      : boolean;          { sortie de la gestion de la boite }
  S            : TypeSauveTx;

  (**)
  Procedure VaDroite;

  Var
    Ancien : byte;

  Begin
    with UneBoite^ do
    Begin
      Ancien := CaActive;
      inc(CaActive);
      if CaActive > NbCase then CaActive := 1;
      CacheSouris;
      AfficheCaseACocher(UneBoite,Ancien);
      AfficheCaseACocher(UneBoite,CaActive);
      MontreSouris;
    End;
  End;

  (**)
  Procedure VaGauche;

  Var
    Ancien : byte;

  Begin
    with UneBoite^ do
    Begin
      Ancien := CaActive;
      dec(CaActive);
      if CaActive = 0 then CaActive := NbCase;
      CacheSouris;
      AfficheCaseACocher(UneBoite,Ancien);
      AfficheCaseACocher(UneBoite,CaActive);
      MontreSouris;
    End;
  End;

  (**)
  Procedure VaBas;

  Var
    Ancien,Tmp : byte;

  Begin
    with UneBoite^ do
    Begin
      Ancien := CaActive;
      inc(CaActive,NbEnX);
      if CaActive > NbCase then
      Begin
        Tmp := NbEnX * NbEnY;
        if CaActive <= Tmp then inc(CaActive,NbEnX);
        CaActive := CaActive - Tmp;
      End;
      CacheSouris;
      AfficheCaseACocher(UneBoite,Ancien);
      AfficheCaseACocher(UneBoite,CaActive);
      MontreSouris;
    End;
  End;

  (**)
  Procedure VaHaut;

  Var
    Ancien,Tmp : byte;

  Begin
    with UneBoite^ do
    Begin
      Ancien := CaActive;
      if CaActive > NbEnX then dec(CaActive,NbEnX)
      else
      Begin
        Tmp := NbEnX * (NbEnY - 1) + CaActive;
        if Tmp > NbCase then dec(Tmp,NbEnX);
        CaActive := Tmp;
      End;
      CacheSouris;
      AfficheCaseACocher(UneBoite,Ancien);
      AfficheCaseACocher(UneBoite,CaActive);
      MontreSouris;
    End;
  End;

  (**)
  Procedure Selection;

  Begin
    with UneBoite^ do
    Begin
      with CaseCocher[CaActive] do  Select := not Select;
      CacheSouris;
      AfficheCaseACocher(UneBoite,CaActive);
      MontreSouris;
    End;
  End;

  (**)
  Procedure RaccourciBouton;

  Var
    N : byte;
    Ancien,Tmp : byte;

  Begin
    with UneBoite^ do
    Begin
      Ancien := CaActive;
      for N := 1 to NbCase do
      with CaseCocher[N] do
        if Majuscules(LeCar) = Majuscules(Raccourci) then
        Begin
          CaActive := N;
          CacheSouris;
          AfficheCaseACocher(UneBoite,Ancien);
          AfficheCaseACocher(UneBoite,CaActive);
          MontreSouris;
        End;
    End;
  End;

  (**)
  Procedure GereSouris;

  Var
    Ancien : byte;

  Begin
    Ancien := UneBoite^.CaActive;
    if SourisDsBteCaseACocherTx(UneBoite,InfoSouris) then
    Begin
      CacheSouris;
      AfficheCaseACocher(UneBoite,Ancien);
      AfficheCaseACocher(UneBoite,UneBoite^.CaActive);
      MontreSouris;
    End
    else Abandon := true;
    LeCar := #0;
  End;

  (**)
  Procedure GereClavier;

  Begin
    if ToucheFct then
      case LeCar of
        FlchDroite : VaDroite;
        FlchGauche : VaGauche;
        FlchBas    : VaBas;
        FlchHaut   : VaHaut;
        ShiftTab   : Abandon := true;
        ShiftF1    : BoiteAProposTx;
        AltX       : Begin
                       Sortie := true;
                       Abandon := true;
                     End;
        else Abandon := true;
      end
    else
    Begin
      case LeCar of
        Tab        : Abandon := true;
        CarEsc     : Abandon := true;
        CarReturn  : Abandon := true;
        Espace     : Selection;
      else RaccourciBouton;
      end;
    End;
  End;

  (**)

Begin
  Abandon := false;
  SauvegardeTx(S);
  CacheCurseurTx;
  MontreSouris;
  UneBoite^.Active := true;
  AfficheBoiteCaseACocherTx(UneBoite);
  while not Abandon do
  Begin
    if AttendActionTx(LeCar,InfoSouris) then GereSouris;
    if LeCar <> #0 then GereClavier;
  End;
  UneBoite^.Active := false;
  AfficheBoiteCaseACocherTx(UneBoite);
  RestaureTx(S);
End;

{}

Function SourisDsBteCaseACocherTx(Var UneBoite : BteCaseACocherTxPtr;
                                              InfoSouris : PosRec) : boolean;

Var
  X,Y   : byte;   { position texte de la souris }
  X1,X2 : byte;   { debut et fin du bouton      }
  N     : byte;

Begin
  SourisDsBteCaseACocherTx := false;
  if InfoSouris.Bouton = BoutonGauche then
  Begin
    with InfoSouris do PosSourisPosTx(Colonne,Ligne,X,Y);
    with UneBoite^ do
    Begin
      Active := false;
      if (Y >= PosY) and (Y <= (PosY + NbEnY)) then
      Begin
        Active := ((X >= PosX) and (X <= (PosX + Larg)));
        if (Active and (Y <> PosY)) then
        Begin
          N := PosX + NbEnX * LargTexte;
          if X < N then
          Begin
            N := (Y - PosY - 1) * NbEnX;
            N := N + ((X - PosX) div LargTexte + 1);
            if N <= NbCase then
            Begin
              CaActive := N;
              with CaseCocher[N] do Select:= not Select;
            End;
          End;
        End;
      End;
      SourisDsBteCaseACocherTx := Active;
    End;
  End;
End;

(**)

Begin

End.