{

                           AJGENGR  Version 1.0

                         Creation Alain JAFFRE 1995

  ͸
                   Unite ecrite pour TURBO PASCAL 7.0                     
                                                                          
                             Alain JAFFRE                                 
  ;

}

{$I AJGENGR.DOC }

IMPLEMENTATION

{}

{$F+}
Procedure MyExitProc;

Begin
  ExitProc := OldExitProc;
  if ModeGr then CloseGraph;
End;
{$F-}

{}

Procedure InitGraphique;

Var
  Carte      : integer;
  Mode       : integer;
  CodeErreur : integer;

  (**)
  Procedure Quitte(Msg : string;Code : integer);

  Begin
    closegraph;
    Beep;
    writeln(Msg,' : ',GraphErrorMsg(Code));
    halt(1);
  End;

Begin
  DirectVideo := False;
  OldExitProc := ExitProc;
  ExitProc    := @MyExitProc;
  if registerBGIdriver(@EGAVGADriverProc) < 0 then
     Quitte('EGA/VGA',graphresult);
  Carte := detect;
  initgraph(Carte,Mode,'');
  CodeErreur := graphresult;
  if CodeErreur <> grOk then Quitte('Erreur graphique',CodeErreur);
  if Carte > VGA then
  Begin
    Carte := VGA;
    Mode  := VGAHi;
    initgraph(Carte,Mode,'');
    CodeErreur := graphresult;
    if CodeErreur <> grOk then Quitte('Erreur graphique',CodeErreur);
  End;
  if not (Carte in [EGA,EGA64,VGA]) then Quitte('Carte non EGA/VGA',0);
  SetTextStyle(DefaultFont,HorizDir,1);
  SetTextJustify(LeftText, TopText);
  SetLineStyle(SolidLn, 0, NormWidth);
  HautCarGr := TextHeight('M') + 2;
  LargCarGr := TextWidth('M');
  CurseurXGr := 1;
  CurseurYGr := 1;
  OldCurseurXGr := 0;
  OldCurseurYGr := 0;
  if SourisVis then
    Begin
      CacheSouris;
      MontreSouris;
    End;
  ModeGr := true;
End;

{}

Procedure PasseGraphique;

Begin
  if not ModeGr then
  Begin
    SetGraphMode(GetGraphMode);
    if CurseurVis then MontreCurseurGr
                  else CacheCurseurGr;
    if SourisVis then
    Begin
      CacheSouris;
      RazSouris;
      MontreSouris;
    End;
    ModeGr := true;
  End;
End;

{}

Procedure FenetreMaxGr;

Begin
  SetViewPort(0, 0, GetMaxX, GetMaxY, ClipOn);
End;

{}

Procedure GotoXYGr(X,Y : integer);

Begin
  OldCurseurXGr := CurseurXGr;
  OldCurseurYGr := CurseurYGr;
  CurseurXGr := X;
  CurseurYGr := Y;
  MoveTo(CurseurXGr,CurseurYGr);
End;

{}

Function WhereXGr : integer;

Begin
  WhereXGr := CurseurXGr;
End;

{}

Function WhereYGr : integer;

Begin
  WhereYGr := CurseurYGr;
End;

{}

Procedure EffaceCurseurGr(CurseurX,CurseurY : integer);

Var
  S     : TypeSauveGr;
  PosY  : integer;
  N     : byte;

Begin
  if not CurseurVisGr then exit;
  SauvegardeGr(S);
  PosY := CurseurY + HautCarGr - 1;
  setcolor(EncreGr);
  setwritemode(XorPut);
  CurseurVisGr := false;
  if not OldCurseurOve then line(CurseurX,PosY,CurseurX + LargCarGr - 1,PosY)
  else
    for N := 1 to (HautCarGr - 1) do
    Begin
      line(CurseurX,PosY,CurseurX + LargCarGr - 1,PosY);
      dec(PosY);
    End;
  RestaureGr(S);
End;

{}

Procedure AfficheCurseurGr;

Var
  S     : TypeSauveGr;
  Reg   : registers;
  Pulse : longint;
  PosY  : integer;
  N     : byte;

Begin
  if not CurseurVis then exit;
  SauvegardeGr(S);
  if not ((OldCurseurXGr = CurseurXGr) and (OldCurseurYGr = CurseurYGr))
    then
    Begin
      EffaceCurseurGr(OldCurseurXGr,OldCurseurYGr);
      OldCurseurXGr := CurseurXGr;
      OldCurseurYGr := CurseurYGr;
    End;
  if not (OldCurseurOve = CurseurOve) then
  Begin
    EffaceCurseurGr(CurseurXGr,CurseurYGr);
    OldCurseurOve := CurseurOve;
  End;
  Reg.ah:=0;
  intr($1a,Reg);
  Pulse    := trunc(Reg.dx / 5);
  PosY := CurseurYGr + HautCarGr - 1;
  if (Pulse mod 2 = 0) then
  Begin
    if not CurseurVisGr then
    Begin
      setcolor(EncreGr);
      setwritemode(XorPut);
      CurseurVisGr := true;
      if not OldCurseurOve then
         line(CurseurXGr,PosY,CurseurXGr + LargCarGr - 1,PosY)
      else for N := 1 to (HautCarGr - 1) do
      Begin
        line(CurseurXGr,PosY,CurseurXGr + LargCarGr - 1,PosY);
        dec(PosY);
      End;
      OldCurseurOve := CurseurOve;
    End;
  End
  else
  Begin
    if CurseurVisGr then
    Begin
      setcolor(EncreGr);
      setwritemode(XorPut);
      CurseurVisGr := false;
      if not OldCurseurOve then
         line(CurseurXGr,PosY,CurseurXGr + LargCarGr - 1,PosY)
      else for N := 1 to (HautCarGr - 1) do
      Begin
        line(CurseurXGr,PosY,CurseurXGr + LargCarGr - 1,PosY);
        dec(PosY);
      End;
    End;
  End;
  RestaureGr(S);
End;

{}

Procedure WriteGr(Texte : string);

Var
  Fenetre : ViewPortType;
  Long    : integer;
  X1Gr    : integer;
  Y1Gr    : integer;
  X2Gr    : integer;
  Y2Gr    : integer;

Begin
  GetViewSettings(Fenetre);
  with Fenetre do
  Begin
    if (CurseurYGr + HautCarGr) > (Y2 - Y1) then exit;
    Long := length(Texte) * LargCarGr;
    if (CurseurXGr + Long) > X2 then
    Begin
      Long := GetMaxX - CurseurXGr - 1;
      Texte := copy(Texte,1,Long div LargCarGr);
    End;
  End;
  X1Gr := CurseurXGr;
  Y1Gr := CurseurYGr;
  X2Gr := X1Gr + length(Texte) * LargCarGr;
  Y2Gr := Y1Gr + HautCarGr;
  SetFillStyle(SolidFill,FondGr);
  Bar(X1Gr,Y1Gr,X2Gr,Y2Gr);
  OutTextXY(CurseurXGr,CurseurYGr+1,Texte);
  CurseurXGr := CurseurXGr + (length(Texte) * LargCarGr);
End;

{}

Procedure WriteLnGr(Texte : string);

Var
  Fenetre : ViewPortType;
  Long    : integer;
  X1Gr    : integer;
  Y1Gr    : integer;
  X2Gr    : integer;
  Y2Gr    : integer;

Begin
  GetViewSettings(Fenetre);
  with Fenetre do
  Begin
    if (CurseurYGr + HautCarGr) > (Y2 - Y1) then exit;
    Long := length(Texte) * LargCarGr;
    if (CurseurXGr + Long) > X2 then
    Begin
      Long := GetMaxX - CurseurXGr - 1;
      Texte := copy(Texte,1,Long div LargCarGr);
    End;
  End;
  X1Gr := CurseurXGr;
  Y1Gr := CurseurYGr;
  X2Gr := X1Gr + length(Texte) * LargCarGr;
  Y2Gr := Y1Gr + HautCarGr;
  SetFillStyle(SolidFill,FondGr);
  Bar(X1Gr,Y1Gr,X2Gr,Y2Gr);
  OutTextXY(CurseurXGr,CurseurYGr+1,Texte);
  CurseurXGr := 1;
  CurseurYGr := CurseurYGr + HautCarGr;
End;

{}

Function AttendActionGr(Var Car : char;Var Souris : PosRec):boolean;

Var
  ActionSouris  : boolean;
  ActionClavier : boolean;
  Bouton        : byte;

Begin
  ActionSouris := false;
  ActionClavier := false;
  repeat
    AfficheCurseurGr;
    AppelTache;
    if SourisUtil then
    Begin
      if ClickSouris(Bouton) then
      Begin
        SourisPressee(Bouton,Souris);
        ActionSouris := (Souris.Nombre <> 0);
      End;
    End;
    ActionClavier := keypressed ;
  until ActionSouris or ActionClavier;
  if ActionClavier then
  Begin
    Car := readkey;
    if Car = #0 then
    Begin                            { une touche de fonction a t appuye }
      Car := readkey;                { lecture du second code }
      ToucheFct := true;
    End
    else ToucheFct := false;
  End
  else
  Begin
    Car := #0;
    ToucheFct := false;
  End;
  AttendActionGr := ActionSouris;
End;

{}

Procedure PlusDeMemoireGr;

Begin
  with CoulAlarme do
  Begin
    MessageGr(Fond,Encre,24,LignePlusDeMem,false);
    MessageGr(Fond,Encre,25,LigneSuite,true);
  End;
End;

{}

Procedure AfficheLigneAideGr(Oui : boolean);

Var
  S           : TypeSauveGr;
  X1,Y1,X2,Y2 : integer;
  Taille      : word;
  N           : integer;
  Surligner   : boolean;

  Procedure ChangeCouleur;

  Begin
    with LigneAide do
    if Surligner then
    Begin
      CoulFondGr(Normal.Fond);
      CoulEncreGr(Normal.Encre);
    End
    else
    Begin
      CoulFondGr(Surligne.Fond);
      CoulEncreGr(Surligne.Encre);
    End;
    Surligner := not Surligner;
  End;

  Function CompteTilde : byte;

  Var
    NbTilde, Z : byte;

  Begin
    with LigneAide do
    Begin
      NbTilde := 0;
      for Z := 1 to length(Texte) do
        if Texte[Z] = '~' then inc(NbTilde);
    End;
    CompteTilde := NbTilde;
  End;

Begin
  if not AffiAide then exit;
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  X1 := 0;
  Y1 := GetMaxY - HautCarGr;
  X2 := GetMaxX;
  Y2 := GetMaxY;
  Taille := imagesize(X1,Y1,X2,Y2);
  FenetreMaxGr;
  with LigneAide do
    if Oui then
    Begin
      SetWriteMode(NormalPut);
      SetFillStyle(SolidFill,Normal.Fond);
      Bar(X1,Y1,X2,Y2);
      GotoXYGr(X1,Y1);
      N := (X2 - X1) div LargCarGr + CompteTilde;
      Texte := ElargiADte(Texte,N);
      CoulFondGr(Normal.Fond);
      CoulEncreGr(Normal.Encre);
      Surligner := false;
      for N := 1 to length(Texte) do
      Begin
        if Texte[N] = '~' then ChangeCouleur
                          else WriteGr(Texte[N]);
      End;
    End
    else
    Begin
      SetWriteMode(NormalPut);
      SetFillStyle(SolidFill,Normal.Fond);
      Bar(X1,Y1,X2,Y2);
      GotoXYGr(X1,Y1)
    End;
  RestaureGr(S);
End;

(**)

Procedure CacheCurseurGr;

Begin
  if CurseurVis then
  Begin
    EffaceCurseurGr(OldCurseurXGr,OldCurseurYGr);
    CurseurVis := false;
    CurseurVisGr := false;
  End;
End;

{}

Procedure MontreCurseurGr;

Begin
  if not CurseurVis then
  Begin
    CurseurVis := true;
    OldCurseurOve := CurseurOve;
  End;
End;

{}

Procedure SauvegardeGr(Var S : TypeSauveGr);

Begin
  with S do
  Begin
    CoulFond  := FondGr;
    CoulEncre := EncreGr;
    CurseurX  := WhereXGr;
    CurseurY  := WhereYGr;
    CVisible  := CurseurVis;
    COverwri  := CurseurOve;
    SVisible  := SourisVis;
    GetViewSettings(Fenetre);
  End;
End;

{}

Procedure RestaureGr(S : TypeSauveGr);

Begin
  with S do
  Begin
    FondGr  := CoulFond;
    EncreGr := CoulEncre;
    GotoXYGr(CurseurX,CurseurY);
    if CVisible then MontreCurseurGr
                else CacheCurseurGr;
    CurseurOve := COverwri;
    if SVisible then MontreSouris
                else CacheSouris;
    with Fenetre do SetViewPort(X1,Y1,X2,Y2,Clip);
  End;
End;

{}

Procedure EcritEcranGr (NomFichier : Str80);

Var
  S           : TypeSauveGr;
  Colonne     : word;
  Ligne       : word;
  FicEcran    : file of word;
  Tmp         : word;
  MaxX        : integer;
  MaxY        : integer;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  MaxX := GetMaxX;
  MaxY := GetMaxY;
  SetViewPort(0, 0, MaxX, MaxY, ClipOn);
  assign(FicEcran,NomFichier);
  {$I-}
  rewrite(FicEcran);
  {$I+}
  if ioresult = 0 then
  Begin
    for Ligne := 0 to MaxY do
    Begin
      for Colonne := 0 to MaxX do
      Begin
        Tmp := getpixel(Colonne,Ligne);
        write(FicEcran,Tmp);
      End;
    End;
    close(FicEcran);
  End;
  RestaureGr(S);
End;

{}

Procedure LitEcranGr (NomFichier : Str80; EffaceFic : boolean);

Var
  S           : TypeSauveGr;
  Colonne     : word;
  Ligne       : word;
  FicEcran    : file of word;
  Tmp         : word;
  MaxX        : integer;
  MaxY        : integer;


Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  MaxX := GetMaxX;
  MaxY := GetMaxY;
  SetViewPort(0, 0, MaxX, MaxY, ClipOn);
  assign(FicEcran,NomFichier);
  {$I-}
  reset(FicEcran);
  {$I+}
  if ioresult = 0 then
  Begin
    for Ligne := 0 to MaxY do
    Begin
      for Colonne := 0 to MaxX do
      if not Eof(FicEcran) then
      Begin
        read(FicEcran,Tmp);
        putpixel(Colonne,Ligne,Tmp);
      End;
    End;
    close(FicEcran);
    if EffaceFic then erase(FicEcran);
  End;
  RestaureGr(S);
End;


{}

Procedure SauveRectGr(X1,Y1,X2,Y2 : integer;Var LePtr : pointer);

Var
  S : TypeSauveGr;

Begin
  SauvegardeGr(S);
  CacheSouris;
  CacheCurseurGr;
  getimage(X1,Y1,X2,Y2,LePtr^);
  RestaureGr(S);
End;

{}

Procedure LitRectGr (X1, Y1, X2, Y2 : integer; Var LePtr : pointer);

Var
  S : TypeSauveGr;

Begin
  SauvegardeGr(S);
  CacheSouris;
  CacheCurseurGr;
  putimage(X1,Y1,LePtr^,normalput);
  RestaureGr(S);
End;

(**)

Procedure CoulFondGr(Coul : Couleur);

Begin
  if Coul = Noir then FondGr := Gris
                 else FondGr := Coul;
End;

{}

Procedure CoulEncreGr(Coul : Couleur);

Begin
  if Coul = Noir then EncreGr := Gris
                 else EncreGr := Coul;
  setcolor(EncreGr);
End;

{}

Procedure InverseGr(X1,Y1,X2,Y2 : integer);

Var
  M       : integer;
  N       : integer;
  CoulTmp : integer;

Begin
  for M := X1 to X2 do
    for N := Y1 to Y2 do
    Begin
      CoulTmp := getpixel(M,N);
      CoulTmp := CoulTmp xor 15;
      putpixel(M,N,CoulTmp);
    End;
End;

{}

Procedure CentreTexteGr(PosY : integer;Texte : Str80);

Var
  Fenetre : ViewPortType;
  XTmp    : integer;

Begin
  GetViewSettings(Fenetre);
  with Fenetre do XTmp := (X2 - X1) div 2;
  XTmp := XTmp - (length(Texte) * LargCarGr div 2);
  GotoXYGr(XTmp,PosY);
  writeGr(Texte);
End;

{}

Procedure MessageGr(Fond,Encre : Couleur;PosY : integer;Texte : Str80;
                                                          Reponse : boolean);
Begin
  CoulFondGr(Fond);
  CoulEncreGr(Encre);
  CentreTexteGr(PosY,Texte);
  if Reponse then SaisirCar(CarReponse);
End;

{}

Procedure AfficheGr(Texte : str80;Longueur : byte);

Begin
  Texte := ElargiADte(Texte,Longueur);
  WriteGr(Texte);
end;

{}

Procedure EffaceGr(X1,Y1,X2,Y2 : integer);

Var
  S : TypeSauveGr;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  SetFillStyle(SolidFill,FondGr);
  Bar(X1,Y1,X2,Y2);
  RestaureGr(S);
End;

{}

Procedure EffaceEcranGr(Coul : Couleur);

Var
  S : TypeSauveGr;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  FenetreMaxGr;
  SetBkColor(Coul);
  ClearDevice;
  RestaureGr(S);
End;

{}

Procedure BoiteGr(X,Y,Larg,Haut : integer;Tip : TypeBoite; Coul : CoupleCoul;
                                                            Plein : boolean);

  (**)
  Procedure AjusteDimension;

  Var
    Fenetre : ViewPortType;
    MaxLarg : integer;
    MaxHaut : integer;

  Begin
    GetViewSettings(Fenetre);
    with Fenetre do
    Begin
      MaxLarg := X2 - X1;
      MaxHaut := Y2 - Y1;
    End;
    if Tip in [OmbreSs,Ombre1,Ombre2,Ombre3,Ombre4] then
    Begin
      if Larg > (MaxLarg - OmbreBoite - X - 1) then
         Larg := (MaxLarg - OmbreBoite - X - 1);
      if Haut > (MaxHaut - OmbreBoite - Y - 1) then
         Haut := (MaxHaut - OmbreBoite - Y - 1);
    End
    else
    Begin
      if Larg > (MaxLarg - 1 - X) then Larg := (MaxLarg - 1 - X);
      if Haut > (MaxHaut - 1 - Y) then Haut := (MaxHaut - 1 - Y);
    End;
  End;

  (**)
  Procedure TraceBordure;

  Begin
    SetFillStyle(SolidFill,FondGr);
    Bar(X,Y,X + Larg,Y + HCadreBoite);
    Bar(X,Y + Haut - HCadreBoite,X + Larg,Y + Haut);
    Bar(X,Y,X + HCadreBoite,Y + Haut);
    Bar(X + Larg - HCadreBoite,Y,X + Larg,Y + Haut);
  End;

  (**)
  Procedure TraceHaut;

  Var
    Dx : byte;
    Dy : byte;

  Begin
    SetLineStyle(SolidLn, 0, NormWidth);
    case Tip of
      Cadre1  : Begin
                  Dx := HCadreBoite div 2;
                  Dy := Dx;
                  Line(X + Dx,Y + Dy,X + Larg - Dx,Y + Dy);
                End;
      Cadre2  : Begin
                  Dx := HCadreBoite div 3;
                  Dy := Dx;
                  Line(X + Dx,Y + Dy,X + Larg - Dx,Y + Dy);
                  Line(X + HCadreBoite - Dx,Y + HCadreBoite - Dy,
                       X + Larg - HCadreBoite + Dx,Y + HCadreBoite - Dy);
                End;
      Cadre3  : Begin
                  Dx := HCadreBoite div 2;
                  Dy := HCadreBoite div 3;
                  Line(X + Dx,Y + Dy,X + Larg - Dx,Y +  Dy);
                  Line(X + Dx,Y + HCadreBoite - Dy,
                       X + Larg - Dx,Y + HCadreBoite - Dy);
                End;
      Cadre4  : Begin
                  Dx := HCadreBoite div 3;
                  Dy := HCadreBoite div 2;
                  Line(X + Dx,Y + Dy,X + Larg - Dx,Y + Dy);
                End;
      Ombre1  : Begin
                  Dx := HCadreBoite div 2;
                  Dy := Dx;
                  Line(X + Dx,Y + Dy,X + Larg - Dx,Y + Dy);
                End;
      Ombre2  : Begin
                  Dx := HCadreBoite div 3;
                  Dy := Dx;
                  Line(X + Dx,Y + Dy,X + Larg - Dx,Y + Dy);
                  Line(X + HCadreBoite - Dx,Y + HCadreBoite - Dy,
                       X + Larg - HCadreBoite + Dx,Y + HCadreBoite - Dy);
                End;
      Ombre3  : Begin
                  Dx := HCadreBoite div 2;
                  Dy := HCadreBoite div 3;
                  Line(X + Dx,Y + Dy,X + Larg - Dx,Y +  Dy);
                  Line(X + Dx,Y + HCadreBoite - Dy,
                       X + Larg - Dx,Y + HCadreBoite - Dy);
                End;
      Ombre4  : Begin
                  Dx := HCadreBoite div 3;
                  Dy := HCadreBoite div 2;
                  Line(X + Dx,Y + Dy,X + Larg - Dx,Y + Dy);
                End;
    end;
  End;

  (**)
  Procedure TraceBas;

  Var
    Dx : byte;
    Dy : byte;

  Begin
    SetLineStyle(SolidLn, 0, NormWidth);
    case Tip of
      Cadre1  : Begin
                  Dx := HCadreBoite div 2;
                  Dy := Dx;
                  Line(X + Dx,Y + Haut - Dy,X + Larg - Dx,Y + Haut - Dy);
                End;
      Cadre2  : Begin
                  Dx := HCadreBoite div 3;
                  Dy := Dx;
                  Line(X + Dx,Y + Haut - Dy,X + Larg - Dx,Y + Haut - Dy);
                  Line(X + HCadreBoite - Dx,Y + Haut - HCadreBoite + Dy,
                    X + Larg - HCadreBoite + Dx,Y + Haut - HCadreBoite + Dy);
                End;
      Cadre3  : Begin
                  Dx := HCadreBoite div 2;
                  Dy := HCadreBoite div 3;
                  Line(X + Dx,Y + Haut - Dy,X + Larg - Dx,Y + Haut - Dy);
                  Line(X + Dx,Y + Haut - HCadreBoite + Dy,
                       X + Larg - Dx,Y + Haut - HCadreBoite + Dy);
                End;
      Cadre4  : Begin
                  Dx := HCadreBoite div 3;
                  Dy := HCadreBoite div 2;
                  Line(X + Dx,Y + Haut - Dy,X + Larg - Dx,Y + Haut - Dy);
                End;
      Ombre1  : Begin
                  Dx := HCadreBoite div 2;
                  Dy := Dx;
                  Line(X + Dx,Y + Haut - Dy,X + Larg - Dx,Y + Haut - Dy);
                End;
      Ombre2  : Begin
                  Dx := HCadreBoite div 3;
                  Dy := Dx;
                  Line(X + Dx,Y + Haut - Dy,X + Larg - Dx,Y + Haut - Dy);
                  Line(X + HCadreBoite - Dx,Y + Haut - HCadreBoite + Dy,
                    X + Larg - HCadreBoite + Dx,Y + Haut - HCadreBoite + Dy);
                End;
      Ombre3  : Begin
                  Dx := HCadreBoite div 2;
                  Dy := HCadreBoite div 3;
                  Line(X + Dx,Y + Haut - Dy,X + Larg - Dx,Y + Haut - Dy);
                  Line(X + Dx,Y + Haut - HCadreBoite + Dy,
                       X + Larg - Dx,Y + Haut - HCadreBoite + Dy);
                End;
      Ombre4  : Begin
                  Dx := HCadreBoite div 3;
                  Dy := HCadreBoite div 2;
                  Line(X + Dx,Y + Haut - Dy,X + Larg - Dx,Y + Haut - Dy);
                End;
    end;
  End;

  (**)
  Procedure TraceGauche;

  Var
    Dx : byte;
    Dy : byte;

  Begin
    SetLineStyle(SolidLn, 0, NormWidth);
    case Tip of
      Cadre1  : Begin
                  Dx := HCadreBoite div 2;
                  Dy := Dx;
                  Line(X + Dx,Y + Dy,X + Dx,Y + Haut - Dy);
                End;
      Cadre2  : Begin
                  Dx := HCadreBoite div 3;
                  Dy := Dx;
                  Line(X + Dx,Y + Dy,X + Dx,Y + Haut - Dy);
                  Line(X + HCadreBoite - Dx,Y + HCadreBoite - Dy,
                       X + HCadreBoite - Dx,Y + Haut - HCadreBoite + Dy);
                End;
      Cadre3  : Begin
                  Dx := HCadreBoite div 2;
                  Dy := HCadreBoite div 3;
                  Line(X + Dx,Y + Dy,X + Dx,Y + Haut - Dy);
                End;
      Cadre4  : Begin
                  Dx := HCadreBoite div 3;
                  Dy := HCadreBoite div 2;
                  Line(X + Dx,Y + Dy,X + Dx,Y + Haut - Dy);
                  Line(X + HCadreBoite - Dx,Y + Dy,
                       X + HCadreBoite - Dx,Y + Haut - Dy);
                End;
      Ombre1  : Begin
                  Dx := HCadreBoite div 2;
                  Dy := Dx;
                  Line(X + Dx,Y + Dy,X + Dx,Y + Haut - Dy);
                End;
      Ombre2  : Begin
                  Dx := HCadreBoite div 3;
                  Dy := Dx;
                  Line(X + Dx,Y + Dy,X + Dx,Y + Haut - Dy);
                  Line(X + HCadreBoite - Dx,Y + HCadreBoite - Dy,
                       X + HCadreBoite - Dx,Y + Haut - HCadreBoite + Dy);
                End;
      Ombre3  : Begin
                  Dx := HCadreBoite div 2;
                  Dy := HCadreBoite div 3;
                  Line(X + Dx,Y + Dy,X + Dx,Y + Haut - Dy);
                End;
      Ombre4  : Begin
                  Dx := HCadreBoite div 3;
                  Dy := HCadreBoite div 2;
                  Line(X + Dx,Y + Dy,X + Dx,Y + Haut - Dy);
                  Line(X + HCadreBoite - Dx,Y + Dy,
                       X + HCadreBoite - Dx,Y + Haut - Dy);
                End;
    end;
  End;

  (**)
  Procedure TraceDroit;

  Var
    Dx : byte;
    Dy : byte;

  Begin
    SetLineStyle(SolidLn, 0, NormWidth);
    case Tip of
      Cadre1  : Begin
                  Dx := HCadreBoite div 2;
                  Dy := Dx;
                  Line(X + Larg - Dx,Y + Dy,X + Larg - Dx,Y + Haut - Dy);
                End;
      Cadre2  : Begin
                  Dx := HCadreBoite div 3;
                  Dy := Dx;
                  Line(X + Larg - Dx,Y + Dy,X + Larg - Dx,Y + Haut - Dy);
                  Line(X + Larg - HCadreBoite + Dx,Y + HCadreBoite - Dy,
                    X + Larg - HCadreBoite + Dx,Y + Haut - HCadreBoite + Dy);
                End;
      Cadre3  : Begin
                  Dx := HCadreBoite div 2;
                  Dy := HCadreBoite div 3;
                  Line(X + Larg - Dx,Y + Dy,X + Larg - Dx,Y + Haut - Dy);
                End;
      Cadre4  : Begin
                  Dx := HCadreBoite div 3;
                  Dy := HCadreBoite div 2;
                  Line(X + Larg - Dx,Y + Dy,X + Larg - Dx,Y + Haut - Dy);
                  Line(X + Larg - HCadreBoite + Dx,Y + Dy,
                       X + Larg - HCadreBoite + Dx,Y + Haut - Dy);
                End;
      Ombre1  : Begin
                  Dx := HCadreBoite div 2;
                  Dy := Dx;
                  Line(X + Larg - Dx,Y + Dy,X + Larg - Dx,Y + Haut - Dy);
                End;
      Ombre2  : Begin
                  Dx := HCadreBoite div 3;
                  Dy := Dx;
                  Line(X + Larg - Dx,Y + Dy,X + Larg - Dx,Y + Haut - Dy);
                  Line(X + Larg - HCadreBoite + Dx,Y + HCadreBoite - Dy,
                    X + Larg - HCadreBoite + Dx,Y + Haut - HCadreBoite + Dy);
                End;
      Ombre3  : Begin
                  Dx := HCadreBoite div 2;
                  Dy := HCadreBoite div 3;
                  Line(X + Larg - Dx,Y + Dy,X + Larg - Dx,Y + Haut - Dy);
                End;
      Ombre4  : Begin
                  Dx := HCadreBoite div 3;
                  Dy := HCadreBoite div 2;
                  Line(X + Larg - Dx,Y + Dy,X + Larg - Dx,Y + Haut - Dy);
                  Line(X + Larg - HCadreBoite + Dx,Y + Dy,
                       X + Larg - HCadreBoite + Dx,Y + Haut - Dy);
                End;
    end;
  End;

  (**)
  Procedure TraceOmbre;

  Begin
    SetFillStyle(SolidFill,Gris);
    Bar(X + Larg + 1,Y + OmbreBoite,
        X + Larg + OmbreBoite,Y + Haut + OmbreBoite);
    Bar(X + OmbreBoite,Y + Haut + 1,X + Larg,Y + Haut + OmbreBoite);
  End;

Begin
  AjusteDimension;
  CoulFondGr(Coul.Fond);
  CoulEncreGr(Coul.Encre);
  SetWriteMode(NormalPut);
  if Plein then EffaceGr(X,Y,X + Larg,Y + Haut)
           else TraceBordure;
  TraceHaut;
  TraceBas;
  TraceGauche;
  TraceDroit;
  if Tip in [OmbreSs,Ombre1,Ombre2,Ombre3,Ombre4] then TraceOmbre;
End;

{}

Procedure BoiteReliefGr(X,Y,Larg,Haut : integer;Tip : TypeBoiteRelief;
                                          Coul : CoupleCoul;Plein : boolean);

Var
  AncienTip : TypeBoiteRelief;
  Rayon     : integer;

  (**)
  Procedure AjusteDimension;

  Var
    Fenetre : ViewPortType;
    MaxLarg : integer;
    MaxHaut : integer;

  Begin
    GetViewSettings(Fenetre);
    with Fenetre do
    Begin
      MaxLarg := X2 - X1;
      MaxHaut := Y2 - Y1;
    End;
    if Larg > (MaxLarg - 1 - X) then Larg := (MaxLarg - 1 - X);
    if Haut > (MaxHaut - 1 - Y) then Haut := (MaxHaut - 1 - Y);
  End;

  (**)
  Procedure HautGauche;

  Begin
    case Tip of
      Normale : setcolor(Blanc);
      Creux   : setcolor(Gris);
      Relief  : setcolor(Blanc);
    end;
    line(X,Y + Rayon,X,Y + Haut - Rayon);
    line(X + Rayon,Y,X + Larg - Rayon,Y);
    arc(X + Rayon,Y + Rayon,90,180,Rayon);
    arc(X + Rayon,Y + Haut - Rayon,180,225,Rayon);
    arc(X + Larg - Rayon,Y + Rayon,45,90,Rayon);
  End;

  (**)
  Procedure BasDroit;

  Begin
    case Tip of
      Normale : setcolor(Blanc);
      Creux   : setcolor(Blanc);
      Relief  : setcolor(Gris);
    end;
    line(X + Larg,Y + Rayon,X + Larg,Y + Haut - Rayon);
    line(X + Rayon,Y + Haut,X + Larg - Rayon,Y + Haut);
    arc(X + Larg - Rayon,Y + Haut - Rayon,270,360,Rayon);
    arc(X + Rayon,Y + Haut - Rayon,225,270,Rayon);
    arc(X + Larg - Rayon,Y + Rayon,0,45,Rayon);
  End;

  (**)
  Procedure VideInterieur;

  Begin
    SetFillStyle(SolidFill,Coul.Fond);
    FloodFill(X + Rayon,Y + Rayon,Blanc);
  End;

Begin
  Rayon := RayonRelief;
  AjusteDimension;
  SetWriteMode(NormalPut);
  SetLineStyle(SolidLn, 0, NormWidth);
  AncienTip := Tip;
  Tip := Normale;
  HautGauche;
  BasDroit;
  VideInterieur;
  if AncienTip in [Creux,Relief] then
  Begin
    Tip := AncienTip;
    HautGauche;
    BasDroit;
  End;
End;

{}

Procedure BoutonGr(UnBouton : BoutonRecGr;Selectionne : boolean);

Var
  S       : TypeSauveGr;
  M , N   : integer;
  Long    : integer;

  (**)
  Procedure CalculLongeur;

  Var
    Z : integer;

  Begin
    with UnBouton do
    Begin
      Long := 0;
      for Z := 1 to length(Texte) do
        if not (Texte[Z] = '~') then inc(Long);
      if Long >= Larg then
      Begin
        M := 0;
        N := 0;
        Z := Long - Larg;
        delete(Texte,length(Texte) - Z,Z);
        Long := Larg;
      End
      else
      Begin
        M := (Larg - Long) div 2;
        N := Larg - Long - M;
      End;
    End;
  End;

  (**)
  Procedure AfficheDebut;

  Begin
    if Selectionne then
    Begin
      CoulEncreGr(CoulBoutonSelec.Encre);
      CoulFondGr(CoulBoutonSelec.Fond);
    End
    else
    Begin
      CoulEncreGr(CoulBouton.Encre);
      CoulFondGr(CoulBouton.Fond);
    End;
  while M > 0 do
  Begin
    WriteGr(' ');
    dec(M);
  End;
  M := 1;
  while not ((UnBouton.Texte[M] = '~') or (M > Long)) do
  Begin
    WriteGr(UnBouton.Texte[M]);
    inc(M);
  End;
  inc(M);
  End;

  (**)
  Procedure AfficheRaccourci;

  Begin
    CoulEncreGr(CoulCarBouton.Encre);
    CoulFondGr(CoulCarBouton.Fond);
    while not ((UnBouton.Texte[M] = '~') or (M > Long)) do
    Begin
      WriteGr(UnBouton.Texte[M]);
      inc(M);
    End;
    inc(M);
  End;

  (**)
  Procedure AfficheFin;

  Begin
    if Selectionne then
    Begin
      CoulEncreGr(CoulBoutonSelec.Encre);
      CoulFondGr(CoulBoutonSelec.Fond);
    End
    else
    Begin
      CoulEncreGr(CoulBouton.Encre);
      CoulFondGr(CoulBouton.Fond);
    End;
    if M <= length(UnBouton.Texte) then
      with UnBouton do WriteGr(copy(Texte,M,length(Texte) - M + 1));
    while N > 0 do
    Begin
      WriteGr(' ');
      dec(N);
    End;
  End;

  (**)
  Procedure AfficheOmbre;

  Var
    HautOmbre : integer;
    LargOmbre : integer;

  Begin
    HautOmbre := HautCarGr div 2;
    LargOmbre := LargCarGr div 2;
    with UnBouton do
    Begin
      SetFillStyle(SolidFill,Gris);
      SetWriteMode(NormalPut);
      Bar(X + LargOmbre,Y + HautCarGr +1,
          X + (Larg * LargCarGr),Y + HautCarGr + HautOmbre);
      Bar(X + (Larg * LargCarGr) + 1,Y + HautOmbre,
          X + (Larg * LargCarGr) + LargOmbre,Y + HautCarGr + HautOmbre);
    End;
  End;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  with UnBouton do gotoxyGr(X,Y);
  CalculLongeur;
  AfficheDebut;
  AfficheRaccourci;
  AfficheFin;
  if UnBouton.Ombre then AfficheOmbre;
  RestaureGr(S);
End;

{}

Procedure BoutonReliefGr(UnBouton : BoutonReliefRecGr;
                                                     Selectionne : boolean);

Var
  S       : TypeSauveGr;
  M , N   : integer;
  Long    : integer;

  (**)
  Procedure CalculLongeur;

  Var
    Z : integer;

  Begin
    with UnBouton do
    Begin
      Long := 0;
      for Z := 1 to length(Texte) do
        if not (Texte[Z] = '~') then inc(Long);
      if Long >= Larg then
      Begin
        M := 0;
        N := 0;
        Z := Long - Larg;
        delete(Texte,length(Texte) - Z,Z);
        Long := Larg;
      End
      else
      Begin
        M := (Larg - Long) div 2;
        N := Larg - Long - M;
      End;
    End;
  End;

  (**)
  Procedure AfficheDebut;

  Begin
    if Selectionne then
    Begin
      CoulEncreGr(CoulBoutonSelec.Encre);
      CoulFondGr(CoulBoutonSelec.Fond);
    End
    else
    Begin
      CoulEncreGr(CoulBouton.Encre);
      CoulFondGr(CoulBouton.Fond);
    End;
  while M > 0 do
  Begin
    WriteGr(' ');
    dec(M);
  End;
  M := 1;
  while not ((UnBouton.Texte[M] = '~') or (M > Long)) do
  Begin
    WriteGr(UnBouton.Texte[M]);
    inc(M);
  End;
  inc(M);
  End;

  (**)
  Procedure AfficheRaccourci;

  Begin
    CoulEncreGr(CoulCarBouton.Encre);
    CoulFondGr(CoulCarBouton.Fond);
    while not ((UnBouton.Texte[M] = '~') or (M > Long)) do
    Begin
      WriteGr(UnBouton.Texte[M]);
      inc(M);
    End;
    inc(M);
  End;

  (**)
  Procedure AfficheFin;

  Begin
    if Selectionne then
    Begin
      CoulEncreGr(CoulBoutonSelec.Encre);
      CoulFondGr(CoulBoutonSelec.Fond);
    End
    else
    Begin
      CoulEncreGr(CoulBouton.Encre);
      CoulFondGr(CoulBouton.Fond);
    End;
    if M <= length(UnBouton.Texte) then
      with UnBouton do WriteGr(copy(Texte,M,length(Texte) - M + 1));
    while N > 0 do
    Begin
      WriteGr(' ');
      dec(N);
    End;
  End;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  with UnBouton do
  Begin
    BoiteReliefGr(X - 2,Y - 2,(Larg * LargCarGr) + 4,HautCarGr + 4,
                                                      Tip,CoulBouton,true);
    GotoXYGr(X,Y);
  End;
  CalculLongeur;
  AfficheDebut;
  AfficheRaccourci;
  AfficheFin;
  RestaureGr(S);
End;

{}

Function SourisDsBoutonGr(X,Y : integer;UnBouton : BoutonRecGr):boolean;

Var
  XG,YG,XD,YD : integer;
  Fenetre     : ViewPortType;

Begin
  GetViewSettings(Fenetre);
  with UnBouton,Fenetre do
  Begin
    XG := X1 + X;
    XD := X1 + X + (Larg * LargCarGr);
    YG := Y1 + Y;
    YD := Y1 + Y + HautCarGr;
  End;
  SourisDsBoutonGr := SourisDsZone(X,Y,XG,YG,XD,YD);
End;

{}

Function SourisDsBoutonReliefGr(X,Y : integer;
                                       UnBouton : BoutonReliefRecGr):boolean;

Var
  XG,YG,XD,YD : integer;
  Fenetre     : ViewPortType;

Begin
  GetViewSettings(Fenetre);
  with UnBouton,Fenetre do
  Begin
    XG := X1 + X;
    XD := X1 + X + (Larg * LargCarGr);
    YG := Y1 + Y;
    YD := Y1 + Y + HautCarGr;
  End;
  SourisDsBoutonReliefGr := SourisDsZone(X,Y,XG,YG,XD,YD);
End;

{}

Function ToucheDuBoutonGr(Touche : char;UnBouton : BoutonRecGr):boolean;

Var
  N         : byte;
  CarTmp    : char;
  Raccourci : char;

Begin
  with UnBouton do
  Begin
    N := pos('~',Texte);
    CarTmp := Texte[N + 1];
  End;
  case CarTmp of
    'A' : Raccourci := AltA;
    'B' : Raccourci := AltB;
    'C' : Raccourci := AltC;
    'D' : Raccourci := AltD;
    'E' : Raccourci := AltE;
    'F' : Raccourci := AltF;
    'G' : Raccourci := AltG;
    'H' : Raccourci := AltH;
    'I' : Raccourci := AltI;
    'J' : Raccourci := AltJ;
    'K' : Raccourci := AltK;
    'L' : Raccourci := AltL;
    'M' : Raccourci := AltM;
    'N' : Raccourci := AltN;
    'O' : Raccourci := AltO;
    'P' : Raccourci := AltP;
    'Q' : Raccourci := AltQ;
    'R' : Raccourci := AltR;
    'S' : Raccourci := AltS;
    'T' : Raccourci := AltT;
    'U' : Raccourci := AltU;
    'V' : Raccourci := AltV;
    'W' : Raccourci := AltW;
    'X' : Raccourci := AltX;
    'Y' : Raccourci := AltY;
    'Z' : Raccourci := AltZ;
  end;
  ToucheDuBoutonGr := (Touche = Raccourci);
End;

{}

Function ToucheDuBoutonReliefGr(Touche : char;
                                       UnBouton : BoutonReliefRecGr):boolean;

Var
  N         : byte;
  CarTmp    : char;
  Raccourci : char;

Begin
  with UnBouton do
  Begin
    N := pos('~',Texte);
    CarTmp := Texte[N + 1];
  End;
  case CarTmp of
    'A' : Raccourci := AltA;
    'B' : Raccourci := AltB;
    'C' : Raccourci := AltC;
    'D' : Raccourci := AltD;
    'E' : Raccourci := AltE;
    'F' : Raccourci := AltF;
    'G' : Raccourci := AltG;
    'H' : Raccourci := AltH;
    'I' : Raccourci := AltI;
    'J' : Raccourci := AltJ;
    'K' : Raccourci := AltK;
    'L' : Raccourci := AltL;
    'M' : Raccourci := AltM;
    'N' : Raccourci := AltN;
    'O' : Raccourci := AltO;
    'P' : Raccourci := AltP;
    'Q' : Raccourci := AltQ;
    'R' : Raccourci := AltR;
    'S' : Raccourci := AltS;
    'T' : Raccourci := AltT;
    'U' : Raccourci := AltU;
    'V' : Raccourci := AltV;
    'W' : Raccourci := AltW;
    'X' : Raccourci := AltX;
    'Y' : Raccourci := AltY;
    'Z' : Raccourci := AltZ;
  end;
  ToucheDuBoutonReliefGr := (Touche = Raccourci);
End;

{}

Procedure BarreGrapheGr(Var UnBarreGraphe : BarreGrapheRecGr;Valeur : longint;
                                                         UneAction : Action);

Var
  S            : TypeSauveGr;

  (**)
  Procedure AjusteDimension;

  Var
    Fenetre : ViewPortType;
    MaxLarg : integer;
    MaxHaut : integer;

  Begin
    GetViewSettings(Fenetre);
    with Fenetre do
    Begin
      MaxLarg := X2 - X1;
      MaxHaut := Y2 - Y1;
    End;
    with UnBarreGraphe do
      if Larg > (MaxLarg - X - 1) then Larg := (MaxLarg - X - 1);
  End;


  (**)
  Procedure Affichage;

  Begin
    AjusteDimension;
    with UnBarreGraphe do
    Begin
     SetFillStyle(CloseDotFill,CoulBarreGraphe.Encre);
     Bar(X,Y,X + Larg,Y + Haut);
     SetLineStyle(SolidLn, 0, NormWidth);
     Rectangle(X,Y,X + Larg,Y + Haut);
    End;
  End;

  (**)
  Procedure Utilisation;

  Var
    Nombre : longint;

  Begin
    with UnBarreGraphe do
    Begin
     if Valeur = Maxi then Nombre := Larg
                       else Nombre := trunc(Larg * Valeur / Maxi);
     SetFillStyle(SolidFill,CoulBarreGraphe.Encre);
     Bar(X,Y,X + Nombre,Y + Haut);
    End;
  End;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  CoulFondGr(CoulBarreGraphe.Fond);
  CoulEncreGr(CoulBarreGraphe.Encre);
  SetWriteMode(NormalPut);
  case UneAction of
    Afficher : Affichage;
    Utiliser : Utilisation;
  end;
  RestaureGr(S);
End;

{}

Procedure FondEcranGr(Motif : FillPatternType;Fond , Encre : Couleur);

Var
  S       : TypeSauveGr;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  FenetreMaxGr;
  SetBkColor(Fond);
  ClearDevice;
  SetFillPattern(Motif,Encre);
  SetWriteMode(NormalPut);
  Bar(0,0,GetMaxX,GetMaxY);
  RestaureGr(S);
End;

{}

Procedure BoiteAProposGr;

Var
  S             : TypeSauveGr;
  PosX          : integer;            { Coordonnee en X du coin haut gauche }
  PosY          : integer;            { Coordonnee en Y du coin haut gauche }
  Largeur       : integer;            { Largeur de la boite                 }
  Hauteur       : integer;            { Hauteur de la boite                 }
  Taille        : word;               { Taille des donnees recouvertes      }
  Donnees       : pointer;            { Donnees recouvertes                 }
  UnBouton      : BoutonRecGr;        { Bouton OK            }

  (**)
  Procedure Initialisation;

  Var
    Fenetre : ViewPortType;
    Long : integer;
    Mil  : integer;

  Begin
    Largeur := 46 * LargCarGr;
    Hauteur := 16 * HautCarGr;

    GetViewSettings(Fenetre);
    with Fenetre do
    Begin
      Long := Largeur div 2;
      Mil := (X2 - X1) div 2 + 1;
      PosX := Mil - Long + 1;

      Long := Hauteur div 2;
      Mil := (Y2 - Y1) div 2 + 1;
      PosY := Mil - Long;
    End;

    Taille := imagesize(PosX, PosY, PosX + Largeur, PosY + Hauteur);
    if not ReserveMem(Donnees,Taille) then PlusDeMemoireGr;
    SauveRectGr (PosX, PosY, PosX + Largeur, PosY + Hauteur,Donnees);
  End;

  (**)
  Procedure Affichage;

  Var
    Long : byte;
    Tmp  : Str40;

  Begin
    BoiteGr(PosX,PosY,Largeur - 10,Hauteur - 10,Ombre2,CoulBtSaisie,true);
    CoulFondGr(CoulBtAPropos.Fond);
    CoulEncreGr(CoulBtAPropos.Encre);
    Long := (Largeur div LargCarGr) - 6;
    (*GotoXYGr(PosX + 2 * LargCarGr, PosY + 2 * HautCarGr);*)
    GotoXYGr(PosX + LargCarGr + LargCarGr, PosY + HautCarGr + HautCarGr);
    WriteGr(Elargi(Soft.Nom,Long));
    (*GotoXYGr(PosX + 2 * LargCarGr, PosY + 4 * HautCarGr);*)
    GotoXYGr(PosX + LargCarGr + LargCarGr, PosY + 4 * HautCarGr);
    WriteGr(Elargi(Soft.Version,Long));
    (*GotoXYGr(PosX + 2 * LargCarGr, PosY + 6 * HautCarGr);*)
    GotoXYGr(PosX + LargCarGr + LargCarGr, PosY + 6 * HautCarGr);
    WriteGr(Elargi(Soft.Info1,Long));
    (*GotoXYGr(PosX + 2 * LargCarGr, PosY + 8 * HautCarGr);*)
    GotoXYGr(PosX + LargCarGr + LargCarGr, PosY + 8 * HautCarGr);
    WriteGr(Elargi(Soft.Info2,Long));
    str(MemAvail,Tmp);
    Tmp := Tmp + LigneMemLibre;
    (*GotoXYGr(PosX + 2 * LargCarGr, PosY + 10 * HautCarGr);*)
    GotoXYGr(PosX + LargCarGr + LargCarGr, PosY + 10 * HautCarGr);
    WriteGr(Elargi(Tmp,Long));
    with UnBouton do
    Begin
      Larg := 6;
      X     := PosX + (Largeur div 2) - LargCarGr
                     - ((Larg * LargCarGr) div 2);
      Y     := PosY + 12 * HautCarGr;
      Texte := '~O~k';
      Ombre := true;
    End;
    BoutonGr(UnBouton,true);
  End;

  (**)
  Procedure Attente;

  Var
    Ok     : boolean;
    Car    : char;
    Souris : PosRec;

  Begin
    MontreSouris;
    Ok := false;
    repeat
      if AttendActionGr(Car,Souris) then
      Begin
        DelaiSouris(TempoSouris);
        with Souris do
         if SourisDsBoutonGr(Colonne,Ligne,UnBouton) then Car := CarReturn;
      End;
      if ToucheFct and (Car = AltO) then Car := CarReturn;
      Ok := Car = CarReturn;
    until Ok;
    CacheSouris;
  End;

  (**)
  Procedure Efface;

  Begin
    LitRectGr (PosX, PosY, PosX + Largeur, PosY + Hauteur,Donnees);
    freemem(Donnees,Taille);
    Donnees := nil;
  End;

Begin
  with Soft do
    if (Nom = '') and (Version = '') and (Info1 = '') and
                                         (Info2 = '') then exit;
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  Initialisation;
  Affichage;
  Attente;
  Efface;
  RestaureGr(S);
End;

{}

Procedure BoiteReliefAProposGr;

Var
  S             : TypeSauveGr;
  PosX          : integer;            { Coordonnee en X du coin haut gauche }
  PosY          : integer;            { Coordonnee en Y du coin haut gauche }
  Largeur       : integer;            { Largeur de la boite                 }
  Hauteur       : integer;            { Hauteur de la boite                 }
  Taille        : word;               { Taille des donnees recouvertes      }
  Donnees       : pointer;            { Donnees recouvertes                 }
  UnBouton      : BoutonReliefRecGr;  { Bouton OK            }

  (**)
  Procedure Initialisation;

  Var
    Fenetre : ViewPortType;
    Long : integer;
    Mil  : integer;

  Begin
    Largeur := 46 * LargCarGr;
    Hauteur := 16 * HautCarGr;

    GetViewSettings(Fenetre);
    with Fenetre do
    Begin
      Long := Largeur div 2;
      Mil := (X2 - X1) div 2 + 1;
      PosX := Mil - Long + 1;

      Long := Hauteur div 2;
      Mil := (Y2 - Y1) div 2 + 1;
      PosY := Mil - Long;
    End;

    Taille := imagesize(PosX, PosY, PosX + Largeur, PosY + Hauteur);
    if not ReserveMem(Donnees,Taille) then PlusDeMemoireGr;
    SauveRectGr (PosX, PosY, PosX + Largeur, PosY + Hauteur,Donnees);
  End;

  (**)
  Procedure Affichage;

  Var
    Long : byte;
    Tmp  : Str40;

  Begin
    BoiteReliefGr(PosX,PosY,Largeur - 10,Hauteur - 10,Relief,CoulBtSaisie,true);
    CoulFondGr(CoulBtAPropos.Fond);
    CoulEncreGr(CoulBtAPropos.Encre);
    Long := (Largeur div LargCarGr) - 6;
    (*GotoXYGr(PosX + 2 * LargCarGr, PosY + 2 * HautCarGr);*)
    GotoXYGr(PosX + LargCarGr + LargCarGr, PosY + HautCarGr + HautCarGr);
    WriteGr(Elargi(Soft.Nom,Long));
    (*GotoXYGr(PosX + 2 * LargCarGr, PosY + 4 * HautCarGr);*)
    GotoXYGr(PosX + LargCarGr + LargCarGr, PosY + 4 * HautCarGr);
    WriteGr(Elargi(Soft.Version,Long));
    (*GotoXYGr(PosX + 2 * LargCarGr, PosY + 6 * HautCarGr);*)
    GotoXYGr(PosX + LargCarGr + LargCarGr, PosY + 6 * HautCarGr);
    WriteGr(Elargi(Soft.Info1,Long));
    (*GotoXYGr(PosX + 2 * LargCarGr, PosY + 8 * HautCarGr);*)
    GotoXYGr(PosX + LargCarGr + LargCarGr, PosY + 8 * HautCarGr);
    WriteGr(Elargi(Soft.Info2,Long));
    str(MemAvail,Tmp);
    Tmp := Tmp + LigneMemLibre;
    (*GotoXYGr(PosX + 2 * LargCarGr, PosY + 10 * HautCarGr);*)
    GotoXYGr(PosX + LargCarGr + LargCarGr, PosY + 10 * HautCarGr);
    WriteGr(Elargi(Tmp,Long));
    with UnBouton do
    Begin
      Larg := 6;
      X     := PosX + (Largeur div 2) - LargCarGr
                     - ((Larg * LargCarGr) div 2);
      Y     := PosY + 12 * HautCarGr;
      Texte := '~O~k';
      Tip   := Creux;
    End;
    BoutonReliefGr(UnBouton,true);
  End;

  (**)
  Procedure Attente;

  Var
    Ok     : boolean;
    Car    : char;
    Souris : PosRec;

  Begin
    MontreSouris;
    Ok := false;
    repeat
      if AttendActionGr(Car,Souris) then
      Begin
        DelaiSouris(TempoSouris);
        with Souris do
         if SourisDsBoutonReliefGr(Colonne,Ligne,UnBouton) then
            Car := CarReturn;
      End;
      if ToucheFct and (Car = AltO) then Car := CarReturn;
      Ok := Car = CarReturn;
    until Ok;
    CacheSouris;
  End;

  (**)
  Procedure Efface;

  Begin
    LitRectGr (PosX, PosY, PosX + Largeur, PosY + Hauteur,Donnees);
    freemem(Donnees,Taille);
    Donnees := nil;
  End;

Begin
  with Soft do
    if (Nom = '') and (Version = '') and (Info1 = '') and
                                         (Info2 = '') then exit;
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  Initialisation;
  Affichage;
  Attente;
  Efface;
  RestaureGr(S);
End;
(**)

Function SaisieGr(X,Y : integer;Long : byte;Tip : Donnee;UneAction : Action;
                                                       Autre : boolean):char;

Var
  S            : TypeSauveGr;      { sauvegarde de parametre }
  AncienneAide : RecLigneAide;     { sauvegarde de l'aide precedente }
  Souligne     : Str80;            { soulignement de 80 caracteres }
  ValParDefaut : Str80;            { stockage valeur par defaut }
  PremierCar   : boolean;          { est-ce le premier caractere ? }
  Fin          : boolean;          { une donnee vient d'etre validee }
  Abandon      : boolean;          { demande d'abandon }
  Insertion    : boolean;          { en mode insertion ? }
  NumCar       : byte;             { n du caractere curseur dans la chaine }
  LeCar        : char;             { caractere venant d'etre frappe }
  InfoSouris   : PosRec;           { position souris lors du dernier clic }
  XTmp         : integer;          { position temporaire en X }
  YTmp         : integer;          { position temporaire en Y }
  Tmp          : integer;          { valeur temporaire }
  Fenetre      : viewporttype;     { fenetre actuelle }

  (**)
  Procedure Convertir;

  Begin
    case Tip of
      Entier : UneChaine := IntToStr(UnEntier);
      Reel   : UneChaine := RealToStr(UnReel,LongStd,PrecisStd);
    end;
    if length(UneChaine) > Long then UneChaine := copy(UneChaine,1,Long);
  End; { Convertir }

  (**)
  Procedure SaisieVide;

  Begin
    CacheCurseurGr;
    fillchar (Souligne,81,' ');
    Souligne[0] := #80;
    CoulFondGr(CoulSaisie.Fond);
    GotoXYGr(X,Y);
    WriteGr(' ');
    WriteGr(copy(Souligne,1,Long));
    WriteGr(' ');
    MontreCurseurGr;
  End; { SaisieVide }

  (**)
  Procedure InitSaisie;

  Begin
    CoulFondGr(CoulInitSaisie.Fond);
    CoulEncreGr(CoulInitSaisie.Encre);
    PremierCar := true;
    fillchar (Souligne,81,'_');
    Souligne[0] := #80;
    ValParDefaut := UneChaine;
    NumCar := 1;
    Fin := false;
    Abandon := false;
    Insertion := not CurseurOve;
  End; { InitSaisie }

  (**)
  Procedure Position;

  Begin
    if NumCar >= 1 then GotoXYGr((X + (NumCar * LargCarGr)),Y)
                   else Beep;
  End; { Position }

  (**)
  Procedure AfficheValeur;

  Begin
    CacheSouris;
    CacheCurseurGr;
    GotoXYGr((X + LargCarGr),Y);
    WriteGr(UneChaine);
    WriteGr(copy(Souligne,1,Long - length(UneChaine)));
    Position;
    MontreSouris;
    MontreCurseurGr;
  End; { AfficheValeur }

  (**)
  Procedure AfficheDefaut;

  Begin
    UneChaine := ValParDefaut;
    PremierCar := false;
    NumCar := 1;
    AfficheValeur;
  End; { AfficheDefaut }

  (**)
  Procedure RemonteTampon;

  Var
    AncienneChaine : Str80;

  Begin
    AncienneChaine := UneChaine;
    case Tip of
      Chaine : UneChaine := LitTampon(TamponChaine,true);
      Entier : UneChaine := LitTampon(TamponEntier,true);
      Reel   : UneChaine := LitTampon(TamponReel,true);
    end;
    if UneChaine = '' then
    Begin
      UneChaine := AncienneChaine;
      Beep;
    End;
    NumCar := 1;
    AfficheValeur;
  End; { RemonteTampon }

  (**)
  Procedure DescendTampon;

  Var
    AncienneChaine : Str80;

  Begin
    AncienneChaine := UneChaine;
    case Tip of
      Chaine : UneChaine := LitTampon(TamponChaine,false);
      Entier : UneChaine := LitTampon(TamponEntier,false);
      Reel   : UneChaine := LitTampon(TamponReel,false);
    end;
    if UneChaine = '' then
    Begin
      UneChaine := AncienneChaine;
      Beep;
    End;
    NumCar := 1;
    AfficheValeur;
  End; { DescendTampon }


  (**)
  Procedure TestPremierCar;

  Begin
    if PremierCar then
    Begin
      PremierCar := false;
      AfficheValeur;
    End;
  End; { TestPremierCar }

  (**)
  Procedure DebutLigne;

  Begin
    NumCar := 1;
    Position;
    TestPremierCar;
  End; { DebutLigne }

  (**)
  Procedure FinLigne;

  Begin
    NumCar := length(UneChaine) + 1;
    Position;
    TestPremierCar;
  End; { FinLigne }

  (**)
  Procedure VaGauche;

  Begin
    if NumCar > 1 then
    Begin
      dec(NumCar);
      Position;
    End
    else Beep;
    TestPremierCar;
  End; { VaGauche }

  (**)
  Procedure VaDroite;

  Begin
    if (NumCar < Long) and (NumCar < (length(UneChaine) + 1)) then
    Begin
      inc(NumCar);
      Position;
    End
    else Beep;
    TestPremierCar;
  End; { VaDroite }

  (**)
  Procedure RemiseAZero;

  Begin
    UneChaine := '';
    DebutLigne;
    AfficheValeur;
  End; { RemiseAZero }

  (**)
  Procedure Supprime;

  Begin
    if (NumCar >= 1) and (UneChaine <> '') then
    Begin
      delete(UneChaine,NumCar,1);
      AfficheValeur;
    End
    else Beep;
  End; { Supprime }

  (**)
  Procedure InsertionOverwrite;

  Begin
    CurseurOve := not CurseurOve;
    Insertion := not CurseurOve;
    MontreCurseurGr;
  End; { InsertionOverwrite }

  (**)
  Procedure Corrige;

  Begin
    if NumCar > 1 then
    Begin
      delete(UneChaine,(NumCar - 1),1);
      dec(NumCar);
      AfficheValeur;
    End
    else Beep;
  End; { Corrige }

  (**)
  Procedure Ajouter;

  Begin
    if NumCar <= Long then
    Begin
      if NumCar > length(UneChaine) then
         UneChaine := concat(UneChaine,LeCar)
      else UneChaine[NumCar] := LeCar;
      inc(NumCar);
      Affichevaleur;
    End
    else Beep;
  End; { Ajouter }

  (**)
  Procedure Inserer;

  Begin
    if length(UneChaine) < Long then
    Begin
      insert (LeCar,UneChaine,NumCar);
      inc(NumCar);
      AfficheValeur;
    End
    else Beep;
  End; { Inserer }

  (**)
  Function CaractereValide : boolean;

  Var
    Ok : boolean;

  Begin
    Ok := false;
    case Tip of
      Chaine : Ok := (LeCar >= ' ');
      Entier : Begin
                 if LeCar in ['0'..'9'] then Ok := true;
                 if (LeCar in ['+','-']) and (NumCar = 1) then Ok := true;
               End;
      Reel   : Begin
                 if LeCar in ['0'..'9'] then Ok := true;
                 if (LeCar in ['+','-']) and (NumCar = 1) then Ok := true;
                 if (LeCar = '.') and (pos('.',UneChaine) = 0) then Ok := true;
               End;
    end;
    if (not Ok) and (LeCar <> #0) then Beep;
    CaractereValide := Ok;
  End; { CaractereValide }

  (**)
  Procedure Reconvertir;

  Begin
    case Tip of
      Entier : UnEntier := StrToInt(UneChaine);
      Reel   : UnReel := StrToReal(UneChaine);
    end;
  End; { Reconvertir }

  (**)
  Procedure AfficheFinal;

  Begin
    CacheSouris;
    CacheCurseurGr;
    GotoXYGr((X + LargCarGr),Y);
    WriteGr(ElargiADte(UneChaine,Long));
    MontreSouris;
    MontreCurseurGr;
  End;

  (**)
  Procedure StockeTampon;

  Begin
    case Tip of
      Chaine : AjouteTampon(TamponChaine,UneChaine);
      Entier : AjouteTampon(TamponEntier,UneChaine);
      Reel   : AjouteTampon(TamponReel,UneChaine);
    end;
  End;

  (**)
  Function SourisDsSaisie:boolean;

  Var
    Exact : boolean;

  Begin
    Exact := false;
    if (Ytmp >= Y) and (YTmp < (Y + HautCarGr)) then
    Begin
      Tmp := (XTmp - X) div LargCarGr;
      if Tmp <= Long then Exact := true;
    End;
    SourisDsSaisie := Exact;
  End;

  (**)
  Procedure Affichage;

  Begin
    Convertir;
    SaisieVide;
    InitSaisie;
    CoulFondGr(CoulSaisie.Fond);
    CoulEncreGr(CoulSaisie.Encre);
    AfficheFinal;
    SaisieGr := #255;
  End;

  (**)
  Procedure Utilisation;

  Begin
    Convertir;
    SaisieVide;
    InitSaisie;
    AfficheValeur;
    AncienneAide := LigneAide;
    LigneAide.Texte := AideSaisie;
    AfficheLigneAideGr(true);
    GetViewSettings(Fenetre);
    repeat
      if PremierCar then
      Begin
        CoulFondGr(CoulSaisie.Fond);
        CoulEncreGr(CoulSaisie.Encre);
      End;

      if AttendActionGr(LeCar,InfoSouris) then
      Begin
        DelaiSouris(TempoSouris);
        if (InfoSouris.Bouton = BoutonGauche) then
        Begin
          XTmp := InfoSouris.Colonne - Fenetre.X1;
          YTmp := InfoSouris.Ligne - Fenetre.Y1;
          if SourisDsSaisie then
          Begin
            if Tmp <= length(UneChaine) then
            Begin
              NumCar := Tmp;
              TestPremierCar;
              Position;
            End
            else Beep;
          End
          else
          if Autre then
          Begin
            LeCar := #00;
            Fin := true;
          End;
        End;
        if (InfoSouris.Bouton = BoutonDroit) then LeCar := CarReturn;
      End;
      if ToucheFct then
      Begin
        case LeCar of
          FlchDebut  : DebutLigne ;
          FlchFin    : FinLigne ;
          FlchGauche : VaGauche;
          FlchDroite : VaDroite;
          FlchHaut   : RemonteTampon;
          FlchBas    : DescendTampon;
          TchSuppr   : Supprime;
          TchInser   : InsertionOverwrite;
          F3         : AfficheDefaut;
          F5         : RemiseAZero;
          ShiftTab   : if Autre then Fin := true
                                else Beep;
          ShiftF1    : if AProposRelief then BoiteReliefAProposGr
                                        else BoiteAProposGr;
          AltX       : Begin
                         Sortie := true;
                         Abandon := true;
                       End;
          else
          if (LeCar in [AltQ..AltP,AltA..AltL,AltZ,AltC..AltM]) and Autre
             then Fin := true
             else Beep;
        end;
      End
      else
      Begin
        case LeCar of
          TchBS     : Corrige;
          CarReturn : Begin
                        StockeTampon;
                        Fin := true;
                      End;
          CarEsc    : Abandon := true;
          Tab       : if Autre then Fin := true
                               else Beep;
          else
          if CaractereValide then
          Begin
            if PremierCar then UneChaine := '';
            if Insertion and (NumCar < length(UneChaine)) then Inserer
                                                          else Ajouter;
            TestPremierCar;
          End;
        end;
      End;
    until Fin or Abandon;
    if Fin then Reconvertir;
    AfficheFinal;
    SaisieGr := LeCar;
    LigneAide := AncienneAide;
    AfficheLigneAideGr(true);
  End;

Begin
  SauvegardeGr(S);
  MontreCurseurGr;
  CacheSouris;
  case UneAction of
    Afficher : Affichage;
    Utiliser : Utilisation;
  end;
  RestaureGr(s);
End;

{}

Function LireChaineGr(Titre : Str80;X,Y : integer;Long : byte;
                                    UneAction : Action;Autre : boolean):char;

Var
  S    : TypeSauveGr;      { sauvegarde de parametre }
  XTmp : integer;          { valeur de X pour la saisie }

Begin
  SauvegardeGr(S);
  GotoXYGr(X,Y);
  WriteGr(Titre);
  XTmp := X + length(Titre) * LargCarGr;
  LireChaineGr := SaisieGr(XTmp,Y,Long,Chaine,UneAction,Autre);
  RestaureGr(S);
End;

{}

Function LireEntierGr(Titre : Str80;X,Y : integer;Long : byte;
                  UneAction : Action;Autre : boolean;Min,Max : longint):char;

Var
  S    : TypesauveGr;      { sauvegarde de parametre }
  XTmp : integer;          { valeur de X pour la saisie }
  Tmp  : char;             { caractere temporaire }
  Ok   : boolean;          { touche ESC ou AltX actionnee }

  Procedure Utilisation;

  Begin
    repeat
      Tmp := SaisieGr(XTmp,Y,Long,Entier,UneAction,Autre);
      if not ((UnEntier >= Min) and (UnEntier <= Max)) then Beep;
      Ok := (Tmp = CarEsc) or Sortie;
    until (((UnEntier >= Min) and (UnEntier <= Max))) or  Ok;
  End;

Begin
  SauvegardeGr(S);
  GotoXYGr(X,Y);
  WriteGr(Titre);
  XTmp := X + length(Titre) * LargCarGr;
  case UneAction of
    Afficher : Tmp := SaisieGr(XTmp,Y,Long,Entier,UneAction,Autre);
    Utiliser : Utilisation;
  end;
  LireEntierGr := Tmp;
  RestaureGr(S);
End;

{}

Function LireReelGr(Titre : Str80;X,Y : integer;Long : byte;
                     UneAction : Action;Autre : boolean;Min,Max : real):char;

Var
  S    : TypesauveGr;      { sauvegarde de parametre }
  XTmp : integer;          { valeur de X pour la saisie }
  Tmp  : char;             { caractere temporaire }
  Ok   : boolean;          { touche ESC ou AltX actionnee }

  Procedure Utilisation;

  Begin
    repeat
      Tmp := SaisieGr(XTmp,Y,Long,Reel,UneAction,Autre);
      if not ((UnReel >= Min) and (UnReel <= Max)) then Beep;
      Ok := (Tmp = CarEsc) or Sortie;
    until ((UnReel >= Min) and (UnReel <= Max)) or Ok;
  End;

Begin
  SauvegardeGr(S);
  GotoXYGr(X,Y);
  WriteGr(Titre);
  XTmp := X + length(Titre) * LargCarGr;
  case UneAction of
    Afficher : Tmp := SaisieGr(XTmp,Y,Long,Reel,UneAction,Autre);
    Utiliser : Utilisation;
  end;
  LireReelGr := Tmp;
  RestaureGr(S);
End;

{}

Function ChoixCtrlGr(Var ChoixCtrl : ChoixCtrlRecGr;Var Liste : ListeRec;
                                    UneAction : Action;Autre : boolean):char;

Var
  S            : TypeSauveGr;
  AncienneAide : RecLigneAide; { Sauvegarde de l'aide precedente }
  XTmp         : integer;
  YTmp         : integer;
  HTmp         : integer;          { hauteur temporaire }
  Fenetre      : ViewPortType;     { taille de la fenetre active }
  W            : integer;          { variable de comptage }
  Nombre       : integer;          { nombre d'elements de la liste }
  Largeur      : byte;             { largeur de la zone liste en caracteres }
  Hauteur      : byte;             { hauteur de la zone liste en caracteres }
  Fin          : boolean;          { une donnee vient d'etre validee }
  Abandon      : boolean;          { demande d'abandon }
  LeCar        : char;             { caractere venant d'etre frappe }
  InfoSouris   : PosRec;           { position souris lors du dernier clic }
  PremierAffi  : integer;          { numero du premier element affiche }
  NumEnCours   : integer;          { numero de l'element selectionee }
  Reafficher   : boolean;          { reaffichage necessaire }
  ChaineRech   : Str80;            { chaine recherchee }
  PosGrListe   : CoinRectangle;    { position de la liste }

  (**)
  Procedure CalculLargeur;

  Var
    N : integer;

  Begin
    Largeur := 0;
    Nombre := 0;
    for N := 1 to MaxChoix do
      if Liste[N]^.Texte <> '' then
      Begin
        if length(Liste[N]^.Texte) > Largeur then
          Largeur := length(Liste[N]^.Texte);
        inc(Nombre);
      End;
    Largeur := Largeur + 2;
  End;

  (**)
  Procedure AfficheAscenceur;

  Var
    S1    : TypeSauveGr;
    XBas  : integer;
    YBas  : integer;
    XHaut : integer;
    YHaut : integer;
    Pos   : byte;

  Begin
    with ChoixCtrl do
    Begin
      if not Ascenseur then exit;
      SauvegardeGr(S1);
      CacheSouris;
      if MaxVisible >= 3 then
      Begin
        CoulFondGr(CoulAscenceur.Fond);
        CoulEncreGr(CoulAscenceur.Fond);
        XHaut := X + Largeur * LargCarGr + 1;
        YHaut := Y;
        XBas  := X + (Largeur + 1) * LargCarGr + 1;
        YBas  := Y + Hauteur * HautCarGr - 1;
        SetWriteMode(NormalPut);
        SetFillStyle(CloseDotFill,FondGr);
        Bar(XHaut,YHaut,XBas,YBas);
        Rectangle(XHaut,YHaut,XBas,YBas);
        CoulFondGr(CoulAscenceur.Fond);
        CoulEncreGr(CoulAscenceur.Encre);
        GotoXYGr(X + Largeur * LargCarGr + 1,Y);
        WriteGr('');
        XBas := X + Largeur * LargCarGr + 1;
        YBas:= Y + (Hauteur - 1) * HautCarGr;
        GotoXYGr(XBas,YBas);
        WriteGr('');
        Pos := trunc((NumEnCours / Nombre) * (Hauteur - 2));
        if NumEnCours = 1 then Pos := 1;
        if Pos = 0 then Pos := 1;
        if Pos > (Hauteur - 2) then Pos := (Hauteur - 2);
        GotoXYGr(X + Largeur * LargCarGr + 1,Y + Pos * HautCarGr);
        WriteGr('');
      End;
      RestaureGr(S1);
    End;
  End;

  (**)
  Procedure TrieListe(Debut,Fin : integer;Ascendant : boolean);

  Var
    Bas        : integer;
    Haut       : integer;
    Separateur : Str80;
    Tmp        : EltListe;

  Begin
    Bas := Debut;
    Haut := Fin;
    Separateur := Liste[(Debut + Fin) div 2]^.Texte;

    repeat
      Begin
        if Ascendant then
        Begin
          while (Liste[Bas]^.Texte < Separateur) do inc(Bas);
          while (Liste[Haut]^.Texte > Separateur) do dec(Haut);
        End
        else
        Begin
          while (Liste[Bas]^.Texte > Separateur) do inc(Bas);
          while (Liste[Haut]^.Texte < Separateur) do dec(Haut);
        End;
        if Bas <= Haut then
        Begin
          Tmp := Liste[Bas]^;
          Liste[Bas]^ := Liste[Haut]^;
          Liste[Haut]^ := Tmp;
          inc(Bas);
          dec(Haut);
        End;
      End;
    until (Bas > Haut);

    if Debut < Haut then TrieListe(Debut,Haut,Ascendant);
    if Bas < Fin then TrieListe(Bas,Fin,Ascendant);
  End;

  (**)
  Procedure AfficheListe;

  Var
    S1         : TypeSauveGr;
    Select     : byte;
    N          : integer;

  Begin
    with ChoixCtrl do
    Begin
      SauvegardeGr(S1);
      CacheSouris;
      CoulFondGr(CoulChoixCtrl.Fond);
      CoulEncreGr(CoulChoixCtrl.Encre);
      SetWriteMode(NormalPut);
      SetFillStyle(SolidFill,FondGr);
      Bar(X,Y,X + Largeur * LargCarGr,Y + Hauteur * HautCarGr - 1);
      for N := 1 to MaxVisible do
      Begin
        GotoXYGr(X, Y + (N - 1) * HautCarGr);
        if Liste[(N + PremierAffi - 1)]^.Selectionne then
        Begin
          CoulFondGr(CoulChoixSelec.Fond);
          CoulEncreGr(CoulChoixSelec.Encre);
        End
        else
        Begin
          CoulFondGr(CoulChoixCtrl.Fond);
          CoulEncreGr(CoulChoixCtrl.Encre);
        End;
        WriteGr(' ');
        WriteGr(ElargiADte(Liste[(N + PremierAffi - 1)]^.Texte,Largeur - 1));
      End;
      Select := NumEnCours - PremierAffi + 1;
      InverseGr(X,Y + (Select - 1) * HautCarGr,
                X + Largeur * LargCarGr,Y + Select * HautCarGr - 1);
      RestaureGr(S1);
    End;
  End;

  (**)
  Procedure ReafficheListe;

  Var
    S1         : TypeSauveGr;
    Select     : byte;
    N          : integer;

  Begin
    with ChoixCtrl do
    Begin
      SauvegardeGr(S1);
      CacheSouris;
      for N := 1 to MaxVisible do
      Begin
        GotoXYGr(X, Y + (N - 1) * HautCarGr);
        if Liste[(N + PremierAffi - 1)]^.Selectionne then
        Begin
          CoulFondGr(CoulChoixSelec.Fond);
          CoulEncreGr(CoulChoixSelec.Encre);
        End
        else
        Begin
          CoulFondGr(CoulChoixCtrl.Fond);
          CoulEncreGr(CoulChoixCtrl.Encre);
        End;
        WriteGr(' ');
        WriteGr(ElargiADte(Liste[(N + PremierAffi - 1)]^.Texte,Largeur - 1));
      End;
      Select := NumEnCours - PremierAffi + 1;
      InverseGr(X,Y + (Select - 1) * HautCarGr,
                X + Largeur * LargCarGr,Y + Select * HautCarGr - 1);
      RestaureGr(S1);
    End;
  End;

  (**)
  Procedure VaDebut;

  Begin
    if (PremierAffi = 1) and (NumEnCours = 1) then Reafficher := false
                                              else Reafficher := true;
    PremierAffi := 1;
    NumEnCours := 1;
    ChaineRech := '';
  End;

  (**)
  Procedure VaFin;

  Var
    Tmp : integer;

  Begin
    with ChoixCtrl do
    Begin
      Tmp := Nombre - Hauteur + 1;
      if (PremierAffi = Tmp) and (NumEnCours = Nombre)
        then Reafficher := false
        else Reafficher := true;
      if Nombre > MaxVisible then PremierAffi := Tmp
                             else PremierAffi := 1;
      NumEnCours := Nombre;
      ChaineRech := '';
    End;
  End;

  (**)
  Procedure VaBas;

  Begin
    if NumEnCours < Nombre then
    Begin
      inc(NumEnCours);
      Reafficher := true;
    End;
    if NumEnCours > (PremierAffi + ChoixCtrl.MaxVisible - 1) then
       inc(PremierAffi);
    ChaineRech := '';
  End;

  (**)
  Procedure VaHaut;

  Begin
    if NumEnCours > 1 then
    Begin
      dec(NumEnCours);
      Reafficher := true;
    End;
    if NumEnCours < PremierAffi then dec(PremierAffi);
    ChaineRech := '';
  End;

  (**)
  Procedure VaPgBas;

  Var
    Tmp : integer;

  Begin
    with ChoixCtrl do
    Begin
      if NumEnCours < Nombre then
      Begin
        Reafficher := true;
        Tmp := PremierAffi + MaxVisible + MaxVisible  - 1;
        if Tmp <= Nombre then
          Begin
            PremierAffi := PremierAffi + MaxVisible;
            NumEnCours := NumEnCours + MaxVisible;
          End
          else
          Begin
            if Nombre > MaxVisible then
               PremierAffi := Nombre - MaxVisible + 1;
            NumEnCours := Nombre;
          End;
      End;
      ChaineRech := '';
    End;
  End;

  (**)
  Procedure VaPgHaut;

  Begin
    with ChoixCtrl do
    Begin
      if NumEnCours > 1 then
      Begin
        Reafficher := true;
        if PremierAffi > MaxVisible then
          Begin
            PremierAffi := PremierAffi - MaxVisible;
            NumEnCours := NumEnCours - MaxVisible;
          End
          else
          Begin
            PremierAffi := 1;
            NumEnCours := 1;
          End;
      End;
      ChaineRech := '';
    End;
  End;

  (**)
  Procedure ChangeSelection;

  Begin
    Liste[NumEnCours]^.Selectionne := not Liste[NumEnCours]^.Selectionne;
    Reafficher := true;
  End;

  (**)
  Procedure VaNumero(Num : integer);

  Var
    Tmp : integer;

  Begin
    with ChoixCtrl do
    Begin
      Reafficher := true;
      Tmp := Nombre - Num;
      if Tmp < MaxVisible then
        Begin
          if Nombre > MaxVisible
            then PremierAffi := Nombre -  MaxVisible + 1
            else PremierAffi := 1;
          NumEnCours := Num;
        End
        else
        Begin
          if not (Num in [PremierAffi .. (PremierAffi + MaxVisible - 1)]) then
             PremierAffi := Num;
          NumEnCours := Num;
        End;
      End;
    End;

  (**)
  Procedure RechercheChaine;

  Var
    Long      : byte;
    ChaineTmp : Str80;
    NumRech   : integer;

    {}
    Procedure Avance;

    Begin
      repeat
        inc(NumRech);
        ChaineTmp := copy(Liste[NumRech]^.Texte,1,Long);
      until (ChaineTmp >= ChaineRech) or (NumRech = Nombre);
    End;

    {}
    Procedure Recule;

    Begin
      repeat
        dec(NumRech);
        ChaineTmp := copy(Liste[NumRech]^.Texte,1,Long);
      until (ChaineTmp < ChaineRech) or (NumRech = 1);
      if (ChaineTmp < ChaineRech) then inc(NumRech);
      ChaineTmp := copy(Liste[NumRech]^.Texte,1,Long);
    End;


  Begin
    if ChoixCtrl.Trie = Sans then
    Begin
      Beep;
      exit;
    End;
    ChaineRech := ChaineRech + LeCar;
    Long := length(ChaineRech);
    NumRech := NumEnCours;
    ChaineTmp := copy(Liste[NumRech]^.Texte,1,Long);
    if ChaineTmp < ChaineRech then Avance
      else if ChaineTmp > ChaineRech then Recule;
    if ChaineTmp = ChaineRech then VaNumero(NumRech)
    else
    Begin
      ChaineRech := copy(ChaineRech,1,Long - 1);
      Beep;
    End;
  End;

  (**)
  Procedure TesteSouris;

  Var
    NumTmp : integer;

    {}
    Procedure SourisVaHaut;

    Begin
      repeat
        VaHaut;
        if Reafficher then
        Begin
          AfficheAscenceur;
          ReafficheListe;
        End
        else Beep;
        delay(TempoSouris);
        SourisRelachee(BoutonGauche,InfoSouris);
      until (InfoSouris.Bouton <> BoutonGauche) or (NumEnCours = 1);
      if NumEnCours = 1 then Beep;
    End;

    {}
    Procedure SourisVaBas;

    Begin
      repeat
        VaBas;
        if Reafficher then
        Begin
          AfficheAscenceur;
          ReafficheListe;
        End
        else Beep;
        delay(TempoDefile);
        SourisRelachee(BoutonGauche,InfoSouris);
      until (InfoSouris.Bouton <> BoutonGauche) or (NumEnCours = Nombre);
      if NumEnCours = Nombre then Beep;
    End;

    {}
    Procedure SourisAscenceur;

    Var
      Y1Tmp : integer;
      Y2Tmp : integer;

    Begin
      with ChoixCtrl do
      Begin
        if not Ascenseur then exit;
        if YTmp in [Y .. (Y + HautCarGr - 1)] then SourisVaHaut;
        Y1Tmp := Y + (Hauteur - 1) * HautCarGr;
        Y2Tmp := Y + Hauteur * HautCarGr - 1;
        if (YTmp >= Y1Tmp) and (YTmp <= Y2Tmp) then SourisVaBas;
        Y1Tmp := Y + HautCarGr;
        Y2Tmp := Y + (Hauteur - 1) * HautCarGr - 1;
        if (YTmp >= Y1Tmp) and (YTmp <= Y2Tmp) then
        Begin
          NumTmp := (YTmp - Y) div HautCarGr;
          if NumTmp = 1 then VaNumero(1)
          else
          Begin
            NumTmp := NumTmp * Nombre div (Hauteur - 2) + 1;
            if NumTmp > Nombre then NumTmp := Nombre;
            VaNumero(NumTmp);
          End;
        End;
        if (Autre and not (YTmp in [Y.. (Y + Hauteur * HautCarGr - 1)])) then
        Begin
          LeCar := #00;
          Fin := true;
        End
        else LeCar := #255;
      End;
    End;

    {}
    Procedure SourisListe;

    Begin
      DelaiSouris(TempoSouris);
      with PosGrListe do
      if SourisDsZone(XTmp,YTmp,X1,Y1,X2,Y2) then
      Begin
        if ChoixCtrl.Multiple then
        Begin
          NumTmp := PremierAffi + (YTmp - Y1) div HautCarGr;
          if Compresse(Liste[NumTmp]^.Texte) = '' then LeCar := #255
          else
          Begin
            VaNumero(NumTmp);
            ChangeSelection;
            LeCar := #255;
          End;
        End
        else
        Begin
          NumTmp := PremierAffi + (YTmp - Y1) div HautCarGr;
          if Compresse(Liste[NumTmp]^.Texte) = '' then LeCar := #255
          else
          Begin
            VaNumero(NumTmp);
            LeCar := CarReturn;
          End;
        End;
      End
      else if Autre then
      Begin
        LeCar := #00;
        Fin := true;
      End;
    End;

    {}
    Procedure TestBoutonGauche;

    Var
      X1Tmp : integer;
      X2Tmp : integer;

    Begin
      with ChoixCtrl do
      Begin
        X1Tmp := X + Largeur * LargcarGr;
        X2Tmp := X + (Largeur + 1) * LargcarGr;
        if XTmp in [X1Tmp .. X2Tmp] then SourisAscenceur
                                    else SourisListe;
      End;
    End;

    {}

  Begin
    if InfoSouris.Nombre <> 0 then
    with ChoixCtrl do
    Begin
      case InfoSouris.Bouton of
        BoutonGauche : TestBoutonGauche;
        BoutonDroit  : if ChoixCtrl.Multiple then LeCar := CarReturn;
      end;
      if Reafficher then
      Begin
        AfficheAscenceur;
        ReafficheListe;
      End
      else if (LeCar <> CarReturn) and not Fin then Beep;
      ChaineRech := '';
    End;
  End;

  (**)
  Procedure TesteTouche;

  Begin
    Reafficher := false;
    if ToucheFct then
    Begin
      case LeCar of
        FlchDebut  : VaDebut;
        FlchFin    : VaFin;
        FlchBas    : VaBas;
        FlchHaut   : VaHaut;
        FlchGauche : VaPgHaut;
        FlchDroite : VaPgBas;
        FlchPgHaut : VaPgHaut;
        FlchPgBas  : VaPgBas;
        ShiftTab   : if Autre then Fin := true
                              else Beep;
        ShiftF1    : if AProposRelief then BoiteReliefAProposGr
                                      else BoiteAProposGr;
        AltX       : Begin
                       Sortie := true;
                       Abandon := true;
                     End;
        else
          if (LeCar in [AltQ..AltP,AltA..AltL,AltZ,AltC..AltM]) and Autre
             then Fin := true
             else Beep;
      end;
      if Reafficher then
      Begin
        AfficheAscenceur;
        ReafficheListe;
      End
      else
      if not (LeCar in [ShiftTab,AltQ..AltP,AltA..AltL,AltZ..AltM]) then Beep;
    End
    else
    Begin
      TestClavier;
      if ChoixCtrl.EnMaj then LeCar := UpCase(LeCar);
      if (LeCar in Alphanumerique) and not ((LeCar = Espace) and Clavier.Alt)
         then RechercheChaine
      else
      case LeCar of
        CarReturn : Fin := true;
        CarEsc    : Abandon := true;
        Espace    : if ChoixCtrl.Multiple then ChangeSelection
                                          else Beep;
        Tab       : if Autre then Fin := true
                             else Beep;
        #255      :;
        #00       : if not Autre then Beep;
        else Beep;
      end;
      if Reafficher then
      Begin
        AfficheAscenceur;
        ReafficheListe;
      End;
    End;
  End;

  (**)
  Procedure Affichage;

  Begin
    with ChoixCtrl do
    Begin
      if Pos > Nombre then Pos := 1;
      PremierAffi := 1;
      NumEnCours := Pos;
      if NumEnCours > MaxVisible then VaNumero(NumEnCours);
    End;
    ChaineRech := '';
    AfficheAscenceur;
    AfficheListe;
    ChoixCtrlGr := #255;
  End;

  (**)
  Procedure Utilisation;

  Begin
    with ChoixCtrl do
    Begin
      if Pos > Nombre then Pos := 1;
      PremierAffi := 1;
      NumEnCours := Pos;
      if NumEnCours > MaxVisible then VaNumero(NumEnCours);
      ChaineRech := '';
      AncienneAide := LigneAide;
      if Multiple then LigneAide.Texte := AideChoixMultiple
                  else LigneAide.Texte := AideChoix;
      AfficheAscenceur;
      AfficheListe;
      AfficheLigneAideGr(true);
      Fin := false;
      Abandon := false;
      MontreSouris;
      repeat
        if AttendActionGr(LeCar,InfoSouris) then
          Begin
            XTmp := InfoSouris.Colonne - Fenetre.X1;
            YTmp := InfoSouris.Ligne - Fenetre.Y1;
          End;
          TesteSouris;
          TesteTouche;
      until Fin or Abandon;
      LigneAide := AncienneAide;
      AfficheLigneAideGr(true);
      if not Multiple then Liste[NumEnCours]^.Selectionne := true;
      Pos := NumEnCours;
      ChoixCtrlGr := LeCar;
    End;
  End;

Begin
  with ChoixCtrl do
  Begin
    SauvegardeGr(S);
    CacheCurseurGr;
    GetViewSettings(Fenetre);
    CalculLargeur;
    Larg := Largeur;
    if Ascenseur then inc(Larg);
    with Fenetre do
    Begin
      HTmp := (X2 - X1) div HautCarGr;
      if MaxVisible > HTmp then MaxVisible := HTmp;
      Hauteur := MaxVisible;
      Haut := Hauteur;
    if (Y + Hauteur * HautCarGr) > Y2 then Y := Y2 - Hauteur * HautCarGr + 2;
    if (X + Largeur * LargCarGr) > X2 then X := X2 - Largeur * LargCarGr + 1;
    with PosGrListe do
        Begin
          X1 := X;
          Y1 := Y;
          X2 := X + Largeur * LargCarGr - 1;
          Y2 := Y + Hauteur * HautCarGr - 1;
        End;
    End;
    if Trie = Ascendant then TrieListe(1,Nombre,true);
    if Trie = Descendant then TrieListe(1,Nombre,false);
    case UneAction of
      Afficher : Affichage;
      Utiliser : Utilisation;
    end;
    delay(100);
    RestaureGr(S);
  End;
End;

{}

Function ChoixFichierGr(Var ChoixFic : ChoixFicRecGr;Var UnRepertoire : NomRep;
              Var UnMasque : NomFic;UneAction : Action;Autre : boolean):char;

Var
  S            : TypeSauveGr;
  AncienneAide : RecLigneAide; { Sauvegarde de l'aide precedente }
  XTmp         : integer;
  YTmp         : integer;
  HTmp         : integer;          { hauteur temporaire }
  Fenetre      : ViewPortType;     { taille de la fenetre active }
  Liste        : ListeFicRec;      { liste des fichiers }
  Nombre       : integer;          { nombre d'elements de la liste }
  Largeur      : byte;             { largeur de la zone liste }
  Hauteur      : byte;             { hauteur de la zone liste }
  Fin          : boolean;          { une donnee vient d'etre validee }
  Abandon      : boolean;          { demande d'abandon }
  LeCar        : char;             { caractere venant d'etre frappe }
  InfoSouris   : PosRec;           { position souris lors du dernier clic }
  PremierAffi  : integer;          { numero du premier element affiche }
  NumEnCours   : integer;          { numero de l'element selectionee }
  Reafficher   : boolean;          { reaffichage necessaire }
  PosGrListe   : CoinRectangle;    { position de la liste }

  (**)
  Procedure TrieAlpha(Debut,Fin : integer;Ascendant : boolean);

  Var
    Bas        : integer;
    Haut       : integer;
    Separateur : Str80;
    Tmp        : EltListeFic;

  Begin
    Bas := Debut;
    Haut := Fin;
    Separateur := Liste[(Debut + Fin) div 2]^.Texte;

    repeat
      Begin
        if Ascendant then
        Begin
          while (Liste[Bas]^.Texte < Separateur) do inc(Bas);
          while (Liste[Haut]^.Texte > Separateur) do dec(Haut);
        End
        else
        Begin
          while (Liste[Bas]^.Texte > Separateur) do inc(Bas);
          while (Liste[Haut]^.Texte < Separateur) do dec(Haut);
        End;
        if Bas <= Haut then
        Begin
          Tmp := Liste[Bas]^;
          Liste[Bas]^ := Liste[Haut]^;
          Liste[Haut]^ := Tmp;
          inc(Bas);
          dec(Haut);
        End;
      End;
    until (Bas > Haut);

    if Debut < Haut then TrieAlpha(Debut,Haut,Ascendant);
    if Bas < Fin then TrieAlpha(Bas,Fin,Ascendant);
  End;

  (**)
  Procedure TrieExtension(Debut,Fin : integer;Ascendant : boolean);

  Var
    Bas        : integer;
    Haut       : integer;
    Separateur : Str80;
    Tmp        : EltListeFic;

    {}
    Function ChaineRef(Chaine : Str80 ) : Str80;

    Var
      N   : integer;
      Tmp : Str80;

    Begin
      N := pos('.',Chaine);
      if N = 0 then ChaineRef := Chaine
               else
               Begin
                 Tmp := copy(Chaine,N,length(Chaine) - N);
                 delete(Chaine,N,length(Chaine) - N);
                 ChaineRef := Tmp + Chaine;
               End;
    End;

  Begin
    Bas := Debut;
    Haut := Fin;
    Separateur := ChaineRef(Liste[(Debut + Fin) div 2]^.Texte);

    repeat
      Begin
        if Ascendant then
        Begin
          while (ChaineRef(Liste[Bas]^.Texte) < Separateur) do inc(Bas);
          while (ChaineRef(Liste[Haut]^.Texte) > Separateur) do dec(Haut);
        End
        else
        Begin
          while (ChaineRef(Liste[Bas]^.Texte) > Separateur) do inc(Bas);
          while (ChaineRef(Liste[Haut]^.Texte) < Separateur) do dec(Haut);
        End;
        if Bas <= Haut then
        Begin
          Tmp := Liste[Bas]^;
          Liste[Bas]^ := Liste[Haut]^;
          Liste[Haut]^ := Tmp;
          inc(Bas);
          dec(Haut);
        End;
      End;
    until (Bas > Haut);

    if Debut < Haut then TrieExtension(Debut,Haut,Ascendant);
    if Bas < Fin then TrieExtension(Bas,Fin,Ascendant);
  End;

  (**)
  Procedure TrieDate(Debut,Fin : integer;Ascendant : boolean);

  Var
    Bas        : integer;
    Haut       : integer;
    Separateur : longint;
    Tmp        : EltListeFic;

  Begin
    Bas := Debut;
    Haut := Fin;
    Separateur := Liste[(Debut + Fin) div 2]^.Date;

    repeat
      Begin
        if Ascendant then
        Begin
          while (Liste[Bas]^.Date < Separateur) do inc(Bas);
          while (Liste[Haut]^.Date > Separateur) do dec(Haut);
        End
        else
        Begin
          while (Liste[Bas]^.Date > Separateur) do inc(Bas);
          while (Liste[Haut]^.Date < Separateur) do dec(Haut);
        End;
        if Bas <= Haut then
        Begin
          Tmp := Liste[Bas]^;
          Liste[Bas]^ := Liste[Haut]^;
          Liste[Haut]^ := Tmp;
          inc(Bas);
          dec(Haut);
        End;
      End;
    until (Bas > Haut);

    if Debut < Haut then TrieDate(Debut,Haut,Ascendant);
    if Bas < Fin then TrieDate(Bas,Fin,Ascendant);
  End;

  (**)
  Procedure TrieTaille(Debut,Fin : integer;Ascendant : boolean);

  Var
    Bas        : integer;
    Haut       : integer;
    Separateur : longint;
    Tmp        : EltListeFic;

  Begin
    Bas := Debut;
    Haut := Fin;
    Separateur := Liste[(Debut + Fin) div 2]^.Taille;

    repeat
      Begin
        if Ascendant then
        Begin
          while (Liste[Bas]^.Taille < Separateur) do inc(Bas);
          while (Liste[Haut]^.Taille > Separateur) do dec(Haut);
        End
        else
        Begin
          while (Liste[Bas]^.Taille > Separateur) do inc(Bas);
          while (Liste[Haut]^.Taille < Separateur) do dec(Haut);
        End;
        if Bas <= Haut then
        Begin
          Tmp := Liste[Bas]^;
          Liste[Bas]^ := Liste[Haut]^;
          Liste[Haut]^ := Tmp;
          inc(Bas);
          dec(Haut);
        End;
      End;
    until (Bas > Haut);

    if Debut < Haut then TrieTaille(Debut,Haut,Ascendant);
    if Bas < Fin then TrieTaille(Bas,Fin,Ascendant);
  End;

  (**)
  Procedure CreeListe;

  Var
    LeRep : LstRepPtr;
    W     : integer;

    {}
    Procedure StockeRepertoireSource;

    Var
      N   : integer;
      Tmp : NomRep;
      Rec : searchrec;

    Begin
      if MemAvail > sizeof(Liste[Nombre]) then new(Liste[Nombre])
                                          else PlusDeMemoireGr;
      if UnRepertoire[length(UnRepertoire)] = '\' then
        delete(UnRepertoire,length(UnRepertoire),1);
      N := length(UnRepertoire);
      while not (UnRepertoire[N] in ['\',':']) do dec(N);
      if UnRepertoire[N] = ':' then
        Begin
          Tmp := copy(UnRepertoire,1,N);
          Liste[Nombre]^.Texte :=  ' ' + Tmp;
          Liste[Nombre]^.Date     := 0;
          Liste[Nombre]^.Taille   := disksize(ord(UnRepertoire[N - 1]) - 64);
          Liste[Nombre]^.Attribut := 255;
        End
        else
        Begin
          Tmp := copy(UnRepertoire,N + 1,length(UnRepertoire) - N);
          Liste[Nombre]^.Texte := #17 + ' ' + Tmp;
          FindFirst(UnRepertoire,Directory,Rec);
          Liste[Nombre]^.Date     := Rec.Time;
          Liste[Nombre]^.Taille   := Rec.Size;
          Liste[Nombre]^.Attribut := Rec.Attr;
        End;
      Liste[Nombre]^.Selectionne := false;
    End;

    {}
    Procedure StockeRepertoire;

    Var
      N       : integer;
      Premier : integer;
      Dernier : integer;

    Begin
      Premier := 0;
      with LeRep^ do
      Begin
        Attribut   := Directory;
        Repertoire := UnRepertoire;
        Masque     := '*.*';
      End;
      ListeRep(LeRep);
      with LeRep^ do
      if (ErreurES <> 1) and (NbRep > 0) then
      Begin
        Premier := Nombre + 1;
        for N := 1 to NbRep do
        Begin
          inc(Nombre);
          if MemAvail > sizeof(Liste[Nombre]) then new(Liste[Nombre])
                                              else PlusDeMemoireGr;
          Liste[Nombre]^.Texte    := #16 + ' ' + ListeDuRep[N].Name;
          Liste[Nombre]^.Date     := ListeDuRep[N].Time;
          Liste[Nombre]^.Taille   := ListeDuRep[N].Size;
          Liste[Nombre]^.Attribut := ListeDuRep[N].Attr;
          Liste[Nombre]^.Selectionne := false;
        End;
        Dernier := Nombre;
      End;
      if (Premier > 0) then
        case ChoixFic.Trie of
          Ascendant  : TrieAlpha(Premier,Dernier,true);
          Descendant : TrieAlpha(Premier,Dernier,false);
        end;
    End;

    {}
    Procedure TrieFichier(Premier,Dernier : integer);

    Begin
      if (Premier > 0) then
        case ChoixFic.TypeTrie of
          Nom       : case ChoixFic.Trie of
                        Ascendant  : TrieAlpha(Premier,Dernier,true);
                        Descendant : TrieAlpha(Premier,Dernier,false);
                      end;
          Date      : case ChoixFic.Trie of
                        Ascendant  : TrieDate(Premier,Dernier,true);
                        Descendant : TrieDate(Premier,Dernier,false);
                      end;
          Taille    : case ChoixFic.Trie of
                        Ascendant  : TrieTaille(Premier,Dernier,true);
                        Descendant : TrieTaille(Premier,Dernier,false);
                      end;
          Extension : case ChoixFic.Trie of
                        Ascendant  : TrieExtension(Premier,Dernier,true);
                        Descendant : TrieExtension(Premier,Dernier,false);
                      end;
        end;
    End;
    {}
    Procedure StockeFichier;

    Var
      N       : integer;
      Premier : integer;
      Dernier : integer;

    Begin
      Premier := 0;
      with LeRep^ do
      Begin
        Attribut   := Archive;
        Repertoire := UnRepertoire;
        Masque     := UnMasque;
      End;
      ListeRep(LeRep);
      with LeRep^ do
      if (ErreurES <> 1) and (NbFic > 0) then
      Begin
        Premier := Nombre + 1;
        for N := 1 to NbFic do
        Begin
          inc(Nombre);
          if MemAvail > sizeof(Liste[Nombre]) then new(Liste[Nombre])
                                              else PlusDeMemoireGr;
          Liste[Nombre]^.Texte := ' ' + ListeDsFic[N].Name;
          Liste[Nombre]^.Date     := ListeDsFic[N].Time;
          Liste[Nombre]^.Taille   := ListeDsFic[N].Size;
          Liste[Nombre]^.Attribut := ListeDsFic[N].Attr;
          Liste[Nombre]^.Selectionne := false;
        End;
        Dernier := Nombre;
      End;
      TrieFichier(Premier,Dernier);
    End;

  Begin
    Nombre := 1;
    StockeRepertoireSource;
    if MemAvail > sizeof(LeRep) then new(LeRep)
                                else PlusDeMemoireGr;
    StockeRepertoire;
    StockeFichier;
    dispose(LeRep);
    if Nombre < ChoixFic.MaxVisible then
      for W := (Nombre + 1) to ChoixFic.MaxVisible do
      Begin
        if MemAvail > sizeof(Liste[W]) then new(Liste[W])
                                       else PlusDeMemoireGr;
        Liste[W]^.Texte := ' ';
        Liste[W]^.Selectionne := false;
      End;
    while keypressed do readkey;
  End;

  (**)
  Procedure EffaceListe;

  Var
    N : integer;

  Begin
    for N := Nombre downto 1 do dispose(Liste[N]);
    Nombre := 0;
  End;

  (**)
  Procedure AfficheAscenceur;

  Var
    S1    : TypeSauveGr;
    XBas  : integer;
    YBas  : integer;
    XHaut : integer;
    YHaut : integer;
    Pos   : byte;

  Begin
    with ChoixFic do
    Begin
      if not Ascenseur then exit;
      SauvegardeGr(S1);
      CacheSouris;
      if MaxVisible >= 3 then
      Begin
        CoulFondGr(CoulAscenceur.Fond);
        CoulEncreGr(CoulAscenceur.Fond);
        XHaut := X + Largeur * LargCarGr + 1;
        YHaut := Y;
        XBas  := X + (Largeur + 1) * LargCarGr + 1;
        YBas  := Y + Hauteur * HautCarGr - 1;
        SetWriteMode(NormalPut);
        SetFillStyle(CloseDotFill,FondGr);
        Bar(XHaut,YHaut,XBas,YBas);
        Rectangle(XHaut,YHaut,XBas,YBas);
        CoulFondGr(CoulAscenceur.Fond);
        CoulEncreGr(CoulAscenceur.Encre);
        GotoXYGr(X + Largeur * LargCarGr + 1,Y);
        WriteGr('');
        XBas := X + Largeur * LargCarGr + 1;
        YBas:= Y + (Hauteur - 1) * HautCarGr;
        GotoXYGr(XBas,YBas);
        WriteGr('');
        Pos := trunc((NumEnCours / Nombre) * (Hauteur - 2));
        if NumEnCours = 1 then Pos := 1;
        if Pos = 0 then Pos := 1;
        if Pos > (Hauteur - 2) then Pos := (Hauteur - 2);
        GotoXYGr(X + Largeur * LargCarGr + 1,Y + Pos * HautCarGr);
        WriteGr('');
      End;
      RestaureGr(S1);
    End;
  End;

  (**)
  Procedure AfficheInfo;

  Var
    S1         : TypeSauveGr;
    FenetreMin : word;
    FenetreMax : word;
    DateHeure  : datetime;

    {}
    Function DecrypteTaille(Taille : longint) : Str80;

    Var
      Tmp       : Str80;

    Begin
      str(Taille : 9,Tmp);
      Tmp := Tmp + ' octets';
      DecrypteTaille := ElargiADte(Tmp,Largeur);
    End;

    {}
    Function DecrypteDateHeure(Date : longint) : Str80;

    Var
      DateHeure : datetime;
      Chaine    : Str80;
      Tmp       : Str80;

    Begin
      unpacktime(Liste[NumEnCours]^.Date,DateHeure);
      str(DateHeure.Day : 2,Tmp);
      if Tmp[1] = ' ' then Tmp[1] := '0';
      Chaine := Tmp + '/';
      str(DateHeure.Month : 2,Tmp);
      if Tmp[1] = ' ' then Tmp[1] := '0';
      Chaine := Chaine + Tmp + '/';
      str(DateHeure.Year : 2,Tmp);
      Chaine := Chaine + Tmp + ' ';
      str(DateHeure.Hour : 2,Tmp);
      if Tmp[1] = ' ' then Tmp[1] := '0';
      Chaine := Chaine + Tmp + ':';
      str(DateHeure.Min : 2,Tmp);
      if Tmp[1] = ' ' then Tmp[1] := '0';
      Chaine := Chaine + Tmp;
      DecrypteDateHeure := ElargiADte(Chaine,Largeur);
    End;

  Begin
    with ChoixFic do
    if Info then
    Begin
      SauvegardeGr(S1);
      CacheSouris;
      CoulFondGr(CoulInfoFic.Fond);
      CoulEncreGr(CoulInfoFic.Encre);
      SetWriteMode(NormalPut);
      SetFillStyle(SolidFill,FondGr);
      Bar(X,Y + (Hauteur + 1) * HautCarGr + 1,
        X + (Largeur + 1) * LargCarGr + 1,Y + (Hauteur + 3) * HautCarGr + 1);
      GotoXYGr(X + LargCarGr, Y + (Hauteur + 1) * HautCarGr + 1);
      if not (Liste[NumEnCours]^.Attribut = Directory)
         then WriteGr(DecrypteTaille(Liste[NumEnCours]^.Taille));
      GotoXYGr(X + LargCarGr, Y + (Hauteur + 2) * HautCarGr + 1);
      if not (Liste[NumEnCours]^.Attribut = 255)
         then WriteGr(DecrypteDateHeure(Liste[NumEnCours]^.Date));
      RestaureGr(S1);
    End;
  End;

  (**)
  Procedure AfficheListe;

  Var
    S1         : TypeSauveGr;
    Select     : byte;
    N          : integer;

  Begin
    with ChoixFic do
    Begin
      SauvegardeGr(S1);
      CacheSouris;
      CoulFondGr(CoulChoixCtrl.Fond);
      CoulEncreGr(CoulChoixCtrl.Encre);
      SetWriteMode(NormalPut);
      SetFillStyle(SolidFill,FondGr);
      Bar(X,Y,X + Largeur * LargCarGr,Y + Hauteur * HautCarGr - 1);
      for N := 1 to MaxVisible do
      Begin
        GotoXYGr(X, Y + (N - 1) * HautCarGr);
        if Liste[(N + PremierAffi - 1)]^.Selectionne then
        Begin
          CoulFondGr(CoulChoixSelec.Fond);
          CoulEncreGr(CoulChoixSelec.Encre);
        End
        else
        Begin
          CoulFondGr(CoulChoixCtrl.Fond);
          CoulEncreGr(CoulChoixCtrl.Encre);
        End;
        WriteGr(' ');
        WriteGr(ElargiADte(Liste[(N + PremierAffi - 1)]^.Texte,Largeur - 1));
      End;
      Select := NumEnCours - PremierAffi + 1;
      InverseGr(X,Y + (Select - 1) * HautCarGr,
                X + Largeur * LargCarGr,Y + Select * HautCarGr - 1);
      RestaureGr(S1);
    End;
    AfficheInfo;
  End;

  (**)
  Procedure ReafficheListe;

  Var
    S1         : TypeSauveGr;
    Select     : byte;
    N          : integer;

  Begin
    with ChoixFic do
    Begin
      SauvegardeGr(S1);
      CacheSouris;
      for N := 1 to MaxVisible do
      Begin
        GotoXYGr(X, Y + (N - 1) * HautCarGr);
        if Liste[(N + PremierAffi - 1)]^.Selectionne then
        Begin
          CoulFondGr(CoulChoixSelec.Fond);
          CoulEncreGr(CoulChoixSelec.Encre);
        End
        else
        Begin
          CoulFondGr(CoulChoixCtrl.Fond);
          CoulEncreGr(CoulChoixCtrl.Encre);
        End;
        WriteGr(' ');
        WriteGr(ElargiADte(Liste[(N + PremierAffi - 1)]^.Texte,Largeur - 1));
      End;
      Select := NumEnCours - PremierAffi + 1;
      InverseGr(X,Y + (Select - 1) * HautCarGr,
                X + Largeur * LargCarGr,Y + Select * HautCarGr - 1);
      RestaureGr(S1);
    End;
    AfficheInfo;
  End;


  (**)
  Procedure VaDebut;

  Begin
    if (PremierAffi = 1) and (NumEnCours = 1) then Reafficher := false
                                              else Reafficher := true;
    PremierAffi := 1;
    NumEnCours := 1;
  End;

  (**)
  Procedure VaFin;

  Var
    Tmp : integer;

  Begin
    with ChoixFic do
    Begin
      Tmp := Nombre - Hauteur + 1;
      if (PremierAffi = Tmp) and (NumEnCours = Nombre)
         then Reafficher := false
         else Reafficher := true;
      if Nombre > MaxVisible then PremierAffi := Tmp
                             else PremierAffi := 1;
      NumEnCours := Nombre;
    End;
  End;

  (**)
  Procedure VaBas;

  Begin
    if NumEnCours < Nombre then
    Begin
      inc(NumEnCours);
      Reafficher := true;
    End;
    if NumEnCours > (PremierAffi + ChoixFic.MaxVisible - 1) then
       inc(PremierAffi);
  End;

  (**)
  Procedure VaHaut;

  Begin
    if NumEnCours > 1 then
    Begin
      dec(NumEnCours);
      Reafficher := true;
    End;
    if NumEnCours < PremierAffi then dec(PremierAffi);
  End;

  (**)
  Procedure VaPgBas;

  Var
    Tmp : integer;

  Begin
    with ChoixFic do
    Begin
      if NumEnCours < Nombre then
      Begin
        Reafficher := true;
        Tmp := PremierAffi + MaxVisible + MaxVisible  - 1;
        if Tmp <= Nombre then
          Begin
            PremierAffi := PremierAffi + MaxVisible;
            NumEnCours := NumEnCours + MaxVisible;
          End
          else
          Begin
            if Nombre > MaxVisible
              then PremierAffi := Nombre - MaxVisible + 1;
            NumEnCours := Nombre;
          End;
      End;
    End;
  End;

  (**)
  Procedure VaPgHaut;

  Begin
    with ChoixFic do
    Begin
      if NumEnCours > 1 then
      Begin
        Reafficher := true;
        if PremierAffi > MaxVisible then
          Begin
            PremierAffi := PremierAffi - MaxVisible;
            NumEnCours := NumEnCours - MaxVisible;
          End
          else
          Begin
            PremierAffi := 1;
            NumEnCours := 1;
          End;
      End;
    End;
  End;

  (**)
  Procedure VaNumero(Num : integer);

  Var
    Tmp : integer;

  Begin
    with ChoixFic do
    Begin
      Reafficher := true;
      Tmp := Nombre - Num;
      if Tmp < MaxVisible then
        Begin
          if Nombre > MaxVisible then PremierAffi := Nombre -  MaxVisible + 1
                                 else PremierAffi := 1;
          NumEnCours := Num;
        End
        else
        Begin
          if not (Num in [PremierAffi .. (PremierAffi + MaxVisible - 1)]) then
            PremierAffi := Num;
          NumEnCours := Num;
        End;
      End;
    End;

  (**)
  Procedure TesteSouris;

  Var
    NumTmp : integer;

    {}
    Procedure SourisVaHaut;

    Begin
      repeat
        VaHaut;
        if Reafficher then
        Begin
          AfficheAscenceur;
          ReafficheListe;
        End
        else Beep;
        delay(TempoDefile);
        SourisRelachee(BoutonGauche,InfoSouris);
      until (InfoSouris.Bouton <> BoutonGauche) or (NumEnCours = 1);
      if NumEnCours = 1 then Beep;
    End;

    {}
    Procedure SourisVaBas;

    Begin
      repeat
        VaBas;
        if Reafficher then
        Begin
          AfficheAscenceur;
          ReafficheListe;
        End
        else Beep;
        delay(TempoDefile);
        SourisRelachee(BoutonGauche,InfoSouris);
      until (InfoSouris.Bouton <> BoutonGauche) or (NumEnCours = Nombre);
      if NumEnCours = Nombre then Beep;
    End;

    {}
    Procedure SourisAscenceur;

    Var
      Y1Tmp : integer;
      Y2Tmp : integer;

    Begin
      with ChoixFic do
      Begin
        if not Ascenseur then exit;
        if YTmp in [Y .. (Y + HautCarGr - 1)] then SourisVaHaut;
        Y1Tmp := Y + (Hauteur - 1) * HautCarGr;
        Y2Tmp := Y + Hauteur * HautCarGr - 1;
        if (YTmp >= Y1Tmp) and (YTmp <= Y2Tmp) then SourisVaBas;
        Y1Tmp := Y + HautCarGr;
        Y2Tmp := Y + (Hauteur - 1) * HautCarGr - 1;
        if (YTmp >= Y1Tmp) and (YTmp <= Y2Tmp) then
        Begin
          NumTmp := (YTmp - Y) div HautCarGr;
          if NumTmp = 1 then VaNumero(1)
          else
          Begin
            NumTmp := NumTmp * Nombre div (Hauteur - 2) + 1;
            if NumTmp > Nombre then NumTmp := Nombre;
            VaNumero(NumTmp);
          End;
        End;
        if (Autre and not (YTmp in [Y.. (Y + Hauteur * HautCarGr - 1)])) then
        Begin
          LeCar := #00;
          Fin := true;
        End
        else LeCar := #255;
      End;
    End;

    {}
    Procedure SourisListe;

    Begin
      DelaiSouris(TempoSouris);
      with PosGrListe do
      if SourisDsZone(XTmp,YTmp,X1,Y1,X2,Y2) then
      Begin
        NumTmp := PremierAffi + (YTmp - Y1) div HautCarGr;
        if Compresse(Liste[NumTmp]^.Texte) = '' then LeCar := #255
        else
        Begin
          VaNumero(NumTmp);
          LeCar := CarReturn;
        End;
      End
      else if Autre then
      Begin
        LeCar := #00;
        Fin := true;
      End;

    End;

    {}
    Procedure TestBoutonGauche;

    Var
      X1Tmp : integer;
      X2Tmp : integer;

    Begin
      with ChoixFic do
      Begin
        X1Tmp := X + Largeur * LargcarGr;
        X2Tmp := X + (Largeur + 1) * LargcarGr;
        if XTmp in [X1Tmp .. X2Tmp] then SourisAscenceur
                                    else SourisListe;
      End;
    End;
    {}

  Begin
    if InfoSouris.Nombre <> 0 then
    with ChoixFic do
    Begin
      case InfoSouris.Bouton of
        BoutonGauche : TestBoutonGauche;
      end;
      if Reafficher then
      Begin
        AfficheAscenceur;
        ReafficheListe;
      End
      else if (LeCar <> CarReturn) and not Fin then Beep;
    End;
  End;

  (**)
  Procedure TesteTouche;

  Begin
    Reafficher := false;
    if ToucheFct then
    Begin
      case LeCar of
        FlchDebut  : VaDebut;
        FlchFin    : VaFin;
        FlchBas    : VaBas;
        FlchHaut   : VaHaut;
        FlchGauche : VaPgHaut;
        FlchDroite : VaPgBas;
        FlchPgHaut : VaPgHaut;
        FlchPgBas  : VaPgBas;
        ShiftTab   : if Autre then Fin := true
                              else Beep;
        ShiftF1    : if AProposRelief then BoiteReliefAProposGr
                                      else BoiteAProposGr;
        AltX       : Begin
                       Sortie := true;
                       Abandon := true;
                     End;
        else
          if (LeCar in [AltQ..AltP,AltA..AltL,AltZ,AltC..AltM]) and Autre
             then Fin := true
             else Beep;
      end;
      if Reafficher then
      Begin
        AfficheAscenceur;
        ReafficheListe;
      End
      else
      if not (LeCar in [ShiftTab,AltQ..AltP,AltA..AltL,AltZ..AltM]) then Beep;
    End
    else
    Begin
      case LeCar of
        CarReturn : Fin := true;
        CarEsc    : Abandon := true;
        Tab       : if Autre then Fin := true
                             else Beep;
        #255      :;
        #00       : if not Autre then Beep;
        else Beep;
      end;
      if Reafficher then
      Begin
        AfficheAscenceur;
        ReafficheListe;
      End;
    End;
  End;

  (**)
  Procedure ChangeRepertoire;

  Var
    N   : integer;
    Tmp : Str80;

  Begin
    if Liste[NumEnCours]^.Texte[1] = #17 then
      Begin
        N := length(UnRepertoire);
        while not (UnRepertoire[N] in ['\',':']) do dec(N);
        UnRepertoire := copy(UnRepertoire,1,N);
      End
      else
      Begin
        Tmp := Liste[NumEnCours]^.Texte;
        Tmp := copy(Tmp,3,length(Tmp) - 2);
        UnRepertoire := UnRepertoire + '\' + Tmp;
      End;
    EffaceListe;
    CreeListe;
    PremierAffi := 1;
    NumEnCours := 1;
    AfficheAscenceur;
    ReafficheListe;
    Fin := false;
  End;

  (**)
  Procedure ChangeLecteur;

  Var
    Lecteur : char;
    W       : integer;

  Begin
    EffaceListe;
    Nombre := 0;
    for Lecteur := 'A' to 'Z' do
      if LecteurExiste(Lecteur) = 0 then
      Begin
        inc(Nombre);
        if MemAvail > sizeof(Liste[Nombre]) then new(Liste[Nombre])
                                            else PlusDeMemoireGr;
        Liste[Nombre]^.Texte       := Lecteur + ':';
        Liste[Nombre]^.Date        := 0;
        Liste[Nombre]^.Taille      := disksize(ord(Lecteur) - 64);
        Liste[Nombre]^.Attribut    := 255;
        Liste[Nombre]^.Selectionne := false;
      End;
    if Nombre < ChoixFic.MaxVisible then
      for W := (Nombre + 1) to ChoixFic.MaxVisible do
      Begin
        if MemAvail > sizeof(Liste[W]) then new(Liste[W])
                                       else PlusDeMemoireGr;
        Liste[W]^.Texte := ' ';
        Liste[W]^.Selectionne := false;
      End;
    while keypressed do readkey;
    PremierAffi := 1;
    NumEnCours := 1;
    AfficheAscenceur;
    ReafficheListe;
    Fin := false;
    repeat
      if AttendActionGr(LeCar,InfoSouris) then
      Begin
        XTmp := InfoSouris.Colonne;
        YTmp := InfoSouris.Ligne;
      End;
        TesteSouris;
        TesteTouche;
    until Fin or Abandon;

    if (LeCar = CarReturn) then
      Begin
        UnRepertoire := Liste[NumEnCours]^.Texte;
        EffaceListe;
        CreeListe;
        PremierAffi := 1;
        NumEnCours := 1;
        AfficheAscenceur;
        ReafficheListe;
      End;
    Fin := false;
  End;

  (**)
  Procedure Affichage;

  Begin
    with ChoixFic do
    Begin
      if Pos > Nombre then Pos := 1;
      PremierAffi := 1;
      NumEnCours := Pos;
      AfficheAscenceur;
      AfficheListe;
    End;
    ChoixFichierGr := #255;
  End;

  (**)
  Procedure Utilisation;

  Begin
    with ChoixFic do
    Begin
      if Pos > Nombre then Pos := 1;
      PremierAffi := 1;
      NumEnCours := Pos;
      AfficheAscenceur;
      AfficheListe;
      AncienneAide := LigneAide;
      LigneAide.Texte := AideChoix;
      AfficheLigneAideGr(true);
      Fin := false;
      Abandon := false;
      MontreSouris;
      repeat
        repeat
          if AttendActionGr(LeCar,InfoSouris) then
          Begin
            XTmp := InfoSouris.Colonne - Fenetre.X1;
            YTmp := InfoSouris.Ligne - Fenetre.Y1;
          End;
            TesteSouris;
            TesteTouche;
        until Fin or Abandon;
        if (LeCar = CarReturn) then
          case Liste[NumEnCours]^.Attribut of
            directory : ChangeRepertoire;
            255       : ChangeLecteur;
          end;
      until Fin or Abandon;
      LigneAide := AncienneAide;
      AfficheLigneAideGr(true);
      if LeCar = CarReturn then
      Begin
        UnRepertoire := UnRepertoire + '\';
        UnMasque := Compresse(Liste[NumEnCours]^.Texte);
      End;
      Pos := NumEnCours;
      ChoixFichierGr := LeCar;
    End;
  End;


Begin
  with ChoixFic do
  Begin
    SauvegardeGr(S);
    CacheCurseurGr;
    GetViewSettings(Fenetre);
    UnRepertoire := Majuscules(UnRepertoire);
    Largeur := 17;
    Larg := Largeur;
    if Ascenseur then inc(Larg);
    with Fenetre do
    Begin
      HTmp := (X2 - X1) div HautCarGr;
      if MaxVisible > HTmp then MaxVisible := HTmp;
      Hauteur := MaxVisible;
      Haut := Hauteur;
    if (Y + Hauteur * HautCarGr) > Y2 then Y := Y2 - Hauteur * HautCarGr + 2;
    if (X + Largeur * LargCarGr) > X2 then X := X2 - Largeur * LargCarGr + 1;
    with PosGrListe do
        Begin
          X1 := X;
          Y1 := Y;
          X2 := X + Largeur * LargCarGr - 1;
          Y2 := Y + Hauteur * HautCarGr - 1;
        End;
    End;
    CreeListe;
    case UneAction of
      Afficher : Affichage;
      Utiliser : Utilisation;
    end;
    EffaceListe;
    RestaureGr(S);
  End;
End;

(**)

Begin
  CurseurVisGr := false;
  AProposRelief := false;
End.