{

                           AJFTRTX  Version 1.0

                         Creation Alain JAFFRE 1995

  ͸
                   Unite ecrite pour TURBO PASCAL 7.0                     
                                                                          
                             Alain JAFFRE                                 
  ;

}

{$I AJFTRTX.DOC }

IMPLEMENTATION

{}

Procedure CalculLargDialogTx(Largeur : byte;Var LeDialog : DialogRecTx);

Begin
  with LeDialog do
  Begin
    case Tip of
      CadreSs : Larg := Largeur + 2;
      Cadre1  : Larg := Largeur + 2;
      Cadre2  : Larg := Largeur + 2;
      Cadre3  : Larg := Largeur + 2;
      Cadre4  : Larg := Largeur + 2;
      OmbreSs : Larg := Largeur + 4;
      Ombre1  : Larg := Largeur + 4;
      Ombre2  : Larg := Largeur + 4;
      Ombre3  : Larg := Largeur + 4;
      Ombre4  : Larg := Largeur + 4;
    end;
    if Larg > 80 then Larg := 80;
  End;
End;

{}

Procedure CalculHautDialogTx(Hauteur : byte;Var LeDialog : DialogRecTx);

Begin
  with LeDialog do
  Begin
    case Tip of
      CadreSs : Haut := Hauteur + 2;
      Cadre1  : Haut := Hauteur + 2;
      Cadre2  : Haut := Hauteur + 2;
      Cadre3  : Haut := Hauteur + 2;
      Cadre4  : Haut := Hauteur + 2;
      OmbreSs : Haut := Hauteur + 3;
      Ombre1  : Haut := Hauteur + 3;
      Ombre2  : Haut := Hauteur + 3;
      Ombre3  : Haut := Hauteur + 3;
      Ombre4  : Haut := Hauteur + 3;
    end;
    if Haut > 25 then Haut := 25;
  End;
End;

{}

Procedure CalculXDialogTx(Var LeDialog : DialogRecTx);

Var
  Mil  : byte;
  Long : byte;

Begin
  with LeDialog do
  Begin
    Long := Larg div 2;
    Mil := (lo(windmax) - lo(windmin)) div 2 + 1;
    X := Mil - Long + 1;
  End;
End;

{}

Procedure CalculYDialogTx(Var LeDialog : DialogRecTx);

Var
  Mil  : byte;
  Long : byte;

Begin
  with LeDialog do
  Begin
    Long := Haut div 2;
    Mil := (hi(windmax) - hi(windmin)) div 2 + 1;
    Y := Mil - Long;
  End;
End;

{}

Procedure CentreDialogTx(Largeur,Hauteur : byte;Var LeDialog : DialogRecTx);

Begin
  CalculLargDialogTx(Largeur,LeDialog);
  CalculHautDialogTx(Hauteur,LeDialog);
  CalculXDialogTx(LeDialog);
  CalculYDialogTx(LeDialog);
End;

(**)

Procedure OuvreDialogTx(Var LeDialog : DialogRecTx);

Var
  S : TypeSauveTx;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  with LeDialog do
  Begin
    Taille := (Larg + 1) * (Haut + 1) * 2;
    if not ReserveMem(Donnees,Taille) then PlusDeMemoireTx;
    SauveRectTx (X, Y, X + Larg, Y + Haut,Donnees);
    if Tip in [OmbreSs,Ombre1,Ombre2,Ombre3,Ombre4]
       then BoiteTx(X,Y,Larg - 4,Haut - 3,Tip,Coul,true,Titre,'')
       else BoiteTx(X,Y,Larg - 2,Haut - 2,Tip,Coul,true,Titre,'');
  End;
  RestaureTx(S);
End;

{}

Procedure FermeDialogTx(Var LeDialog : DialogRecTx);

Var
  S : TypeSauveTx;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  with LeDialog do
  Begin
    LitRectTx (X, Y, X + Larg, Y + Haut,Donnees);
    freemem(Donnees,Taille);
    Donnees := nil;
  End;
  RestaureTx(S);
End;

{}

Procedure AlarmeTx(PosY : byte;Lalarme : AlarmeRec);

Var
  Dialogue : DialogRecTx;
  S        : TypeSauveTx;
  N        : byte;
  Largeur  : byte;               { largeur du dialogue }
  Hauteur  : byte;               { hauteur du dialogue }
  YTmp     : byte;
  LeCar    : char;
  InfoSouris : PosRec;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  with Dialogue do
  Begin
    Tip := Ombre2;
    Coul := CoulAlarme;
    Titre := '';
    CoulFondTx(Coul.Fond);
    CoulEncreTx(Coul.Encre);
  End;
  Largeur := 0;
  Hauteur := 0;
  for N := 1 to 4 do
  Begin
    if length(Lalarme[N]) > 74 then Lalarme[N] := copy(Lalarme[N],1,74);
    if length(Lalarme[N]) > Largeur then Largeur := length(Lalarme[N]);
    if length(Lalarme[N]) > 0 then inc(Hauteur);
  End;
  if TempoAlarme = 0 then
     if (length(LigneSuite) + 2) > Largeur then
        Largeur := length(LigneSuite) + 2;
  if Hauteur > 0 then
  Begin
    if PosY = 0 then CentreDialogTx(Largeur,Hauteur,Dialogue)
    else
    Begin
      CalculLargDialogTx(Largeur,Dialogue);
      CalculHautDialogTx(Hauteur,Dialogue);
      CalculXDialogTx(Dialogue);
      if (PosY + Dialogue.Haut) < 25 then Dialogue.Y := PosY
                                     else Dialogue.Y := 25 - Dialogue.Haut;
    End;
    OuvreDialogTx(Dialogue);
    YTmp := Dialogue.Y;
    for N := 1 to 4 do
      if length(Lalarme[N]) > 0 then
      Begin
        inc(YTmp);
        CentreTexteTx(YTmp,Lalarme[N]);
      End;
    inc(YTmp);
    if FaitBip then
    Begin
      sound(600);
      delay(50);
      sound(400);
      delay(50);
      nosound;
    End;
    if TempoAlarme = 0 then
    Begin
      CentreTexteTx(YTmp,LigneSuite);
(*      repeat
        AppelTache;
      until keypressed;
      readkey;*)
      if AttendActionTx(LeCar,InfoSouris) then ;
    End
    else delay(TempoAlarme * Largeur * Hauteur);
    FermeDialogTx(Dialogue);
  End;
  RestaureTx(S);
End;

{}

Function BoiteChaineTx(Var Dialogue : DialogRecTx;Long : byte
                                                    ; Autre : boolean): char;

Var
  Largeur : byte;                { largeur du dialogue }
  Hauteur : byte;                { hauteur du dialogue }
  Tmp     : char;
  PosX    : byte;
  AncienneAide : RecLigneAide; { Sauvegarde de l'aide precedente }

Begin
  AncienneAide := LigneAide;
  with Dialogue do
  Begin
    Largeur := length(Titre) + 2;
    if Largeur < (Long + 4) then Largeur := Long + 4;
    Hauteur := 3;
    CalculLargDialogTx(Largeur,Dialogue);
    CalculHautDialogTx(Hauteur,Dialogue);
    if X = 0 then CalculXDialogTx(Dialogue);
    if Y = 0 then CalculYDialogTx(Dialogue);
    Coul := CoulBtSaisie;
  End;
  OuvreDialogTx(Dialogue);
  with Dialogue do
  Begin
    PosX := X + (Larg div 2) - (Long div 2) - 2;
    Tmp := SaisieTx(PosX,Y + 2,Long,Chaine,Utiliser,Autre);
  End;
  FermeDialogTx(Dialogue);
  LigneAide := AncienneAide;
  AfficheLigneAideTx(true);
  BoiteChaineTx := Tmp;
End;

{}

Function BoiteEntierTx(Var Dialogue : DialogRecTx;Long : byte;
                                   Min,Max : longint; Autre : boolean): char;

Var
  S       : TypeSauveTx;
  Largeur : byte;                { largeur du dialogue }
  Hauteur : byte;                { hauteur du dialogue }
  Tmp     : char;                { Caractere temporaire }
  PosX    : byte;                { Position en X de la saisie }
  Ok      : boolean;
  Message : Str80;
  AncienneAide : RecLigneAide; { Sauvegarde de l'aide precedente }

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  AncienneAide := LigneAide;
  Message := ' ' + IntToStr(Min) + ' ... ' + IntToStr(Max) + ' ';
  with Dialogue do
  Begin
    Largeur := length(Titre) + 2;
    if Largeur < length(Message) + 2 then Largeur := length(Message) + 2 ;
    if Largeur < (Long + 4) then Largeur := Long + 4;
    Hauteur := 3;
    CalculLargDialogTx(Largeur,Dialogue);
    CalculHautDialogTx(Hauteur,Dialogue);
    if X = 0 then CalculXDialogTx(Dialogue);
    if Y = 0 then CalculYDialogTx(Dialogue);
    Coul := CoulBtSaisie;
  End;
  OuvreDialogTx(Dialogue);
  with Dialogue do
  Begin
    CoulFondTx(Coul.Fond);
    CoulEncreTx(Coul.Encre);
    PosX := X + (Larg div 2) - (length(Message) div 2) - 1;
    gotoxy(PosX,Y + 4);
    write(Message);
    PosX := X + (Larg div 2) - (Long div 2) - 2;
    repeat
      Tmp := SaisieTx(PosX,Y + 2,Long,Entier,Utiliser,Autre);
      if not ((UnEntier >= Min) and (UnEntier <= Max)) then Beep;
      Ok := (Tmp = CarEsc) or Sortie;
    until (((UnEntier >= Min) and (UnEntier <= Max))) or  Ok;
  End;
  FermeDialogTx(Dialogue);
  LigneAide := AncienneAide;
  AfficheLigneAideTx(true);
  RestaureTx(S);
  BoiteEntierTx := Tmp;
End;

{}

Function BoiteReelTx(Var Dialogue : DialogRecTx;Long : byte;
                                      Min,Max : real; Autre : boolean): char;

Var
  S       : TypeSauveTx;
  Largeur : byte;                { largeur du dialogue }
  Hauteur : byte;                { hauteur du dialogue }
  Tmp     : char;                { Caractere temporaire }
  PosX    : byte;                { Position en X de la saisie }
  Ok      : boolean;
  Message : Str80;
  AncienneAide : RecLigneAide; { Sauvegarde de l'aide precedente }

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  AncienneAide := LigneAide;
  Message := ' ' + RealToStr(Min,LongStd,PrecisStd) + ' ... ' +
                   RealToStr(Max,LongStd,PrecisStd) + ' ';
  with Dialogue do
  Begin
    Largeur := length(Titre) + 2;
    if Largeur < length(Message) + 2 then Largeur := length(Message) + 2 ;
    if Largeur < (Long + 4) then Largeur := Long + 4;
    Hauteur := 3;
    CalculLargDialogTx(Largeur,Dialogue);
    CalculHautDialogTx(Hauteur,Dialogue);
    if X = 0 then CalculXDialogTx(Dialogue);
    if Y = 0 then CalculYDialogTx(Dialogue);
    Coul := CoulBtSaisie;
  End;
  OuvreDialogTx(Dialogue);
  with Dialogue do
  Begin
    CoulFondTx(Coul.Fond);
    CoulEncreTx(Coul.Encre);
    PosX := X + (Larg div 2) - (length(Message) div 2) - 1;
    gotoxy(PosX,Y + 4);
    write(Message);
    PosX := X + (Larg div 2) - (Long div 2) - 2;
    repeat
      Tmp := SaisieTx(PosX,Y + 2,Long,Reel,Utiliser,Autre);
      if not ((UnReel >= Min) and (UnReel <= Max)) then Beep;
      Ok := (Tmp = CarEsc) or Sortie;
    until (((UnReel >= Min) and (UnReel <= Max))) or  Ok;
  End;
  FermeDialogTx(Dialogue);
  LigneAide := AncienneAide;
  AfficheLigneAideTx(true);
  RestaureTx(S);
  BoiteReelTx := Tmp;
End;

{}

Function BoiteBoutTx(Var Dialogue : DialogRecTx;Bout1, Bout2 : Str80): char;

Var
  S          : TypeSauveTx;
  Largeur    : byte;             { largeur du dialogue }
  Hauteur    : byte;             { hauteur du dialogue }
  XBouton1   : byte;             { position en X du bouton 1 }
  XBouton2   : byte;             { position en X du bouton 2 }
  PosTxBt1   : CoinRectangle;    { position du texte du bouton 1 }
  PosTxBt2   : CoinRectangle;    { position du texte du bouton 2 }
  Bouton1    : boolean;          { bouton 1 enclenche ? }
  Fin        : boolean;          { une donnee vient d'etre validee }
  Abandon    : boolean;          { demande d'abandon }
  LeCar      : char;             { caractere venant d'etre frappe }
  InfoSouris : PosRec;           { position souris lors du dernier clic }
  XTmp       : byte;             { position temporaire en X }
  YTmp       : byte;             { position temporaire en Y }
  Tmp        : byte;             { valeur temporaire }

  (**)
  Procedure DefiniDialogue;

  Begin
    with Dialogue do
    Begin
      Titre := ' ' + Compresse(Titre) + ' ';
      Largeur := length(Bout1) + length(Bout2) + 7;
      if Largeur < (length(Titre) + 2) then Largeur := length(Titre) + 2;
      Hauteur := 3;
      CalculLargDialogTx(Largeur,Dialogue);
      CalculHautDialogTx(Hauteur,Dialogue);
      if X = 0 then CalculXDialogTx(Dialogue);
      if Y = 0 then CalculYDialogTx(Dialogue);
      Coul := CoulBtSaisie;
      Tmp := Larg - length(Bout1) - length(Bout2) - 4;
      Tmp := Tmp div 3;
      XBouton1 := X +  Tmp;
      (*XBouton2 := X + length(Bout1) + (2 * Tmp) + 1;*)
      XBouton2 := X + length(Bout1) + Tmp + Tmp + 1;
      with PosTxBt1 do
      Begin
        X1 := XBouton1 + 1;
        Y1 := Y +2;
        X2 := X1 + length(Bout1);
        Y2 := Y1;
      End;
      with PosTxBt2 do
      Begin
        X1 := XBouton2 + 1;
        Y1 := Y +2;
        X2 := X1 + length(Bout2);
        Y2 := Y1;
      End;
    End;
  End;

  (**)
  Procedure AfficheBouton1;

  Var
    S1 : TypeSauveTx;

  Begin
    SauvegardeTx(S1);
    CacheSouris;
    with Dialogue do
    Begin
      BoiteTx(XBouton1,Y+1,length(Bout1),1,Cadre2,CoulBoutonChoix,true,'','');
      CoulFondTx(CoulBoutonChoix.Fond);
      CoulEncreTx(CoulBoutonChoix.Encre);
      gotoxy(XBouton1 + 1,Y + 2);
      write(Bout1);
      InverseTexteTx(XBouton1 + 1,Y + 2,length(Bout1));
      BoiteTx(XBouton2,Y+1,length(Bout2),1,Cadre1,CoulBoutonChoix,true,'','');
      CoulFondTx(CoulBoutonChoix.Fond);
      CoulEncreTx(CoulBoutonChoix.Encre);
      gotoxy(XBouton2 + 1,Y + 2);
      write(Bout2);
    End;
    RestaureTx(S1);
  End;

  (**)
  Procedure AfficheBouton2;

  Var
    S1 : TypeSauveTx;

  Begin
    SauvegardeTx(S1);
    CacheSouris;
    with Dialogue do
    Begin
      BoiteTx(XBouton1,Y+1,length(Bout1),1,Cadre1,CoulBoutonChoix,true,'','');
      CoulFondTx(CoulBoutonChoix.Fond);
      CoulEncreTx(CoulBoutonChoix.Encre);
      gotoxy(XBouton1 + 1,Y + 2);
      write(Bout1);
      BoiteTx(XBouton2,Y+1,length(Bout2),1,Cadre2,CoulBoutonChoix,true,'','');
      CoulFondTx(CoulBoutonChoix.Fond);
      CoulEncreTx(CoulBoutonChoix.Encre);
      gotoxy(XBouton2 + 1,Y + 2);
      write(Bout2);
      InverseTexteTx(XBouton2 + 1,Y + 2,length(Bout2));
    End;
    RestaureTx(S1);
  End;

  (**)
  Procedure TesteSouris;

  Begin
    DelaiSouris(TempoSouris);
    if (InfoSouris.Nombre <> 0) and
       (InfoSouris.Bouton = BoutonGauche) then
    Begin
      with Dialogue do
        if SourisDsZone(XTmp,YTmp,X,Y,X+Largeur,Y+Hauteur) then
        Begin
          with PosTxBt1 do
            if SourisDsZone(XTmp,YTmp,X1,Y1,X2,Y2) then
            Begin
              Bouton1 := true;
              LeCar := CarReturn;
            End;
          with PosTxBt2 do
            if SourisDsZone(XTmp,YTmp,X1,Y1,X2,Y2) then
            Begin
              Bouton1 := false;
              LeCar := CarReturn;
            End;
        End
        else
        Begin
          LeCar := #0;
          Abandon := true;
        End;
    End;
  End;

  (**)
  Procedure TesteTouche;

  Begin
    if ToucheFct then
    Begin
      case LeCar of
        FlchGauche : Bouton1 := not Bouton1;
        FlchDroite : Bouton1 := not Bouton1;
        ShiftTab   : Abandon := true;
        ShiftF1    : BoiteAProposTx;
        AltX       : Begin
                       Sortie := true;
                       Abandon := true;
                     End;
        else Beep;
      end;
    End
    else
    Begin
      case LeCar of
        CarReturn : Fin := true;
        CarEsc    : Abandon := true;
        Tab       : Abandon := true;
        #0        :;
        else Beep;
      end;
    End;
  End;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  MontreSouris;
  DefiniDialogue;
  OuvreDialogTx(Dialogue);
  Bouton1 := true;
  AfficheBouton1;
  Fin := false;
  Abandon := false;
  repeat
    if AttendActionTx(LeCar,InfoSouris) then
    Begin
      PosSourisPosTx(InfoSouris.Colonne,InfoSouris.Ligne,Xtmp,YTmp);
      TesteSouris;
    End;
    TesteTouche;
    if Bouton1 then AfficheBouton1
               else AfficheBouton2;
  until Fin or Abandon;
  if Fin and Bouton1 then BoiteBoutTx := '1';
  if Fin and not Bouton1 then BoiteBoutTx := '2';
  if Abandon then BoiteBoutTx := LeCar;
  delay(100);
  FermeDialogTx(Dialogue);
  RestaureTx(S);
End;

{}

Function BoiteChoixCtrlTx(Var Dialogue : DialogRecTx;
   Var ChoixCtrl : ChoixCtrlRecTx;Var Liste : ListeRec;Autre : boolean):char;

Var
  S            : TypeSauveTx;
  Largeur      : byte;           { Largeur du dialogue }
  Hauteur      : byte;           { Hauteur du dialogue }
  LargeurListe : byte;           { Largeur de la liste }
  Tmp          : char;           { Caractere temporaire }
  AncienneAide : RecLigneAide; { Sauvegarde de l'aide precedente }

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  AncienneAide := LigneAide;
  with Dialogue do
  Begin
    ChoixCtrlTx(ChoixCtrl,Liste,Initialiser,Autre);
    Largeur := length(Titre) + 2;
    LargeurListe := ChoixCtrl.Larg;
    if (LargeurListe + 3) > Largeur then Largeur := LargeurListe + 3;
    Hauteur := ChoixCtrl.Haut;
    CalculLargDialogTx(Largeur,Dialogue);
    CalculHautDialogTx(Hauteur,Dialogue);
    if X = 0 then CalculXDialogTx(Dialogue);
    if Y = 0 then CalculYDialogTx(Dialogue);
    Coul := CoulBtSaisie;
  End;
  OuvreDialogTx(Dialogue);
  with Dialogue do
  Begin
    CoulFondTx(Coul.Fond);
    CoulEncreTx(Coul.Encre);
    ChoixCtrl.X := X + (Largeur div 2) - (LargeurListe div 2) + 1;
    ChoixCtrl.Y := Y + 1;
    Tmp := ChoixCtrlTx(ChoixCtrl,Liste,Utiliser,Autre);
  End;
  Delay(100);
  FermeDialogTx(Dialogue);
  LigneAide := AncienneAide;
  AfficheLigneAideTx(true);
  RestaureTx(S);
  BoiteChoixCtrlTx := Tmp;
End;

{}

Function BoiteChoixFichierTx(Var Dialogue : DialogRecTx;Var ChoixFic :
               ChoixFicRecTx;Var UnRepertoire : NomRep;Var UnMasque : NomFic;
                                                       Autre : boolean):char;

Var
  S            : TypeSauveTx;
  Largeur      : byte;           { Largeur du dialogue }
  Hauteur      : byte;           { Hauteur du dialogue }
  Tmp          : char;           { Caractere temporaire }
  AncienneAide : RecLigneAide; { Sauvegarde de l'aide precedente }

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  AncienneAide := LigneAide;
  with Dialogue do
  Begin
    ChoixFichierTx(ChoixFic,UnRepertoire,UnMasque,Initialiser,Autre);
    Largeur := length(Titre) + 2;
    if Largeur < 20 then Largeur := 20;
    Hauteur := ChoixFic.Haut + 3;
    CalculLargDialogTx(Largeur,Dialogue);
    CalculHautDialogTx(Hauteur,Dialogue);
    if X = 0 then CalculXDialogTx(Dialogue);
    if Y = 0 then CalculYDialogTx(Dialogue);
    Coul := CoulBtSaisie;
  End;
  OuvreDialogTx(Dialogue);
  with Dialogue do
  Begin
    CoulFondTx(Coul.Fond);
    CoulEncreTx(Coul.Encre);
    ChoixFic.X := X + (Largeur div 2) - (18 div 2) + 1;
    ChoixFic.Y := Y + 1;
    Tmp := ChoixFichierTx(ChoixFic,UnRepertoire,UnMasque,Utiliser,Autre);
  End;
  Delay(100);
  FermeDialogTx(Dialogue);
  LigneAide := AncienneAide;
  AfficheLigneAideTx(true);
  RestaureTx(S);
  BoiteChoixFichierTx := Tmp;
End;

{}

Procedure BoiteBarreGrapheTx(Var Dialogue : DialogRecTx;
   Var UnBarreGraphe : BarreGrapheRecTx;Valeur : longint;UneAction : Action);

Var
  S             : TypeSauveTx;
  Largeur       : byte;               { Largeur du dialogue  }
  Hauteur       : byte;               { Hauteur du dialogue  }

  (**)
  Procedure Ouverture;

  Begin
    with Dialogue do
    Begin
      Largeur := length(Titre) + 2;
      if Largeur < 12 then Largeur := 12;
      if Tip in [OmbreSs,Ombre1,Ombre2,Ombre3,Ombre4] then
         Largeur := Largeur + 2;
      if Titre = '' then Hauteur := 1
                    else Hauteur := 3;
      CalculLargDialogTx(Largeur,Dialogue);
      CalculHautDialogTx(Hauteur,Dialogue);
      if X = 0 then CalculXDialogTx(Dialogue);
      if Y = 0 then CalculYDialogTx(Dialogue);
    End;
    with UnBarreGraphe do
    Begin
      X := Dialogue.X + 2;
      if Dialogue.Titre = '' then Y := Dialogue.Y + 1
                             else Y := Dialogue.Y + 2;
      Larg := Dialogue.Larg - 4;
      if Dialogue.Tip in [OmbreSs,Ombre1,Ombre2,Ombre3,Ombre4] then
        Larg := Larg - 2;
    End;
    OuvreDialogTx(Dialogue);
    BarreGrapheTx(UnBarreGraphe,0,Afficher);
  End;

  (**)
  Procedure Utilisation;

  Begin
    BarreGrapheTx(UnBarreGraphe,Valeur,Utiliser);
  End;

  (**)
  Procedure Fermeture;

  Begin
    Delay(100);
    FermeDialogTx(Dialogue);
  End;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  case UneAction of
    Ouvrir   : Ouverture;
    Utiliser : Utilisation;
    Fermer   : Fermeture;
  end;
  RestaureTx(S);
End;

{}

Procedure InitBteEsFichierTx(Var UneBoite : BteEsFichierTxPtr;
                     Nom,Fichier,ErrFic,ExisteFic : Str40;Ok,Annule : Str20);

Begin
  if MemAvail > sizeof(UneBoite) then
  Begin
    new(UneBoite);
    with UneBoite^ do
    Begin
      Repertoire   := '';
      Masque       := '';
      AncienMasque := '';
      MasqueTmp    := '';
      TxtNom       := Nom;
      TxtFichier   := Fichier;
      TxtErrFic    := ErrFic;
      TxtExisteFic := ExisteFic;
      TxtOk        := Ok;
      TxtAnnule    := Annule;
    End;
  End
  else
  Begin
    PlusDeMemoireTx;
    Halt(1);
  End;
End;

{}

Procedure RepBteEsFichierTx(Var UneBoite : BteEsFichierTxPtr;
                                           UnRep : NomRep;UnMasque : NomFic);

Begin
  with UneBoite^ do
  Begin
    if UnRep <> '' then Repertoire := UnRep;
    if UnMasque <> '' then Masque := UnMasque;
  End;
End;

{}

Procedure LibereBteEsFichierTx(Var UneBoite : BteEsFichierTxPtr);

Begin
  if UneBoite <> nil then dispose(UneBoite);
End;

{}

Function BoiteEsFichierTx(Var Dialogue : DialogRecTx;
                      Var UneBoite : BteEsFichierTxPtr;Ouvre : boolean):char;

Var
  S            : TypeSauveTx;
  Largeur      : byte;           { Largeur du dialogue }
  Hauteur      : byte;           { Hauteur du dialogue }
  ChoixFic     : ChoixFicRecTx;  { Liste choix fichier }
  Bouton1      : BoutonTxPtr;    { bouton Ok }
  Bouton2      : BoutonTxPtr;    { bouton Annule }
  Abandon      : boolean;        { abandon ou fin de la boite }
  LeCar        : char;           { touche }
  InfoSouris   : PosRec;         { information souris }
  Position     : byte;           { position dans la boite }
  AncienneAide : RecLigneAide;   { Sauvegarde de l'aide precedente }
  Tas          : pointer;


  (**)
  Procedure Initialisation;

  Begin
    with Dialogue do
    Begin
      Titre := ' ' + Compresse(Titre) + ' ';
      Largeur := length(Titre) + 2;
      if Largeur < 40 then Largeur := 40;
      Hauteur := 19;
      CalculLargDialogTx(Largeur,Dialogue);
      CalculHautDialogTx(Hauteur,Dialogue);
      if X = 0 then CalculXDialogTx(Dialogue);
      if Y = 0 then CalculYDialogTx(Dialogue);
      Coul := CoulBtSaisie;
    End;
    with ChoixFic do
    Begin
      X := Dialogue.X + 3;
      Y := Dialogue.Y + 6;
      Pos := 1;
      MaxVisible := 10;
      TypeTrie := Nom;
      Trie := Ascendant;
      Ascenseur := true;
      Info := true;
      Immediat := false;
    End;
    with Dialogue,Uneboite^ do
    Begin
      InitBoutonTx(Bouton1,TxtOk,X + 24,Y + 4,10,true,false);
      InitBoutonTx(Bouton2,TxtAnnule,X + 24,Y + 6,10,true,false);
      UneChaine := Masque;
    End;
    Abandon := false;
    Position := 1;
    LeCar := #255;
  End;

  (**)
  Procedure AffichageBoutons;

  Var
    S1 : TypeSauveTx;

  Begin
    SauvegardeTx(S1);
    CacheCurseurTx;
    CacheSouris;
    Bouton1^.Actif := false;
    Bouton2^.Actif := false;
    AfficheBoutonTx(Bouton1);
    AfficheBoutonTx(Bouton2);
    RestaureTx(S1);
  End;

  (**)
  Procedure Affichage;

  Var
    S1 : TypeSauveTx;

  Begin
    SauvegardeTx(S1);
    CacheCurseurTx;
    CacheSouris;
    OuvreDialogTx(Dialogue);
    with Dialogue,UneBoite^ do
    Begin
      CoulFondTx(Coul.Fond);
      CoulEncreTx(CoulChoixCtrl.Encre);
      gotoxy(X + 3, Y + 2);
      write(TxtNom + ' : ');
      LeCar := SaisieTx(X + 3,Y + 3,12,Chaine,Afficher,true);
      gotoxy(X + 3, Y + 5);
      write(TxtFichier + ' : ');
      LeCar := ChoixFichierTx(ChoixFic,Repertoire,Masque,Afficher,true);
      AffichageBoutons;
    End;
    RestaureTx(S1);
  End;

  (**)
  Function TesteOuvreFichierOk : boolean;

  Var
    NomFicTmp : Str80;
    Alarme : AlarmeRec;

  Begin
    with UneBoite^ do
    Begin
      if Repertoire[length(Repertoire)] <> '\' then
         Repertoire := Repertoire + '\';
      NomFicTmp := Repertoire +  UneChaine;
      if (not FicExiste(NomFicTmp)) or Wildcards(NomFicTmp) then
      Begin
        Alarme[1] := UneChaine;
        Alarme[2] := TxtErrFic;
        Alarme[3] := '';
        Alarme[4] := '';
        TempoAlarme := 0;
        AlarmeTx(0,Alarme);
        LeCar := #255;
        Position := 1;
        TesteOuvreFichierOk := false;
      End
      else
      Begin
        Masque := UneChaine;
        TesteOuvreFichierOk := true;
      End;
    End;
  End;

  (**)
  Function RemplaceExistant : boolean;

  Var
    Dlg    : DialogRecTx;
    CarTmp : char;
    TxtOui, TxtNon : Str20;

  Begin
    TxtOui := UneBoite^.TxtOk;
    while pos('&',TxtOui) <> 0 do delete(TxtOui,pos('&',TxtOui),1);
    TxtNon := UneBoite^.TxtAnnule;
     while pos('&',TxtNon) <> 0 do delete(TxtNon,pos('&',TxtNon),1);
    with Dlg do
    Begin
      X     := 0;
      Y     := 0;
      Tip   := Ombre2;
      Titre := UneBoite^.TxtExisteFic;
    End;
    with UneBoite^ do
      CarTmp := BoiteBoutTx(Dlg,' '+TxtOui+' ',' '+TxtNon+' ');
    if CarTmp = '1' then
    Begin
      UneBoite^.Masque := UneChaine;
      RemplaceExistant := true;
    End
    else
    Begin
      LeCar := #255;
      Position := 1;
      RemplaceExistant := false;
    End;
  End;

  (**)
  Function TesteSauveFichierOk : boolean;

  Var
    NomFicTmp : Str80;
    Alarme : AlarmeRec;

  Begin
    with UneBoite^ do
    Begin
      if Repertoire[length(Repertoire)] <> '\' then
         Repertoire := Repertoire + '\';
      NomFicTmp := Repertoire +  UneChaine;
      if Wildcards(NomFicTmp) then
      Begin
        Alarme[1] := UneChaine;
        Alarme[2] := TxtErrFic;
        Alarme[3] := '';
        Alarme[4] := '';
        TempoAlarme := 0;
        AlarmeTx(0,Alarme);
        LeCar := #255;
        Position := 1;
        TesteSauveFichierOk := false;
      End
      else
      if FicExiste(NomFicTmp) then TesteSauveFichierOk := RemplaceExistant
        else
        Begin
          Masque := UneChaine;
          TesteSauveFichierOk := true;
        End;
    End;
  End;

  (**)
  Procedure NomClavier;

  Var
    S1 : TypeSauveTx;

  Begin
    UneChaine := Majuscules(UneChaine);
    SauvegardeTx(S1);
    CacheCurseurTx;
    CacheSouris;
    if Wildcards(UneChaine) then
    Begin
      with Dialogue,UneBoite^ do
      Begin
        Masque := UneChaine;
        LeCar := ChoixFichierTx(ChoixFic,Repertoire,Masque,Afficher,true);
      End;
    End;
    RestaureTx(S1);
  End;

  (**)
  Procedure FichierClavier;

  Begin
    with Dialogue, UneBoite^ do
    Begin
      UneChaine := Masque;
      LeCar := SaisieTx(X + 3,Y + 3,12,Chaine,Afficher,true);
      LeCar := CarReturn;
      Position := 3;
    End;
  End;

  (**)
  Procedure SortieOk(Oui : boolean);

  Begin
    Abandon := true;
    if Oui then
    Begin
      LeCar := CarReturn;
      if Ouvre then Abandon := TesteOuvreFichierOk
               else Abandon := TesteSauveFichierOk;
    End
    else LeCar := CarEsc;
  End;

  (**)
  Function SourisDsNom(X,Y : integer) : boolean;

  Var
    X1, X2, Y1, Y2 : word;

  Begin
    with Dialogue do
    Begin
      X1 := X + 3;
      X2 := X1 + 13;
      Y1 := Y + 3;
      Y2 := Y1;
    End;
    SourisDsNom := SourisDsZone(X,Y,X1,Y1,X2,Y2);
  End;

  (**)
  Function SourisDsFichier(X,Y : integer) : boolean;

  Var
    X1, X2, Y1, Y2 : word;
    Dedans : boolean;

  Begin
    with ChoixFic do
    Begin
      X1 := X;
      X2 := X1 + Larg - 1;
      Y1 := Y;
      Y2 := Y1 + Haut - 1;
    End;
    Dedans := SourisDsZone(X,Y,X1,Y1,X2,Y2);
    ChoixFic.Immediat := Dedans;
    SourisDsFichier := Dedans;
  End;

  (**)
  Procedure GereSouris;

  Var
    XTmp, YTmp : byte;

  Begin
    DelaiSouris(TempoSouris);
    PosSouris(InfoSouris);
    if SourisDsBoutonTx(Bouton1,InfoSouris) then SortieOk(true)
    else
      if SourisDsBoutonTx(Bouton2,InfoSouris) then SortieOk(false)
      else
      Begin
        with InfoSouris do PosSourisPosTx(Colonne,Ligne,XTmp,YTmp);
        if SourisDsNom(XTmp,YTmp) then Position := 1
        else
          if SourisDsFichier(XTmp,YTmp) then Position := 2;
      End;
  End;

  (**)
  Procedure GereClavier;

  Begin
    if ToucheFct then
    Begin
      case LeCar of
        ShiftTab  : Begin
                      dec(Position);
                      if Position = 0 then Position := 4;
                    End;
        ShiftF1   : BoiteAProposTx;
        AltX      : Begin
                      Sortie := true;
                      Abandon := true;
                    End;
      end;
      if ToucheDuBoutonTx(Bouton1,LeCar) then SortieOk(true)
      else
        if ToucheDuBoutonTx(Bouton2,LeCar) then SortieOk(false);
    End
    else
    Begin
      case LeCar of
        Tab       : Begin
                      inc(Position);
                      if Position = 5 then Position := 1;
                    End;
        CarEsc    : Abandon := true;
        CarReturn : Begin
                      case Position of
                        1 : NomClavier;
                        2 : FichierClavier;
                        3 : SortieOk(true);
                        4 : SortieOk(false);
                      end;
                    End;
      end;
    End;
  End;

  (**)
  Procedure GestionNom;

  Var
    S1 : TypeSauveTx;

  Begin
    SauvegardeTx(S1);
    CacheCurseurTx;
    CacheSouris;
    with Dialogue, UneBoite^ do
    Begin
      CoulFondTx(Coul.Fond);
      CoulEncreTx(Coul.Encre);
      gotoxy(X + 3, Y + 2);
      write(TxtNom + ' : ');
      LeCar := SaisieTx(X + 3,Y + 3,12,Chaine,Utiliser,true);
      CoulFondTx(Coul.Fond);
      CoulEncreTx(CoulChoixCtrl.Encre);
      gotoxy(X + 3, Y + 2);
      write(TxtNom + ' : ');
    End;
    RestaureTx(S1);
    if LeCar = #0 then GereSouris
                  else GereClavier;
  End;

  (**)
  Procedure GestionFichier;

  Var
    S1     : TypeSauveTx;
    CarTmp : char;

  Begin
    SauvegardeTx(S1);
    CacheCurseurTx;
    CacheSouris;
    with Dialogue, UneBoite^ do
    Begin
      CoulFondTx(Coul.Fond);
      CoulEncreTx(Coul.Encre);
      gotoxy(X + 3, Y + 5);
      write(TxtFichier + ' : ');
      if AncienMasque = '' then AncienMasque := Masque;
      if Masque <> AncienMasque then
      Begin
        if Wildcards(Masque) then AncienMasque := Masque
        else
        Begin
          MasqueTmp := Masque;
          Masque := AncienMasque;
          UneChaine := Masque;
          LeCar := SaisieTx(X + 3,Y + 3,12,Chaine,Afficher,true);
        End;
      End;
      LeCar := ChoixFichierTx(ChoixFic,Repertoire,Masque,Utiliser,true);
      CoulFondTx(Coul.Fond);
      CoulEncreTx(CoulChoixCtrl.Encre);
      gotoxy(X + 3, Y + 5);
      write(TxtFichier + ' : ');
      if (LeCar = Tab) or (ToucheFct and (LeCar = ShiftTab)) then
      Begin
        Masque := MasqueTmp;
        UneChaine := Masque;
        CarTmp := SaisieTx(X + 3,Y + 3,12,Chaine,Afficher,true);
      End;
    End;
    RestaureTx(S1);
    if LeCar = #0 then GereSouris
                  else GereClavier;
  End;

  (**)
  Procedure GestionOk;

  Var
    S1 : TypeSauveTx;

  Begin
    SauvegardeTx(S1);
    CacheCurseurTx;
    CacheSouris;
    LigneAide.Texte := AideChoix;
    AfficheLigneAideTx(true);
    Bouton1^.Actif := true;
    AfficheBoutonTx(Bouton1);
    RestaureTx(S1);
    if AttendActionTx(LeCar,InfoSouris) then GereSouris
                                        else GereClavier;
    AfficheLigneAideTx(true);
  End;

  (**)
  Procedure GestionAnnule;

  Var
    S1 : TypeSauveTx;

  Begin
    SauvegardeTx(S1);
    CacheCurseurTx;
    CacheSouris;
    LigneAide.Texte := AideChoix;
    AfficheLigneAideTx(true);
    Bouton2^.Actif := true;
    AfficheBoutonTx(Bouton2);
    RestaureTx(S1);
    if AttendActionTx(LeCar,InfoSouris) then GereSouris
                                        else GereClavier;
    AfficheLigneAideTx(true);
  End;

  (**)
  Procedure GereBteOuvreFic;

  Begin
    MontreSouris;
    while not Abandon do
    Begin
      AffichageBoutons;
      with Dialogue,UneBoite^ do
      case Position of
        1 : GestionNom;
        2 : GestionFichier;
        3 : GestionOk;
        4 : GestionAnnule;
      end;
    End;
  End;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  AncienneAide := LigneAide;
  mark(Tas);
  Initialisation;
  Affichage;
  GereBteOuvreFic;
  LibereBoutonTx(Bouton1);
  LibereBoutonTx(Bouton2);
  FermeDialogTx(Dialogue);
  release(Tas);
  LigneAide := AncienneAide;
  AfficheLigneAideTx(true);
  RestaureTx(S);
  BoiteEsFichierTx := LeCar;
End;

{}

Procedure InitBteChoixRepTx(Var UneBoite : BteChoixRepTxPtr;UnRep : NomRep;
                                         TexteRep : Str40;Ok,Annule : Str20);

Begin
  if MemAvail > sizeof(UneBoite) then
  Begin
    new(UneBoite);
    with UneBoite^ do
    Begin
      Repertoire    := UnRep;
      TxtRepertoire := TexteRep;
      TxtOk         := Ok;
      TxtAnnule     := Annule;
    End;
  End
  else
  Begin
    PlusDeMemoireTx;
    Halt(1);
  End;
End;

{}

Procedure LibereBteChoixRepTx(Var UneBoite : BteChoixRepTxPtr);

Begin
  if UneBoite <> nil then dispose(UneBoite);
End;


{}

Function BoiteChoixRepTx(Var Dialogue : DialogRecTx;
                                       Var UneBoite : BteChoixRepTxPtr):char;

Var
  S            : TypeSauveTx;
  Largeur      : byte;           { Largeur du dialogue }
  Hauteur      : byte;           { Hauteur du dialogue }
  ChoixFic     : ChoixFicRecTx;  { Liste choix fichier }
  Bouton1      : BoutonTxPtr;    { bouton Ok }
  Bouton2      : BoutonTxPtr;    { bouton Annule }
  Abandon      : boolean;        { abandon ou fin de la boite }
  LeCar        : char;           { touche }
  InfoSouris   : PosRec;         { information souris }
  Position     : byte;           { position dans la boite }
  AncienneAide : RecLigneAide; { Sauvegarde de l'aide precedente }
  Tas          : pointer;
  Masque       : NomFic;


  (**)
  Procedure Initialisation;

  Begin
    with Dialogue do
    Begin
      Titre := ' ' + Compresse(Titre) + ' ';
      Largeur := length(Titre) + 2;
      if Largeur < 40 then Largeur := 40;
      Hauteur := 13;
      CalculLargDialogTx(Largeur,Dialogue);
      CalculHautDialogTx(Hauteur,Dialogue);
      if X = 0 then CalculXDialogTx(Dialogue);
      if Y = 0 then CalculYDialogTx(Dialogue);
      Coul := CoulBtSaisie;
    End;
    with ChoixFic do
    Begin
      X := Dialogue.X + 3;
      Y := Dialogue.Y + 3;
      Pos := 1;
      MaxVisible := 10;
      TypeTrie := Nom;
      Trie := Ascendant;
      Ascenseur := true;
      Info := false;
      Immediat := false;
    End;
    with Dialogue,Uneboite^ do
    Begin
      InitBoutonTx(Bouton1,TxtOk,X + 26,Y + 4,10,true,false);
      InitBoutonTx(Bouton2,TxtAnnule,X + 26,Y + 9,10,true,false);
    End;
    Masque := '';
    Abandon := false;
    Position := 1;
    LeCar := #255;
  End;

  (**)
  Procedure AffichageBoutons;

  Var
    S1 : TypeSauveTx;

  Begin
    SauvegardeTx(S1);
    CacheCurseurTx;
    CacheSouris;
    Bouton1^.Actif := false;
    Bouton2^.Actif := false;
    AfficheBoutonTx(Bouton1);
    AfficheBoutonTx(Bouton2);
    RestaureTx(S1);
  End;

  (**)
  Procedure Affichage;

  Var
    S1 : TypeSauveTx;

  Begin
    SauvegardeTx(S1);
    CacheCurseurTx;
    CacheSouris;
    OuvreDialogTx(Dialogue);
    with Dialogue,UneBoite^ do
    Begin
      CoulFondTx(Coul.Fond);
      CoulEncreTx(CoulChoixCtrl.Encre);
      gotoxy(X + 3, Y + 2);
      write(TxtRepertoire + ' : ');
      LeCar := ChoixFichierTx(ChoixFic,Repertoire,Masque,Afficher,true);
      AffichageBoutons;
    End;
    RestaureTx(S1);
  End;

  (**)
  Procedure SortieOk(Oui : boolean);

  Begin
    Abandon := true;
    if Oui then
    Begin
      LeCar := CarReturn;
      Abandon := true;
    End
    else LeCar := CarEsc;
  End;

  (**)
  Function SourisDsFichier(X,Y : integer) : boolean;

  Var
    X1, X2, Y1, Y2 : word;
    Dedans : boolean;

  Begin
    with ChoixFic do
    Begin
      X1 := X;
      X2 := X1 + Larg - 1;
      Y1 := Y;
      Y2 := Y1 + Haut - 1;
    End;
    Dedans := SourisDsZone(X,Y,X1,Y1,X2,Y2);
    ChoixFic.Immediat := Dedans;
    SourisDsFichier := Dedans;
  End;

  (**)
  Procedure GereSouris;

  Var
    XTmp, YTmp : byte;

  Begin
    DelaiSouris(TempoSouris);
    PosSouris(InfoSouris);
    if SourisDsBoutonTx(Bouton1,InfoSouris) then SortieOk(true)
    else
      if SourisDsBoutonTx(Bouton2,InfoSouris) then SortieOk(false)
      else
      Begin
        with InfoSouris do PosSourisPosTx(Colonne,Ligne,XTmp,YTmp);
          if SourisDsFichier(XTmp,YTmp) then Position := 1;
      End;
  End;

  (**)
  Procedure GereClavier;

  Begin
    if ToucheFct then
    Begin
      case LeCar of
        ShiftTab  : Begin
                      dec(Position);
                      if Position = 0 then Position := 3;
                    End;
        ShiftF1   : BoiteAProposTx;
        AltX      : Begin
                      Sortie := true;
                      Abandon := true;
                    End;
      end;
      if ToucheDuBoutonTx(Bouton1,LeCar) then SortieOk(true)
      else
        if ToucheDuBoutonTx(Bouton2,LeCar) then SortieOk(false);
    End
    else
    Begin
      case LeCar of
        Tab       : Begin
                      inc(Position);
                      if Position = 4 then Position := 1;
                    End;
        CarEsc    : Abandon := true;
        CarReturn : Begin
                      case Position of
                        2 : SortieOk(true);
                        3 : SortieOk(false);
                      end;
                    End;
      end;
    End;
  End;

  (**)
  Procedure GestionRepertoire;

  Var
    S1 : TypeSauveTx;

  Begin
    SauvegardeTx(S1);
    CacheCurseurTx;
    CacheSouris;
    with Dialogue, UneBoite^ do
    Begin
      CoulFondTx(Coul.Fond);
      CoulEncreTx(Coul.Encre);
      gotoxy(X + 3, Y + 2);
      write(TxtRepertoire + ' : ');
      LeCar := ChoixFichierTx(ChoixFic,Repertoire,Masque,Utiliser,true);
      CoulFondTx(Coul.Fond);
      CoulEncreTx(CoulChoixCtrl.Encre);
      gotoxy(X + 3, Y + 2);
      write(TxtRepertoire + ' : ');
    End;
    RestaureTx(S1);
    if LeCar = #0 then GereSouris
                  else GereClavier;
  End;

  (**)
  Procedure GestionOk;

  Var
    S1 : TypeSauveTx;

  Begin
    SauvegardeTx(S1);
    CacheCurseurTx;
    CacheSouris;
    LigneAide.Texte := AideChoix;
    AfficheLigneAideTx(true);
    Bouton1^.Actif := true;
    AfficheBoutonTx(Bouton1);
    RestaureTx(S1);
    if AttendActionTx(LeCar,InfoSouris) then GereSouris
                                        else GereClavier;
    AfficheLigneAideTx(true);
  End;

  (**)
  Procedure GestionAnnule;

  Var
    S1 : TypeSauveTx;

  Begin
    SauvegardeTx(S1);
    CacheCurseurTx;
    CacheSouris;
    LigneAide.Texte := AideChoix;
    AfficheLigneAideTx(true);
    Bouton2^.Actif := true;
    AfficheBoutonTx(Bouton2);
    RestaureTx(S1);
    if AttendActionTx(LeCar,InfoSouris) then GereSouris
                                        else GereClavier;
    AfficheLigneAideTx(true);
  End;

  (**)
  Procedure GereBteChoixRep;

  Begin
    MontreSouris;
    while not Abandon do
    Begin
      AffichageBoutons;
      with Dialogue,UneBoite^ do
      case Position of
        1 : GestionRepertoire;
        2 : GestionOk;
        3 : GestionAnnule;
      end;
    End;
  End;

Begin
  SauvegardeTx(S);
  CacheCurseurTx;
  CacheSouris;
  AncienneAide := LigneAide;
  mark(Tas);
  Initialisation;
  Affichage;
  GereBteChoixRep;
  LibereBoutonTx(Bouton1);
  LibereBoutonTx(Bouton2);
  FermeDialogTx(Dialogue);
  release(Tas);
  LigneAide := AncienneAide;
  AfficheLigneAideTx(true);
  RestaureTx(S);
  BoiteChoixRepTx := LeCar;
End;

{}

Begin

End.
