{

                           AJFTRGR  Version 1.0

                         Creation Alain JAFFRE 1995

  ͸
                   Unite ecrite pour TURBO PASCAL 7.0                     
                                                                          
                             Alain JAFFRE                                 
  ;

}

{$I AJFTRGR.DOC }

IMPLEMENTATION

{}

Procedure CalculLargDialogGr(Largeur : integer;Var LeDialog : DialogRecGr);

Var
  Fenetre : ViewPortType;

Begin
  with LeDialog do
  Begin
    case Tip of
      CadreSs : Larg := Largeur + HCadreBoite + HCadreBoite;
      Cadre1  : Larg := Largeur + HCadreBoite + HCadreBoite;
      Cadre2  : Larg := Largeur + HCadreBoite + HCadreBoite;
      Cadre3  : Larg := Largeur + HCadreBoite + HCadreBoite;
      Cadre4  : Larg := Largeur + HCadreBoite + HCadreBoite;
      OmbreSs : Larg := Largeur + HCadreBoite + HCadreBoite + OmbreBoite;
      Ombre1  : Larg := Largeur + HCadreBoite + HCadreBoite + OmbreBoite;
      Ombre2  : Larg := Largeur + HCadreBoite + HCadreBoite + OmbreBoite;
      Ombre3  : Larg := Largeur + HCadreBoite + HCadreBoite + OmbreBoite;
      Ombre4  : Larg := Largeur + HCadreBoite + HCadreBoite + OmbreBoite;
    end;
    GetViewSettings(Fenetre);
    with Fenetre do
      if Larg > (X2 - X1) then Larg := (X2 - X1);
  End;
End;

{}

Procedure CalculHautDialogGr(Hauteur : integer;Var LeDialog : DialogRecGr);

Var
  Fenetre : ViewPortType;

Begin
  with LeDialog do
  Begin
    case Tip of
      CadreSs : Haut := Hauteur + HCadreBoite + HCadreBoite;
      Cadre1  : Haut := Hauteur + HCadreBoite + HCadreBoite;
      Cadre2  : Haut := Hauteur + HCadreBoite + HCadreBoite;
      Cadre3  : Haut := Hauteur + HCadreBoite + HCadreBoite;
      Cadre4  : Haut := Hauteur + HCadreBoite + HCadreBoite;
      OmbreSs : Haut := Hauteur + HCadreBoite + HCadreBoite + OmbreBoite;
      Ombre1  : Haut := Hauteur + HCadreBoite + HCadreBoite + OmbreBoite;
      Ombre2  : Haut := Hauteur + HCadreBoite + HCadreBoite + OmbreBoite;
      Ombre3  : Haut := Hauteur + HCadreBoite + HCadreBoite + OmbreBoite;
      Ombre4  : Haut := Hauteur + HCadreBoite + HCadreBoite + OmbreBoite;
    end;
    GetViewSettings(Fenetre);
    with Fenetre do
      if Haut > (Y2 - Y1) then Haut := (Y2 - Y1);
  End;
End;

{}

Procedure CalculXDialogGr(Var LeDialog : DialogRecGr);

Var
  Mil     : integer;
  Long    : integer;
  Fenetre : ViewPortType;

Begin
  GetViewSettings(Fenetre);
  with LeDialog,Fenetre do
  Begin
    Long := Larg div 2;
    Mil := (X2 - X1) div 2 + 1;
    X := Mil - Long + 1;
  End;
End;

{}

Procedure CalculYDialogGr(Var LeDialog : DialogRecGr);

Var
  Mil     : integer;
  Long    : integer;
  Fenetre : ViewPortType;

Begin
  GetViewSettings(Fenetre);
  with LeDialog,Fenetre do
  Begin
    Long := Haut div 2;
    Mil := (Y2 - Y1) div 2 + 1;
    Y := Mil - Long;
  End;
End;

{}

Procedure CentreDialogGr(Largeur,Hauteur:integer;Var LeDialog : DialogRecGr);

Begin
  CalculLargDialogGr(Largeur,LeDialog);
  CalculHautDialogGr(Hauteur,LeDialog);
  CalculXDialogGr(LeDialog);
  CalculYDialogGr(LeDialog);
End;

{}

Procedure CentreTitreGr(Var LeDialog : DialogRecGr);

Var
  Long : integer;
  Mil  : integer;

Begin
  with LeDialog do
  Begin
    if Tip in [OmbreSs,Ombre1,Ombre2,Ombre3,Ombre4]
      then Long := Larg - OmbreBoite
      else Long := Larg ;
    Mil := X + (Long div 2) - 1;
    if (length(Titre) * LargCarGr) < Long then
      Long := length(Titre) * LargCarGr
      else Titre := copy(Titre,1,(Long div LargCarGr));
    CoulFondGr(Coul.Fond);
    CoulEncreGr(Coul.Encre);
    GotoXYGr(Mil - (Long div 2),Y);
    WriteGr(Titre);
  End;
End;

{}

Procedure CalculXDialogReliefGr(Var LeDialog : DialogReliefRecGr);

Var
  Mil     : integer;
  Long    : integer;
  Fenetre : ViewPortType;

Begin
  GetViewSettings(Fenetre);
  with LeDialog,Fenetre do
  Begin
    Long := Larg div 2;
    Mil := (X2 - X1) div 2 + 1;
    X := Mil - Long + 1;
  End;
End;

{}

Procedure CalculYDialogReliefGr(Var LeDialog : DialogReliefRecGr);

Var
  Mil     : integer;
  Long    : integer;
  Fenetre : ViewPortType;

Begin
  GetViewSettings(Fenetre);
  with LeDialog,Fenetre do
  Begin
    Long := Haut div 2;
    Mil := (Y2 - Y1) div 2 + 1;
    Y := Mil - Long;
  End;
End;

{}

Procedure AjusteLargeurDialogReliefGr(Var LeDialog : DialogReliefRecGr);

Var
  Fenetre : ViewPortType;

Begin
  GetViewSettings(Fenetre);
  with LeDialog, Fenetre do
  Begin
    (*Larg := Larg + 2 * RayonRelief;*)
    Larg := Larg + RayonRelief + RayonRelief;
    if Larg > (X2 - X1) then Larg := (X2 - X1);
  End;
End;

{}

Procedure AjusteHauteurDialogReliefGr(Var LeDialog : DialogReliefRecGr);

Var
  Fenetre : ViewPortType;

Begin
  GetViewSettings(Fenetre);
  with LeDialog, Fenetre do
  Begin
    (*Haut := Haut + 2 * RayonRelief;*)
    Haut := Haut + RayonRelief + RayonRelief;
    if Haut > (Y2 - Y1) then Haut := (Y2 - Y1);
  End;
End;

{}

Procedure CentreDialogReliefGr(Var LeDialog : DialogReliefRecGr);

Begin
  AjusteLargeurDialogReliefGr(LeDialog);
  AjusteHauteurDialogReliefGr(LeDialog);
  CalculXDialogReliefGr(LeDialog);
  CalculYDialogReliefGr(LeDialog);
End;

{}

Procedure CentreTitreReliefGr(Var LeDialog : DialogReliefRecGr);

Var
  Long : integer;
  Mil  : integer;

Begin
  with LeDialog do
  Begin
    Long := Larg;
    Mil := X + (Long div 2) - 1;
    if (length(Titre) * LargCarGr) < Long then
      Long := length(Titre) * LargCarGr
      else Titre := copy(Titre,1,(Long div LargCarGr));
    CoulFondGr(Coul.Fond);
    CoulEncreGr(Coul.Encre);
    GotoXYGr(Mil - (Long div 2),Y + RayonRelief);
    WriteGr(Titre);
  End;
End;


(**)

Procedure OuvreDialogGr(Var LeDialog : DialogRecGr);

Var
  S : TypeSauveGr;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  with LeDialog do
  Begin
    Taille := imagesize(X,Y,X + Larg,Y + Haut);
    if not ReserveMem(Donnees,Taille) then PlusDeMemoireGr;
    SauveRectGr (X,Y,X + Larg,Y + Haut,Donnees);
    if Tip in [OmbreSs,Ombre1,Ombre2,Ombre3,Ombre4]
       then BoiteGr(X,Y,Larg - OmbreBoite,Haut - OmbreBoite,Tip,Coul,true)
       else BoiteGr(X,Y,Larg,Haut,Tip,Coul,true);
    if length(Titre) > 0 then CentreTitreGr(LeDialog);
  End;
  RestaureGr(S);
End;

{}

Procedure FermeDialogGr(Var LeDialog : DialogRecGr);

Var
  S : TypeSauveGr;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  with LeDialog do
  Begin
    LitRectGr(X, Y, X + Larg, Y + Haut,Donnees);
    freemem(Donnees,Taille);
    Donnees := nil;
  End;
  RestaureGr(S);
End;

{}

Procedure OuvreDialogReliefGr(Var LeDialog : DialogReliefRecGr);

Var
  S : TypeSauveGr;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  with LeDialog do
  Begin
    Taille := imagesize(X,Y,X + Larg,Y + Haut);
    if not ReserveMem(Donnees,Taille) then PlusDeMemoireGr;
    SauveRectGr (X,Y,X + Larg,Y + Haut,Donnees);
    BoiteReliefGr(X,Y,Larg,Haut,Tip,Coul,true);
  End;
  RestaureGr(S);
End;

{}

Procedure FermeDialogReliefGr(Var LeDialog : DialogReliefRecGr);

Var
  S : TypeSauveGr;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  with LeDialog do
  Begin
    LitRectGr(X, Y, X + Larg, Y + Haut,Donnees);
    freemem(Donnees,Taille);
    Donnees := nil;
  End;
  RestaureGr(S);
End;

{}

Procedure AlarmeGr(PosY : integer;Lalarme : AlarmeRec);

Var
  Dialogue : DialogRecGr;
  S        : TypeSauveGr;
  N        : byte;
  Largeur  : integer;            { largeur du dialogue }
  Hauteur  : integer;            { hauteur du dialogue }
  NbLarg   : byte;               { nombre de caracteres de large }
  NbHaut   : byte;               { nombre de lignes }
  YTmp     : integer;
  Fenetre  : ViewPortType;
  LeCar    : char;
  InfoSouris : PosRec;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  with Dialogue do
  Begin
    Tip := Ombre2;
    Coul := CoulAlarme;
    Titre := '';
    CoulFondGr(Coul.Fond);
    CoulEncreGr(Coul.Encre);
  End;
  NbLarg := 0;
  NbHaut := 0;
  for N := 1 to 4 do
  Begin
    if length(Lalarme[N]) > 74 then Lalarme[N] := copy(Lalarme[N],1,74);
    if length(Lalarme[N]) > NbLarg then NbLarg := length(Lalarme[N]);
    if length(Lalarme[N]) > 0 then inc(NbHaut);
  End;
  if TempoAlarme = 0 then
     if (length(LigneSuite) + 2) > NbLarg then
        NbLarg := length(LigneSuite) + 2;
  Hauteur := NbHaut * HautCarGr;
  Largeur := NbLarg * LargCarGr;
  if Hauteur > 0 then
  Begin
    if PosY = 0 then CentreDialogGr(Largeur,Hauteur,Dialogue)
    else
    Begin
      CalculLargDialogGr(Largeur,Dialogue);
      CalculHautDialogGr(Hauteur,Dialogue);
      CalculXDialogGr(Dialogue);
      GetViewSettings(Fenetre);
      with Fenetre do
        if (PosY + Dialogue.Haut) < (Y2 - Y1) then Dialogue.Y := PosY
           else Dialogue.Y := (Y2 - Y1) - Dialogue.Haut;
    End;
    OuvreDialogGr(Dialogue);
    YTmp := Dialogue.Y;
    for N := 1 to 4 do
      if length(Lalarme[N]) > 0 then
      Begin
        YTmp := YTmp + HautCarGr;
        CentreTexteGr(YTmp,Lalarme[N]);
      End;
    YTmp := YTmp + HautCarGr;
    if FaitBip then
    Begin
      sound(600);
      delay(50);
      sound(400);
      delay(50);
      nosound;
    End;
    if TempoAlarme = 0 then
    Begin
      CentreTexteGr(YTmp,LigneSuite);
(*      repeat
        AppelTache;
      until keypressed;
      readkey;*)
      if AttendActionGr(LeCar,InfoSouris) then ;
    End
    else delay(TempoAlarme * NbLarg * NbHaut);
    FermeDialogGr(Dialogue);
  End;
  RestaureGr(S);
End;

{}

Procedure AlarmeReliefGr(PosY : integer;Lalarme : AlarmeRec);

Var
  Dialogue : DialogReliefRecGr;
  S        : TypeSauveGr;
  NbLarg   : byte;               { nombre de caracteres de large }
  NbHaut   : byte;               { nombre de lignes }
  YTmp     : integer;
  Fenetre  : ViewPortType;
  LeCar    : char;
  InfoSouris : PosRec;

  (**)
  Procedure CalculDimension;

  Var
    N : byte;

  Begin
    NbLarg := 0;
    NbHaut := 0;
    for N := 1 to 4 do
    Begin
      if length(Lalarme[N]) > NbLarg then NbLarg := length(Lalarme[N]);
      if length(Lalarme[N]) > 0 then inc(NbHaut);
    End;
    if TempoAlarme = 0 then
      if (length(LigneSuite) + 2) > NbLarg then
      Begin
        NbLarg := length(LigneSuite) + 2;
        inc(NbHaut);
        inc(NbHaut);
      End;
  End;

  (**)
  Procedure CalculDialogue;

  Begin
    Dialogue.Haut := NbHaut * HautCarGr;
    Dialogue.Larg := NbLarg * LargCarGr;
    if PosY = 0 then CentreDialogReliefGr(Dialogue)
    else
    Begin
      AjusteLargeurDialogReliefGr(Dialogue);
      AjusteHauteurDialogReliefGr(Dialogue);
      CalculXDialogReliefGr(Dialogue);
      GetViewSettings(Fenetre);
      with Fenetre do
        if (PosY + Dialogue.Haut) < (Y2 - Y1) then Dialogue.Y := PosY
           else Dialogue.Y := (Y2 - Y1) - Dialogue.Haut;
    End;
  End;

  (**)
  Procedure AfficheMessage;

  Var
    N : byte;

  Begin
    YTmp := Dialogue.Y + RayonRelief;
    for N := 1 to 4 do
      if length(Lalarme[N]) > 0 then
      Begin
        CentreTexteGr(YTmp,Lalarme[N]);
        YTmp := YTmp + HautCarGr;
      End;
  End;

  (**)

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  with Dialogue do
  Begin
    Tip := Relief;
    Coul := CoulAlarme;
    Titre := '';
  End;
  CalculDimension;
  if NbHaut > 0 then
  Begin
    CalculDialogue;
    OuvreDialogReliefGr(Dialogue);
    with Dialogue do
    Begin
      CoulFondGr(Coul.Fond);
      CoulEncreGr(Coul.Encre);
    End;
    AfficheMessage;
    if FaitBip then
    Begin
      sound(600);
      delay(50);
      sound(400);
      delay(50);
      nosound;
    End;
    if TempoAlarme = 0 then
    Begin
      YTmp := YTmp + HautCarGr;
      CentreTexteGr(YTmp,LigneSuite);
(*      repeat
        AppelTache;
      until keypressed;
      readkey;*)
      if AttendActionGr(LeCar,InfoSouris) then ;
    End
    else delay(TempoAlarme * NbLarg * NbHaut);
    FermeDialogReliefGr(Dialogue);
  End;
  RestaureGr(S);
End;

{}

Function BoiteChaineGr(Var Dialogue : DialogRecGr;Long : byte
                                                    ; Autre : boolean): char;

Var
  Largeur : byte;                { largeur du dialogue }
  Hauteur : byte;                { hauteur du dialogue }
  Tmp     : char;
  PosX    : integer;

Begin
  with Dialogue do
  Begin
    Largeur := length(Titre) + 2;
    if Largeur < (Long + 4) then Largeur := Long + 4;
    Hauteur := 3;
    Largeur := Largeur * LargCarGr;
    Hauteur := Hauteur * HautCarGr;
    CalculLargDialogGr(Largeur,Dialogue);
    CalculHautDialogGr(Hauteur,Dialogue);
    if X = 0 then CalculXDialogGr(Dialogue);
    if Y = 0 then CalculYDialogGr(Dialogue);
    Coul := CoulBtSaisie;
  End;
  OuvreDialogGr(Dialogue);
  with Dialogue do
  Begin
    if Tip in [OmbreSs,Ombre1,Ombre2,Ombre3,Ombre4] then
      PosX := X + (Larg - OmbreBoite) div 2 - ((Long div 2) + 1) * LargCarGr
    else
      PosX := X + (Larg div 2) - ((Long div 2) + 1) * LargCarGr;
    (*Tmp := SaisieGr(PosX,Y + 2 * HautCarGr,Long,Chaine,Utiliser,Autre);*)
    Tmp := SaisieGr(PosX,Y+HautCarGr+HautCarGr,Long,Chaine,Utiliser,Autre);
  End;
  FermeDialogGr(Dialogue);
  BoiteChaineGr := Tmp;
End;

{}

Function BoiteChaineReliefGr(Var Dialogue : DialogReliefRecGr;
                                         Long : byte; Autre : boolean): char;

Var
  Largeur : byte;                { largeur du dialogue }
  Hauteur : byte;                { hauteur du dialogue }
  Tmp     : char;
  PosX    : integer;

Begin
  with Dialogue do
  Begin
    Largeur := length(Titre) + 2;
    if Largeur < (Long + 4) then Largeur := Long + 4;
    Hauteur := 3;
    Larg := Largeur * LargCarGr;
    Haut := Hauteur * HautCarGr;
    AjusteLargeurDialogReliefGr(Dialogue);
    AjusteHauteurDialogreliefGr(Dialogue);
    if X = 0 then CalculXDialogReliefGr(Dialogue);
    if Y = 0 then CalculYDialogReliefGr(Dialogue);
    Coul := CoulBtSaisie;
  End;
  OuvreDialogReliefGr(Dialogue);
  CentreTitreReliefGr(Dialogue);
  with Dialogue do
  Begin
    PosX := X + (Larg div 2) - ((Long div 2)  + 1) * LargCarGr;
    (*Tmp := SaisieGr(PosX,Y +  2 * HautCarGr + RayonRelief,
           Long,Chaine,Utiliser,Autre);*)
    Tmp := SaisieGr(PosX,Y + HautCarGr + HautCarGr + RayonRelief,
           Long,Chaine,Utiliser,Autre);
  End;
  FermeDialogReliefGr(Dialogue);
  BoiteChaineReliefGr := Tmp;
End;

{}

Function BoiteEntierGr(Var Dialogue : DialogRecGr;Long : byte;
                                   Min,Max : longint; Autre : boolean): char;

Var
  S       : TypeSauveGr;
  Largeur : integer;             { largeur du dialogue }
  Hauteur : integer;             { hauteur du dialogue }
  Tmp     : char;                { Caractere temporaire }
  PosX    : integer;             { Position en X de la saisie }
  Ok      : boolean;
  Message : Str80;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  Message := ' ' + IntToStr(Min) + ' ... ' + IntToStr(Max) + ' ';
  with Dialogue do
  Begin
    Largeur := length(Titre) + 2;
    if Largeur < length(Message) + 2 then Largeur := length(Message) + 2 ;
    if Largeur < (Long + 4) then Largeur := Long + 4;
    Hauteur := 3;
    Largeur := Largeur * LargCarGr;
    Hauteur := Hauteur * HautCarGr;
    CalculLargDialogGr(Largeur,Dialogue);
    CalculHautDialogGr(Hauteur,Dialogue);
    if X = 0 then CalculXDialogGr(Dialogue);
    if Y = 0 then CalculYDialogGr(Dialogue);
    Coul := CoulBtSaisie;
  End;
  OuvreDialogGr(Dialogue);
  with Dialogue do
  Begin
    CoulFondGr(Coul.Fond);
    CoulEncreGr(Coul.Encre);
    PosX := X + (Larg div 2) - ((length(Message) div 2) * LargCarGr);
    GotoXYGr(PosX,Y + 4 * HautCarGr);
    WriteGr(Message);
    if Tip in [OmbreSs,Ombre1,Ombre2,Ombre3,Ombre4] then
      PosX := X + (Larg - OmbreBoite) div 2 - ((Long div 2) + 1) * LargCarGr
    else
      PosX := X + (Larg div 2) - ((Long div 2) + 1) * LargCarGr;
    repeat
      (*Tmp := SaisieGr(PosX,Y + 2 * HautCarGr,Long,Entier,Utiliser,Autre);*)
      Tmp := SaisieGr(PosX,Y+HautCarGr+HautCarGr,Long,Entier,Utiliser,Autre);
      if not ((UnEntier >= Min) and (UnEntier <= Max)) then Beep;
      Ok := (Tmp = CarEsc) or Sortie;
    until (((UnEntier >= Min) and (UnEntier <= Max))) or  Ok;
  End;
  FermeDialogGr(Dialogue);
  RestaureGr(S);
  BoiteEntierGr := Tmp;
End;

{}

Function BoiteEntierReliefGr(Var Dialogue : DialogReliefRecGr;Long : byte;
                                   Min,Max : longint; Autre : boolean): char;

Var
  S       : TypeSauveGr;
  Largeur : integer;             { largeur du dialogue }
  Hauteur : integer;             { hauteur du dialogue }
  Tmp     : char;                { Caractere temporaire }
  PosX    : integer;             { Position en X de la saisie }
  PosY    : integer;
  Ok      : boolean;
  Message : Str80;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  Message := ' ' + IntToStr(Min) + ' ... ' + IntToStr(Max) + ' ';
  with Dialogue do
  Begin
    Largeur := length(Titre) + 2;
    if Largeur < length(Message) + 2 then Largeur := length(Message) + 2 ;
    if Largeur < (Long + 4) then Largeur := Long + 4;
    Hauteur := 4;
    Larg := Largeur * LargCarGr;
    Haut := Hauteur * HautCarGr;
    AjusteLargeurDialogReliefGr(Dialogue);
    AjusteHauteurDialogReliefGr(Dialogue);
    if X = 0 then CalculXDialogReliefGr(Dialogue);
    if Y = 0 then CalculYDialogReliefGr(Dialogue);
    Coul := CoulBtSaisie;
  End;
  OuvreDialogReliefGr(Dialogue);
  CentreTitreReliefGr(Dialogue);
  with Dialogue do
  Begin
    CoulFondGr(Coul.Fond);
    CoulEncreGr(Coul.Encre);
    PosX := X + (Larg div 2) - ((length(Message) div 2) * LargCarGr);
    PosY := Y + RayonRelief + 3 * HautCarGr;
    GotoXYGr(PosX,PosY);
    WriteGr(Message);
    PosX := X + (Larg div 2) - ((Long div 2) + 1) * LargCarGr;
    PosY := Y + RayonRelief + HautCarGr + (HautCarGr div 2);
    repeat
      Tmp := SaisieGr(PosX,PosY,Long,Entier,Utiliser,Autre);
      if not ((UnEntier >= Min) and (UnEntier <= Max)) then Beep;
      Ok := (Tmp = CarEsc) or Sortie;
    until (((UnEntier >= Min) and (UnEntier <= Max))) or  Ok;
  End;
  FermeDialogReliefGr(Dialogue);
  RestaureGr(S);
  BoiteEntierReliefGr := Tmp;
End;

{}

Function BoiteReelGr(Var Dialogue : DialogRecGr;Long : byte;
                                      Min,Max : real; Autre : boolean): char;

Var
  S       : TypeSauveGr;
  Largeur : integer;             { largeur du dialogue }
  Hauteur : integer;             { hauteur du dialogue }
  Tmp     : char;                { Caractere temporaire }
  PosX    : integer;             { Position en X de la saisie }
  Ok      : boolean;
  Message : Str80;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  Message := ' ' + RealToStr(Min,LongStd,PrecisStd) + ' ... ' +
                   RealToStr(Max,LongStd,PrecisStd) + ' ';
  with Dialogue do
  Begin
    Largeur := length(Titre) + 2;
    if Largeur < length(Message) + 2 then Largeur := length(Message) + 2 ;
    if Largeur < (Long + 4) then Largeur := Long + 4;
    Hauteur := 3;
    Largeur := Largeur * LargCarGr;
    Hauteur := Hauteur * HautCarGr;
    CalculLargDialogGr(Largeur,Dialogue);
    CalculHautDialogGr(Hauteur,Dialogue);
    if X = 0 then CalculXDialogGr(Dialogue);
    if Y = 0 then CalculYDialogGr(Dialogue);
    Coul := CoulBtSaisie;
  End;
  OuvreDialogGr(Dialogue);
  with Dialogue do
  Begin
    CoulFondGr(Coul.Fond);
    CoulEncreGr(Coul.Encre);
    PosX := X + (Larg div 2) - (length(Message) div 2) * LargCarGr;
    GotoXYGr(PosX,Y + 4 * HautCarGr);
    WriteGr(Message);
    if Tip in [OmbreSs,Ombre1,Ombre2,Ombre3,Ombre4] then
      PosX := X + (Larg - OmbreBoite) div 2 - ((Long div 2) + 1) * LargCarGr
    else
      PosX := X + (Larg div 2) - ((Long div 2) + 1) * LargCarGr;
    repeat
      (*Tmp := SaisieGr(PosX,Y + 2 * HautCarGr,Long,Reel,Utiliser,Autre);*)
      Tmp := SaisieGr(PosX,Y+HautCarGr+HautCarGr,Long,Reel,Utiliser,Autre);
      if not ((UnReel >= Min) and (UnReel <= Max)) then Beep;
      Ok := (Tmp = CarEsc) or Sortie;
    until (((UnReel >= Min) and (UnReel <= Max))) or  Ok;
  End;
  FermeDialogGr(Dialogue);
  RestaureGr(S);
  BoiteReelGr := Tmp;
End;

{}

Function BoiteReelReliefGr(Var Dialogue : DialogReliefRecGr;Long : byte;
                                      Min,Max : real; Autre : boolean): char;

Var
  S       : TypeSauveGr;
  Largeur : integer;             { largeur du dialogue }
  Hauteur : integer;             { hauteur du dialogue }
  Tmp     : char;                { Caractere temporaire }
  PosX    : integer;             { Position en X de la saisie }
  PosY    : integer;
  Ok      : boolean;
  Message : Str80;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  Message := ' ' + RealToStr(Min,LongStd,PrecisStd) + ' ... ' +
                   RealToStr(Max,LongStd,PrecisStd) + ' ';
  with Dialogue do
  Begin
    Largeur := length(Titre) + 2;
    if Largeur < length(Message) + 2 then Largeur := length(Message) + 2 ;
    if Largeur < (Long + 4) then Largeur := Long + 4;
    Hauteur := 4;
    Larg := Largeur * LargCarGr;
    Haut := Hauteur * HautCarGr;
    AjusteLargeurDialogReliefGr(Dialogue);
    AjusteHauteurDialogReliefGr(Dialogue);
    if X = 0 then CalculXDialogReliefGr(Dialogue);
    if Y = 0 then CalculYDialogReliefGr(Dialogue);
    Coul := CoulBtSaisie;
  End;
  OuvreDialogReliefGr(Dialogue);
  CentreTitreReliefGr(Dialogue);
  with Dialogue do
  Begin
    CoulFondGr(Coul.Fond);
    CoulEncreGr(Coul.Encre);
    PosX := X + (Larg div 2) - (length(Message) div 2) * LargCarGr;
    PosY := Y + RayonRelief + 3 * HautCarGr;
    GotoXYGr(PosX,PosY);
    WriteGr(Message);
    PosX := X + (Larg div 2) - ((Long div 2) + 1) * LargCarGr;
    PosY := Y + RayonRelief + HautCarGr + (HautCarGr div 2);
    repeat
      Tmp := SaisieGr(PosX,PosY,Long,Reel,Utiliser,Autre);
      if not ((UnReel >= Min) and (UnReel <= Max)) then Beep;
      Ok := (Tmp = CarEsc) or Sortie;
    until (((UnReel >= Min) and (UnReel <= Max))) or  Ok;
  End;
  FermeDialogReliefGr(Dialogue);
  RestaureGr(S);
  BoiteReelReliefGr := Tmp;
End;

{}

Function BoiteBoutGr(Var Dialogue : DialogRecGr;Bout1, Bout2 : Str80): char;

Var
  S          : TypeSauveGr;
  Largeur    : integer;          { largeur du dialogue }
  Hauteur    : integer;          { hauteur du dialogue }
  XBouton1   : integer;          { position en X du bouton 1 }
  XBouton2   : integer;          { position en X du bouton 2 }
  PosTxBt1   : CoinRectangle;    { position du texte du bouton 1 }
  PosTxBt2   : CoinRectangle;    { position du texte du bouton 2 }
  Bouton1    : boolean;          { bouton 1 enclenche ? }
  Fin        : boolean;          { une donnee vient d'etre validee }
  Abandon    : boolean;          { demande d'abandon }
  LeCar      : char;             { caractere venant d'etre frappe }
  InfoSouris : PosRec;           { position souris lors du dernier clic }
  XTmp       : integer;          { position temporaire en X }
  YTmp       : integer;          { position temporaire en Y }
  Tmp        : integer;          { valeur temporaire }

  (**)
  Procedure DefiniDialogue;

  Begin
    with Dialogue do
    Begin
      Largeur := length(Bout1) + length(Bout2) + 7;
      if Largeur < (length(Titre) + 2) then Largeur := length(Titre) + 2;
      Hauteur := 3;
      Largeur := Largeur * LargCarGr;
      Hauteur := Hauteur * HautCarGr;
      CalculLargDialogGr(Largeur,Dialogue);
      CalculHautDialogGr(Hauteur,Dialogue);
      if X = 0 then CalculXDialogGr(Dialogue);
      if Y = 0 then CalculYDialogGr(Dialogue);
      Coul := CoulBtSaisie;
      Tmp := Larg - (length(Bout1) + length(Bout2) + 4) * LargCarGr;
      Tmp := Tmp div 3;
      XBouton1 := X +  Tmp;
      (*XBouton2 := X + (length(Bout1) + 1) * LargCarGr + (2 * Tmp);*)
      XBouton2 := X + (length(Bout1) + 1) * LargCarGr + Tmp + Tmp;
      with PosTxBt1 do
      Begin
        X1 := XBouton1 + LargCarGr;
        (*Y1 := Y + 2 * HautCarGr;*)
        Y1 := Y + HautCarGr + HautCarGr;
        X2 := X1 + length(Bout1) * LargCarGr;
        Y2 := Y1;
      End;
      with PosTxBt2 do
      Begin
        X1 := XBouton2 + LargCarGr;
        (*Y1 := Y + 2 * HautCarGr;*)
        Y1 := Y + HautCarGr + HautCarGr;
        X2 := X1 + length(Bout2) * LargCarGr;
        Y2 := Y1;
      End;
    End;
  End;

  (**)
  Procedure AfficheBouton1;

  Var
    S1      : TypeSauveGr;
    X1Tmp   : integer;
    Y1Tmp   : integer;
    LargTmp : integer;
    HautTmp : integer;

  Begin
    SauvegardeGr(S1);
    CacheSouris;
    with Dialogue do
    Begin
      X1Tmp := XBouton1 - HCadreBoite;
      Y1Tmp := Y + HautCarGr;
      (*LargTmp := (length(Bout1) + 2) * LargCarGr + 2 * HCadreBoite;
      HautTmp := HautCarGr + 2 * HCadreBoite;*)
      LargTmp := (length(Bout1) + 2) * LargCarGr + HCadreBoite + HCadreBoite;
      HautTmp := HautCarGr + HCadreBoite + HCadreBoite;
      BoiteGr(X1Tmp,Y1Tmp,LargTmp,HautTmp,Cadre2,CoulBoutonChoix,true);
      CoulFondGr(CoulBoutonChoix.Fond);
      CoulEncreGr(CoulBoutonChoix.Encre);
      (*GotoXYGr(XBouton1 + LargCarGr,Y + 2 * HautCarGr);*)
      GotoXYGr(XBouton1 + LargCarGr,Y + HautCarGr + HautCarGr);
      WriteGr(Bout1);
      (*InverseGr(XBouton1 + LargCarGr,Y + 2 * HautCarGr,
               XBouton1 + (length(Bout1) + 1) * LargCarGr,Y + 3 * HautCarGr);*)
      InverseGr(XBouton1 + LargCarGr,Y + HautCarGr + HautCarGr,
               XBouton1 + (length(Bout1) + 1) * LargCarGr,Y + 3 * HautCarGr);
      X1Tmp := XBouton2 - HCadreBoite;
      Y1Tmp := Y + HautCarGr;
      (*LargTmp := (length(Bout2) + 2) * LargCarGr + 2 * HCadreBoite;
      HautTmp := HautCarGr + 2 * HCadreBoite;*)
      LargTmp := (length(Bout2) + 2) * LargCarGr + HCadreBoite + HCadreBoite;
      HautTmp := HautCarGr + HCadreBoite + HCadreBoite;
      BoiteGr(X1Tmp,Y1Tmp,LargTmp,HautTmp,Cadre1,CoulBoutonChoix,true);
      CoulFondGr(CoulBoutonChoix.Fond);
      CoulEncreGr(CoulBoutonChoix.Encre);
      (*GotoXYGr(XBouton2 + LargCarGr,Y + 2 * HautCarGr);*)
      GotoXYGr(XBouton2 + LargCarGr,Y + HautCarGr + HautCarGr);
      WriteGr(Bout2);
    End;
    RestaureGr(S1);
  End;

  (**)
  Procedure AfficheBouton2;

  Var
    S1      : TypeSauveGr;
    X1Tmp   : integer;
    Y1Tmp   : integer;
    LargTmp : integer;
    HautTmp : integer;

  Begin
    SauvegardeGr(S1);
    CacheSouris;
    with Dialogue do
    Begin
      X1Tmp := XBouton1 - HCadreBoite;
      Y1Tmp := Y + HautCarGr;
      (*LargTmp := (length(Bout1) + 2) * LargCarGr + 2 * HCadreBoite;
      HautTmp := HautCarGr + 2 * HCadreBoite;*)
      LargTmp := (length(Bout1) + 2) * LargCarGr + HCadreBoite + HCadreBoite;
      HautTmp := HautCarGr + HCadreBoite + HCadreBoite;
      BoiteGr(X1Tmp,Y1Tmp,LargTmp,HautTmp,Cadre1,CoulBoutonChoix,true);
      CoulFondGr(CoulBoutonChoix.Fond);
      CoulEncreGr(CoulBoutonChoix.Encre);
      (*GotoXYGr(XBouton1 + LargCarGr,Y + 2 * HautCarGr);*)
      GotoXYGr(XBouton1 + LargCarGr,Y + HautCarGr + HautCarGr);
      WriteGr(Bout1);
      X1Tmp := XBouton2 - HCadreBoite;
      Y1Tmp := Y + HautCarGr;
      (*LargTmp := (length(Bout2) + 2) * LargCarGr + 2 * HCadreBoite;
      HautTmp := HautCarGr + 2 * HCadreBoite;*)
      LargTmp := (length(Bout2) + 2) * LargCarGr + HCadreBoite + HCadreBoite;
      HautTmp := HautCarGr + HCadreBoite + HCadreBoite;
      BoiteGr(X1Tmp,Y1Tmp,LargTmp,HautTmp,Cadre2,CoulBoutonChoix,true);
      CoulFondGr(CoulBoutonChoix.Fond);
      CoulEncreGr(CoulBoutonChoix.Encre);
      (*GotoXYGr(XBouton2 + LargCarGr,Y + 2 * HautCarGr);*)
      GotoXYGr(XBouton2 + LargCarGr,Y + HautCarGr + HautCarGr);
      WriteGr(Bout2);
      (*InverseGr(XBouton2 + LargCarGr,Y + 2 * HautCarGr,
               XBouton2 + (length(Bout1) + 1) * LargCarGr,Y + 3 * HautCarGr);*)
      InverseGr(XBouton2 + LargCarGr,Y + HautCarGr + HautCarGr,
               XBouton2 + (length(Bout1) + 1) * LargCarGr,Y + 3 * HautCarGr);
    End;
    RestaureGr(S1);
  End;

  (**)
  Procedure TesteSouris;

  Begin
    if (InfoSouris.Nombre <> 0) and
       (InfoSouris.Bouton = BoutonGauche) then
    Begin
      with PosTxBt1 do
        if SourisDsZone(XTmp,YTmp,X1,Y1,X2,Y2) then Bouton1 := true;
      with PosTxBt2 do
        if SourisDsZone(XTmp,YTmp,X1,Y1,X2,Y2) then Bouton1 := false;
      LeCar := CarReturn;
    End;
  End;

  (**)
  Procedure TesteTouche;

  Begin
    if ToucheFct then
    Begin
      case LeCar of
        FlchGauche : Bouton1 := not Bouton1;
        FlchDroite : Bouton1 := not Bouton1;
        ShiftTab   : Bouton1 := not Bouton1;
        AltX       : Begin
                       Sortie := true;
                       Abandon := true;
                     End;
        else Beep;
      end;
    End
    else
    Begin
      case LeCar of
        CarReturn : Fin := true;
        CarEsc    : Abandon := true;
        Tab       : Bouton1 := not Bouton1;
        else Beep;
      end;
    End;
  End;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  MontreSouris;
  DefiniDialogue;
  OuvreDialogGr(Dialogue);
  Bouton1 := true;
  AfficheBouton1;
  Fin := false;
  Abandon := false;
  repeat
    if AttendActionGr(LeCar,InfoSouris) then
    Begin
      XTmp := InfoSouris.Colonne;
      YTmp := InfoSouris.Ligne;
    End;
    TesteSouris;
    TesteTouche;
    if Bouton1 then AfficheBouton1
               else AfficheBouton2;
  until Fin or Abandon;
  if Fin and Bouton1 then BoiteBoutGr := '1';
  if Fin and not Bouton1 then BoiteBoutGr := '2';
  if Abandon then BoiteBoutGr := LeCar;
  delay(100);
  FermeDialogGr(Dialogue);
  RestaureGr(S);
End;

{}

Function BoiteBoutReliefGr(Var Dialogue : DialogReliefRecGr;
                                                 Bout1, Bout2 : Str80): char;

Var
  S          : TypeSauveGr;
  Largeur    : integer;          { largeur du dialogue }
  Hauteur    : integer;          { hauteur du dialogue }
  XBouton1   : integer;          { position en X du bouton 1 }
  XBouton2   : integer;          { position en X du bouton 2 }
  Bouton1Gr  : BoutonReliefRecGr;{ definition du bouton 1 }
  Bouton2Gr  : BoutonReliefRecGr;{ definition du bouton 2 }
  Bouton1    : boolean;          { bouton 1 enclenche ? }
  Fin        : boolean;          { une donnee vient d'etre validee }
  Abandon    : boolean;          { demande d'abandon }
  LeCar      : char;             { caractere venant d'etre frappe }
  InfoSouris : PosRec;           { position souris lors du dernier clic }
  XTmp       : integer;          { position temporaire en X }
  YTmp       : integer;          { position temporaire en Y }
  Tmp        : integer;          { valeur temporaire }

  (**)
  Procedure DefiniDialogue;

  Begin
    Bout1 := ' ' + Bout1 + ' ';
    Bout2 := ' ' + Bout2 + ' ';
    with Dialogue do
    Begin
      Largeur := length(Bout1) + length(Bout2) + 7;
      if Largeur < (length(Titre) + 2) then Largeur := length(Titre) + 2;
      Hauteur := 3;
      Larg := Largeur * LargCarGr;
      Haut := Hauteur * HautCarGr;
      AjusteLargeurDialogReliefGr(Dialogue);
      AjusteHauteurDialogReliefGr(Dialogue);
      if X = 0 then CalculXDialogReliefGr(Dialogue);
      if Y = 0 then CalculYDialogReliefGr(Dialogue);
      Coul := CoulBtSaisie;
      Tmp := Larg - (length(Bout1) + length(Bout2)) * LargCarGr;
      Tmp := Tmp div 3;
    End;
    with Bouton1Gr do
    Begin
      X := Dialogue.X + Tmp;
      (*Y := Dialogue.Y + RayonRelief + 2 * HautCarGr;*)
      Y := Dialogue.Y + RayonRelief + HautCarGr + HautCarGr;
      Larg := length(Bout1);
      Texte := Bout1;
      Tip := Normale;
    End;
    with Bouton2Gr do
    Begin
      (*X := Dialogue.X + 2 * Tmp + Bouton1Gr.Larg * LargCarGr;
      Y := Dialogue.Y + RayonRelief + 2 * HautCarGr;*)
      X := Dialogue.X + Tmp + Tmp + Bouton1Gr.Larg * LargCarGr;
      Y := Dialogue.Y + RayonRelief + HautCarGr + HautCarGr;
      Larg := length(Bout2);
      Texte := Bout2;
      Tip := Normale;
    End;
  End;

  (**)
  Procedure AfficheBouton1;

  Var
    S1      : TypeSauveGr;

  Begin
    SauvegardeGr(S1);
    CacheSouris;
    Bouton1Gr.Tip := Creux;
    Bouton2Gr.Tip := Normale;
    BoutonReliefGr(Bouton1Gr,true);
    BoutonReliefGr(Bouton2Gr,false);
    RestaureGr(S1);
  End;

  (**)
  Procedure AfficheBouton2;

  Var
    S1      : TypeSauveGr;
    X1Tmp   : integer;
    Y1Tmp   : integer;
    LargTmp : integer;
    HautTmp : integer;

  Begin
    SauvegardeGr(S1);
    CacheSouris;
    Bouton1Gr.Tip := Normale;
    Bouton2Gr.Tip := Creux;
    BoutonReliefGr(Bouton1Gr,false);
    BoutonReliefGr(Bouton2Gr,true);
    RestaureGr(S1);
  End;

  (**)
  Procedure TesteSouris;

  Begin
    if (InfoSouris.Nombre <> 0) and
       (InfoSouris.Bouton = BoutonGauche) then
    Begin
      if SourisDsBoutonReliefGr(XTmp,YTmp,Bouton1Gr) then Bouton1 := true;
      if SourisDsBoutonReliefGr(XTmp,YTmp,Bouton2Gr) then Bouton1 := false;
      LeCar := CarReturn;
    End;
  End;

  (**)
  Procedure TesteTouche;

  Begin
    if ToucheFct then
    Begin
      case LeCar of
        FlchGauche : Bouton1 := not Bouton1;
        FlchDroite : Bouton1 := not Bouton1;
        ShiftTab   : Bouton1 := not Bouton1;
        AltX       : Begin
                       Sortie := true;
                       Abandon := true;
                     End;
        else Beep;
      end;
    End
    else
    Begin
      case LeCar of
        CarReturn : Fin := true;
        CarEsc    : Abandon := true;
        Tab       : Bouton1 := not Bouton1;
        else Beep;
      end;
    End;
  End;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  MontreSouris;
  DefiniDialogue;
  OuvreDialogReliefGr(Dialogue);
  CentreTitreReliefGr(Dialogue);
  Bouton1 := true;
  AfficheBouton1;
  Fin := false;
  Abandon := false;
  repeat
    if AttendActionGr(LeCar,InfoSouris) then
    Begin
      XTmp := InfoSouris.Colonne;
      YTmp := InfoSouris.Ligne;
    End;
    TesteSouris;
    TesteTouche;
    if Bouton1 then AfficheBouton1
               else AfficheBouton2;
  until Fin or Abandon;
  if Fin and Bouton1 then BoiteBoutReliefGr := '1';
  if Fin and not Bouton1 then BoiteBoutReliefGr := '2';
  if Abandon then BoiteBoutReliefGr := LeCar;
  delay(100);
  FermeDialogReliefGr(Dialogue);
  RestaureGr(S);
End;

{}

Function BoiteChoixCtrlGr(Var Dialogue : DialogRecGr;
   Var ChoixCtrl : ChoixCtrlRecGr;Var Liste : ListeRec;Autre : boolean):char;

Var
  S            : TypeSauveGr;
  Largeur      : integer;        { Largeur du dialogue }
  Hauteur      : integer;        { Hauteur du dialogue }
  LargeurListe : byte;           { Largeur de la liste }
  Tmp          : char;           { Caractere temporaire }

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  with Dialogue do
  Begin
    ChoixCtrlGr(ChoixCtrl,Liste,Initialiser,Autre);
    Largeur := length(Titre) + 2;
    LargeurListe := ChoixCtrl.Larg;
    if (LargeurListe + 3) > Largeur then Largeur := LargeurListe + 3;
    Hauteur := ChoixCtrl.Haut;
    Largeur := Largeur * LargCarGr;
    Hauteur := Hauteur * HautcarGr;
    CalculLargDialogGr(Largeur,Dialogue);
    CalculHautDialogGr(Hauteur,Dialogue);
    if X = 0 then CalculXDialogGr(Dialogue);
    if Y = 0 then CalculYDialogGr(Dialogue);
    Coul := CoulBtSaisie;
  End;
  OuvreDialogGr(Dialogue);
  with Dialogue do
  Begin
    CoulFondGr(Coul.Fond);
    CoulEncreGr(Coul.Encre);
    ChoixCtrl.X := X + (Largeur div 2)
                   - (LargeurListe * LargCarGr div 2) + HCadreBoite;
    ChoixCtrl.Y := Y + HCadreBoite;
    Tmp := ChoixCtrlGr(ChoixCtrl,Liste,Utiliser,Autre);
  End;
  Delay(100);
  FermeDialogGr(Dialogue);
  RestaureGr(S);
  BoiteChoixCtrlGr := Tmp;
End;

{}

Function BoiteChoixCtrlReliefGr(Var Dialogue : DialogReliefRecGr;
   Var ChoixCtrl : ChoixCtrlRecGr;Var Liste : ListeRec;Autre : boolean):char;

Var
  S            : TypeSauveGr;
  Largeur      : integer;        { Largeur du dialogue }
  Hauteur      : integer;        { Hauteur du dialogue }
  LargeurListe : byte;           { Largeur de la liste }
  Tmp          : char;           { Caractere temporaire }

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  with Dialogue do
  Begin
    ChoixCtrlGr(ChoixCtrl,Liste,Initialiser,Autre);
    Largeur := length(Titre) + 2;
    LargeurListe := ChoixCtrl.Larg;
    if (LargeurListe + 3) > Largeur then Largeur := LargeurListe + 3;
    Hauteur := ChoixCtrl.Haut + 2;
    Larg := Largeur * LargCarGr;
    Haut := Hauteur * HautcarGr;
    AjusteLargeurDialogReliefGr(Dialogue);
    AjusteHauteurDialogReliefGr(Dialogue);
    if X = 0 then CalculXDialogReliefGr(Dialogue);
    if Y = 0 then CalculYDialogReliefGr(Dialogue);
    Coul := CoulBtSaisie;
  End;
  OuvreDialogReliefGr(Dialogue);
  CentreTitreReliefGr(Dialogue);
  with Dialogue do
  Begin
    CoulFondGr(Coul.Fond);
    CoulEncreGr(Coul.Encre);
    ChoixCtrl.X := X + (Larg div 2) - (LargeurListe * LargCarGr div 2);
    ChoixCtrl.Y := Y + RayonRelief + HautCarGr + HautCarGr div 2;
    Tmp := ChoixCtrlGr(ChoixCtrl,Liste,Utiliser,Autre);
  End;
  Delay(100);
  FermeDialogReliefGr(Dialogue);
  RestaureGr(S);
  BoiteChoixCtrlReliefGr := Tmp;
End;

{}

Function BoiteChoixFichierGr(Var Dialogue : DialogRecGr;Var ChoixFic :
               ChoixFicRecGr;Var UnRepertoire : NomRep;Var UnMasque : NomFic;
                                                       Autre : boolean):char;

Var
  S            : TypeSauveGr;
  Largeur      : integer;        { Largeur du dialogue }
  Hauteur      : integer;        { Hauteur du dialogue }
  Tmp          : char;           { Caractere temporaire }

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  with Dialogue do
  Begin
    Largeur := length(Titre) + 2;
    if Largeur < 20 then Largeur := 20;
    Hauteur := ChoixFic.MaxVisible + 3;
    Largeur := Largeur * LargCarGr;
    Hauteur := Hauteur * HautcarGr;
    CalculLargDialogGr(Largeur,Dialogue);
    CalculHautDialogGr(Hauteur,Dialogue);
    if X = 0 then CalculXDialogGr(Dialogue);
    if Y = 0 then CalculYDialogGr(Dialogue);
    Coul := CoulBtSaisie;
  End;
  OuvreDialogGr(Dialogue);
  with Dialogue do
  Begin
    CoulFondGr(Coul.Fond);
    CoulEncreGr(Coul.Encre);
    ChoixFic.X := X + (Largeur div 2) - (18 * LargCarGr div 2) + HCadreBoite;
    ChoixFic.Y := Y + HCadreBoite;
    Tmp := ChoixFichierGr(ChoixFic,UnRepertoire,UnMasque,Utiliser,Autre);
  End;
  Delay(100);
  FermeDialogGr(Dialogue);
  RestaureGr(S);
  BoiteChoixFichierGr := Tmp;
End;

{}

Function BoiteChoixFichierReliefGr(Var Dialogue : DialogReliefRecGr;
      Var ChoixFic:ChoixFicRecGr;Var UnRepertoire:NomRep;Var UnMasque:NomFic;
                                                       Autre : boolean):char;

Var
  S            : TypeSauveGr;
  Largeur      : integer;        { Largeur du dialogue }
  Hauteur      : integer;        { Hauteur du dialogue }
  Tmp          : char;           { Caractere temporaire }

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  with Dialogue do
  Begin
    Largeur := length(Titre) + 2;
    if Largeur < 20 then Largeur := 20;
    Hauteur := ChoixFic.MaxVisible + 5;
    Larg := Largeur * LargCarGr;
    Haut := Hauteur * HautcarGr;
    AjusteLargeurDialogReliefGr(Dialogue);
    AjusteHauteurDialogReliefGr(Dialogue);
    if X = 0 then CalculXDialogReliefGr(Dialogue);
    if Y = 0 then CalculYDialogReliefGr(Dialogue);
    Coul := CoulBtSaisie;
  End;
  OuvreDialogReliefGr(Dialogue);
  CentreTitreReliefGr(Dialogue);
  with Dialogue do
  Begin
    CoulFondGr(Coul.Fond);
    CoulEncreGr(Coul.Encre);
    ChoixFic.X := X + (Larg div 2) - (18 * LargCarGr div 2);
    ChoixFic.Y := Y + RayonRelief + HautCarGr + HautCarGr div 2;;
    Tmp := ChoixFichierGr(ChoixFic,UnRepertoire,UnMasque,Utiliser,Autre);
  End;
  Delay(100);
  FermeDialogReliefGr(Dialogue);
  RestaureGr(S);
  BoiteChoixFichierReliefGr := Tmp;
End;

{}

Procedure BoiteBarreGrapheGr(Var Dialogue : DialogRecGr;
   Var UnBarreGraphe : BarreGrapheRecGr;Valeur : longint;UneAction : Action);

Var
  S             : TypeSauveGr;
  Largeur       : integer;            { Largeur du dialogue  }
  Hauteur       : integer;            { Hauteur du dialogue  }

  (**)
  Procedure Ouverture;

  Begin
    with Dialogue do
    Begin
      Largeur := length(Titre) + 2;
      if Largeur < 12 then Largeur := 12;
      if Tip in [OmbreSs,Ombre1,Ombre2,Ombre3,Ombre4] then
         Largeur := Largeur + 2;
      if Titre = '' then Hauteur := 1
                    else Hauteur := 3;
      Largeur := Largeur * LargCarGr;
      Hauteur := Hauteur * HautCarGr;
      CalculLargDialogGr(Largeur,Dialogue);
      CalculHautDialogGr(Hauteur,Dialogue);
      if X = 0 then CalculXDialogGr(Dialogue);
      if Y = 0 then CalculYDialogGr(Dialogue);
    End;
    with UnBarreGraphe do
    Begin
      X := Dialogue.X + LargCarGr + HCadreBoite;
      if Dialogue.Titre = '' then Y := Dialogue.Y + HCadreBoite
                             else Y := Dialogue.Y + HCadreBoite + HautCarGr;
      (*Larg := Dialogue.Larg - 2 * LargCarGr - 2 * HCadreBoite;*)
      Larg := Dialogue.Larg-LargCarGr-LargCarGr-HCadreBoite-HCadreBoite;
      Haut := HautCarGr;
      if Dialogue.Tip in [OmbreSs,Ombre1,Ombre2,Ombre3,Ombre4] then
        Larg := Larg - OmbreBoite;
    End;
    OuvreDialogGr(Dialogue);
    BarreGrapheGr(UnBarreGraphe,0,Afficher);
  End;

  (**)
  Procedure Utilisation;

  Begin
    BarreGrapheGr(UnBarreGraphe,Valeur,Utiliser);
  End;

  (**)
  Procedure Fermeture;

  Begin
    Delay(100);
    FermeDialogGr(Dialogue);
  End;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  case UneAction of
    Ouvrir   : Ouverture;
    Utiliser : Utilisation;
    Fermer   : Fermeture;
  end;
  RestaureGr(S);
End;

{}

Procedure BoiteBarreGrapheReliefGr(Var Dialogue : DialogReliefRecGr;
   Var UnBarreGraphe : BarreGrapheRecGr;Valeur : longint;UneAction : Action);

Var
  S             : TypeSauveGr;
  Largeur       : integer;            { Largeur du dialogue  }
  Hauteur       : integer;            { Hauteur du dialogue  }

  (**)
  Procedure Ouverture;

  Begin
    with Dialogue do
    Begin
      Largeur := length(Titre) + 2;
      if Largeur < 12 then Largeur := 12;
      if Titre = '' then Hauteur := 1
                    else Hauteur := 3;
      Larg := Largeur * LargCarGr;
      Haut := Hauteur * HautCarGr;
      AjusteLargeurDialogReliefGr(Dialogue);
      AjusteHauteurDialogReliefGr(Dialogue);
      if X = 0 then CalculXDialogReliefGr(Dialogue);
      if Y = 0 then CalculYDialogReliefGr(Dialogue);
    End;
    with UnBarreGraphe do
    Begin
      X := Dialogue.X + LargCarGr + RayonRelief;
      if Dialogue.Titre = '' then Y := Dialogue.Y + RayonRelief
      else Y := Dialogue.Y + RayonRelief + HautCarGr + HautCarGr div 2;
      (*Larg := Dialogue.Larg - 2 * LargCarGr - 2 * RayonRelief;*)
      Larg := Dialogue.Larg-LargCarGr-LargCarGr-RayonRelief-RayonRelief;
      Haut := HautCarGr;
    End;
    OuvreDialogReliefGr(Dialogue);
    CentreTitreReliefGr(Dialogue);
    BarreGrapheGr(UnBarreGraphe,0,Afficher);
  End;

  (**)
  Procedure Utilisation;

  Begin
    BarreGrapheGr(UnBarreGraphe,Valeur,Utiliser);
  End;

  (**)
  Procedure Fermeture;

  Begin
    Delay(100);
    FermeDialogReliefGr(Dialogue);
  End;

Begin
  SauvegardeGr(S);
  CacheCurseurGr;
  CacheSouris;
  case UneAction of
    Ouvrir   : Ouverture;
    Utiliser : Utilisation;
    Fermer   : Fermeture;
  end;
  RestaureGr(S);
End;

{}

Begin

End.
