unit Main;

/////////////////////////////////////////////////////////////
//                                                         //
//                   AssembleEPS                           //
//     Assemblage de fichiers eps puis conversion en pdf   //
//            Copyright (C) 2002 Alain JAFFRE              //
/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////
//                Update history                           //
//                                                         //
//  V1.0.0 First release                                   //
//  V1.1.1 Correction:                                     //
//           Bug in AddAll and RemoveAll if some file      //
//           exist in the opposite list                    //
//         Addition:                                       //
//           Original EPS file deletion if suceed          //
//  V1.1.2 Addition:                                       //
//           Message box if assembly or conversion         //
//           did not suceed                                //
//           Deletion of assemble EPS file or PDF file     //
//           if filename already exist before running      //
//  V1.1.3 Correction:                                     //
//           Change in ps2pdf.bat and in PDFCreate in      //
//           order to enable space in filename             //
//                                                         //
/////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 2 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, sinon, veuillez crire  la Free Software Foundation, Inc., }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 2 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, write to the Free Software Foundation, Inc.,   }
{ 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                  }
{***************************************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, Buttons, ExtCtrls, ShellApi;

type
  TFPrincipale = class(TForm)
    LblDirectory: TLabel;
    EdtDirectory: TEdit;
    SbnLocalDir: TSpeedButton;
    PrbRunning: TProgressBar;
    BtnOk: TButton;
    BtnCancel: TButton;
    LbxEnable: TListBox;
    LbxSelected: TListBox;
    SbnAddAll: TSpeedButton;
    SbnAdd: TSpeedButton;
    SbnRemove: TSpeedButton;
    SbnRemoveAll: TSpeedButton;
    LbEdtFinalName: TLabeledEdit;
    LblFileList: TLabel;
    LblFileSelected: TLabel;
    CbxPDFConvert: TCheckBox;
    CbxDeleteFiles: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure SbnLocalDirClick(Sender: TObject);
    procedure BtnOkClick(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
    procedure SbnAddAllClick(Sender: TObject);
    procedure SbnRemoveAllClick(Sender: TObject);
    procedure SbnAddClick(Sender: TObject);
    procedure SbnRemoveClick(Sender: TObject);
    procedure LbEdtFinalNameChange(Sender: TObject);
    procedure EdtDirectoryChange(Sender: TObject);
  private
    { Dclarations prives }
    EPSFile: string;
    PDFFile: string;
    procedure ScanDirectory(ADir: string);
    procedure UpdateSTatus;
    procedure PDFCreate;
    procedure RemoveFiles;
  public
    { Dclarations publiques }
  end;

var
  FPrincipale: TFPrincipale;

implementation

{$R *.DFM}

uses DirInput;

const
  Version= '1.1.3';

{************************************************************}
{ Utilities                                                  }
{************************************************************}

function GetCommandProcessor: pchar;
// Which command processor is available
var
  Size: longint;
  CommandProcessor: pchar;
begin
  Size:= GetEnvironmentVariable('Comspec',nil,0);
  CommandProcessor:= StrAlloc(Size);
  GetEnvironmentVariable('Comspec',CommandProcessor,Size);
  result:= CommandProcessor;
end;

function ExecuteAndWait(ExeName: string; Parameters: string): boolean;
// Execute program and wait it end's
// Adapted from answer found on Borland newsgroup archive
var
  StartInfo: TStartupInfo;
  ProcessInfo: TProcessInformation;
begin
  // Fill with known state
  fillchar(StartInfo,sizeof(TStartupInfo),#0);
  fillchar(ProcessInfo,sizeof(TProcessInformation),#0);
  // StartInfo set up
  StartInfo.cb:= sizeof(TStartupInfo);
  StartInfo.wShowWindow:= SW_SHOWNORMAL;
  StartInfo.dwFlags:= STARTF_USESHOWWINDOW;
  // Process
  result:= CreateProcess(nil, pchar(ExeName + ' ' + Parameters),
             nil, nil, true,
             NORMAL_PRIORITY_CLASS,
             nil, nil, StartInfo, ProcessInfo);
  // Wait until finished
  if result then
  begin
    WaitForSingleObject(ProcessInfo.hProcess, INFINITE);
    CloseHandle(ProcessInfo.hProcess);
    CloseHandle(ProcessInfo.hThread);
  end;
end;

procedure TFPrincipale.ScanDirectory(ADir: string);
var
  SRec: TSearchRec;
  SResult: integer;
begin
  LbxEnable.Items.BeginUpdate;
  SResult:= FindFirst(ADir + '*.eps',faAnyfile,SRec);
  try
    while SResult=0 do
    begin
      if ((SRec.Attr and faDirectory)<>faDirectory)
        and (SRec.Name<>'.') and (SRec.Name<>'..') then
      begin
        LbxEnable.Items.Add(SRec.Name);
      end;
      SResult:= FindNext(SRec);
    end;
  finally
    FindClose(SRec);
    LbxEnable.Items.EndUpdate;
  end;
end;

procedure TFPrincipale.UpdateStatus;
var
  Ready: boolean;
  Selection: boolean;
  Available: boolean;
begin
  Ready:= LbEdtFinalName.Text <> '';
  LbxEnable.Enabled:= Ready;
  LbxSelected.Enabled:= Ready;
  Available:= LbxEnable.Count > 0;
  SbnAdd.Enabled:= Available;
  SbnAddAll.Enabled:= Available;
  Selection:= LbxSelected.Count > 0;
  SbnRemove.Enabled:= Selection;
  SbnRemoveAll.Enabled:= Selection;
  BtnOk.Visible:= Selection;
end;

procedure TFPrincipale.PDFCreate;
var
  CmdLine: string;
begin
  CmdLine:= ApplicationDir+'ps2pdf.bat "'+EPSFile+'" "'+PDFFile+'"';
  if ExecuteAndWait(CmdLine,'') then
  begin
    if FileExists(PDFFile) then deletefile(EPSFile);
  end;
end;

procedure TFPrincipale.RemoveFiles;
var
  N: integer;
begin
  for N:= 0 to (LbxSelected.Items.Count-1) do
  begin
    deletefile(EdtDirectory.Text+'\'+LbxSelected.Items[N]);
  end;
end;

{************************************************************}
{ Main form                                                  }
{************************************************************}

procedure TFPrincipale.FormCreate(Sender: TObject);
var
  PDFOK: boolean;
begin
  FPrincipale.Caption:= 'Assemblage de fichiers EPS version ' + Version;
  ApplicationDir:= ExtractFilePath(Application.ExeName);
  PDFOK:= FileExists(ApplicationDir+'ps2pdf.bat') and
    FileExists(ApplicationDir+'pdfwrite.rsp');
  CbxPDFConvert.Visible:= PDFOK;
  CbxPDFConvert.Checked:= PDFOK;
end;

procedure TFPrincipale.SbnLocalDirClick(Sender: TObject);
var
  AFolder: string;
begin
  AFolder:= EdtDirectory.Text;
  if FrmChooseDirectory.Execute('Choix du rpertoire','&Ok','&Annule',AFolder) then
    EdtDirectory.Text:= AFolder;
    LbxEnable.Clear;
    LbxSelected.Clear;
    ScanDirectory(AFolder+'\');
    UpdateStatus;
end;

procedure TFPrincipale.BtnOkClick(Sender: TObject);
var
  FIn: file of byte;
  FOut: file of byte;
  Buf: array[1..2048] of byte;
  N: integer;
  NumRead, NumWritten: Integer;

begin
  screen.cursor:= crHourGlass;
  BtnOK.Visible:= false;
  BtnCancel.Visible:= false;
  // File names
  EPSFile:= EdtDirectory.Text+'\'+LbEdtFinalName.Text+'.eps';
  PDFFile:= EdtDirectory.Text+'\'+LbEdtFinalName.Text+'.pdf';
  if FileExists(EPSFile) then deletefile(EPSFile);
  if CbxPDFConvert.Checked and FileExists(PDFFile) then deletefile(PDFFile);
  // EPS assembly
  // Defini le barregraphe
  PrbRunning.Min:= 0;
  PrbRunning.Max:= LbxSelected.Items.Count;
  PrbRunning.Visible:= true;
  // Ouvre le fichier final en ecriture
  assignfile(FOut,EdtDirectory.Text+'\'+LbEdtFinalName.Text+'.eps');
  rewrite(FOut);
  for N:= 0 to (LbxSelected.Items.Count-1) do
  begin
    PrbRunning.Position:= N + 1;
    assignfile(FIn,EdtDirectory.Text+'\'+LbxSelected.Items[N]);
    reset(FIn);
    repeat
      BlockRead(FIn, Buf, SizeOf(Buf), NumRead);
      BlockWrite(FOut, Buf, NumRead, NumWritten);
    until (NumRead = 0) or (NumWritten <> NumRead);
    closefile(FIn);
  end;
  closefile(FOut);
  PrbRunning.Visible:= false;
  // PDF creation
  if CbxPDFConvert.Checked then PDFCreate;
  // Selected files deletion
  if CbxDeleteFiles.Checked then
  begin
    if CbxPDFConvert.Checked then
    begin
      if FileExists(PDFFile) then RemoveFiles
      else MessageDlg('Echec de la conversion.', mtError, [mbOk], 0)
    end
    else
    begin
      if FileExists(EPSFile) then RemoveFiles
      else MessageDlg('Echec de la l''assemblage.', mtError, [mbOk], 0)
    end;
  end;
  LbxEnable.Items.Clear;
  LbxSelected.Items.Clear;
  UpdateStatus;
  BtnCancel.Visible:= true;
  screen.cursor:= crDefault;
end;

procedure TFPrincipale.BtnCancelClick(Sender: TObject);
begin
  close;
end;

procedure TFPrincipale.SbnAddAllClick(Sender: TObject);
var
  N: integer;
begin
  for N:= 0 to (LbxEnable.Items.Count-1) do
  begin
    LbxSelected.Items.Add(LbxEnable.Items[N]);
  end;
  LbxEnable.Clear;
  UpdateStatus;
end;

procedure TFPrincipale.SbnRemoveAllClick(Sender: TObject);
var
  N: integer;
begin
  for N:= 0 to (LbxSelected.Items.Count-1) do
  begin
    LbxEnable.Items.Add(LbxSelected.Items[N]);
  end;
  LbxSelected.Clear;
  UpdateStatus;
end;

procedure TFPrincipale.SbnAddClick(Sender: TObject);
var
  N: integer;
begin
  N:= 0;
  while (LbxEnable.SelCount>0) and (N<LbxEnable.Items.count) do
  begin
    if LbxEnable.Selected[N] then
    begin
      LbxSelected.Items.Add(LbxEnable.Items[N]);
      LbxEnable.Items.Delete(N);
    end
    else inc(N);
  end;
  LbxEnable.ItemIndex:= 0;
  UpdateStatus;
end;

procedure TFPrincipale.SbnRemoveClick(Sender: TObject);
var
  N: integer;
begin
  N:= 0;
  while (LbxSelected.SelCount>0) and (N<LbxSelected.Items.count) do
  begin
    if LbxSelected.Selected[N] then
    begin
      LbxEnable.Items.Add(LbxSelected.Items[N]);
      LbxSelected.Items.Delete(N);
    end
    else inc(N);
  end;
  LbxSelected.ItemIndex:= 0;
  UpdateStatus;
end;

procedure TFPrincipale.LbEdtFinalNameChange(Sender: TObject);
begin
  UpdateStatus;
end;

procedure TFPrincipale.EdtDirectoryChange(Sender: TObject);
begin
  LbEdtFinalName.Enabled:= EdtDirectory.Text <> '';
end;

end.
