unit MCLng;

/////////////////////////////////////////////////////////////////////////////
//                       Part of MD5Checker project                        //
//                     Compute and compare MD5 file hash                   //
//  2007  Main developper Alain JAFFRE         http://jack.r.free.fr       //
//                                                                         //
// Language management for that project                                    //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 3 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, veuillez consulter <http://www.gnu.org/licenses/>           }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 3 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, see <http://www.gnu.org/licenses/>.            }
{***************************************************************************}

interface

const
  en = 1;
  fr = 2;
var
  CurrentLanguage: integer;

  procedure BuildMsgList;
  function GetMsg(Index: integer): string;

implementation

uses SysUtils;

const
  max= 99;
type
  Msg = Array [1..max] of string;
var
  MsgList : Array [1..2] of Msg;

{*****************************************************************************}
{ Private                                                                      }
{*****************************************************************************}

procedure BuildMsgListEn;
var
  N: integer;
begin
  for N:= 1 to max do MsgList[en][N]:= Format('Untranslated message n %3d', [N]);
  // File menu
  MsgList[en][01]:= '&File';
  MsgList[en][02]:= 'File menu';
  MsgList[en][03]:= 'Open ...';
  MsgList[en][04]:= 'Slect files to compute hash';
  MsgList[en][05]:= 'Save ...';
  MsgList[en][06]:= 'Save computed hash';
  MsgList[en][07]:= 'Print ...';
  MsgList[en][08]:= 'Print computed hash';
  MsgList[en][19]:= 'Quit';
  MsgList[en][20]:= 'Exit that application';
  // Tools menu
  MsgList[en][21]:= '&Tools';
  MsgList[en][22]:= 'Tools menu';
  MsgList[en][23]:= 'Language';
  MsgList[en][24]:= 'Select user interface language';
  // Help menu
  MsgList[en][31]:= '&Help';
  MsgList[en][32]:= 'Help menu';
  MsgList[en][33]:= 'About ...';
  MsgList[en][34]:= 'Informations regarding that application';
  // Stop
  MsgList[en][35]:= 'Stop';
  MsgList[en][36]:= 'Stop MD5 computation and check';
  // Hash listview
  MsgList[en][41]:= 'File';
  MsgList[en][42]:= 'Hash';
  MsgList[en][43]:= 'Found in';
  // Current folder label
  MsgList[en][51]:= 'Current folder: %s';
  // Status information
  MsgList[en][52]:= 'Processing: %s';
  // Open file filter
  MsgList[en][53]:= 'All files (*.*)|*.*';
  // Save format selection box
  MsgList[en][81]:= 'Select save filename format';
  MsgList[en][82]:= 'Available formats';
  MsgList[en][83]:= 'Ok';
  MsgList[en][84]:= 'Cancel';
  MsgList[en][85]:= 'File %s already exist. Replace ?';
end;

{------------------------------------------------------------------------------}

procedure BuildMsgListFr;
var
  N: integer;
begin
  for N:= 1 to max do MsgList[fr][N]:= Format('Untranslated message n %3d', [N]);
  // File menu
  MsgList[fr][01]:= '&Fichier';
  MsgList[fr][02]:= 'Menu fichier';
  MsgList[fr][03]:= 'Ouvrir ...';
  MsgList[fr][04]:= 'Choix des fichiers pour le calcule de la somme de contrle';
  MsgList[fr][05]:= 'Enregistrer ...';
  MsgList[fr][06]:= 'Sauvegarde des sommes de contrles';
  MsgList[fr][07]:= 'Imprimer ...';
  MsgList[fr][08]:= 'Imprimer les sommes de contrles';
  MsgList[fr][19]:= 'Quitter';
  MsgList[fr][20]:= 'Quitte cette application';
  // Tools menu
  MsgList[fr][21]:= '&Outils';
  MsgList[fr][22]:= 'Menu outils';
  MsgList[fr][23]:= 'Langue';
  MsgList[fr][24]:= 'Choix de la langue de l''interface';
  // Help menu
  MsgList[fr][31]:= '&Aide';
  MsgList[fr][32]:= 'Menu aide';
  MsgList[fr][33]:= 'A propos ...';
  MsgList[fr][34]:= 'Informations sur cette application';
  // Stop
  MsgList[fr][35]:= 'Stop';
  MsgList[fr][36]:= 'Stop le calcul et la comparaison du MD5';
  // Hash listview
  MsgList[fr][41]:= 'Fichier';
  MsgList[fr][42]:= 'Somme de contrle';
  MsgList[fr][43]:= 'Trouv dans';
  // Current folder label
  MsgList[fr][51]:= 'Rpertoire actuel: %s';
  // Status information
  MsgList[fr][52]:= 'Traitement de: %s';
  // Open file filter
  MsgList[fr][53]:= 'Tous fichiers (*.*)|*.*';
  // Save format selection box
  MsgList[fr][81]:= 'Choix du format de fichier d''enregistrement';
  MsgList[fr][82]:= 'Formats disponibles';
  MsgList[fr][83]:= 'Ok';
  MsgList[fr][84]:= 'Annuler';
  MsgList[fr][85]:= 'Le fichier %s existe dj. Replacer ?';
end;

{*****************************************************************************}
{ Public                                                                      }
{*****************************************************************************}

procedure BuildMsgList;
// Build message list for all languages
begin
  BuildMsgListEn;
  BuildMsgListFr;
end;

{------------------------------------------------------------------------------}

function GetMsg(Index: integer): string;
// Get proper message
begin
  result:= MsgList[CurrentLanguage][Index];
end;

end.
