unit MCAbout;

/////////////////////////////////////////////////////////////////////////////
//                       Part of MD5Checker project                        //
//                     Compute and compare MD5 file hash                   //
//  2007  Main developper Alain JAFFRE         http://jack.r.free.fr       //
//                                                                         //
// About box of that project                                               //
/////////////////////////////////////////////////////////////////////////////

{***************************************************************************}
{ Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le       }
{ modifier suivant les termes de la GNU General Public License telle que    }
{ publie par la Free Software Foundation, soit la version 3 de cette        }
{ license, soit ( votre convenance) une version ultrieure.                }
{                                                                           }
{ Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE }
{ GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou      }
{ d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License  }
{ pour plus de dtails.                                                     }
{                                                                           }
{ Vous devriez avoir reu une copie de la GNU General Public License avec   }
{ ce programme, veuillez consulter <http://www.gnu.org/licenses/>           }
{***************************************************************************}

{***************************************************************************}
{ This program is free software. You can redistribute it and/or modify it   }
{ under the terms of the GNU Public License as published by the             }
{ Free Software Foundation, either version 3 of the license, or             }
{ (at your option) any later version.                                       }
{                                                                           }
{ This program is distributed in the hope it will be useful, but WITHOUT    }
{ ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or     }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for  }
{ more details.                                                             }
{                                                                           }
{ You should have received a copy of the GNU General Public License along   }
{ with this program, if not, see <http://www.gnu.org/licenses/>.            }
{***************************************************************************}

interface

uses
  Windows, StdCtrls, Controls, Buttons, Graphics, Classes, ExtCtrls, Forms,
  ShellApi,
  XPMenu;

type
  TFrmAbout = class(TForm)
    BtnOk: TBitBtn;
    Icon: TImage;
    CopyrightTitle: TLabel;
    LblProgram: TLabel;
    LblVersion: TLabel;
    MemoFr: TMemo;
    MemoGb: TMemo;
    LblWebsite: TLabel;
    LblMailAddress: TLabel;
    LblDescription: TLabel;

    procedure FormShow(Sender: TObject);
    procedure LblWebsiteClick(Sender: TObject);
    procedure LblMailAddressClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Dclarations prives }
    XPMenu: TXPMenu;
  public
    { Dclarations publiques }
    SoftVersion : string;
    BtnOkTitle: string;
  end;

var
  FrmAbout: TFrmAbout;

implementation

{$R *.DFM}

procedure TFrmAbout.FormCreate(Sender: TObject);
begin
  // XP menu style
  XPMenu := TXPMenu.Create(Self);
  with XPMenu do
  begin
    Name := 'XPMenu';
    DimLevel := 30;
    GrayLevel := 10;
    Font.Charset := ANSI_CHARSET;
    Font.Color := clMenuText;
    Font.Height := -11;
    Font.Name := 'Microsoft Sans Serif';
    Font.Style := [];
    Color := clBtnFace;
    DrawMenuBar := False;
    IconBackColor := clBtnFace;
    MenuBarColor := clBtnFace;
    SelectColor := clHighlight;
    SelectBorderColor := clHighlight;
    SelectFontColor := clMenuText;
    DisabledColor := clInactiveCaption;
    SeparatorColor := clBtnFace;
    CheckedColor := clHighlight;
    IconWidth := 24;
    DrawSelect := True;
    UseSystemColors := True;
    UseDimColor := False;
    OverrideOwnerDraw := False;
    Gradient := False;
    FlatMenu := True;
    AutoDetect := True;
    Active := True;
    Left := 56;
    Top := 120;
  end;
end;

{------------------------------------------------------------------------------}

procedure TFrmAbout.FormShow(Sender: TObject);
begin
  LblProgram.Caption := Application.Title;
  Icon.Picture.Graphic := Application.Icon;
  LblVersion.Caption := 'Version ' + SoftVersion;
  BtnOk.Caption:= BtnOkTitle;
end;

{------------------------------------------------------------------------------}

procedure TFrmAbout.LblWebsiteClick(Sender: TObject);
begin
  ShellExecute(0,'open','http://jack.r.free.fr',nil,nil,SW_SHOW);
end;

{------------------------------------------------------------------------------}

procedure TFrmAbout.LblMailAddressClick(Sender: TObject);
begin
  ShellExecute(0,'open','mailto:jack.r@free.fr',nil,nil,SW_SHOW);
end;

{------------------------------------------------------------------------------}

end.
