Attribute VB_Name = "FileFct"
' +--------------------------------------------------------------------------+
' | Author: Alain JAFFRE                                                     |
' | Contributors:                                                            |
' |                                                                          |
' +--------------------------------------------------------------------------+
' | This program is free software. You can redistribute it and/or modify it  |
' | under the terms of the GNU Public License as published by the            |
' | Free Software Foundation, either version 2 of the license, or            |
' | (at your option) any later version.                                      |
' |                                                                          |
' | This program is distributed in the hope it will be useful, but WITHOUT   |
' | ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or    |
' | FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for |
' | more details.                                                            |
' |                                                                          |
' | You should have received a copy of the GNU General Public License        |
' | with this program, if not, write to the Free Software Foundation, Inc.,  |
' | 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                 |
' +--------------------------------------------------------------------------+
' | Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le      |
' | modifier suivant les termes de la GNU General Public License telle que   |
' | publie par la Free Software Foundation, soit la version 2 de cette       |
' | license, soit ( votre convenance) une version ultrieure.               |
' |                                                                          |
' | Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE|
' | GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou     |
' | d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License |
' | pour plus de dtails.                                                    |
' |                                                                          |
' | Vous devriez avoir reu une copie de la GNU General Public License avec  |
' | ce programme, sinon, veuillez crire  la Free Software Foundation, Inc.,|
' | 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                 |
' +--------------------------------------------------------------------------+
Option Explicit
' +--------------------------------------------------------------------------+
' | Files and directories routines                                           |
' +--------------------------------------------------------------------------+

Function GetBookPath() As String
' return the path of the current workbook
    GetBookPath = ThisWorkbook.Path + "\"
End Function

Function GetBookName() As String
' return the name of the current workbook
    GetBookName = ThisWorkbook.Name
End Function

Function GetFilename(fileTypes, aTitle As String) As String
' return nothing or the selected filename
' example: GetFilename("Comma separated files (*.csv),*.csv, All files (*.*), *.*", "Select file to import")
    Dim aFilename
    aFilename = Application.GetOpenFilename(fileTypes, , aTitle)
    If VarType(aFilename) = vbBoolean Then
        GetFilename = ""
    Else
        GetFilename = aFilename
    End If
End Function

Function ExtractPathName(aFilename As String) As String
' return the path of aFilename
' example: ExtractPathName("c:\windows\notepad.exe") will return "c:\windows\"
    Dim x As Variant
    x = Split(aFilename, Application.PathSeparator)
    ReDim Preserve x(0 To UBound(x) - 1)
    ExtractPathName = Join(x, Application.PathSeparator) & Application.PathSeparator
End Function

Function ExtractFileName(aFilename As String) As String
' return the filename of aFilename
' example: ExtractFileName("c:\windows\notepad.exe") will return "notepad.exe"
    Dim x As Variant
    x = Split(aFilename, Application.PathSeparator)
    ExtractFileName = x(UBound(x))
End Function

Function FileExists(aFilename As String) As Boolean
' return true if file exist
' example: FileExists("c:\windows\notepad.exe")
    FileExists = Dir(aFilename) <> ""
End Function

Function PathExists(aPathName As String) As Boolean
' return true if path exist
' example: PathExists("c:\windows\")
    Dim x As String
    aPathName = ExtractPathName(aPathName)
    On Error Resume Next
    x = GetAttr(aPathName) And 0
    If Err = 0 Then
        PathExists = True
    Else
        PathExists = False
    End If
End Function

