Attribute VB_Name = "DateFct"
' +--------------------------------------------------------------------------+
' | Author: Alain JAFFRE                                                     |
' | Contributors:                                                            |
' |                                                                          |
' +--------------------------------------------------------------------------+
' | This program is free software. You can redistribute it and/or modify it  |
' | under the terms of the GNU Public License as published by the            |
' | Free Software Foundation, either version 2 of the license, or            |
' | (at your option) any later version.                                      |
' |                                                                          |
' | This program is distributed in the hope it will be useful, but WITHOUT   |
' | ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or    |
' | FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for |
' | more details.                                                            |
' |                                                                          |
' | You should have received a copy of the GNU General Public License        |
' | with this program, if not, write to the Free Software Foundation, Inc.,  |
' | 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                 |
' +--------------------------------------------------------------------------+
' | Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le      |
' | modifier suivant les termes de la GNU General Public License telle que   |
' | publie par la Free Software Foundation, soit la version 2 de cette       |
' | license, soit ( votre convenance) une version ultrieure.               |
' |                                                                          |
' | Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE|
' | GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou     |
' | d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License |
' | pour plus de dtails.                                                    |
' |                                                                          |
' | Vous devriez avoir reu une copie de la GNU General Public License avec  |
' | ce programme, sinon, veuillez crire  la Free Software Foundation, Inc.,|
' | 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                 |
' +--------------------------------------------------------------------------+
Option Explicit
' +--------------------------------------------------------------------------+
' | Date routines                                                            |
' +--------------------------------------------------------------------------+

Function PreviousDateByMonth(aDate As String, ByVal aDelta As Long) As String
' return date corresponding to aDelta month before aDate
' aDate is in the form yyyymmdd
' example: PreviousDateByMonth("20050502", 3) will return "20050203"
    Dim aYear As Variant
    Dim aMonth As Variant
    Dim aDay As Variant
    Dim tmpMonth As Long
        
    aDate = Application.Trim(aDate)
    aYear = Left(aDate, 4)
    aMonth = Mid(aDate, 5, 2)
    aDay = Mid(aDate, 7, 2)
    
    tmpMonth = aMonth + 0
    If aDay = LastDayOfMonth(aYear, tmpMonth) Then
        aDay = 1
        If aMonth < 12 Then
            aMonth = aMonth + 1
        Else
            aMonth = 1
            aYear = aYear + 1
        End If
    Else
        aDay = aDay + 1
    End If
        
    
    While aDelta > aMonth
        aDelta = aDelta - aMonth
        aMonth = 12
        aYear = aYear - 1
    Wend
    aMonth = aMonth - aDelta
    
    If aMonth = 0 Then
      aMonth = 12
      aYear = aYear - 1
    End If
    
    If Len(aMonth) < 2 Then aMonth = "0" & aMonth
    If Len(aDay) < 2 Then aDay = "0" & aDay
    PreviousDateByMonth = aYear & aMonth & aDay
End Function

Function LastDayOfMonth(aYear, aMonth As Long) As Long
' return the last day of the specified year and month
    LastDayOfMonth = Day(CDate(DateSerial(aYear, aMonth + 1, 0)))
End Function
