Attribute VB_Name = "ColorFct"
' +--------------------------------------------------------------------------+
' | Author: Alain JAFFRE                                                     |
' | Contributors:                                                            |
' |                                                                          |
' +--------------------------------------------------------------------------+
' | This program is free software. You can redistribute it and/or modify it  |
' | under the terms of the GNU Public License as published by the            |
' | Free Software Foundation, either version 2 of the license, or            |
' | (at your option) any later version.                                      |
' |                                                                          |
' | This program is distributed in the hope it will be useful, but WITHOUT   |
' | ANY WARRANTY, without even the implied warranty of MERCHANTABILITY or    |
' | FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for |
' | more details.                                                            |
' |                                                                          |
' | You should have received a copy of the GNU General Public License        |
' | with this program, if not, write to the Free Software Foundation, Inc.,  |
' | 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                 |
' +--------------------------------------------------------------------------+
' | Ce logiciel est un logiciel libre. Vous pouvez le diffuser et/ou le      |
' | modifier suivant les termes de la GNU General Public License telle que   |
' | publie par la Free Software Foundation, soit la version 2 de cette       |
' | license, soit ( votre convenance) une version ultrieure.               |
' |                                                                          |
' | Ce programme est diffus dans l'espoir qu'il sera utile, mais SANS AUCUNE|
' | GARANTIE, sans mme une garantie implicite de COMMERCIALISABILITE ou     |
' | d'ADEQUATION A UN USAGE PARTICULIER. Voyez la GNU General Public License |
' | pour plus de dtails.                                                    |
' |                                                                          |
' | Vous devriez avoir reu une copie de la GNU General Public License avec  |
' | ce programme, sinon, veuillez crire  la Free Software Foundation, Inc.,|
' | 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.                 |
' +--------------------------------------------------------------------------+

Option Explicit

' +--------------------------------------------------------------------------+
' | Color routines                                                           |
' +--------------------------------------------------------------------------+

Public Const black = 1
Public Const blue = 5
Public Const green = 4
Public Const cyan = 8
Public Const red = 3
Public Const magenta = 7
Public Const brown = 9
Public Const lightgray = 15
Public Const darkgray = 16
Public Const lightblue = 33
Public Const lightgreen = 35
Public Const lightcyan = 34
Public Const lightred = 22
Public Const lightmagenta = 38
Public Const yellow = 6
Public Const white = 2
Public Const lila = 17


Private Sub BuildColorTable()
    Dim number As Integer
    Dim column As Integer
    Dim line As Integer

    Const ShiftX = 2
    Const ShiftY = 2
    
    ' Clear sheet
    Cells.Select
    selection.Clear
    
    ' Coloring cells
    For number = 1 To 56
        column = number
        line = 0
        While column >= 10
            column = column - 10
            line = line + 1
        Wend
        With Cells(ShiftY + line, ShiftX + column)
            If ((number <> 0) And (number <> 2) And (number <> 19) And (number <> 36)) Then
                .font.ColorIndex = white
            Else
                .font.ColorIndex = black
            End If
            .ColumnWidth = 4
            .RowHeight = 25
            .font.Bold = True
            .HorizontalAlignment = xlCenter
            .VerticalAlignment = xlCenter
            .Interior.ColorIndex = number
            .Value = number
        End With
    Next number
    
    With Cells(1, 1)
        .ColumnWidth = 4
        .RowHeight = 25
    End With
    
    Range("A1").Select
End Sub

